<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
<xsl:template match="/">
<html>
  <head>
  <link rel="stylesheet" type="text/css" href="styles.css"/>
  <body>
  <xsl:apply-templates select = "forums/forum[@id='[forum_id]']"/>
  <xsl:apply-templates select = "forums/forum[@id='[forum_id]']//message[@id='[message_id]']"/>
  </body>
  </head>
</html>
</xsl:template>

<xsl:template match="forum">
  <span class="textTitle"><xsl:value-of select="@name"/></span>
</xsl:template>

<xsl:template match="message">
  <br/><br/><hr/>
  <table border="0" cellspacing="5" cellpadding="0">
    <tr>
	  <td class="tableRowtitle">Messdage id:</td>
	  <td><xsl:value-of select = "@id"/></td>
	</tr>
    <tr>
	  <td class="tableRowtitle">Date:</td>
	  <td><xsl:value-of select = "@message_date"/></td>
	</tr>
	<tr>
	  <td class="tableRowtitle">Subject:</td>
	  <td><xsl:value-of select = "subject"/></td>
	</tr>
	<tr>
	  <td class="tableRowtitle">Sender:</td>
	  <td>
	    <xsl:value-of select = "sender_name"/>
		[<a>
		  <xsl:attribute name="href">mailto:<xsl:value-of select="sender_email"/></xsl:attribute>
	      <xsl:value-of select="sender_email"/>
	    </a>]
	  </td>
	</tr>
	<tr>
	  <td class="tableRowtitle" colspan="2" align="center">Body</td>
	</tr>
	<tr>
	  <td colspan="2"><xsl:value-of select="body"/></td>
	</tr>
	<tr>
	  <td class="tableRowtitle" colspan="2" align="center">
	    <a href="newMessage.asp?forumID=[forum_id]&amp;replyOf=[message_id]">Reply</a>
	  </td>
	</tr>
  </table>
  <hr/><br/><br/>
  <a href="showForum.asp?forumID=[forum_id]">Back to forum</a>
  |
  <a href="default.asp">Back to forums list</a>

  
</xsl:template>

</xsl:stylesheet>