#! /usr/bin/perl

# b.shr/index.cgi
# Victor Liu See-le - mailto:victor@n-gon.com
# Parse an XBEL-Collab format document and produce HTML display.
#
# XBEL-Collab adds a few features to the XBEL spec to allow for 
# shared bookmarks.
#
# Information on the XML Bookmark Exchange Language (XBEL) is at:
#        http://www.python.org/topics/xml/xbel/
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.init.pl";
require "cgi.pl";
require "b.display.pl";


###############################################################################
# Begin MAIN                                                                  #

&get_env_params;
&store_open_folders;
&print_content_type_html_no_cache unless $dont_need_content_type;
&print_html_from_template("$theme_path/b.shr.header.html") or 
    &print_html_header('b.shr', $html_dtd, $html_ns, &link_to_css($css_path));
&register_handlers;
&open_xml_file;
&process_xbel;
&close_xml_file;
&print_html_from_template("$theme_path/b.shr.footer.html") or 
    &print_html_footer;

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_env_params {
  &parse_form_data(*dat);
  $src = $dat{'src'} ? $dat{'src'} : 'shr';
  $view_folder = $dat{'view_folder'};
 
  &set_working_xml_file($shr_dir . $shr_xml_file) if $src eq 'shr';

  $view_folder = 'all' if (! $view_folder);
  $interactive_folding = '';
  $show_user_buttons = '';
}

sub register_handlers {
  &set_handler("Element-Start.xbel", \&display_xbel_start);
  &set_handler("Element-Start.folder", \&display_folder_start);
  &set_handler("Element-Start.bookmark", \&display_bookmark_start);
  &set_handler("Element-Start.comment", \&display_comment_start);
  &set_handler("Element-Start.info", \&display_info_start);
  &set_handler("Element-End.xbel", \&display_xbel_end);
  &set_handler("Element-End.folder", \&display_folder_end);
  &set_handler("Element-End.bookmark", \&display_bookmark_end);
  &set_handler("Element-End.comment", \&display_comment_end);
  &set_handler("Element-End.info", \&display_info_end);
  &set_handler("Text.xbel.title", \&display_xbel_title);
  &set_handler("Text.xbel.desc", \&display_xbel_desc);
  &set_handler("Text.folder.title", \&display_folder_title);
  &set_handler("Text.folder.desc", \&display_folder_desc);
  &set_handler("Text.folder.comment", \&display_folder_comment);
  &set_handler("Text.bookmark.title", \&display_bookmark_title);
  &set_handler("Text.bookmark.desc", \&display_bookmark_desc);
  &set_handler("Text.bookmark.comment", \&display_bookmark_comment);
  &set_handler("Element-Empty.metadata", \&display_metadata);
}

