#! /usr/bin/perl

# b.usrnfo.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Displays info about a b. user. A user can also change his/her info here.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.init.pl";
require "b.header.pl";
require "cgi.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&get_env_params;
&print_content_type_html unless $dont_need_content_type;
&print_html_from_template("$theme_path/b.usrnfo.header.html") or 
    &print_html_header('b.usrnfo', $html_dtd, $html_ns, 
                       &link_to_css($css_path));
&print_user_menu(&inactive_menu_item) if defined $user;
&read_usrnfo;
&print_html;
&print_html_from_template("$theme_path/b.usrnfo.footer.html") or 
    &print_html_footer;

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_env_params {
  &parse_form_data(*dat);
  $src = $dat{'src'};
  $view_folder = $dat{'view_folder'};
  $usrnfo_on = $dat{'usrnfo_on'};
  
  # If no usrnfo_on param, then defaults to current user.
  $usrnfo_on = $user if (defined $user and ! $usrnfo_on);
  
  # A user can edit his own info. This happens if the 'usrnfo_on' parameter
  # equals this user, or there is no 'usrnfo_on' parameter.
  if ((defined $user) and ((($usrnfo_on) and ($user eq $usrnfo_on)) or
                           (! $usrnfo_on))) 
    { $editable = 1; }

  if (! $max_usrnfo) { $max_usrnfo = 10; } # Default
}

sub read_usrnfo {
  return if ($user eq $usrnfo_on); # Already have usrnfo items.
  
  # Clear usrnfo items.
  foreach my $i (1 .. $max_usrnfo) {
    eval("\$usrnfo_$i = ''");
  }
  
  # Read in config file, looking at lines beginning with 'usrnfo_i='.
  my $file = "$users_path$usrnfo_on/$config_file";
  open(CONF, "<$file") or return;
  while (<CONF>) { 
    if (/^(usrnfo_\d+)=(.*)\n/) { 
      eval qq[\$$1='$2'];
    }
  }
  close(CONF);
}

sub print_html {

  print qq[<h1>User info on $usrnfo_on</h1>\n];

  # If this usrnfo belongs to the current user, then the usrnfo is editable,
  # so place all usrnfo in text boxes. Otherwise, just display.

  if ($editable) {
    print qq[<form action="$busrnfo2_path" method="post">\n];
    print qq[<input type="hidden" name="src" value="$src" />\n];
    print qq[<input type="hidden" name="view_folder" value="$view_folder" />\n];
    print qq[<input type="hidden" name="usrnfo_on" value="$usrnfo_on" />\n];
  }

  my $no_usrnfo = 1;
  
  foreach my $i (1 .. $max_usrnfo) {
    my $usrnfo_i = eval("\$usrnfo_$i");
    my ($usrnfo_name, $usrnfo_data);

    if ($usrnfo_i) {
      ($usrnfo_name, $usrnfo_data) = split(/:/, $usrnfo_i, 2);
      $no_usrnfo = 0;
    }

    if ($usrnfo_name) {
      print qq[<div class="usrnfo-block-cl">\n];
      print qq[<div class="usrnfo-name-cl">$usrnfo_name</div>\n];
    
      if ($editable) {
        print qq[<input type="hidden" name="usrnfo_name_$i" value="$usrnfo_name" />\n];
        print qq[<input type="text" name="usrnfo_data_$i" value="$usrnfo_data" />\n];
      }
      else {
        print qq[<div class="usrnfo-data-cl">$usrnfo_data</div>];
      }
      print qq[</div>\n];
    }    
  }

  if ($no_usrnfo) {
    print qq[<div class="usrnfo-block-cl">\n];
    print qq[No info on user <strong>$usrnfo_on</strong>.\n];
    print qq[</div>\n];
  } 
  else {
    if ($editable) {
      print qq[<p>\n];
      print qq[<input type="submit" value="Mod" />];
      print qq[</p>\n];
      print qq[</form>\n];
    }
  }
}

sub inactive_menu_item {
  my $inactive = ($editable) ? 'usrnfo' : '';
  return $inactive;
}

