#! /usr/bin/perl

# b.link.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Intercepts a bookmark link to update access times and hits (hits updated
# for shared bookmarks only).
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.init.pl";
require "b.parse.pl";
require "cgi.pl";
require "time.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&get_env_params;
&register_handlers;
&open_and_lock_xml_file;
&process_xbel;
&write_xml if &xml_has_changed;
&unlock_and_close_xml_file;
&goto_page($url);

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_env_params {
  &parse_form_data(*dat);
  $link_item_id = $dat{'id'};
  $src = $dat{'src'} ? $dat{'src'} : '';
  if (! $link_item_id) {
    &print_content_type_html unless $dont_need_content_type;
    &print_html_msg_page('Error: No id specified! Contact b. admin.');
    exit(-1);
  }
  &set_working_xml_file($shr_dir . $shr_xml_file) if $src eq 'shr';
}

sub register_handlers {
  &set_handler("Element-Start.bookmark", \&handle_bookmark_start);
}

sub handle_bookmark_start {
  return if $found_link_item;
  
  my $id = &get_id;
  if ($id eq $link_item_id) {
    my $dt = &get_iso8601_datetime_utc;
    my $link_item_attributes = &get_attributes;
    my %att = &parse_attributes($link_item_attributes);
    $url = $att{'href'};
    if ($src eq 'shr') {
      my $hits = $att{'hits'} + 1;
      $link_item_attributes = &set_attribute($link_item_attributes, 
                                             'hits', $hits);
    }
    $link_item_attributes = &set_attribute($link_item_attributes, 
                                           'visited', $dt);
    my $s = qq[<bookmark $link_item_attributes>];
    &splice_xbel(&get_index, 1, $s);
    $found_link_item = 1;

    # Possible error trap
    if (! $url) {
      &print_content_type_html unless $dont_need_content_type;
      &print_html_msg_page('Error: No href found for id=$link_item_id!');
      exit(-1);
    }
  }
}

