#! /usr/bin/perl

# index.cgi 
# Victor Liu See-le - mailto:victor@n-gon.com
# First page, nothing special.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.header.pl";
require "cgi.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&print_content_type_html unless $dont_need_content_type;
&print_html_from_template("$theme_path/index.html") or 
    &print_default_page;

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub print_default_page {
  &print_html_header($html_title, $html_dtd, $html_ns, &link_to_css($css_path));
  &print_user_menu;
  &print_welcome_message;
  &print_html_footer;
}

sub print_menu {
  print qq[<div class="menu-cl">\n];
  
  print qq[$tab<div class="menu-button-cl">\n];
  print qq[$tab$tab<a href="$bsee_path">see</a>\n];
  print qq[$tab$tab | \n];
  print qq[$tab$tab<a href="$bmod_path">add</a>\n];
  print qq[$tab</div>\n];
  
  if (defined $user) {
    print qq[$tab<div class="menu-usrnfo-button-cl">\n];
    print qq[$tab$tab<a href="$busrnfo_path">usrnfo</a>\n];
    print qq[$tab</div>\n];
  }
  
  if ($shr_on) {
    $shr_view_mode = 'all' if ! $shr_view_mode; # Default view mode.
    my $folder_view = ($shr_view_mode eq 'all') ? 'all' : 'folder.0';
    my $bshrsee_path = "$bsee_path?src=shr\&view_folder=$folder_view";
    my $bshradd_path = "$bmod_path?src=shr\&dest=shr";
    print qq[$tab<div class="menu-shr-button-cl">\n];
    print qq[$tab$tab<a href="$bshrsee_path">shr:see</a>\n];
    print qq[$tab$tab | \n];
    print qq[$tab$tab<a href="$bshradd_path">shr:add</a>\n];
    print qq[$tab</div>\n];
  }
  
  print qq[</div>\n];
}

sub print_welcome_message {
  print qq[<div class="xbel-cl">\n];
  print qq[$tab<h1>b.</h1>\n];
  print qq[$tab<em>\n];
  print qq[$tab$tab Where have you been?<br />\n];
  print qq[$tab$tab Where are you going?<br />\n];
  print qq[$tab</em>\n];
  print qq[</div>\n];
}

