# cgi.pl
# Victor Liu See-le - mailto:victor@n-gon.com
# Helper routines for CGI.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

sub parse_form_data {
  local(*FORM_DATA) = @_;
  local($request_method, $query_string, @pairs, $key_value, $key, $value);

  $request_method = $ENV{'REQUEST_METHOD'} ? $ENV{'REQUEST_METHOD'} : '';
  $query_string = "";

  if ($request_method eq "GET") {
    $query_string = $ENV{'QUERY_STRING'};
  }
  elsif ($request_method eq "POST") {
    read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
  }
  else {
    # Error
    # die("Unsupported REQUEST_METHOD:$request_method\n");
  }

  @pairs = split(/&/, $query_string);

  foreach $key_value (@pairs) {
    ($key, $value) = split (/=/, $key_value);
    $key =~ tr/+/ /;
    $key =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack("C", hex($1))/eg;

    # Prepare for pairs with multiple entries
    if (defined($FORM_DATA{$key})) {
      $FORM_DATA{$key} = join("\, ", $FORM_DATA{$key}, $value);
    }
    else {
      $FORM_DATA{$key} = $value;
    }
  }
}

sub goto_page {
  print qq[Location: $_[0]\n\n];
}

sub print_content_type_html {
    print qq[Content-type: text/html\n\n];
}

sub print_content_type_html_no_cache {
    print qq[Content-type: text/html\n];
    print qq[Pragma: no-cache\n]; #This is for proxy systems only
    print qq[Cache-control: no-cache\n];
    print qq[Expires: -1\n\n];
}

sub link_to_css {
  return qq[<link rel="stylesheet" type="text/css" href="$_[0]" />];
}

sub print_html_from_template {
  my $bufline;
  my $buf;

  # Substitute template placeholders with their values. Placeholders in the  
  # HTML template file are of the form
  #
  #    ___VARIABLE___
  # 
  # This will be substituted with the value of $VARIABLE in the Perl context.
  open(TEMPLATE, "<$_[0]") or return 0; 
  while (<TEMPLATE>) { 
    s/___(\w+)___/\$$1/g;
    s/"/\\"/g; 
    $bufline = eval qq["$_"];
    $buf .= $bufline; 
  }
  close(TEMPLATE);
  
  print $buf;
  
  # Signal success (template file was found)
  return 1;
}

sub print_html_header {
  my $title = $_[0];
  my $dtd = $_[1] ? $_[1] : '';
  my $ns = $_[2] ? $_[2] : '';
  my $in_head_xtra = $_[3] ? $_[3] : '';
 
  print qq[$dtd\n];
  if ($ns) {
    print qq[<html $ns>\n];
  } else {
    print qq[<html>\n];
  }
  print qq[<head>\n];
  print qq[<title>$title</title>\n];
  print qq[$in_head_xtra\n]; 
  print qq[</head>\n];
  print qq[<body>\n];
}

sub print_html_footer {
  print qq[</body>\n];
  print qq[</html>\n];
}

sub encode_html_entities {
  # Translate entities like & and " into html equivalents
  # Watch out for already-encoded elements, ie don't re-encode &amp;
  $_ = $_[0];
  s/\&(\S+);/colorless_green_ideas\1;/g; # remove potential problems
  s/\&/\&amp;/g;
  s/\"/\&quot;/g;
  s/</\&lt;/g;
  s/>/\&gt;/g;
  s/colorless_green_ideas(\S+);/&\1;/g; # substitute back in &'s
  return $_;
}
1;
