#! /usr/bin/perl

# b.usrnfo2.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# In combination with b.usrnfo.pl, modifies a user's usrnfo.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.header.pl";
require "cgi.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&get_form_data;
&update_conf_file;
&redisplay($src, $view_folder);

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_form_data {
  &parse_form_data(*dat);
  $src = $dat{'src'};
  $view_folder = $dat{'view_folder'};
  $usrnfo_on = $dat{'usrnfo_on'};
  
  # usrnfo_on param must match current user to continue.
  if ((! defined $user) or (! defined $usrnfo_on) or ($user ne $usrnfo_on)) {
    # Abort. Write error msg.
    &print_content_type_html unless $dont_need_content_type;
    &print_html_msg_page('You are not allowed to do this.');
    exit(-1);
  }
  
  # Set $usrnfo_i items.
  if (! $max_usrnfo) { $max_usrnfo = 10; } # Default
  foreach my $i (1 .. $max_usrnfo) {
    my $usrnfo_name = $dat{"usrnfo_name_$i"};
    next if ! defined $usrnfo_name;
    my $usrnfo_data = $dat{"usrnfo_data_$i"};
    $usrnfo_data = '' if ! defined $usrnfo_data;
    eval("\$usrnfo_$i = '$usrnfo_name:$usrnfo_data'");
  }
}

sub update_conf_file {
  my $file = "$this_users_path/$config_file";
  my @lines;
  
  # Read in config file, ignoring lines beginning with 'usrnfo_i='.
  open (CONF, "<$file") or return;
  while (<CONF>) { 
    if (! (/^usrnfo_\d+=/)) { 
      push (@lines, $_);
    }
  }
  close(CONF);
  
  # Write to config file, appending usrnfo items.
  open (CONF, ">$file") or return;
  print CONF @lines;
  foreach my $i (1 .. $max_usrnfo) {
    my $usrnfo_i = eval("\$usrnfo_$i");
    next if ! $usrnfo_i;
    print CONF "usrnfo_$i=$usrnfo_i\n";
  }  
  close(CONF);
}



