# b.user.pl
# Victor Liu See-le - mailto:victor@n-gon.com
# Get user's bookmarks and configs.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "$user_authentication_script";

sub init_user {

  return unless defined &get_user; # This subroutine should be defined in
                                   # $user_authentication_script.
  
  # $user is the first parameter of the subroutine. If it's undefined,
  # define it, since the presence of a defined $user determines the presence
  # of various user capabilities, such as adding and modifying bookmarks.
  # If $user is undefined, then bookmarks are read-only.
  $user = $_[0] ? $_[0] : '';
  return unless $user;
   
  # Look for user's directory.
  $users_path = "users/" unless defined $users_path;
  mkdir ($users_path, 0755) unless -d $users_path;
  $this_users_path = "$users_path$user";
  mkdir ($this_users_path, 0755) unless -d $this_users_path;
  
  # Override the default XML file with this user's.
  $xml_file = "$this_users_path/$xml_file";
  if (! (-e $xml_file)) {
    # This user's bookmarks do not exist.
    # Create starter XML bookmark file.
    open (BOOKMARKS, ">$xml_file");
    
    # Use existing template if it exists.
    if (-e "$user_starter_xml_template") {
      local ($bufline);
      open (TEMPLATE, "<$user_starter_xml_template");
      while ($bufline = <TEMPLATE>) { 
        # Substitute name of $user for owner
        $bufline =~ s/metadata\W+owner=\".*\"/metadata owner=\"$user\"/;
        print BOOKMARKS $bufline; 
      }
      close (TEMPLATE);
    } else {
      # Write bare-bones file.
      print BOOKMARKS qq[<?xml version="1.0"?>\n];
      print BOOKMARKS qq[<!DOCTYPE xbel PUBLIC "+//IDN python.org//DTD XML Bookmark Exchange Language 1.0//EN//XML" "http://www.python.org/topics/xml/dtds/xbel-1.0.dtd">\n];
      print BOOKMARKS qq[<xbel>\n];
      print BOOKMARKS qq[<title>My Bookmarks</title>\n];
      print BOOKMARKS qq[<info><metadata owner="$user"/></info>\n];
      print BOOKMARKS qq[</xbel>\n];
    }
    close(BOOKMARKS);
  }
  
  # Read user's config.
  my $this_users_config_file = "$this_users_path/$config_file";
  if (! -e $this_users_config_file) {
    # Doesn't exist; use template.
    if (-e $user_starter_conf_template) {
      local ($bufline);
      open (CONF, ">$this_users_config_file");
      open (TEMPLATE, "<$user_starter_conf_template");
      while ($bufline = <TEMPLATE>) 
        { print CONF $bufline; }
      close (TEMPLATE);
    }
  }
  &load_config_values($this_users_config_file) if -e $this_users_config_file;
  
  # Is user admin of shared bookmarks?
  $is_user_admin = &is_admin;
}

sub is_admin {
  return '' if ! defined $user;
  
  my @admins = split(/[, ]+/, $shr_admins);
  if (defined $user and grep(/^$user$/, @admins)) {
    return 1;
  }
  
  return '';
}

1;
