#! /usr/bin/perl

# b.mod.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Via HTML form, add or modify bookmarks in XBEL format.
#
# Information on the XML Bookmark Exchange Language (XBEL) is at:
#        http://www.python.org/topics/xml/xbel/
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.parse.pl";
require "cgi.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&get_env_params;
&get_modify_item_from_source if $source_xml_file ne $destination_xml_file;
&set_working_xml_file($destination_xml_file);
&register_handlers;
&init_folders_array;
&open_and_lock_xml_file;
&process_xbel;
&write_xml_with_backup if &xml_has_changed;
&unlock_and_close_xml_file;
&abort_if_exceed_shr_limit if $care_about_shr_stats;
&print_content_type_html_no_cache unless $dont_need_content_type;
&print_html_from_template("$theme_path/b.mod.header.html") or 
    &print_html_header('b.mod', $html_dtd, $html_ns, &link_to_css($css_path));
&print_user_menu(&inactive_menu_item) if defined $user;
&print_shr_stats if $care_about_shr_stats;
&print_html_form;
&print_html_from_template("$theme_path/b.mod.footer.html") or 
    &print_html_footer;

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_env_params {
  &parse_form_data(*dat);
  $modify_item_id = $dat{'id'};
  $dest = $dat{'dest'};
  $src = $dat{'src'};
  $view_folder = $dat{'view_folder'};

  $destination_xml_file = ($dest eq 'shr') ? $shr_dir . $shr_xml_file
                                           : $xml_file;
  $source_xml_file = ($src eq 'shr') ? $shr_dir . $shr_xml_file
                                     : $xml_file;

  $care_about_shr_stats = (($shr_on) and ($shr_limit) and 
                           ($dest eq 'shr') and (defined $user));
}

sub get_modify_item_from_source {
  &set_handler("Element-Start.folder", \&look_for_modify_item);
  &set_handler("Element-Start.bookmark", \&look_for_modify_item);
  &set_handler("Text.folder.title", \&if_flag_save_info);
  &set_handler("Text.folder.desc", \&if_flag_save_info);
  &set_handler("Text.bookmark.title", \&if_flag_save_info);
  &set_handler("Text.bookmark.desc", \&if_flag_save_info);

  &set_working_xml_file($source_xml_file);
  &open_and_lock_xml_file;
  &process_xbel;
  &write_xml_with_backup if &xml_has_changed;
  &unlock_and_close_xml_file;
  &reset_xbel;
  $already_have_modify_item = 1;
}

sub register_handlers {
  &set_handler("Element-Start.folder", \&handle_folder_start);
  &set_handler("Element-Start.bookmark", \&handle_bookmark_start);
  &set_handler("Text.folder.title", \&handle_folder_title);
  &set_handler("Text.folder.desc", \&handle_folder_desc);
  &set_handler("Text.bookmark.title", \&handle_bookmark_title);
  &set_handler("Text.bookmark.desc", \&handle_bookmark_desc);
}

sub handle_folder_start {
  &look_for_modify_item unless $already_have_modify_item;

  # Before we add this folder to the array of possible destination folders,
  # make sure that this folder is not, or does not reside in, the modify item. 
  # Can't put a folder within itself!
  if (! (my $in_modify_item = &check_if_in_modify_item)) {

    # Store folder info in an array. We'll need this later to fill out
    # the OPTIONS array of the HTML SELECT form element.
    my %att = &parse_attributes(&get_attributes);
    my $id = &ensure_valid_id($att{'id'});

    push(@folder_titles, "untitled"); # default before we get title tag
    push(@folder_ids, $id);
    push(@folder_levels, &get_folder_level);
  }
}

sub handle_bookmark_start {
  &look_for_modify_item unless $already_have_modify_item;
  &update_shr_stats if $care_about_shr_stats;
}

sub handle_folder_title {
  &if_flag_save_info unless $already_have_modify_item;

  if (! (my $in_modify_item = &check_if_in_modify_item)) { 
    # Update info for folder.
    my $title = &get_text;
    pop(@folder_titles); 
    push(@folder_titles, $title); 
  }
}

sub handle_folder_desc {
  &if_flag_save_info unless $already_have_modify_item;
}

sub handle_bookmark_title {
  &if_flag_save_info unless $already_have_modify_item;
}

sub handle_bookmark_desc {
  &if_flag_save_info unless $already_have_modify_item;
}

sub init_folders_array {
  push(@folder_titles, "top-level"); 
  push(@folder_ids, "folder.0");
  push(@folder_levels, 0);
}

sub check_if_in_modify_item {
  return 0 if (! $modify_item_id);
  return 0 if ($source_xml_file ne $destination_xml_file);
  my $l = &get_depth;
  my $node_id;
  for my $j (0 .. $l) {
    my %att = &parse_attributes(&get_node_attributes($j));
    $node_id = $att{'id'};
    return 1 if $node_id eq $modify_item_id;
  }
  return 0;
}

sub if_flag_save_info {
  my $type = &get_type;
  my $text = &get_text;

  # If flag is set, then store this tag and its text in %modify_item_data.
  if ($flag_until_next_f_or_b) {
    $modify_item_data{$type} = $text;
  }
}

sub look_for_modify_item {
  my $type = &get_type;
  my %att = &parse_attributes(&get_attributes);
  my $id = &ensure_valid_id($att{'id'});

  # Clear flag if set.
  $flag_until_next_f_or_b = 0 if $flag_until_next_f_or_b;

  # Check if this is the item to modify.
  if ($modify_item_id and $modify_item_id eq $id) {

    # This is it. Save info, and set flag to keep looking for other attributes.
    $modify_item_type = $type;
    %modify_item_data = &parse_attributes(&get_attributes);
    $flag_until_next_f_or_b = 1;

    if ($destination_xml_file eq $source_xml_file) {
      # Get the id of the enclosing folder, which will be the next folder in 
      # node tree.
      my $l = &get_depth;
      foreach my $j (1 .. $l) {
        if (&get_node_type($j) eq "folder") {

          # This is the enclosing folder. 
          my %att = &parse_attributes(&get_node_attributes($j));
          $enclosing_folder_id = $att{'id'};
          last;
        }
      }
    }
  }
}

sub print_html_form {

  print qq[<form action="$bmod2_path" method="post">\n];
  
  print qq[<input type="hidden" name="view_folder" value="$view_folder" />\n];
  print qq[<input type="hidden" name="dest" value="$dest" />\n] if $dest;
  print qq[<input type="hidden" name="src" value="$src" />\n] if $src;
  
  print qq[<p>\n];
  if ($modify_item_id) {
    if ($dest eq 'shr') {
      if ($src eq 'shr') {
        print qq[Modify shared $modify_item_type\n];
      }
      else {
        print qq[Add $modify_item_type to shares\n];
      }
    }
    else {
      if ($src eq 'shr') {
        print qq[Import $modify_item_type\n];
      }
      else {
        print qq[Modify $modify_item_type\n];
      }
    }
    print qq[<input type="hidden" name="add_type" value="$modify_item_type" />\n];

    # If the destination file is not the same as the source file, don't 
    # pass along the ID parameter to b.mod2.pl. Hence, it will be treated as 
    # a new item to be added.
    if ($destination_xml_file eq $source_xml_file) {
      print qq[<input type="hidden" name="id" value="$modify_item_id" />\n];
    }
  }
  else {
    my $s = ' to shares' if ($dest eq 'shr'); 
    print qq[<input type="radio" name="add_type" value="bookmark" checked="checked" />Add bookmark$s<br />\n];
    print qq[<input type="radio" name="add_type" value="folder" />Add folder$s\n];
  }
  print qq[</p>\n];

  if (($modify_item_type eq "bookmark") or (! $modify_item_id)) {
    print qq[<p>\n];
    print qq[URI (ignored for folders)<br />\n];
    print qq[<input type="text" name="uri" value="$modify_item_data{'href'}" />\n];
    print qq[</p>\n];
  }

  print qq[<p>\n];
  print qq[Title<br />\n];
  print qq[<input type="text" name="title"];
  if ($modify_item_data{'title'}) {
    print qq[ value="$modify_item_data{'title'}"];
  }
  print qq[ />\n];
  print qq[</p>\n];

  print qq[<p>\n];
  print qq[Description<br />\n];
  print qq[<textarea name="desc" rows="4" cols="24">\n];
  if ($modify_item_data{'desc'}) {
    print qq[$modify_item_data{'desc'}\n];
  }
  print qq[</textarea>\n];
  print qq[</p>\n];

  print qq[<p>\n];
  print qq[In folder<br />\n];
  print qq[<select name="dest_folder">\n];
  &print_folder_options;
  print qq[</select><br />\n];
  print qq[</p>\n];

  print qq[<p>\n];
  print qq[<input type="submit" value="Go" />];
  print qq[</p>\n];

  print qq[</form>\n];
}

sub print_folder_options {

  my ($f_title, $f_level, $i, $space);

  foreach $i (0 .. $#folder_titles) {
    $f_title = $folder_titles[$i];
    $f_id = $folder_ids[$i];
    $f_level = $folder_levels[$i];
    $space = "&nbsp;&nbsp;" x $f_level;
    print qq[<option value="$f_id"];
    if (($enclosing_folder_id and $f_id eq $enclosing_folder_id) or 
        ($view_folder and $f_id eq $view_folder and $dest eq $src)) {
      print qq[ selected="selected"];
    }
    print qq[>$space$f_title</option>\n];
  }
}

sub inactive_menu_item {
  return if $modify_item_id;
  my $inactive = ($dest eq 'shr') ? 'shr:add' : 'add';
  return $inactive;
}
