# b.header.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Static items.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

$VERSION = '1.1.0';
$tab = "\t";

# Files and paths.
$xml_file = "b.xml";
$bsee_path = "b.see.pl";
$bmod_path = "b.mod.pl";
$bmod2_path = "b.mod2.pl";
$bdel_path = "b.del.pl";
$bfold_path = "b.fold.pl";
$busrnfo_path = "b.usrnfo.pl";
$busrnfo2_path = "b.usrnfo2.pl";
$bcontrib_path = "b.contrib.pl";
$blink_path = "b.link.pl";
$themes_path = "../b.shr/themes/";
$theme = "semaphore"; # Default, probably overridden in a b.conf file.
$css = "b.css";
$config_file = "b.conf";

# Related to user authentication.
$user_authentication_script = "b.auth.pl"; 
$users_path = "users/";
$user_starter_xml_template = "b.template.xml";
$user_starter_conf_template = "b.template.conf";
sub validate_user {} # Stub, redefined in b.user.pl. 
require "b.user.pl" if (-e "b.user.pl"); # The presence of this file
                                         # allows for user-interaction.
                                         # Shouldn't be present in the 
                                         # directory for shared bookmarks.

# Related to bookmark sharing. Used only if shr_on variable is set in b.conf.
$shr_xml_file = "b.shr.xml";
$shr_dir = "../b.shr/";

# Read in default configuration in b.conf in the root directory.
# Users may override defaults with a b.conf file in his/her user directory.
&load_config_values($config_file);

# Miscellaneous subroutines.
sub redisplay {
  my ($src, $view_folder) = @_;
  my $bsee_params = "\?src=$src";
  if ($view_folder) { $bsee_params .= "\&view_folder=$view_folder"; }
  &goto_page($bsee_path . $bsee_params);
}

sub load_config_values {
  my $file = $_[0];
  my $line;
  
  # Get list of protected vars
  my @protected = split(/[, ]+/, $protected_vars);

  open(CONF, "<$file") or return;
  while($line = <CONF>) { 
    if (! ($line =~ /^#/)) { # Ignore comments (lines beginning with '#').
      if ($line =~ /^(\w+)=(.*)\n/) {
        
        # Before assigning variable, check if it is a protected var already
        # with a value.
        next if ((defined eval "\$$1") and grep(/^$1$/, @protected));
        
        eval qq[\$$1='$2'];
      }
    }
  }
  close(CONF);

  &refresh_vars;
}

sub refresh_vars {
  # Refresh any variables which may depend on the just-loaded config file.
  $theme_path = $themes_path . $theme; 
  $css_path = $theme_path . "/$css"; 
  $b_user_menu_html = &user_menu_html;
}

sub print_user_menu {
  print &user_menu_html(@_);
}

sub user_menu_html {
  my $inactive = $_[0]; # First arg, if present, indicates which button 
                        # is inactive.
  my $vf = "\&view_folder=$view_folder" if $view_folder;
  my $busrnfo_params;
  $busrnfo_params = "?src=$src$vf" if $src;
  
  my $see_text    = ($inactive eq 'see') ? 
      qq[see] : 
      qq[<a href="$bsee_path" title="See my bookmarks">see</a>];
  my $add_text    = ($inactive eq 'add') ? 
      qq[add] :
      qq[<a href="$bmod_path" title="Add to my bookmarks">add</a>];
  my $usrnfo_text = ($inactive eq 'usrnfo') ? 
      qq[usrnfo] :
      qq[<a href="$busrnfo_path$busrnfo_params" title="See my user info">usrnfo</a>];
  my $shrsee_text = ($inactive eq 'shr:see') ? 
      qq[shr:see] :
      qq[<a href="$bsee_path?src=shr$vf" title="See shared bookmarks">shr:see</a>];
  my $shradd_text = ($inactive eq 'shr:add') ? 
      qq[shr:add] :
      qq[<a href="$bmod_path?src=shr\&dest=shr$vf" title="Add to shared bookmarks">shr:add</a>];
  
  my $s = '';
  $s .= qq[<div class="menu-cl">\n];
  
  $s .= qq[<div class="menu-btn-cl">\n];
  $s .= qq[<span class="menu-btn-text-cl">$see_text</span>\n];
  $s .= qq[ | \n];
  $s .= qq[<span class="menu-btn-text-cl">$add_text</span>\n];
  $s .= qq[</div>\n];
  
  if (defined $user) {
    $s .= qq[<div class="menu-usrnfo-btn-cl">\n];
    $s .= qq[<span class="menu-usrnfo-btn-text-cl">];
    $s .= qq[$usrnfo_text</span>\n];
    $s .= qq[</div>\n];
  }
  
  if ($shr_on) {
    $s .= qq[<div class="menu-shr-btn-cl">\n];
    $s .= qq[<span class="menu-shr-btn-text-cl">];
    $s .= qq[$shrsee_text</span>\n];
    $s .= qq[ | \n];
    $s .= qq[<span class="menu-shr-btn-text-cl">];
    $s .= qq[$shradd_text</span>\n];
    $s .= qq[</div>\n];
  }
  
  $s .= qq[</div>\n];
  
  return $s;
}

sub print_html_msg_page {
  $msg = $_[0];
  &print_html_from_template("$theme_path/b.msg.html") or 
      &print_html_header('b.msg', $html_dtd, $html_ns, 
                         &link_to_css($css_path)) and 
      &print_user_menu and 
      print qq[<div class="msg-cl">$msg</div>] and 
      &print_html_footer;
}

sub update_shr_stats {
  return if (! defined $user);
  my $type = &get_type;
  if ($type eq "bookmark") {
    my %att = &parse_attributes(&get_attributes);
    my $contributer = $att{'contributer'};
    return if (! defined $contributer);
    if ($contributer eq $user) {
      $shr_num++;
    }
  }
}

sub print_shr_stats {
  return unless $shr_on, $shr_limit;

  $shr_num = 0 if (! $shr_num); 
  print qq[<div class="shr-stats-cl">];
  print qq[# of shares: $shr_num/$shr_limit];
  print qq[</div>\n];

  if ($shr_num >= $shr_limit) {
    print qq[<div class="error-msg-cl">\n];
    print qq[$tabYou currently meet the maximum number of shared bookmarks.\n];
    print qq[</div>\n];
    $exceed_shr_limit = 1;
  }
}

sub abort_if_exceed_shr_limit {
  if ($shr_num >= $shr_limit) {
    my $msg = 'You currently meet the maximum number of shared bookmarks';
    $msg .= " alotted per user ($shr_num/$shr_limit). You must first delete";
    $msg .= ' some of your pre-existing bookmarks.';
    &print_content_type_html unless $dont_need_content_type;
    &print_html_msg_page($msg);
    exit -1;
  }
}

1;


