#! /usr/bin/perl

# b.fold.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Open or close a folder.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.parse.pl";
require "cgi.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&register_handlers;
&get_form_data;
&open_and_lock_xml_file;
&process_xbel;
&write_xml_with_backup;
&unlock_and_close_xml_file;
&redisplay;

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub register_handlers {
  &set_handler("Element-Start.folder", \&handle_folder_start);
}

sub handle_folder_start {
  my $i = &get_index;
  my %att = &parse_attributes(&get_attributes);
  my $id = $att{'id'};

  if (($fold_item_id) and ($fold_item_id eq $id)) {

    my $attributes = &get_attributes;
    $fold_item_attributes = &set_attribute($attributes, "folded", $fold);
    &splice_xbel($i, 1, "<folder $fold_item_attributes>");
  }
}

sub get_form_data {
  &parse_form_data(*dat);
  $fold_item_id = $dat{'id'}; 
  $fold = $dat{'fold'};
}

