#! /usr/bin/perl

# b.del.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Delete entry.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "b.parse.pl";
require "cgi.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&get_env_params;
&register_handlers;
&open_and_lock_xml_file;
&process_xbel;
&delete_item if defined $user;
&write_xml_with_backup;
&unlock_and_close_xml_file;
&redisplay($src, $view_folder);

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_env_params {
  &parse_form_data(*dat);
  $delete_item_id = $dat{'id'};
  $src = $dat{'src'};
  $view_folder = $dat{'view_folder'};
  
  &set_working_xml_file($shr_dir . $shr_xml_file) if $src eq 'shr';
  $is_comment_deletable = 1 if ($user_can_delete_comment or $is_user_admin);
}

sub register_handlers {
  &set_handler("Element-Start.folder", \&handle_folder_start);
  &set_handler("Element-Start.bookmark", \&handle_bookmark_start);
  &set_handler("Element-Start.comment", \&handle_comment_start);
  &set_handler("Element-End.folder", \&handle_folder_end);
  &set_handler("Element-End.bookmark", \&handle_bookmark_end);
  &set_handler("Element-End.comment", \&handle_comment_end);
}

sub handle_folder_start {
  &look_for_delete_item;
  &abort_if_not_contributer;
}

sub handle_bookmark_start {
  &look_for_delete_item;
  &abort_if_not_contributer;
}

sub handle_comment_start {
  &look_for_delete_item if $is_comment_deletable;
}

sub handle_folder_end {
  &look_for_delete_item_end;
}

sub handle_bookmark_end {
  &look_for_delete_item_end;
}

sub handle_comment_end {
  &look_for_delete_item_end;
}

sub look_for_delete_item {
  my $type = &get_type;
  my $i = &get_index;
  my $id = &get_id;
  my %att = &parse_attributes(&get_attributes);

  # Check if this is the item to delete.
  if (($delete_item_id) and ($delete_item_id eq $id)) {

    $mark_delete_item_begin = $i;
    $delete_item_type = $type;
    $delete_item_level = &get_depth;
  }
}

sub abort_if_not_contributer {

  # Check to see that the delete item is not, nor contains, any bookmark
  # or folder not contributed by this user. Note: comments contributed 
  # by others are not protected from deletion.
  return if ! defined $user;
  return if (! $mark_delete_item_begin or $mark_delete_item_end); 

  my %att = &parse_attributes(&get_attributes);
  my $contributer = $att{'contributer'};
  return if ! $contributer and ! $is_user_admin;

  if ($user ne $contributer and ! $is_user_admin) {
    # Abort. Prepare error message.
    my $msg = qq[Error: The item to be deleted is contributed by, ];
    $msg .= qq[or contains an item contributed by, another user.];
    &print_content_type_html unless $dont_need_content_type;
    &print_html_msg_page($msg);
    exit(-1);
  }
}

sub look_for_delete_item_end {
  my $type = &get_type;
  my $i = &get_index;
  my $l = &get_depth;

  # If beginning mark is set, look for end.
  if ((! $mark_delete_item_end) and 
      ($mark_delete_item_begin) and 
      ($delete_item_type eq $type) and 
      ($l == $delete_item_level)) {

    $mark_delete_item_end = $i;
  }
}

sub delete_item {

  # Splice out item to delete.
  if (($delete_item_id) and 
      ($mark_delete_item_begin) and 
      ($mark_delete_item_end)) {
    my $len = $mark_delete_item_end - $mark_delete_item_begin + 1;
    &splice_xbel($mark_delete_item_begin, $len) if ($len > 0);
  }
}


