#! /usr/bin/perl

# b.contrib.pl 
# Victor Liu See-le - mailto:victor@n-gon.com
# Via an HTML form, contribute a comment to the b.shr bookmarks.
#
# Copyright (C) 2001 Victor Liu See-le
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "cgi.pl";
require "b.display.pl";


###############################################################################
# Begin MAIN                                                                  #

&validate_user;
&get_env_params;
&print_content_type_html_no_cache unless $dont_need_content_type;
&print_html_from_template("$theme_path/b.contrib.header.html") or 
    &print_html_header('b.contrib', $html_dtd, $html_ns, 
                       &link_to_css($css_path));
&print_user_menu if defined $user;
&print_html_form;
&set_working_xml_file($shr_dir . $shr_xml_file);
&register_handlers;
&open_and_lock_xml_file;
&process_xbel;
&write_xml_with_backup if &xml_has_changed;
&unlock_and_close_xml_file;
&print_html_from_template("$theme_path/b.contrib.footer.html") or 
    &print_html_footer;

exit(0);

# End of MAIN                                                                 #
###############################################################################

sub get_env_params {
  &parse_form_data(*dat);
  $view_folder = $dat{'view_folder'};
  $contrib_item_id = $dat{'id'};
  if (! $contrib_item_id) {
    &print_content_type_html unless $dont_need_content_type;
    &print_html_msg_page('Error: No id specified! Contact b. admin.');
    exit(-1);
  }
  $src = 'shr';
}

sub register_handlers {
  &set_handler("Element-Start.xbel", \&display_xbel_start);
  &set_handler("Element-Start.folder", \&display_contrib_folder_start);
  &set_handler("Element-Start.bookmark", \&display_contrib_bookmark_start);
  &set_handler("Element-Start.comment", \&display_comment_start);
  &set_handler("Element-End.xbel", \&display_xbel_end);
  &set_handler("Element-End.folder", \&display_contrib_folder_end);
  &set_handler("Element-End.bookmark", \&display_contrib_bookmark_end);
  &set_handler("Element-End.comment", \&display_comment_end);
  &set_handler("Text.folder.title", \&display_folder_title);
  &set_handler("Text.folder.desc", \&display_folder_desc);
  &set_handler("Text.folder.comment", \&display_folder_comment);
  &set_handler("Text.bookmark.title", \&display_bookmark_title);
  &set_handler("Text.bookmark.desc", \&display_bookmark_desc);
  &set_handler("Text.bookmark.comment", \&display_bookmark_comment);
}

sub display_contrib_folder_start {
  &display_if_contrib_item;
}

sub display_contrib_bookmark_start {
  &display_if_contrib_item;
}

sub display_contrib_folder_end {
  &finish_display_item if $flag_display_item;
}

sub display_contrib_bookmark_end {
  &finish_display_item if $flag_display_item;
}

sub display_if_contrib_item {
  &finish_display_item if $flag_display_item;

  return if (&get_id ne $contrib_item_id);

  my $type = &get_type;
  my %att = &parse_attributes(&get_attributes);
    
  &print_div_open("$type-cl");
  print "\n";
  $flag_display_item = 1;
  $contrib_item_type = $type;
    
  # Extra information on this item can be displayed after the item's title
  # or desc. Which extra info, and the order in which they're displayed,
  # are specified in b.conf (cf after_bookmark_title_display_order, etc).
  $after_open_div = &xtra_info_div('open', $type, %att);
  $after_title_div = &xtra_info_div('title', $type, %att);
  $after_desc_div = &xtra_info_div('desc', $type, %att);
  
  # Go ahead and print the $after_open_div stuff.
  if ($after_open_div) {
    print $after_open_div;
    $after_open_div = '';
  }
}

sub finish_display_item {
  if ($flag_display_item) {
    $flag_display_item = 0;
    &print_div_close;
  }
}

sub print_html_form {

  print qq[<form action="$bmod2_path" method="post">\n];
  
  print qq[<input type="hidden" name="view_folder" value="$view_folder" />\n];
  print qq[<input type="hidden" name="src" value="shr" />\n];
  print qq[<input type="hidden" name="dest" value="shr" />\n];
  print qq[<input type="hidden" name="add_type" value="$contrib_item_type" />\n];
  print qq[<input type="hidden" name="id" value="$contrib_item_id" />\n];
  print qq[<input type="hidden" name="append" value="comment" />\n];

  print qq[<p>\n];
  print qq[Contribute comment<br />\n];
  print qq[<textarea name="comment" rows="4" cols="24">\n];
  print qq[</textarea>\n];
  print qq[</p>\n];

  print qq[<p>\n];
  print qq[<input type="submit" value="Contrib" />];
  print qq[</p>\n];

  print qq[</form>\n];
}
