VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "TextCmd"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' ************************************************
' Command class that represents adding text.
' ************************************************
Option Explicit

' The TextBox control.
Public TextCtl As TextBox

' Values before the change.
Private OldText As String
Public OldStart As Integer
Public OldLength As Integer

' New values.
Public NewText As String
' ************************************************
' Undo the change.
' ************************************************
Public Sub Undo()
    TextCtl.SelStart = OldStart
    TextCtl.SelLength = Len(NewText)
    TextCtl.SelText = OldText
End Sub
' ************************************************
' Apply the change.
' ************************************************
Public Sub Apply()
    TextCtl.SelStart = OldStart
    TextCtl.SelLength = OldLength
    TextCtl.SelText = NewText
End Sub
' ************************************************
' Save information needed to Apply and Undo.
' ************************************************
Public Sub Initialize(ctl As TextBox, new_text As String)
    Set TextCtl = ctl
    NewText = new_text
    OldStart = TextCtl.SelStart
    OldLength = TextCtl.SelLength
    OldText = TextCtl.SelText
End Sub
