VERSION 5.00
Begin VB.Form frmSparseMatrix 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Sparse Matrix"
   ClientHeight    =   4575
   ClientLeft      =   1755
   ClientTop       =   1800
   ClientWidth     =   6375
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4575
   ScaleWidth      =   6375
   ShowInTaskbar   =   0   'False
   Begin VB.PictureBox Picture1 
      BackColor       =   &H00FFFFFF&
      ClipControls    =   0   'False
      Height          =   3855
      Left            =   120
      ScaleHeight     =   3795
      ScaleWidth      =   5835
      TabIndex        =   1
      Top             =   360
      Width           =   5895
   End
   Begin VB.HScrollBar hscScroll 
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   4200
      Width           =   5895
   End
   Begin VB.VScrollBar vscScroll 
      Height          =   3855
      Left            =   6000
      TabIndex        =   2
      Top             =   360
      Width           =   255
   End
   Begin VB.Label lblTopLeft 
      Caption         =   "..."
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3495
   End
End
Attribute VB_Name = "frmSparseMatrix"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'SprsMtrx - Sparse matrix demo
'Copyright (c) 1997 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This Visual Basic 5.0 example program demonstrates a simple sparse
'matrix class. A sparse matrix class behaves like a 2-dimensional
'array. However, it is indended for enormous arrays that are mostly
'empty. For example, if you used a two-dimensional array to represent
'a spreadsheet with 500 rows and 500 columns, the array would contain
'250,000 elements. This would be an incredible waste of memory if the
'spreadsheet only contained a handful of items.
'
'Here, a sparse matrix class can be used to handle large arrays that
'are only sparsely populated. The sparse matrix class takes advantage
'of Visual Basic's property Let and Get statements to provide the
'functionality of a sparse matrix with the same simple syntax required
'for a two-dimensional array.
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

Private Const CELL_WIDTH = 1000
Private Const CELL_HEIGHT = 255
Private m_Top As Integer, m_Left As Integer
Private Matrix As New CSparseMatrix

'Initialize form
Private Sub Form_Load()
    Dim i As Integer

    'Setup scrollbars for 500x500 grid
    vscScroll.Min = 1
    vscScroll.Max = 500
    vscScroll.LargeChange = (Picture1.ScaleHeight / CELL_HEIGHT)
    hscScroll.Min = 1
    hscScroll.Max = 500
    hscScroll.LargeChange = (Picture1.ScaleWidth / CELL_WIDTH)

    'Enter some values into the spreadsheet
    For i = 1 To 500
        Matrix.Cell(i, i) = CStr(i) & "," & CStr(i)
    Next i
End Sub

'Horizontal scroll
Private Sub hscScroll_Change()
    m_Left = hscScroll
    Picture1.Refresh
End Sub

'Vertical scroll
Private Sub vscScroll_Change()
    m_Top = vscScroll
    Picture1.Refresh
End Sub

'Paint spreadsheet
Private Sub Picture1_Paint()
    Dim x As Integer, y As Integer
    Dim v As Variant

    'Clear existing data
    Picture1.Cls
    'Paint grid lines
    For y = CELL_HEIGHT To Picture1.ScaleHeight Step CELL_HEIGHT
        Picture1.Line (0, y)-(Picture1.ScaleWidth, y), RGB(128, 128, 128)
    Next y
    For x = CELL_WIDTH To Picture1.ScaleWidth Step CELL_WIDTH
        Picture1.Line (x, 0)-(x, Picture1.ScaleHeight), RGB(128, 128, 128)
    Next x
    'Show grid data for cells that contain data
    For x = 0 To Picture1.ScaleWidth / CELL_WIDTH
        For y = 0 To Picture1.ScaleHeight / CELL_HEIGHT
            v = Matrix.Cell(m_Top + y, m_Left + x)
            If Not IsEmpty(v) Then
                Picture1.CurrentX = (x * CELL_WIDTH) + 50
                Picture1.CurrentY = (y * CELL_HEIGHT) + 25
                Picture1.Print CStr(v)
            End If
        Next y
    Next x
    'Indicate current scroll positions
    lblTopLeft = "Top: " & CStr(m_Top) & ", Left: " & CStr(m_Left)
End Sub

