VERSION 4.00
Begin VB.Form EditorForm 
   Caption         =   "Editor []"
   ClientHeight    =   4110
   ClientLeft      =   1140
   ClientTop       =   1800
   ClientWidth     =   4575
   Height          =   4800
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4110
   ScaleWidth      =   4575
   Top             =   1170
   Width           =   4695
   Begin VB.TextBox EditorText 
      Height          =   2175
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   240
      Width           =   2175
   End
   Begin MSComDlg.CommonDialog FileDialog 
      Left            =   0
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
      CancelError     =   -1  'True
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New"
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFileSaveAs 
         Caption         =   "Save &As..."
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpContents 
         Caption         =   "&Contents..."
      End
      Begin VB.Menu mnuHelpSearch 
         Caption         =   "&Search..."
      End
      Begin VB.Menu mnuHelpSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About This Program..."
      End
   End
End
Attribute VB_Name = "EditorForm"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private FileName As String  ' The full file name.
Private FileTitle As String ' The file name without path.

Private DataModified As Boolean

' Return True if the data is safe.
Private Function DataSafe() As Boolean
    ' No problem if the data is unmodified.
    If Not DataModified Then
        DataSafe = True
        Exit Function
    End If
    
    ' See if the user wants to save changes.
    Select Case MsgBox("The data has been modified. Do you want to save the changes?", _
            vbYesNoCancel)
        Case vbYes
            ' Save the data. Procedure SaveData
            ' will reset DataModified.
            mnuFileSave_Click
            DataSafe = Not DataModified
            
        Case vbNo
            ' Discard the changes to the data.
            DataSafe = True
            
        Case vbNo
            ' Cancel.
            DataSafe = False
    End Select
End Function

' Load data from the file.
'
' @@@ Modify to load data of the correct format.
Private Sub LoadData(ftitle As String, fname As String)
Dim fnum As Integer

    ' Open the file.
    fnum = FreeFile
    Open fname For Input As fnum
    
    ' Read all the bytes in the file into the
    ' TextBox.
    EditorText.Text = Input(LOF(fnum), fnum)
    
    ' Close the file.
    Close fnum

    ' Save the file name and title.
    FileTitle = ftitle
    FileName = fname
    
    ' Make sure the caption gets updated.
    DataModified = True
    SetDataChanged False
End Sub
' Save data into the file.
'
' @@@ Modify to save data in the correct format.
Private Sub SaveData(ftitle As String, fname As String)
Dim fnum As Integer

    ' Open the file.
    fnum = FreeFile
    Open fname For Output As fnum
    
    ' Write text from the TextBox into the file.
    Print #fnum, EditorText.Text
    
    ' Close the file.
    Close fnum
    
    ' Save the file name and title.
    FileTitle = ftitle
    FileName = fname
    
    ' Make sure the caption gets updated.
    DataModified = True
    SetDataChanged False
End Sub
' Set DataModified. Display an asterisk in the
' form's Caption next to the file name if
' appropriate.
Private Sub SetDataChanged(changed As Boolean)
    ' Don't bother if it's already been done.
    If DataModified = changed Then Exit Sub
    
    DataModified = changed
    If changed Then
        Caption = "Editor*[" & FileTitle & "]"
    Else
        Caption = "Editor [" & FileTitle & "]"
    End If
End Sub

' Set the file dialog's path for the next time.
Private Sub SetDialogPath()
Dim file_path As String

    ' Remove characters from the right until the
    ' path ends in \.
    file_path = FileDialog.FileName
    Do While Right$(file_path, 1) <> "\"
        file_path = Left$(file_path, Len(file_path) - 1)
    Loop

    FileDialog.InitDir = file_path

    ' Save the directory in the registry.
    '
    ' @@@ Change the application and section names.
    SaveSetting "SimpleEditor", "Directories", _
        "SaveDir", FileDialog.InitDir
End Sub

' Mark the data as modified.
'
' @@@ Call DataChanged whenever the user
' @@@ changes the data.
Private Sub EditorText_Change()
    SetDataChanged True
End Sub

Private Sub Form_Load()
Dim wid As Single
Dim hgt As Single
    
    ' Get the last directory the program accessed.
    ' If there is no entry, use the App.Path.
    '
    ' @@@ Change the application and section names.
    FileDialog.InitDir = GetSetting( _
        "SimpleEditor", "Directories", _
        "SaveDir", App.Path)
End Sub

' Make sure the data is safe to unload.
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Cancel = Not DataSafe
End Sub
Private Sub Form_Resize()
    EditorText.Move 0, 0, ScaleWidth, ScaleHeight
End Sub

' Unload the form.
Private Sub mnuFileExit_Click()
    ' Note: The QueryUnload event handler checks
    ' that the data is safe.
    Unload Me
End Sub


' Start a new file.
'
Private Sub mnuFileNew_Click()
    ' Make sure the existing data is safe.
    If Not DataSafe Then Exit Sub
    
    ' @@@ Do whatever is necessary to start a
    ' @@@ new document.
    EditorText.Text = ""
    
    ' Save the file name and title.
    FileTitle = ""
    FileName = ""

    ' Make sure the caption gets updated.
    DataModified = True
    SetDataChanged False
End Sub

' Open a file.
Private Sub mnuFileOpen_Click()
    ' Make sure the existing data is safe.
    If Not DataSafe Then Exit Sub
    
    ' Start in the application directory.
    If FileDialog.InitDir = "" Then _
        FileDialog.InitDir = App.Path

    ' @@@ Set desired flags.
    FileDialog.Flags = cdlOFNFileMustExist + _
        cdlOFNHideReadOnly + _
        cdlOFNLongNames
        
    ' @@@ Set desired filters.
    FileDialog.Filter = "Text files (*.txt)|*.txt"
    FileDialog.FilterIndex = 0
    
    ' Let the user select the file to open.
    On Error Resume Next
    FileDialog.ShowOpen
    If Err.Number = cdlCancel Then
        ' The user canceled.
        Exit Sub
    ElseIf Err.Number <> 0 Then
        MsgBox "Error" & Str$(Err.Number) & " selecting file." & _
            vbCrLf & Err.Description
        Exit Sub
    End If
    On Error GoTo 0
    
    ' Set the dialog path for next time.
    SetDialogPath
    
    ' Load the data.
    LoadData FileDialog.FileTitle, FileDialog.FileName
End Sub


' Save using the current file name.
Private Sub mnuFileSave_Click()
    ' If there's no file name, treat as Save As.
    If FileTitle = "" Then
        mnuFileSaveAs_Click
        Exit Sub
    End If
    
    ' Save the data using the current file name.
    SaveData FileTitle, FileName
End Sub

' Save using a new file name.
Private Sub mnuFileSaveAs_Click()
    ' Start in the application directory.
    If FileDialog.InitDir = "" Then _
        FileDialog.InitDir = App.Path
        
    ' @@@ Set desired flags.
    FileDialog.Flags = cdlOFNPathMustExist + _
        cdlOFNHideReadOnly + _
        cdlOFNLongNames
        
    ' @@@ Set desired filters.
    FileDialog.Filter = "Text files (*.txt)|*.txt"
    FileDialog.FilterIndex = 0
    
    ' Let the user select the file to open.
    On Error Resume Next
    FileDialog.ShowSave
    If Err.Number = cdlCancel Then
        ' The user canceled.
        Exit Sub
    ElseIf Err.Number <> 0 Then
        MsgBox "Error" & Str$(Err.Number) & " selecting file." & _
            vbCrLf & Err.Description
        Exit Sub
    End If
    On Error GoTo 0
    
    ' Set the dialog path for next time.
    SetDialogPath

    ' Load the data.
    SaveData FileDialog.FileTitle, FileDialog.FileName
End Sub

Private Sub mnuHelpAbout_Click()
    ' @@@
    MsgBox "Show About dialog here."
End Sub


' Show the help contents.
'
' @@@ Create the help file SimpEdit.hlp.
Private Sub mnuHelpContents_Click()
    FileDialog.HelpCommand = cdlHelpContents
    FileDialog.HelpFile = App.Path & "\SimpEdit.hlp"
    FileDialog.ShowHelp
End Sub


' Display the help index so the user can search.
'
' @@@ Create the help file SimpEdit.hlp.
Private Sub mnuHelpSearch_Click()
    FileDialog.HelpCommand = cdlHelpIndex
    FileDialog.HelpFile = App.Path & "\SimpEdit.hlp"
    FileDialog.ShowHelp
End Sub


