VERSION 4.00
Begin VB.Form frmDemo 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "QuickSort Demonstration"
   ClientHeight    =   6555
   ClientLeft      =   2715
   ClientTop       =   1320
   ClientWidth     =   7155
   Height          =   6960
   Left            =   2655
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6555
   ScaleWidth      =   7155
   Top             =   975
   Width           =   7275
   Begin VB.TextBox txtSorted 
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1740
      Left            =   75
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   15
      Top             =   3120
      Width           =   6915
   End
   Begin VB.TextBox txtUnsorted 
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1755
      Left            =   75
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   14
      Top             =   900
      Width           =   6915
   End
   Begin VB.CommandButton cmdCreate 
      Caption         =   "Create Data"
      Height          =   400
      Left            =   5685
      TabIndex        =   13
      Top             =   5040
      Width           =   1275
   End
   Begin VB.Frame Frame2 
      Height          =   1290
      Left            =   4200
      TabIndex        =   9
      Top             =   5040
      Width           =   1365
      Begin VB.OptionButton optNo 
         Caption         =   "No"
         Height          =   240
         Left            =   300
         TabIndex        =   12
         Top             =   900
         Value           =   -1  'True
         Width           =   990
      End
      Begin VB.OptionButton optYes 
         Caption         =   "Yes"
         Height          =   240
         Left            =   300
         TabIndex        =   11
         Top             =   600
         Width           =   765
      End
      Begin VB.Label Label5 
         BackStyle       =   0  'Transparent
         Caption         =   "Remove Dupes"
         Height          =   240
         Left            =   75
         TabIndex        =   10
         Top             =   225
         Width           =   1290
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   400
      Left            =   5685
      TabIndex        =   8
      Top             =   6000
      Width           =   1275
   End
   Begin VB.CommandButton cmdSort 
      Caption         =   "Sort Data"
      Height          =   400
      Left            =   5685
      TabIndex        =   7
      Top             =   5520
      Width           =   1275
   End
   Begin VB.Frame Frame1 
      Height          =   1290
      Left            =   2760
      TabIndex        =   2
      Top             =   5040
      Width           =   1290
      Begin VB.OptionButton optNumeric 
         Caption         =   "Numeric"
         Height          =   315
         Left            =   225
         TabIndex        =   5
         Top             =   900
         Value           =   -1  'True
         Width           =   990
      End
      Begin VB.OptionButton optString 
         Caption         =   "String"
         Height          =   315
         Left            =   225
         TabIndex        =   4
         Top             =   600
         Width           =   915
      End
      Begin VB.Label Label3 
         BackStyle       =   0  'Transparent
         Caption         =   "Select the type of data to sort"
         Height          =   390
         Left            =   75
         TabIndex        =   3
         Top             =   150
         Width           =   1215
      End
   End
   Begin VB.Label lblSortTime 
      BackStyle       =   0  'Transparent
      Height          =   315
      Left            =   75
      TabIndex        =   17
      Top             =   5100
      Width           =   2565
   End
   Begin VB.Label lblComments 
      BackStyle       =   0  'Transparent
      Caption         =   "Written by Kenneth Ives"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Times New Roman"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   780
      Left            =   225
      TabIndex        =   16
      Top             =   5475
      Width           =   2475
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "For demo purposes, we are only using 1000 items."
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   120
      TabIndex        =   6
      Top             =   240
      Width           =   6855
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Sorted data"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   75
      TabIndex        =   1
      Top             =   2880
      Width           =   6915
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Unsorted data"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   75
      TabIndex        =   0
      Top             =   675
      Width           =   6915
   End
End
Attribute VB_Name = "frmDemo"
Attribute VB_Creatable = False
Attribute VB_Exposed = False


Option Explicit

' ---------------------------------------------------------
' Shell sort demo
' Author:     Kenneth Ives      kenives@cmpu.net
'
' This is freeware.  Use as you see fit.
' Compiled with VB 5.0 (Sp3)
'
' If you do not want to use a list box to do your sorting
' then use this sort routine.
'
' NOTE:  It averages about 30-60 seconds to sort and remove
'        the dupes from 10,000 items (depending on the number
'        of duplicate items.  However, it only takes about
'        3-6 seconds without removing the dupes.
' ---------------------------------------------------------

Const MAXSIZE = 1000
Private tstAray(1 To MAXSIZE) As String
Private Function BuildThreeCharStr() As String

' ------------------------------------------------
' Define variables
' ------------------------------------------------
  Dim n As Integer
  Dim iTmpNum As Integer
  Dim sTmpChar As String
  
' ------------------------------------------------
' Initialize variables
' ------------------------------------------------
  n = 0
  iTmpNum = 0
  sTmpChar = ""
  
' ------------------------------------------------
' Seed the random generator with the number of
' seconds that have elapsed since midnight
' ------------------------------------------------
  Randomize Timer
  
' ------------------------------------------------
' Loop until we have created three printable
' characters
' ------------------------------------------------
  Do
      iTmpNum = Int((90 * Rnd) + 1)
      
      Select Case iTmpNum
             '
             ' we want A-Z (Uppercase only)
             Case 65 To 90
                  ' convert the the decimal value to ASCII text
                  sTmpChar = sTmpChar & Chr(iTmpNum)
                  ' increment character count
                  n = n + 1
                
             Case Else
                  ' Try again
      End Select
          
  Loop Until n = 3

' ------------------------------------------------
' Return the three character group
' ------------------------------------------------
  BuildThreeCharStr = sTmpChar
  
End Function

Private Function BuildThreeNumbers() As String
  
' ------------------------------------------------
' Define variables
' ------------------------------------------------
  Dim sNumStr As String
  
' ------------------------------------------------
' Initialize variables
' ------------------------------------------------
  sNumStr = ""
  
' ------------------------------------------------
' Seed the random generator with the number of
' seconds that have elapsed since midnight
' ------------------------------------------------
  Randomize Timer
  
' ------------------------------------------------
' generate a random number between 1 and 999
' ------------------------------------------------
  sNumStr = CStr(Int((999 * Rnd) + 1))
  
' ------------------------------------------------
' Return formatted number with leading zeros
' for display purposes
' ------------------------------------------------
  BuildThreeNumbers = Format(sNumStr, "@@@")

End Function
Private Sub DisplayTheData(ctl As Control)

' ------------------------------------------------
' Define variables
' ------------------------------------------------
  Dim i As Long
  Dim n As Integer
  Dim sTmpStr As String
  Dim sNewStr As String
  
' ------------------------------------------------
' Initialize variables
' ------------------------------------------------

' ------------------------------------------------
' Go thru the sorted array and build the
' display line for the output
' ------------------------------------------------
  For i = 1 To MAXSIZE
      If Len(tstAray(i)) <> 0 Then
          ' Increment the counter
          n = n + 1
          ' No more than 12 items on a line
          If n = 13 Then
              sNewStr = sNewStr & sTmpStr & vbCrLf
              sTmpStr = ""
              n = 1
          End If
          
          ' append additional items to the line
          sTmpStr = sTmpStr & Space(2) & Format(tstAray(i), "@@@")
      
      End If
  Next
  
' ------------------------------------------------
' Check to see if there was any leftover data
' in the temp string.  If so, append it to the
' display string
' ------------------------------------------------
  If Len(sTmpStr) > 0 Then
      sNewStr = sNewStr & sTmpStr & vbCrLf
  End If
  
' ------------------------------------------------
' Copy the sorted data to the text box and
' update the screen
' ------------------------------------------------
  ctl.Text = ""
  ctl.Text = sNewStr
  frmDemo.Refresh

End Sub

Private Sub cmdCreate_Click()

' ------------------------------------------------
' Define variables
' ------------------------------------------------
  Dim i As Long                        ' Index counter
  Dim n As Integer                     ' numbr of items grouped
  Dim iTmpNum As Integer               ' Random value
  Dim sNewStr As String                ' Final string to be displayed
  Dim sTmpLine As String               ' Temp string for building a line
  Dim sTmpStr As String                ' Temp string for building 3 values
  
' ------------------------------------------------
' Initialize variables
' ------------------------------------------------
  Screen.MousePointer = vbHourglass
  i = 0
  n = 0
  sNewStr = ""
  sTmpLine = ""
  
' ------------------------------------------------
' empty the text boxes and refresh the screen
' ------------------------------------------------
  txtUnsorted.Text = ""
  txtSorted.Text = ""
  lblSortTime.Caption = ""
  cmdSort.Enabled = False
  frmDemo.Refresh
  
' ------------------------------------------------
' empty array
' ------------------------------------------------
  Erase tstAray
  
' ------------------------------------------------
' Are we doing strings or numbers
' ------------------------------------------------
  Do
        sTmpStr = ""
        iTmpNum = 0
        
        If optString Then
            sTmpStr = BuildThreeCharStr
        Else
            sTmpStr = BuildThreeNumbers
        End If
  
        i = i + 1              ' increment the array index counter
        tstAray(i) = sTmpStr   ' place in array
        
  Loop Until i = MAXSIZE
  
' ------------------------------------------------
' Display the data
' ------------------------------------------------
  DisplayTheData txtUnsorted
  cmdSort.Enabled = True
  Screen.MousePointer = vbNormal
  
End Sub
Private Sub cmdExit_Click()

' ------------------------------------------------
' Unload this form
' ------------------------------------------------
  Unload frmDemo     ' Deavtivate this form
  
End Sub


Private Sub cmdSort_Click()

' ------------------------------------------------
' Define variables
' ------------------------------------------------
  Dim i As Long                        ' Index counter
  Dim n As Integer                     ' numbr of items on a display line
  Dim lNumOfSeconds As Long            ' Number of seconds
  Dim sNewStr As String                ' Final string to be displayed
  Dim sTmpStr As String                ' Temp string for building a line
  ReDim tmpAray(1 To MAXSIZE) As String  ' Array to be sorted
  Dim bRemovedupes As Boolean          ' remove duplicates (True or False)
  Dim vStart As Variant                ' starting time
  Dim Low As Long
  Dim Hi As Long

' ------------------------------------------------
' Initialize variables
' ------------------------------------------------
  Screen.MousePointer = vbHourglass
  n = 0
  sNewStr = ""
  sTmpStr = ""
  vStart = Now         ' get the system time
  
' ------------------------------------------------
' Remove Duplicates?
' ------------------------------------------------
  If optYes Then
      bRemovedupes = True
  Else
      bRemovedupes = False
  End If
  
' ------------------------------------------------
' Load the array to be sorted.  If there is no
' data in the unsorted array then fill
' with null string
' ------------------------------------------------
  For i = 1 To MAXSIZE
      If Len(Trim(tstAray(i))) = 0 Then
          tmpAray(i) = Empty
      Else
          tmpAray(i) = tstAray(i)
      End If
  Next
  
  Erase tstAray     ' empty the original array
  
' ------------------------------------------------
' Sort the data and remove the duplicate values,
' if requested.
' ------------------------------------------------
  Low = LBound(tmpAray)
  Hi = UBound(tmpAray)
  QuickSort tmpAray(), Low, Hi         ' Sort the data
  
  If bRemovedupes Then
      RemoveDupes tmpAray()            ' Remove the duplicate values
      QuickSort tmpAray(), Low, Hi     ' Resort the data
  End If
  
' ------------------------------------------------
' Transfer data back to origianl array
' ------------------------------------------------
  For i = 1 To MAXSIZE
      tstAray(i) = tmpAray(i)
  Next
  
' ------------------------------------------------
' Display the elapsed time
' ------------------------------------------------
  lNumOfSeconds = DateDiff("s", vStart, Now)
  lNumOfSeconds = IIf(lNumOfSeconds = 0, 1, lNumOfSeconds)
  lblSortTime.Caption = "Elapsed time:  " & CStr(lNumOfSeconds) & " seconds (Approx)"

' ------------------------------------------------
' Display the data
' ------------------------------------------------
  DisplayTheData txtSorted
  cmdSort.Enabled = False
  Screen.MousePointer = vbNormal
  
' ------------------------------------------------
' empty both arrays
' ------------------------------------------------
  Erase tmpAray
  Erase tstAray
  
End Sub


Private Sub Form_Load()
  
' ------------------------------------------------
' Disable the Sort command button
' ------------------------------------------------
  cmdSort.Enabled = False

' ------------------------------------------------
' Set up the comments
' ------------------------------------------------

' Commented by Rod Stephens, VB Helper.
'  lblComments.Caption = App.FileDescription & vbCrLf & App.Comments & vbCrLf & _
'                        "Written by " & App.CompanyName
  
  frmDemo.Refresh
  
End Sub

Private Sub Form_Unload(Cancel As Integer)

' ------------------------------------------------
' Free object from memory
' ------------------------------------------------
  Set frmDemo = Nothing

End Sub


Private Sub optNo_Click()
  
' ------------------------------------------------
' Set the option values based on user selection
' ------------------------------------------------
  optNo.Value = True
  optYes.Value = False

End Sub

Private Sub optNumeric_Click()
  
' ------------------------------------------------
' Set the option values based on user selection
' ------------------------------------------------
  optNumeric.Value = True
  optString.Value = False

End Sub

Private Sub optString_Click()
  
' ------------------------------------------------
' Set the option values based on user selection
' ------------------------------------------------
  optString.Value = True
  optNumeric.Value = False

End Sub


Private Sub optYes_Click()
  
' ------------------------------------------------
' Set the option values based on user selection
' ------------------------------------------------
  optYes.Value = True
  optNo.Value = False

End Sub


