VERSION 5.00
Begin VB.Form ListExam 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "List Search + Kill Double Example - By: TiN"
   ClientHeight    =   5055
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4680
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "ListExam.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5055
   ScaleWidth      =   4680
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton Command6 
      Caption         =   "About"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   100
      Width           =   855
   End
   Begin VB.CommandButton Command5 
      Caption         =   "Reset"
      Height          =   255
      Left            =   3600
      TabIndex        =   13
      Top             =   100
      Width           =   975
   End
   Begin VB.OptionButton Option3 
      Caption         =   "Unsorted Kill Double (Slow)"
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   4320
      Value           =   -1  'True
      Width           =   2775
   End
   Begin VB.OptionButton Option2 
      Caption         =   "API Kill Double (Good)"
      Height          =   255
      Left            =   120
      TabIndex        =   9
      Top             =   4080
      Width           =   2775
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Random"
      Height          =   285
      Left            =   3600
      TabIndex        =   7
      Top             =   3000
      Width           =   975
   End
   Begin VB.TextBox Text1 
      Height          =   330
      Left            =   120
      TabIndex        =   6
      Top             =   3000
      Width           =   3375
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Do Timed Kill Doubles Test!"
      Height          =   735
      Left            =   3000
      TabIndex        =   5
      Top             =   3840
      Width           =   1575
   End
   Begin VB.CommandButton Command2 
      Caption         =   "API Search"
      Height          =   255
      Left            =   3120
      TabIndex        =   4
      Top             =   3360
      Width           =   1455
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Sorted Kill Double (Fast)"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   3840
      Width           =   2775
   End
   Begin VB.ListBox List2 
      Height          =   2535
      Left            =   120
      Sorted          =   -1  'True
      TabIndex        =   2
      Top             =   360
      Visible         =   0   'False
      Width           =   4455
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Loop Search"
      Height          =   255
      Left            =   1440
      TabIndex        =   1
      Top             =   3360
      Width           =   1575
   End
   Begin VB.ListBox List1 
      Height          =   2535
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   4455
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Doevents"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   3360
      Width           =   1095
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   4680
      Width           =   4455
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "List Count - 0"
      Height          =   255
      Left            =   1080
      TabIndex        =   8
      Top             =   120
      Width           =   2415
   End
End
Attribute VB_Name = "ListExam"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'List Search + Kill Double Example
'Created by: Tin Lau
'TiN Simple Creations - Homepage
'Http://members.aol.com/vtinmanv

'Info:
'This example will show you the fastest way to search
'and kill double items in a listbox.  All tests include
'a timer which will show you the time it takes in seconds
'for a task to complete.

'The search test includes the loop search and the API search.
'(Hint: The API search is faster!)

'The kill double test includes sorted loop, unsorted loop, and
'the API loop kill double test.
'(Hint: The sorted loop method is the fastest!)

'Any way you do it, everything in here works.  Some just work
'faster than others.

Option Explicit
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function SendMessageByString Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
'API functions for the API parts.

Const LB_FINDSTRING = &H18F
Const LB_FINDSTRINGEXACT = &H1A2
Const LB_GETCOUNT = &H18B
Const LB_GETTEXT = &H189
Const LB_GETTEXTLEN = &H18A
Const LB_ADDSTRING = &H180
Const LB_DELETESTRING = &H182
Const LB_ERR = (-1)
'Constants for the API parts.
'The names of these constants will tell you what they do.

Sub SortedKD()
'Sorted Kill Double function.

On Error Resume Next
Dim Loo As Integer
Dim CheckLoo As Integer
Dim GotListItem As String
Dim ItemCheck As String

For Loo = 0 To (List2.ListCount - 1)
'Loop throught the list.
    Label2.Caption = "Checking item #" & Loo + 1: Label2.Refresh
    'Show which list item is being processed.
    ItemCheck = List2.List(Loo)
    'Get the list item.
    If Err Then Exit For
    'Check for error.
    List2.RemoveItem Loo
    'Remove the item to get ready to check for doubles.
    If Check1.Value = 1 Then: DoEvents
RECheck:
    GotListItem = List2.List(Loo)
    'Get the next item on the list.
    'Since this is a sorted listbox, the next item
    'will be equal to ItemCheck if it's a double.
    If Err Then Exit For
    'Check for error.
        If ItemCheck = GotListItem Then
        'Check to see if it's a double item.
            List2.RemoveItem Loo
            'If it is a double item, remove it.
            If Err Then Exit For
            'Check for error.
            GoTo RECheck:
            'A GoTo loop.
        End If
    List2.AddItem ItemCheck
    'Add back the removed item.
Next Loo
End Sub
Sub UnsortedKD()
'Unsorted kill double. This is the slowest one.

On Error Resume Next
Dim Loo As Integer
Dim Loo2 As Integer
Dim TmpStr As String

For Loo = 0 To List1.ListCount - 1
'Loop throught the list.
    Label2.Caption = "Checking item #" & Loo + 1: Label2.Refresh
    'Show which item is being processed.
    TmpStr = List1.List(Loo): List1.RemoveItem Loo
    'Get the list item and remove it.
    If Err Then Exit For
    'Check for errors.
        For Loo2 = 0 To List1.ListCount - 1
        'For loop to check for doubles.
            If Check1.Value = 1 Then: DoEvents
            If TmpStr = List1.List(Loo2) Then List1.RemoveItem Loo2
            'Check to see if a double is found. And remove if found.
            If Err Then Exit For
            'Check for error.
        Next Loo2
    List1.AddItem TmpStr
    'Add back the removed item.
Next Loo
End Sub
Sub APIKD()
'API kill double.

On Error Resume Next
Dim Loo As Integer
Dim RetV As Integer
Dim TmpStr As String
Dim Dummy As Integer

For Loo = 0 To SendMessage(List1.hwnd, LB_GETCOUNT, 0, 0) - 1
'Loop throught the list.
    Label2.Caption = "Checking item #" & Loo + 1: Label2.Refresh
    'Show which item is being processed.
    Dummy = SendMessage(List1.hwnd, LB_GETTEXTLEN, Loo, 0)
    'Check the length of the list item. Loo is the item number.
    TmpStr = String(Dummy, " ")
    'Make room for the string.
    Dummy = SendMessageByString(List1.hwnd, LB_GETTEXT, Loo, TmpStr)
    'Get the list item. Loo is the item number. TmpStr is where to place it.
    If Dummy = LB_ERR Then Exit For
    'Check for error. LB_ERR is equal to -1.
    Dummy = SendMessage(List1.hwnd, LB_DELETESTRING, Loo, 0)
    'Delete the list item. Loo is the item number.
    
        Do
        'Loop to check for doubles.
            RetV = SendMessageByString(List1.hwnd, LB_FINDSTRINGEXACT, -1, TmpStr)
            'Check for a string that matches TmpStr.
            If RetV <> LB_ERR Then
            'If no error occured (item found) then remove it.
                Dummy = SendMessage(List1.hwnd, LB_DELETESTRING, RetV, 0)
                'Remove the list item.
            End If
            If Check1.Value = 1 Then: DoEvents
        Loop Until RetV = LB_ERR
        
    Dummy = SendMessageByString(List1.hwnd, LB_ADDSTRING, 0, TmpStr)
    'Add back the removed item.
Next Loo

End Sub
Private Sub Command1_Click()
On Error Resume Next
Dim Loo As Integer
Dim TmpTimer As Long

TmpTimer = Timer
'TmpTimer holds the time when the test started.

If List1.Visible = True Then 'Check which listbox to search with.
    For Loo = 0 To List1.ListCount - 1
    'Loop throught the list.
        If List1.List(Loo) = Text1.Text Then
        'If the list item matches then hi-light it.
            List1.ListIndex = Loo
            Label2.Caption = "The search took about " & Abs(Format(Timer - TmpTimer, "###.##")) & " second(s) to complete."
            'Show the time in seconds it took to complete task.
            Exit Sub
            'Stop when found.
        End If
    If Check1.Value = 1 Then: DoEvents
    Label2.Caption = "Checking item #" & Loo + 1: Label2.Refresh
    'Show which item is being checked.
    Next Loo
Else
    'Check same as above, just with different list.
    For Loo = 0 To List2.ListCount - 1
        If List2.List(Loo) = Text1.Text Then
            List2.ListIndex = Loo
            Label2.Caption = "The search took about " & Abs(Format(Timer - TmpTimer, "###.##")) & " second(s) to complete."
            Exit Sub
        End If
    If Check1.Value = 1 Then: DoEvents
    Label2.Caption = "Checking item #" & Loo + 1: Label2.Refresh
    Next Loo
End If

'This code runs with there is no match.
Label2.Caption = "The search took about " & Abs(Format(Timer - TmpTimer, "###.##")) & " second(s) to complete."
'Show how long it took for the task to complete.
MsgBox "Sorry, the string was not found!!", vbInformation, "Nope..."
End Sub

Private Sub Command2_Click()
On Error Resume Next
Dim TmpTimer As Long
Dim RetV As Integer

TmpTimer = Timer
'TmpTimer holds the time when the test started.

If List1.Visible = True Then 'Check which list to find string in.
    RetV = SendMessageByString(List1.hwnd, LB_FINDSTRINGEXACT, -1, Text1.Text)
    'Using the LB_FINDSTRINGEXACT constant to find the string.
Else
    RetV = SendMessageByString(List2.hwnd, LB_FINDSTRINGEXACT, -1, Text1.Text)
    'Same
End If

If RetV = LB_ERR Then 'Check for error.
    Label2.Caption = "The search took about " & Abs(Format(Timer - TmpTimer, "###.##")) & " second(s) to complete."
    'Show how long it took for the task to complete.
    MsgBox "Sorry, the string was not found!!", vbInformation, "Nope..."
    Exit Sub
    'Exit if an error occurs.
Else
    Label2.Caption = "The search took about " & Abs(Format(Timer - TmpTimer, "###.##")) & " second(s) to complete."
    'Show how long it took for the task to complete.
    If List1.Visible = True Then 'Check to see which list to hi-light.
        List1.ListIndex = RetV 'Hi-light list item.
    Else
        List2.ListIndex = RetV 'Same
    End If
End If
End Sub

Private Sub Command3_Click()
Dim TmpTimer As Long

TmpTimer = Timer
'Holds the time. Same as the other subs.

If Option1.Value = True Then 'Check to see which option was selected.
    Call SortedKD 'Call the sorted kill double sub.
    Label1.Caption = "List Count - " & List2.ListCount 'Count list items.
ElseIf Option2.Value = True Then
    Call APIKD 'Call the API kill double sub.
    Label1.Caption = "List Count - " & List1.ListCount 'Count list items.
ElseIf Option3.Value = True Then
    Call UnsortedKD 'Call the unsorted kill double sub.
    Label1.Caption = "List Count - " & List1.ListCount 'Count list items.
End If

Label2.Caption = "The search took about " & Abs(Format(Timer - TmpTimer, "###.##")) & " second(s) to complete."
'Show how long it took for the task to complete.
End Sub

Private Sub Command4_Click()
Dim Loo As Integer
Dim TmpStr As String

TmpStr = ""
    
For Loo = 1 To 10
    TmpStr = TmpStr & Chr((Int(25 * Rnd) + 97))
Next Loo
Text1.Text = TmpStr

'Make random text for search.
End Sub

Private Sub Command5_Click()
On Error Resume Next
List1.Clear: List1.Visible = True
List2.Clear: List2.Visible = False
Text1.Text = ""
Check1.Value = 0
Option3.Value = True
Me.Hide
Call Form_Load
Me.Show

'Reset everything.
End Sub

Private Sub Command6_Click()
Dim TmpTxt As String
Dim EntR As String

EntR = Chr(10) & Chr(13)

TmpTxt = TmpTxt & "List Search + Kill Double Example" & EntR
TmpTxt = TmpTxt & "Created by: Tin Lau" & EntR & EntR
TmpTxt = TmpTxt & "TiN Simple Creations Homepage:" & EntR
TmpTxt = TmpTxt & "Http://members.aol.com/vtinmanv" & EntR & EntR & EntR
TmpTxt = TmpTxt & "For more examples and/or source codes, please visit my site. More examples and source codes are also available at VBHelp.Net (Http://www.vbhelp.net)!"

MsgBox TmpTxt, vbInformation, "About..."
End Sub

Private Sub Form_Load()
Dim Loo As Integer
Dim Loo2 As Integer
Dim TmpStr As String

TmpStr = ""
Randomize (Timer) 'Randomize, for the RND function.

For Loo = 1 To 1000
    For Loo2 = 1 To 10
        TmpStr = TmpStr & Chr((Int(25 * Rnd) + 97))
    Next Loo2
    If Int(5 * Rnd) = 3 Then: List1.AddItem "Double Test Item"
    List1.AddItem TmpStr: TmpStr = ""
Next Loo
'Fill up the list with random items and "Double Test Item"
'for the kill double test.

Label1.Caption = "List Count - " & List1.ListCount
'Count list items.
End Sub

Private Sub Option1_Click()
On Error Resume Next
Dim Loo As Integer

'Change the list.
If Option1.Value = True Then
    Me.Enabled = False
    Label2.Caption = "Please wait...": Label2.Refresh
    List2.Clear
    For Loo = 0 To List1.ListCount - 1
        List2.AddItem List1.List(Loo)
    Next Loo

    Label2.Caption = ""
    List2.Visible = True
    List1.Visible = False
    List1.Clear
    Me.Enabled = True
End If
End Sub

Private Sub Option2_Click()
Dim Loo As Integer

If List1.Visible = True Then Exit Sub

'Change the list.
If Option2.Value = True Then
    Me.Enabled = False
    Label2.Caption = "Please wait...": Label2.Refresh
    List1.Clear
    For Loo = 0 To List2.ListCount - 1
        List1.AddItem List2.List(Loo)
    Next Loo

    Label2.Caption = ""
    List2.Visible = False
    List1.Visible = True
    List2.Clear
    Me.Enabled = True
End If

End Sub

Private Sub Option3_Click()
Dim Loo As Integer

If List1.Visible = True Then Exit Sub

'Change the list.
If Option3.Value = True Then
    Me.Enabled = False
    Label2.Caption = "Please wait...": Label2.Refresh
    List1.Clear
    For Loo = 0 To List2.ListCount - 1
        List1.AddItem List2.List(Loo)
    Next Loo

    Label2.Caption = ""
    List2.Visible = False
    List1.Visible = True
    List2.Clear
    Me.Enabled = True
End If

End Sub
