VERSION 5.00
Begin VB.Form frmBitArray 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Bit Array"
   ClientHeight    =   1455
   ClientLeft      =   4065
   ClientTop       =   3945
   ClientWidth     =   2775
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   1455
   ScaleWidth      =   2775
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdDown 
      Caption         =   "&<"
      Height          =   255
      Left            =   1800
      TabIndex        =   2
      Top             =   240
      Width           =   255
   End
   Begin VB.CommandButton cmdUp 
      Caption         =   "&>"
      Height          =   255
      Left            =   2040
      TabIndex        =   3
      Top             =   240
      Width           =   255
   End
   Begin VB.Frame Frame1 
      Caption         =   "Value"
      Height          =   615
      Left            =   240
      TabIndex        =   4
      Top             =   600
      Width           =   2295
      Begin VB.OptionButton optValue 
         Caption         =   "&False"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   5
         Top             =   240
         Width           =   975
      End
      Begin VB.OptionButton optValue 
         Caption         =   "&True"
         Height          =   255
         Index           =   1
         Left            =   1200
         TabIndex        =   6
         Top             =   240
         Width           =   975
      End
   End
   Begin VB.Label lblPosition 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      Height          =   255
      Left            =   1080
      TabIndex        =   1
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Index:"
      Height          =   255
      Left            =   480
      TabIndex        =   0
      Top             =   240
      Width           =   615
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileLoad 
         Caption         =   "&Load from Disk"
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save to Disk"
      End
      Begin VB.Menu mnuFileSep10 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmBitArray"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'BitArray - Bit Array Demo Program
'Copyright (c) 1997 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This Visual Basic 5.0 example program demonstrates a bit array
'class. A bit array is an array of yes/no, 0/1, or true/false values.
'It behaves like any other array but since it only stores a simple yes
'or no value, it is designed to only use a single bit for each value.
'
'For example, if you were to create an array of 100 Boolean values,
'that array would consume 200 bytes of memory (Boolean variables use
'two bytes of memory each). The bit array, however, can store the same
'100 values in only about 13 bytes resulting in tremendous memory
'savings, particularly if you need to store a very large number of
'items. The bit array class also takes advantage of data abstraction
'to make this functionality available using syntax that is virtually
'identical to the syntax used to access an ordinary array.
'
'The bit array class also includes routines to save the data to disk
'and read it back. Keeping with the spirit of object-oriented
'programming, disk access is handled internal to the class such that
'using the class does not require knowledge of how the data is stored.
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

Private BitArray As New CBitArray
Private nCurrPos As Long

'Initialize form
Private Sub Form_Load()
    'Make application directory active for file access
    ChDrive App.Path
    ChDir App.Path
    'Initialize bit array for 100,000 elements
    BitArray.RedimArray 100000
    'Set current position and show value
    nCurrPos = 0
    ShowValue
End Sub

'Load data from disk (if data available)
Private Sub mnuFileLoad_Click()
    On Error Resume Next
    Open "BitArray.dat" For Binary As #1
    BitArray.FileRead 1
    Close
    'Show new value
    ShowValue
End Sub

'Save data to disk
Private Sub mnuFileSave_Click()
    On Error Resume Next
    Open "BitArray.dat" For Binary As #1
    BitArray.FileWrite 1
    Close
    'Show new value
    ShowValue
End Sub

'Exit program
Private Sub mnuFileExit_Click()
    Unload Me
End Sub

'Show value for next index
Private Sub cmdUp_Click()
    If nCurrPos < 100000 Then
        nCurrPos = nCurrPos + 1
        ShowValue
    End If
End Sub

'Show value for previous index
Private Sub cmdDown_Click()
    If nCurrPos > 0 Then
        nCurrPos = nCurrPos - 1
        ShowValue
    End If
End Sub

'Display value for current index
Private Sub ShowValue()
    lblPosition = CStr(nCurrPos)
    If BitArray.Value(nCurrPos) Then
        optValue(1) = True
    Else
        optValue(0) = True
    End If
End Sub

'Set the value for the current index
Private Sub optValue_Click(Index As Integer)
    BitArray.Value(nCurrPos) = Index
End Sub
