VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmNewTerm 
   Caption         =   "Visual Basic Terminal"
   ClientHeight    =   5775
   ClientLeft      =   2685
   ClientTop       =   1725
   ClientWidth     =   6015
   LinkTopic       =   "Form1"
   ScaleHeight     =   5775
   ScaleWidth      =   6015
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   8
      Top             =   5400
      Width           =   6015
      _ExtentX        =   10610
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   2
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Key             =   "Status"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
            Key             =   "ConnectTime"
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "&Send"
      Height          =   375
      Left            =   3480
      TabIndex        =   7
      ToolTipText     =   "Sends the text in the text box out the Comm port"
      Top             =   4680
      Visible         =   0   'False
      Width           =   735
   End
   Begin MSComDlg.CommonDialog cdlCD1 
      Left            =   4320
      Top             =   4680
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.TextBox txtTerm 
      Height          =   4455
      Left            =   240
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   120
      Width           =   5535
   End
   Begin VB.Timer UpdateTimer 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   4920
      Top             =   4680
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   5400
      Top             =   4680
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      CommPort        =   2
      DTREnable       =   -1  'True
      RThreshold      =   1
      SThreshold      =   1
   End
   Begin VB.Shape shpReceive 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   2880
      Shape           =   3  'Circle
      Top             =   4680
      Width           =   255
   End
   Begin VB.Shape shpSend 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   2400
      Shape           =   3  'Circle
      Top             =   4680
      Width           =   255
   End
   Begin VB.Shape shpCTS 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   1920
      Shape           =   3  'Circle
      Top             =   4680
      Width           =   255
   End
   Begin VB.Shape shpRTS 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   1440
      Shape           =   3  'Circle
      Top             =   4680
      Width           =   255
   End
   Begin VB.Shape shpPortOpen 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   360
      Shape           =   3  'Circle
      Top             =   4680
      Width           =   255
   End
   Begin VB.Label lblReceive 
      Caption         =   "Receive"
      Height          =   255
      Left            =   2760
      TabIndex        =   6
      Top             =   5040
      Width           =   615
   End
   Begin VB.Label lblSend 
      Caption         =   "Send"
      Height          =   255
      Left            =   2280
      TabIndex        =   5
      Top             =   5040
      Width           =   375
   End
   Begin VB.Label lblCTS 
      Caption         =   "CTS"
      Height          =   255
      Left            =   1920
      TabIndex        =   4
      Top             =   5040
      Width           =   375
   End
   Begin VB.Label lblRTS 
      Caption         =   "RTS"
      Height          =   255
      Left            =   1440
      TabIndex        =   3
      Top             =   5040
      Width           =   495
   End
   Begin VB.Label lblCD 
      Caption         =   "CD"
      Height          =   255
      Left            =   960
      TabIndex        =   2
      Top             =   5040
      Width           =   255
   End
   Begin VB.Label lblPortOpen 
      Caption         =   "Port Open"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   5040
      Width           =   735
   End
   Begin VB.Shape shpCD 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   255
      Left            =   960
      Shape           =   3  'Circle
      Top             =   4680
      Width           =   255
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileTransmit 
         Caption         =   "&Transmit File"
      End
      Begin VB.Menu mnuFileReceive 
         Caption         =   "&Receive File"
      End
      Begin VB.Menu mnuFileSpace1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileClear 
         Caption         =   "&Clear Text Box"
      End
      Begin VB.Menu mnuFileShowEvents 
         Caption         =   "Show &Events"
      End
      Begin VB.Menu mnuFileShowRecData 
         Caption         =   "&Show Received Data"
      End
      Begin VB.Menu mnuFileSpace2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuCommPort 
      Caption         =   "&Comm Port"
      Begin VB.Menu mnuCommPortOpen 
         Caption         =   "&Open Port"
      End
      Begin VB.Menu mnuCommPortClose 
         Caption         =   "&Close Port"
      End
      Begin VB.Menu mnuCommPortSettings 
         Caption         =   "&Settings"
      End
      Begin VB.Menu mnuCommPortLine 
         Caption         =   "-"
      End
      Begin VB.Menu mnuCommPortOptions 
         Caption         =   "O&ptions"
      End
   End
   Begin VB.Menu mnuDial 
      Caption         =   "&Dial"
      Begin VB.Menu mnuDialDial 
         Caption         =   "&Dial Number"
      End
      Begin VB.Menu mnuDialHangUp 
         Caption         =   "&Hang Up"
      End
      Begin VB.Menu mnuDialAnswer 
         Caption         =   "&Answer Mode"
      End
   End
End
Attribute VB_Name = "frmNewTerm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'************************************************************
'  New VB Term - A demonstration program for the MSComm     '
'  control.                                                 '
'                                                           '
'  Written by Ed Hickey and Fred Ednie                      '
'  With contributions from Dick Grier                       '
'  September 1998 - Microsoft Co.                           '
'                                                           '
'************************************************************

' Global variables:
Public mLoadOption As String ' Default or Recommended values
Public Connected As Boolean ' State of the CD line
Private RecFlag As Boolean ' Whether a file is to be received
Public Modem As Boolean 'Modem or serial cable
Private iReceiveFilenum As Integer 'Freefile value for receiving files
Private iSendFilenum As Integer 'Freefile value for sending files

Private Sub cmdSend_Click()
' This will send data out the comm port if there is
' a connection:
   If Connected = True Then
      MSComm1.Output = txtTerm.Text
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo ErrHandler
' Initialize values:
   Modem = True
   Connected = False
   RecFlag = False
   App.Title = "New VBTerm"
' Find which set of values to load:
   mLoadOption = GetSetting(App.Title, "Properties", "Option", "")
   If mLoadOption = "" Then mLoadOption = "R"
' Load the other two forms to initialize the settings:
   Load frmOptions
   Load frmControlProps

' Update visual aids:
   StatusBar1.Panels("Status").Width = 2000
   
   Exit Sub
   
ErrHandler:
   ErrMsg = "An error occurred! Error number = " & Err.Number
   ErrMsg = ErrMsg & ", Description = " & Err.Description
   ErrMsg = ErrMsg & ", Source = " & Err.Source
   MsgBox ErrMsg, vbOKOnly, "Form Load error"
   Err = 0
   Resume Next
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Unload frmControlProps
   Unload frmOptions
End Sub

Private Sub mnuCommPortClose_Click()
' Check for errors or data in the buffer, then
' close the port:
   Dim BadMsg As String, ErrMsg As String
   Dim RetVal As Integer
   
   On Error GoTo ErrHandler
   
   BadMsg = "There is still data in the output buffer.  If"
   BadMsg = BadMsg & "you close the port now, the data will be lost."
   BadMsg = BadMsg & "Press Retry to wait for the data to clear, Cancel to close the port."
   
   If MSComm1.PortOpen = True Then
      If MSComm1.OutBufferCount = 0 Then
         MSComm1.PortOpen = False
         shpPortOpen.FillColor = vbRed
      Else
         RetVal = MsgBox(BadMsg, vbRetryCancel, "Data Loss Warning!")
         If RetVal = vbCancel Then
            MSComm1.PortOpen = False
            shpPortOpen.FillColor = vbRed
            Connected = False
         Else
            Exit Sub
         End If
      End If
      cmdSend.Visible = False
   Else
      StatusBar1.Panels("Status").Text = "The port is already closed!"
   End If
   
' Update visual aids:
   StatusBar1.Panels("Status").Text = "Port Closed"
   Exit Sub
   
ErrHandler:
   ErrMsg = "An error occurred! Error number = " & Err.Number
   ErrMsg = ErrMsg & ", Description = " & Err.Description
   ErrMsg = ErrMsg & ", Source = " & Err.Source
   MsgBox ErrMsg, vbOKOnly, "Port closing error"
   Err = 0
   Resume Next
End Sub

Private Sub mnuCommPortOpen_Click()
' Open the comm port:
   If MSComm1.PortOpen = False Then
      MSComm1.PortOpen = True
            
      ' Update visual aids:
      shpPortOpen.FillColor = vbGreen
      UpdateTimer.Enabled = True
      StatusBar1.Panels("Status").Text = "Port Open"
   Else
      StatusBar1.Panels("Status").Text = "The port is already open!"
   End If
End Sub

Private Sub mnuCommPortOptions_Click()
' Show the Options form:
   frmOptions.Show
End Sub

Private Sub mnuCommPortSettings_Click()
' Show the control settings form:
   frmControlProps.Show
End Sub

Private Sub mnuDialDial_Click()
' Dial the modem after checking for a valid number:
   Dim DialNumber As String
   Dim DialString As String
   Dim ErrMsg As String
   Dim RetVal As Long
   
   On Error GoTo ErrHandler
         
   If Modem = True Then
      ' Modem, get the phone number from the user:
      Do While DialNumber = ""
         DialNumber = InputBox("Enter the number you wish to dial", "Dialing Number")
         If Len(DialNumber) > 0 Then Exit Do
         RetVal = MsgBox("Please enter a number to dial", vbOKCancel, "Dialing Number")
         If RetVal = vbCancel Then
            Exit Sub
         End If
      Loop
      StatusBar1.Panels("Status").Text = "Dialing..."
   End If
   
   ' Check to make sure the port is open:
   If MSComm1.PortOpen = False Then
      Call mnuCommPortOpen_Click
   End If
   
   If Modem = True Then
      ' Dial the modem:
      If DialNumber <> "" Then
         DialString = "ATDT" & DialNumber & vbCrLf
         MSComm1.Output = DialString
      End If
   End If
   
   Exit Sub
   
ErrHandler:
   If Err.Number = 8002 Then
      ErrMsg = "Invalid port number - please try again"
   ElseIf Err.Number = 8018 Then
      ' Error already handled
      Exit Sub
   Else
      ErrMsg = "An error occured while trying to connect. Please "
      ErrMsg = ErrMsg & "check the number you entered and try again."
   End If
   ErrMsg = ErrMsg & " - " & Err.Number 'Description
   MsgBox ErrMsg, vbOKOnly, "Dialing Error"
   Err = 0
   Resume Next
End Sub

Private Sub mnuDialHangUp_Click()
   StatusBar1.Panels("Status").Text = "Hanging up"
   
   If MSComm1.PortOpen = True Then
      MSComm1.Output = "ATH0" & vbCrLf
      Call mnuCommPortClose_Click
   End If
   
' Update visual aids:
   StatusBar1.Panels("Status").Text = "Port Closed"
   StatusBar1.Panels("ConnectTime").Text = ""
End Sub

Private Sub mnuFileClear_Click()
   txtTerm.Text = ""
End Sub

Private Sub mnuFileExit_Click()
   If MSComm1.PortOpen = True Then
     Call mnuCommPortClose_Click
   End If
   
   Unload frmControlProps
   Unload frmOptions
   Unload Me
End Sub

Private Sub mnuFileReceive_Click()
   Dim FileName As String, ErrMsg As String
   
   On Error GoTo ErrHandler
   
   RecFlag = Not (RecFlag)
   mnuFileReceive.Checked = Not (mnuFileReceive.Checked)

   ' close the file if recflag is false:
   If RecFlag = False Then
      Close #iReceiveFilenum
      Exit Sub
   End If
   
   ' Get filename from user:
   With cdlCD1
      .DialogTitle = "Save Received File"
      .Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
      .CancelError = True
      .FileName = ""
      .ShowSave
      
      If Err = cdlCancel Then Exit Sub 'User pressed Cancel button
      FileName = .FileName
   End With
   
   iReceiveFilenum = FreeFile
   Open FileName For Output As iReceiveFilenum
   ' See Sub ScanCom for the rest of the receiving code
   Exit Sub
   
ErrHandler:
   ErrMsg = "An error occurred! Error number = " & Err.Number
   ErrMsg = ErrMsg & ", Description = " & Err.Description
   ErrMsg = ErrMsg & ", Source = " & Err.Source
   MsgBox ErrMsg, vbOKOnly, "File receive error"
   Err = 0
   Resume Next
End Sub

Private Sub mnuFileShowEvents_Click()
   mnuFileShowEvents.Checked = Not mnuFileShowEvents.Checked
End Sub

Private Sub mnuFileShowRecData_Click()
   mnuFileShowRecData.Checked = Not mnuFileShowRecData.Checked
End Sub

Private Sub mnuFileTransmit_Click()
   ' Dim variables
   Dim FileName As String
   Dim ByteData() As Byte
   Dim SendVar As Variant
   Dim FileLen As Long
   Dim BufSize As Long
   Dim OutBuff As String
   Dim RetVal As Long
   Dim BytesSent As Long, IntVal As Long
   Dim Iterations As Long, ModResult As Long
   Dim ErrMsg As String
   
   On Error GoTo ErrHandler
   
   If Modem = False Then ' Null modem cable
      Connected = True
   End If
   
   If Connected = False Then
      MsgBox "You must be connected first!", vbCritical, "Connection Error"
      Exit Sub
   End If
   
   ' Get filename from user:
   With cdlCD1
      .DialogTitle = "Open file to transmit"
      .Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
      .CancelError = True
      .FileName = ""
      .ShowOpen
      
      If Err = cdlCancel Then Exit Sub 'User pressed Cancel button
      FileName = .FileName
   End With
   
   ' Check to see if file exists:
   If Len(Dir$(FileName)) = 0 Then
      MsgBox "There is no file of that name in the system.  Please try again."
      Exit Sub
   End If
   
   ' Change the color of the light so we can see when we are
   ' actually transmitting:

   shpSend.FillColor = vbGreen
   StatusBar1.Panels("Status").Text = "Transmitting File"
   
   iSendFilenum = FreeFile
   Open FileName For Input As iSendFilenum
   Do While Not EOF(1)
      Input #iSendFilenum, OutBuff
      If Right$(OutBuff, 2) <> vbCrLf Then OutBuff = OutBuff & vbCrLf
      MSComm1.Output = OutBuff
   Loop
   Close #iSendFilenum
   
   ' Update visual aids:
   shpSend.FillColor = vbRed
   StatusBar1.Panels("Status").Text = "Done Transmitting"
   Exit Sub

ErrHandler:
   If Err = cdlCancel Then
      Err = 0
      Close #iSendFilenum
      Exit Sub
   Else
      ErrMsg = "An error occurred! Error number = " & Err.Number
      ErrMsg = ErrMsg & ", Description = " & Err.Description
      ErrMsg = ErrMsg & ", Source = " & Err.Source
      RetVal = MsgBox(ErrMsg, vbOKCancel, "Error transmitting file")
      Err = 0
      Resume Next
   End If
End Sub

Private Sub mnuDialAnswer_Click()
   ' Open port:
   Call mnuCommPortOpen_Click
   
   If Modem = True Then
      ' These two settings ensure that the modem will answer:
      MSComm1.DTREnable = True
      MSComm1.Output = "ATE1S0=1" & vbCrLf
   End If
   
   ' Update visual aids:
   StatusBar1.Panels("Status").Text = "Port Open - Answer Mode"
End Sub

Private Sub MSComm1_OnComm()
   Dim InBuff As String

   If mnuFileShowEvents.Checked = True Then
      txtTerm.SelStart = Len(txtTerm.Text)
      txtTerm.SelText = "OnComm event, comEv = " & MSComm1.CommEvent & "  " & vbCrLf
   End If
   
   Select Case MSComm1.CommEvent
   ' Handle each event or error by placing
   ' code below each case statement

   ' Errors
      Case comEventBreak   ' A Break was received.
         ErrMsg = "Break"
      ' These next three timeout values are no longer detected in Win32
      Case comEventCDTO    ' CD (RLSD) Timeout.
      Case comEventCTSTO   ' CTS Timeout.
      Case comEventDSRTO   ' DSR Timeout.
      
      Case comEventFrame   ' Framing Error
         ErrMsg = "Framing"
      Case comEventOverrun ' Data Lost.
         ErrMsg = "Overrun"
      Case comEventRxOver  ' Receive buffer overflow.
         ErrMsg = "OverFlow"
      Case comEventRxParity   ' Parity Error.
         ErrMsg = "Parity"
      Case comEventTxFull  ' Transmit buffer full.
         ErrMsg = "TX Full"
      Case comEventDCB  ' Unexpected error retrieving DCB]
         ErrMsg = "DBC"
         
   ' Events
      Case comEvCD   ' Change in the CD line.
         If MSComm1.CDHolding = True Then
            StatusBar1.Panels("Status").Text = "Connected"
            shpCD.FillColor = vbGreen
            cmdSend.Visible = True
            Connected = True
         Else
            StatusBar1.Panels("Status").Text = "Disconnected"
            shpCD.FillColor = vbRed
            cmdSend.Visible = False
            Connected = False
         End If
         
      Case comEvCTS  ' Change in the CTS line.
         If MSComm1.CTSHolding = True Then
            shpCTS.FillColor = vbGreen
         Else
            shpCTS.FillColor = vbRed
         End If
         
      Case comEvDSR  ' Change in the DSR line.
         ErrMsg = "comEvDSR"
         
      Case comEvRing ' Change in the Ring Indicator.
         txtTerm.SelStart = Len(txtTerm.Text)
         txtTerm.SelText = "comEvRing"
         
      Case comEvReceive ' Received RThreshold # of chars.
         shpReceive.FillColor = vbGreen
         InBuff = MSComm1.Input
         Call ScanCom(InBuff)
         shpReceive.FillColor = vbRed
         
      Case comEvSend ' There are SThreshold number of
                     ' characters in the transmit buffer.
         shpSend.FillColor = vbGreen
         Do While MSComm1.OutBufferCount > 0
            DoEvents
         Loop
         shpSend.FillColor = vbRed
         
      Case comEvEOF  ' An EOF character was found in                        ' the input stream
   End Select

End Sub

Private Sub ScanCom(ByVal Instring As String)
' This routine will "re-assemble" a packet that has
' been received in pieces from the port.  This particular
' routine will work on packets terminated by <CR><LF>:

   Dim y As String
   Dim x As Integer
' These are declared Static so that they will persist between
' function calls:
   Static CRflag As Boolean, SendFlag As Boolean
   Static UseString As String

   For x = 1 To (Len(Instring) + 1)
      y = Mid$(Instring, x, 1)
      If y = Chr$(13) Then
         CRflag = True
         y = ""
         UseString = Trim(UseString)
         If RecFlag = True Then   ' Write data to "receive file"
            Print #iReceiveFilenum, Trim(UseString)
         End If
'"MessageHandler" is where to do the processing on
' the packet after it is fully parsed here:
         Call MessageHandler(UseString)
         UseString = ""
      End If
      If y = Chr$(10) Then
         y = ""
         CRflag = False
      End If
      If CRflag = False Then
         UseString = UseString & y
         'Display in text box if selected:
         If mnuFileShowRecData.Checked = True Then
            'limit textbox to 1600 characters:
            If Len(txtTerm.Text) > 16000 Then
               txtTerm.Text = Mid$(txtTerm.Text, 16000)
            End If
            ' Display text:
            txtTerm.SelStart = Len(txtTerm.Text)
            txtTerm.SelText = y
         End If
      End If
   Next x
End Sub

Private Sub MessageHandler(InBuff As String)
   Static DoOnce As Boolean
   Dim StrLen As Long, ByteCount As Long
   Dim FileData As Byte
   Dim Msg As String
   
   If InStr(InBuff, "RING") And DoOnce Then
      MSComm1.Output = "ATA"
      DoOnce = False
      InBuff = ""
   End If
    
   If InStr(InBuff, "CONNECT") Then
      Connected = True
      StatusBar1.Panels("Status").Text = "Connected"
      InBuff = ""
   End If
   
   If InStr(InBuff, "NO CARRIER") Then
      Msg = "There is no carrier.  Please make sure "
      Msg = Msg & "that all your cables are properly connected"
   End If
   
   If InStr(InBuff, "ERROR") Then
      MsgBox "An Input Error occurred, it was " & ErrMsg
      InBuff = ""
      Exit Sub
   End If
   
   If InStr(InBuff, "BUSY") Then
      MsgBox "The number is busy.  Please try again later."
      InBuff = ""
      Exit Sub
   End If
   
   If InStr(InBuff, "OK") Then
      InBuff = ""
   End If
      
   InBuff = ""
End Sub

Private Sub txtTerm_KeyPress(KeyAscii As Integer)
   'if
End Sub

Private Sub UpdateTimer_Timer()
' This timer updates the status of the various "lights"
' in the UI.
    ' RTS:
    If MSComm1.RTSEnable = True And Connected = True Then 'MSComm1.PortOpen = True Then
        shpRTS.FillColor = vbGreen
    Else
        shpRTS.FillColor = vbRed
    End If
    ' CTS:
    If MSComm1.CTSHolding = True Then
        shpCTS.FillColor = vbGreen
    Else
        shpCTS.FillColor = vbRed
    End If
    'CD:
    If MSComm1.CDHolding = True Then
        shpCD.FillColor = vbGreen
        Connected = True
        cmdSend.Visible = True
    Else
        shpCD.FillColor = vbRed
        Connected = False
        cmdSend.Visible = False
    End If
End Sub
