VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ClassEventLogRegister"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' -------------------------------------------------
' RegSrc.cls -- Copyright (c) Slightly Tilted Software
' By: L.J. Johnson       Date: 06-15-1996
'
' Comments:    Register the message resource DLL
'              found in the app directory in the
'              appropriate location in the registry
' -------------------------------------------------
Option Explicit


' -------------------------------------------------
' Used to return errors from RegisterEvntSource
' -------------------------------------------------
Public LastRegErrNum          As Long
Public LastRegErrSource       As String
Public LastRegErrDescription  As String


' -------------------------------------------------
' Used as part of error string return
' -------------------------------------------------
Private Const REG_SOURCENAME = "WriteEventLogs.RegisterEvntSource."


' -------------------------------------------------
' Used in RegCreateKeyEx API call
' -------------------------------------------------
Private Type SECURITY_ATTRIBUTES
   Length                 As Long
   SecurityDescriptor     As Long
   InheritHandle          As Long
End Type


' -------------------------------------------------
' Declare the API calls to Open, Close, Create, and
'   Set Values in the registry
' -------------------------------------------------
Private Declare Function RegOpenKeyEx Lib "advapi32" _
      Alias "RegOpenKeyExA" _
      (ByVal hKey As Long, _
       ByVal lpSubKey As String, _
       ByVal ulOptions As Long, _
       ByVal samDesired As Long, _
       phkResult As Long) _
      As Long
Private Declare Function RegCloseKey Lib "advapi32" _
      (ByVal hKey As Long) _
      As Long
Private Declare Function RegCreateKeyEx Lib "advapi32" _
      Alias "RegCreateKeyExA" _
      (ByVal hKey As Long, ByVal lpSubKey As String, _
       ByVal Reserved As Long, ByVal lpClass As String, _
       ByVal dwOptions As Long, _
       ByVal samDesired As Long, _
       lpSecurityAttributes As SECURITY_ATTRIBUTES, _
       phkResult As Long, _
       lpdwDisposition As Long) _
      As Long
Private Declare Function RegSetValueEx Lib "advapi32" _
      Alias "RegSetValueExA" _
      (ByVal hKey As Long, _
       ByVal lpValueName As String, _
       ByVal Reserved As Long, _
       ByVal dwType As Long, _
       lpData As Any, _
       ByVal cbData As Long) _
      As Long

Private Declare Function RegFlushKey Lib "advapi32.dll" _
      (ByVal hKey As Long) As Long
Private Declare Function RegQueryValueEx Lib "advapi32.dll" _
      Alias "RegQueryValueExA" _
      (ByVal hKey As Long, ByVal lpValueName As String, _
       ByVal lpReserved As Long, lpType As Long, _
       lpData As Any, lpcbData As Long) _
      As Long

Private Declare Function FormatMessage Lib "kernel32" Alias _
    "FormatMessageA" _
      (ByVal dwFlags As Long, lpSource As Any, _
       ByVal dwMessageId As Long, _
       ByVal dwLanguageId As Long, _
       ByVal lpBuffer As String, _
       ByVal nSize As Long, _
       Arguments As Long) As Long





' -------------------------------------------------
' Used in setting registry values
' -------------------------------------------------
Private Const REG_EXPAND_SZ = 2
Private Const REG_DWORD = 4
Private Const REG_MULTI_SZ = 7


' --------------------------------------------------------
' Read/Write permissions:
' --------------------------------------------------------
Private Const KEY_QUERY_VALUE = &H1&
Private Const KEY_SET_VALUE = &H2&
Private Const KEY_CREATE_SUB_KEY = &H4&
Private Const KEY_ENUMERATE_SUB_KEYS = &H8&
Private Const KEY_NOTIFY = &H10&
Private Const KEY_CREATE_LINK = &H20&
Private Const READ_CONTROL = &H20000
Private Const WRITE_DAC = &H40000
Private Const WRITE_OWNER = &H80000
Private Const SYNCHRONIZE = &H100000
Private Const STANDARD_RIGHTS_REQUIRED = &HF0000
Private Const STANDARD_RIGHTS_READ = READ_CONTROL
Private Const STANDARD_RIGHTS_WRITE = READ_CONTROL
Private Const STANDARD_RIGHTS_EXECUTE = READ_CONTROL
Private Const KEY_READ = STANDARD_RIGHTS_READ Or KEY_QUERY_VALUE Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY
Private Const KEY_WRITE = STANDARD_RIGHTS_WRITE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY
Private Const KEY_EXECUTE = KEY_READ

Private Const ERR_NO_CREATE_KEY = 1011
Private Const ERR_NO_OPEN_KEY = 1012
Private Const ERR_NO_SET_FIRST_VALUE = 1013
Private Const ERR_NO_SET_SECOND_VALUE = 1014
Private Const ERR_NO_CLOSE_KEY = 1015

' --------------------------------------------------------
' Used by RegCreateKeyEx API function
' --------------------------------------------------------
Private Const REG_OPTION_NON_VOLATILE = 0
Private Const HKEY_LOCAL_MACHINE = &H80000002

Private Const EVENTLOG_ERROR_TYPE = 1
Private Const EVENTLOG_WARNING_TYPE = 2
Private Const EVENTLOG_INFORMATION_TYPE = 4
Private Const ERROR_SUCCESS = 0&

Private Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Private Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200


' -----------------------------------------------------
' RegSrc.cls / RegisterEventSource
' By: L.J. Johnson             Date: 06-16-1996
'
'   Comments:  Register the DLL that contains the message
'              resource info in the correct location
'              in the 32-bit registry
'
'     Inputs:  xstrFileName - Name of the DLL we are
'                             registering
'              xstrFilePath - Path of the DLL we are
'                             registering
'              xstrAppName  - Lowest-level key value
'
'    Outputs:  Returns TRUE if successful, FALSE
'              otherwise
' ------------------------------------------------------
Public Function RegisterEventSource(xstrFileName As String, _
               xstrFilePath As String, _
               xstrAppName As String) As Long
   Dim plngRtn             As Long
   Dim plngDisposition     As Long
   Dim pstrSubKey          As String
   Dim plngResKey          As Long
   Dim plngKeyHandle       As Long
   Dim pstrValData         As String
   Dim plngValData         As Long
   Dim plngLenData         As Long
   Dim pstrValueName       As String
   Dim pstrMulti           As String
   Dim plngLenMulti        As Long
   Dim plngSuccess         As Long
   Dim ptypSecAttrib       As SECURITY_ATTRIBUTES
   Const BASE_DIR = "System\CurrentControlSet\Services\EventLog\Application"
   

   ' ----------------------------------------------
   ' Set the full subkey name and default the
   '   return value to TRUE
   ' ----------------------------------------------
   pstrSubKey = BASE_DIR & "\" & xstrAppName
   RegisterEventSource = True
   

   ' ----------------------------------------------
   ' Create the key -- this will work even if the
   '   key already exists!
   ' ----------------------------------------------
   plngRtn = RegCreateKeyEx(HKEY_LOCAL_MACHINE, pstrSubKey, 0, "", _
               REG_OPTION_NON_VOLATILE, KEY_WRITE, _
               ptypSecAttrib, plngResKey, plngDisposition)

   If plngRtn = ERROR_SUCCESS Then
      ' plngDisposition = REG_CREATED_NEW_KEY means
      '   that a new key was created --
      ' plngDisposition = REG_OPENED_EXISTING_KEY
      '   means that we opened an existing key.
      ' We don't care here, but it could matter in
      '   other places
   Else
      LastRegErrNum = (ERR_NO_CREATE_KEY + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not CREATE the key, "
      LastRegErrDescription = LastRegErrDescription & xstrAppName
      LastRegErrDescription = LastRegErrDescription & ", in the registry under "
      LastRegErrDescription = LastRegErrDescription & BASE_DIR
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
      Exit Function
   End If


   ' ----------------------------------------------
   ' Open the key so we can set 2 values
   ' ----------------------------------------------
   plngRtn = RegOpenKeyEx(HKEY_LOCAL_MACHINE, pstrSubKey, _
               0&, KEY_WRITE, plngKeyHandle)

   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_OPEN_KEY + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not OPEN the key, "
      LastRegErrDescription = LastRegErrDescription & xstrAppName
      LastRegErrDescription = LastRegErrDescription & ", in the registry under "
      LastRegErrDescription = LastRegErrDescription & BASE_DIR
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
      Exit Function
   End If


   ' ----------------------------------------------
   ' Set the first value, EventMessageFile
   ' ----------------------------------------------
   pstrValueName = "EventMessageFile"

   If Right$(Trim$(xstrFilePath), 1) <> "\" Then
      xstrFilePath = Trim$(xstrFilePath) & "\"
   End If

   pstrValData = xstrFilePath & xstrFileName
   plngLenData = Len(pstrValData)
   plngRtn = RegSetValueEx(plngKeyHandle, pstrValueName, 0, _
               REG_EXPAND_SZ, ByVal pstrValData, _
               plngLenData)

   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_SET_FIRST_VALUE + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not SET the EventMessageFile value for the key, "
      LastRegErrDescription = LastRegErrDescription & xstrAppName
      LastRegErrDescription = LastRegErrDescription & ", in the registry under "
      LastRegErrDescription = LastRegErrDescription & BASE_DIR
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
      GoTo CloseKey
   End If


   ' ----------------------------------------------
   ' Set the second value, TypesSupported
   ' ----------------------------------------------
   pstrValueName = "TypesSupported"
   
   plngValData = EVENTLOG_ERROR_TYPE Or EVENTLOG_WARNING_TYPE _
              Or EVENTLOG_INFORMATION_TYPE
   plngLenData = Len(plngValData)
   plngRtn = RegSetValueEx(plngKeyHandle, pstrValueName, 0, _
               REG_DWORD, plngValData, _
               plngLenData)

   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_SET_SECOND_VALUE + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not SET the TypesSupported value for the key, "
      LastRegErrDescription = LastRegErrDescription & xstrAppName
      LastRegErrDescription = LastRegErrDescription & ", in the registry under "
      LastRegErrDescription = LastRegErrDescription & BASE_DIR
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
      GoTo CloseKey
   End If

   
   ' ----------------------------------------------
   ' Always close the key you opened
   ' ----------------------------------------------
   plngRtn = RegCloseKey(plngKeyHandle)

   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_CLOSE_KEY + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not CLOSE the key, "
      LastRegErrDescription = LastRegErrDescription & xstrAppName
      LastRegErrDescription = LastRegErrDescription & ", in the registry under "
      LastRegErrDescription = LastRegErrDescription & BASE_DIR
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
   End If


   ' ----------------------------------------------
   ' Reset the subkey, then open it
   ' ----------------------------------------------
   pstrSubKey = BASE_DIR

   plngRtn = RegOpenKeyEx(HKEY_LOCAL_MACHINE, pstrSubKey, _
               0&, KEY_WRITE Or KEY_READ, plngKeyHandle)

   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_OPEN_KEY + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not OPEN the key, "
      LastRegErrDescription = LastRegErrDescription & pstrSubKey
      LastRegErrDescription = LastRegErrDescription & ", in the registry"
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
      Exit Function
   End If


   ' ----------------------------------------------
   ' Get the current values for 'Sources'
   ' ----------------------------------------------
   pstrMulti = Space$(1024 * 10)
   plngLenMulti = Len(pstrMulti)
   plngRtn = RegQueryValueEx(plngKeyHandle, "Sources", _
       0&, REG_MULTI_SZ, ByVal pstrMulti, plngLenMulti)
   
   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_OPEN_KEY + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not OPEN the key, "
      LastRegErrDescription = LastRegErrDescription & pstrSubKey
      LastRegErrDescription = LastRegErrDescription & ", in the registry"
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
      Exit Function
   Else
      pstrMulti = Left$(pstrMulti, plngLenMulti)
      Debug.Print pstrMulti
      plngSuccess = SetMultiString(pstrMulti, xstrAppName)
   End If


   ' ----------------------------------------------
   '
   ' ----------------------------------------------
   If plngSuccess = True Then
      pstrValueName = "Sources"
      pstrValData = pstrMulti
      plngLenData = Len(pstrValData)
      
      plngRtn = RegSetValueEx(plngKeyHandle, pstrValueName, 0, _
                  REG_MULTI_SZ, ByVal pstrValData, _
                  plngLenData)
   
      If plngRtn <> ERROR_SUCCESS Then
         LastRegErrNum = (ERR_NO_SET_FIRST_VALUE + vbObjectError)
         LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
         LastRegErrDescription = "Could not SET the EventMessageFile value for the key, "
         LastRegErrDescription = LastRegErrDescription & xstrAppName
         LastRegErrDescription = LastRegErrDescription & ", in the registry under "
         LastRegErrDescription = LastRegErrDescription & BASE_DIR
         LastRegErrDescription = LastRegErrDescription & ".  The error was: "
         LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
         
         RegisterEventSource = False
         GoTo CloseKey
      End If
   End If
   
   ' ----------------------------------------------
   ' Flush it
   ' ----------------------------------------------
   If plngSuccess = True Then
      plngRtn = RegFlushKey(plngKeyHandle)
   End If
   
CloseKey:
   ' ----------------------------------------------
   ' Always close the key you opened
   ' ----------------------------------------------
   plngRtn = RegCloseKey(plngKeyHandle)

   If plngRtn <> ERROR_SUCCESS Then
      LastRegErrNum = (ERR_NO_CLOSE_KEY + vbObjectError)
      LastRegErrSource = REG_SOURCENAME & "RegisterEventSource"
      LastRegErrDescription = "Could not CLOSE the key, "
      LastRegErrDescription = LastRegErrDescription & xstrAppName
      LastRegErrDescription = LastRegErrDescription & ", in the registry under "
      LastRegErrDescription = LastRegErrDescription & BASE_DIR
      LastRegErrDescription = LastRegErrDescription & ".  The error was: "
      LastRegErrDescription = LastRegErrDescription & ReturnApiErrString(plngRtn)
      
      RegisterEventSource = False
   End If

End Function


' -------------------------------------------------
' RegSrc.cls / SetMultiString
' By: L.J. Johnson             Date: 06-16-1996
'
'   Comments:  Parses the original string
'              (null-delimited), adds the passed
'              xstrAppName to the original string
'              if it doesn't exist within that
'              string
'
'     Inputs:  xstrMulti   - Original string returned
'                            from registry
'              xstrAppName - Name of the application
'
'
'    Outputs:  xstrMulti is returned as modified
'              value
' -------------------------------------------------
Private Function SetMultiString(xstrMulti As String, _
                  xstrAppName As String) As Boolean
   Dim plngStartPos     As Long
   Dim plngEndPos       As Long
   Dim pbolFound        As Boolean
   Dim pstrTmp          As String
   
   
   On Error Resume Next
   pbolFound = False
   plngStartPos = 1
   
   Do
      plngEndPos = InStr(plngStartPos, xstrMulti, Chr$(0))
      If plngEndPos = 0 Then
         Exit Do
      End If
      
      If plngEndPos > 0 Then
         pstrTmp = Mid$(xstrMulti, plngStartPos, (plngEndPos - plngStartPos))
         Debug.Print "*" & pstrTmp & "*"
      End If
   
      If UCase$(Trim$(pstrTmp)) = UCase$(Trim$(xstrAppName)) Then
         pbolFound = True
         Exit Do
      End If
      
      plngStartPos = plngEndPos + 1
      Debug.Print plngStartPos
   
   Loop While plngStartPos > 0
   
   If pbolFound = False Then
      SetMultiString = True
      xstrMulti = Mid$(xstrMulti, 1, Len(xstrMulti) - 1) & xstrAppName$ & Chr$(0) & Chr$(0)
   Else
      SetMultiString = False
   End If
   
   On Error GoTo 0
End Function


' -------------------------------------------------
' EVENTLOG.BAS / ReturnApiErrString
'
' Passed an API error number, return an error
'   string
'
' Comments:    Takes an API error number, and returns
'              a descriptive text string of the error
'       Inputs:   xlngError is the number returned from
'                    the API error
'      Outputs:   Function returns the error string
'
' The original code appeared in Keith Pleas' article
'   in VBPJ, April 1996 (OLE Expert column).  Thanks,
'   Keith.
' -------------------------------------------------
Public Function ReturnApiErrString(ErrorCode As Long) As String
   Dim pstrBuffer    As String

   ' ----------------------------------------------
   ' Allocate the string, then get the system to
   '   tell us the error message associated with
   '   this error number
   ' ----------------------------------------------
   pstrBuffer = String(256, 0)
   FormatMessage FORMAT_MESSAGE_FROM_SYSTEM _
      Or FORMAT_MESSAGE_IGNORE_INSERTS, 0&, _
      ErrorCode, 0&, pstrBuffer, Len(pstrBuffer), 0&


   ' ----------------------------------------------
   ' Strip the last null, then the last CrLf pair if
   ' it exists
   ' ----------------------------------------------
   pstrBuffer = Left(pstrBuffer, InStr(pstrBuffer, vbNullChar) - 1)
   If Right$(pstrBuffer, 2) = Chr$(13) & Chr$(10) Then
      pstrBuffer = Mid$(pstrBuffer, 1, Len(pstrBuffer) - 2)
   End If


   ' ----------------------------------------------
   ' Set the return value
   ' ----------------------------------------------
   ReturnApiErrString = pstrBuffer

End Function


