VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ClassEventLog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

    Private Declare Function RegisterEventSource Lib "advapi32.dll" Alias "RegisterEventSourceA" (ByVal lpUNCServerName As String, ByVal lpSourceName As String) As Long
    Private Declare Function DeregisterEventSource Lib "advapi32.dll" (ByVal hEventLog As Long) As Long
    Private Declare Function ReportEvent Lib "advapi32.dll" Alias "ReportEventA" (ByVal hEventLog As Long, ByVal wType As Integer, ByVal wCategory As Integer, ByVal dwEventID As Long, ByVal lpUserSid As Any, ByVal wNumStrings As Integer, ByVal dwDataSize As Long, plpStrings As Long, lpRawData As Any) As Boolean
    Private Declare Function GetLastError Lib "kernel32" () As Long
    Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
    Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
    Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
    Private Const EVENTLOG_SUCCESS = 0
    Private Const EVENTLOG_ERROR_TYPE = &H1
    Private Const EVENTLOG_WARNING_TYPE = &H2
    Private Const EVENTLOG_INFORMATION_TYPE = &H4
    Private Const EVENTLOG_AUDIT_SUCCESS = 8
    Private Const EVENTLOG_AUDIT_FAILURE = 10
    
    
    Enum ErrorType
        InfoMsg = 1
        WarningMsg = 2
        ErrorMsg = 3
    End Enum
    
Public Sub WriteLog(LType As ErrorType, sMsg As String)
Select Case LType
    Case InfoMsg
        Call LogNTEvent(sMsg, EVENTLOG_INFORMATION_TYPE, &H1&)
    Case WarningMsg
        Call LogNTEvent(sMsg, EVENTLOG_WARNING_TYPE, &H40000002)
    Case ErrorMsg
        Call LogNTEvent(sMsg, EVENTLOG_ERROR_TYPE, &H80000003)
End Select
End Sub

Private Sub LogNTEvent(sString As String, iLogType As Integer, iEventID As Long)
    Dim bRC As Boolean
    Dim iNumStrings As Integer
    Dim hEventLog As Long
    Dim hMsgs As Long
    Dim cbStringSize As Long
    hEventLog = RegisterEventSource("", App.Title)
    cbStringSize = Len(sString) + 1
    hMsgs = GlobalAlloc(&H40, cbStringSize)
    CopyMemory ByVal hMsgs, ByVal sString, cbStringSize
    iNumStrings = 1
    If ReportEvent(hEventLog, iLogType, 0, iEventID, 0&, iNumStrings, cbStringSize, hMsgs, hMsgs) = 0 Then
        MsgBox GetLastError()
    End If
    GlobalFree (hMsgs)
    DeregisterEventSource (hEventLog)
End Sub
