Attribute VB_Name = "IconHandling"
Dim hImgSmall As Long ' The handle to the system image list
Dim hImgLarge As Long
Dim FileName As String     ' The file name to get icon fro
Dim r As Long
   
Public Const MAX_PATH = 260
Public Const SHGFI_DISPLAYNAME = &H200
Public Const SHGFI_EXETYPE = &H2000
Public Const SHGFI_SYSICONINDEX = &H4000  ' System icon index
Public Const SHGFI_LARGEICON = &H0        ' Large icon
Public Const SHGFI_SMALLICON = &H1        ' Small icon
Public Const ILD_TRANSPARENT = &H1        ' Display transparent
Public Const SHGFI_SHELLICONSIZE = &H4
Public Const SHGFI_TYPENAME = &H400
Public Const BASIC_SHGFI_FLAGS = SHGFI_TYPENAME _
   Or SHGFI_SHELLICONSIZE Or SHGFI_SYSICONINDEX _
   Or SHGFI_DISPLAYNAME Or SHGFI_EXETYPE

Public Type SHFILEINFO
    hIcon As Long
    iIcon As Long
    dwAttributes As Long
    szDisplayName As String * MAX_PATH
    szTypeName As String * 80
End Type

Public Declare Function SHGetFileInfo Lib "shell32.dll" Alias "SHGetFileInfoA" _
   (ByVal pszPath As String, _
    ByVal dwFileAttributes As Long, _
    psfi As SHFILEINFO, _
    ByVal cbSizeFileInfo As Long, _
    ByVal uFlags As Long) As Long

Public Declare Function ImageList_Draw Lib "comctl32.dll" _
   (ByVal himl&, ByVal i&, ByVal hDCDest&, _
    ByVal x&, ByVal y&, ByVal flags&) As Long

Public shinfo As SHFILEINFO

Function RetrieveIcon(ByVal pFilename As String) As Integer
    
    ' Get the system icons associated with the file
    hImgLarge = SHGetFileInfo(pFilename, 0&, shinfo, Len(shinfo), BASIC_SHGFI_FLAGS Or SHGFI_LARGEICON)
    hImgSmall = SHGetFileInfo(pFilename, 0&, shinfo, Len(shinfo), BASIC_SHGFI_FLAGS Or SHGFI_SMALLICON)

    TempVal = RetrieveIconNumber("A" & Trim(Str(shinfo.iIcon)))
    If TempVal = 0 Then
        frmMain.PicLarge.Picture = LoadPicture()
        frmMain.PicSmall.Picture = LoadPicture()
   
        ' Draw the associated icons into the picture boxes
        r& = ImageList_Draw(hImgLarge, shinfo.iIcon, frmMain.PicLarge.hDC, 0, 0, ILD_TRANSPARENT)
        r& = ImageList_Draw(hImgSmall, shinfo.iIcon, frmMain.PicSmall.hDC, 0, 0, ILD_TRANSPARENT)
        frmMain.IListBig.ListImages.Add , "A" & Trim(Str(shinfo.iIcon)), frmMain.PicLarge.Image
        frmMain.IListSmall.ListImages.Add , "A" & Trim(Str(shinfo.iIcon)), frmMain.PicSmall.Image
    End If
    If TempVal = 0 Then
        RetrieveIcon = frmMain.IListBig.ListImages.Count
    Else
        RetrieveIcon = TempVal
    End If
End Function

Function RetrieveIconNumber(pTypeName As String) As Integer
    For RetIcon = 1 To frmMain.IListBig.ListImages.Count
        If frmMain.IListBig.ListImages(RetIcon).Key = pTypeName Then RetrieveIconNumber = RetIcon: Exit Function
    Next RetIcon
    RetrieveIconNumber = 0
End Function
