Attribute VB_Name = "Directories"
Public Declare Function SendMessageStr Lib "user32" Alias "SendMessageA" _
       (ByVal hwnd As Long, _
       ByVal wMsg As Long, _
       ByVal wParam As Long, _
       ByVal lParam As String) As Long
       Public Const LB_DIR = &H18D
       Public Const DDL_READWRITE = &H0
       Public Const DDL_READONLY = &H1
       Public Const DDL_HIDDEN = &H2
       Public Const DDL_SYSTEM = &H4
       Public Const DDL_DIRECTORY = &H10
       Public Const DDL_ARCHIVE = &H20
       Public Const DDL_DRIVES = &H4000
       Public Const DDL_EXCLUSIVE = &H8000
       Public Const DDL_POSTMSGS = &H2000
       Public Const DDL_FLAGS = DDL_ARCHIVE Or DDL_DIRECTORY

Type DirType
    IListBigNum As Integer
    IListSmallNum As Integer
    DirName As String
    DisplayName As String
End Type
Type FileType
    IListBigNum As Integer
    IListSmallNum As Integer
    FileName As String
End Type
Type DirectoryType
    NumberOfDirectories As Integer
    NumberOfFiles As Integer
    DirectoryName() As DirType
    FileName() As FileType
    DirPath As String
End Type
Public ThisDir As DirectoryType
Public TempString As String
Public TempVal As Integer
Public DoneJpg As Boolean
'DriveInfo
Declare Function GetVolumeInformation Lib "kernel32" Alias "GetVolumeInformationA" (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, ByVal nVolumeNameSize As Long, lpVolumeSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long) As Long
Declare Function GetLogicalDrives& Lib "kernel32" ()
Declare Function GetDriveType& Lib "kernel32" Alias "GetDriveTypeA" (ByVal nDrive As String)
Declare Function GetDiskFreeSpace& Lib "kernel32" Alias "GetDiskFreeSpaceA" (ByVal lpRootPathName As String, lpSectorsPerCluster As Long, lpBytesPerSector As Long, lpNumberOfFreeClusters As Long, lpTotalNumberOfClusters As Long)
Public vararyDriveInfo(26, 11)     ' a Variant Array to hold the info

Sub RetrieveDirStruct(ByVal pDirName As String)
    pDirName = Trim(pDirName)
    DoneJpg = False
    If Right(pDirName, 1) = "\" Then pDirName = Left(pDirName, Len(pDirName) - 1)
    'If GetAttr(pDirName) <> vbDirectory Then Exit Sub
    frmMain.ListView1.Icons = Nothing
    frmMain.ListView1.SmallIcons = Nothing
    frmMain.IListBig.ListImages.Clear
    frmMain.IListSmall.ListImages.Clear
    ReDim ThisDir.FileName(0)
    ReDim ThisDir.DirectoryName(0)
    ThisDir.NumberOfDirectories = 0
    ThisDir.NumberOfFiles = 0
    ThisDir.DirPath = pDirName
    If pDirName <> "" Then
        PopulateListBox pDirName & "\*.*"
        For i = 0 To Form1.List1.ListCount - 1
            If Trim(Form1.List1.List(i)) <> "[.]" And Trim(Form1.List1.List(i)) <> "[..]" Then
                If Left(Trim(Form1.List1.List(i)), 1) = "[" Then
                    ThisDir.NumberOfDirectories = ThisDir.NumberOfDirectories + 1
                    ReDim Preserve ThisDir.DirectoryName(ThisDir.NumberOfDirectories)
                    TempString = Left(Right(Form1.List1.List(i), Len(Form1.List1.List(i)) - 1), Len(Form1.List1.List(i)) - 2)
                    If InStr(TempString, "~") Then
                        TempString = MiscFunctions.GetLongDirName(ThisDir.DirPath & "\" & TempString)
                    End If
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DirName = Left(Right(Form1.List1.List(i), Len(Form1.List1.List(i)) - 1), Len(Form1.List1.List(i)) - 2)
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DisplayName = TempString
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).IListBigNum = IconHandling.RetrieveIcon(ThisDir.DirPath & "\" & ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DirName & "\")
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).IListSmallNum = ThisDir.DirectoryName(ThisDir.NumberOfDirectories).IListBigNum
                Else
                    ThisDir.NumberOfFiles = ThisDir.NumberOfFiles + 1
                    ReDim Preserve ThisDir.FileName(ThisDir.NumberOfFiles)
                    ThisDir.FileName(ThisDir.NumberOfFiles).FileName = Form1.List1.List(i)
                    If DoneJpg = False Then
                        ThisDir.FileName(ThisDir.NumberOfFiles).IListBigNum = IconHandling.RetrieveIcon(ThisDir.DirPath & "\" & Form1.List1.List(i))
                        If UCase(Right(Form1.List1.List(i), 3)) = "JPG" Then DoneJpg = True
                    Else
                        ThisDir.FileName(ThisDir.NumberOfFiles).IListBigNum = 1
                    End If
                    ThisDir.FileName(ThisDir.NumberOfFiles).IListSmallNum = ThisDir.FileName(ThisDir.NumberOfFiles).IListBigNum
                End If
            End If
        Next i
    Else
        GetDriveInfo
        For i = 1 To 26
            If vararyDriveInfo(i, 1) = True Then
                    ThisDir.NumberOfDirectories = ThisDir.NumberOfDirectories + 1
                    ReDim Preserve ThisDir.DirectoryName(ThisDir.NumberOfDirectories)
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DirName = vararyDriveInfo(i, 2) & ":\"
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DisplayName = "(" & Left(ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DirName, 2) & ") " & vararyDriveInfo(i, 11)
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).IListBigNum = IconHandling.RetrieveIcon(ThisDir.DirectoryName(ThisDir.NumberOfDirectories).DirName)
                    ThisDir.DirectoryName(ThisDir.NumberOfDirectories).IListSmallNum = ThisDir.DirectoryName(ThisDir.NumberOfDirectories).IListBigNum
            End If
        Next i
    End If
    frmMain.ListView1.Icons = frmMain.IListBig
    frmMain.ListView1.SmallIcons = frmMain.IListSmall
    
    Unload Form1
End Sub
Sub LoadDirectoryIntoTree()
    frmMain.ListView1.ListItems.Clear
    For i = 1 To ThisDir.NumberOfDirectories
        frmMain.ListView1.ListItems.Add , ThisDir.DirectoryName(i).DirName, ThisDir.DirectoryName(i).DisplayName, ThisDir.DirectoryName(i).IListBigNum, ThisDir.DirectoryName(i).IListSmallNum
    Next i
    For i = 1 To ThisDir.NumberOfFiles
        frmMain.ListView1.ListItems.Add , ThisDir.FileName(i).FileName, ThisDir.FileName(i).FileName, ThisDir.FileName(i).IListBigNum, ThisDir.FileName(i).IListSmallNum
    Next i
End Sub

Function GetPreviousDir(ByVal pDir As String) As String
    pDir = Trim(pDir)
    If Right(pDir, 1) = "\" Then pDir = Left(pDir, Len(pDir) - 1)
    TempString = pDir
    Do Until InStr(TempString, "\") = 0
        TempString = Mid(TempString, InStr(TempString, "\") + 1)
    Loop
    TempString = Left(pDir, Len(pDir) - Len(TempString))
    If Right(TempString, 1) = "\" Then TempString = Left(TempString, Len(TempString) - 1)
    GetPreviousDir = TempString
End Function

Sub PopulateListBox(pDir As String)
Form1.List1.Clear
Dim r As Long
r = SendMessageStr(Form1.List1.hwnd, LB_DIR, DDL_FLAGS, pDir)
End Sub

Sub GetDriveInfo()

' SUB: This sub will get all the drive
'      info for all the hard drives and
'      network drives.
' 2/19/95
'
' There is a array named vararyDriveInfo that
' holds all the info for up to 26 drives (A-Z).
'
' Array Format:
'    x,1 = Is there a drive for this letter
'    x,2 = Drive Letter
'    x,3 = Drive Type  2=Floppy, 3=Disk Fixed (local) 4=Disk Remote (Network)
'    x,4 = Sectors
'    x,5 = Bytes / Sector
'    x,6 = Number of free sectors
'    x,7 = Total Clusters
'    x,8 = Total Bytes
'    x,9 = Free Bytes
'    x,10 = Percent of Free Bytes
'    x,11 = Vol Name
'
' *********************************************************************
Dim ournum As Long
Dim rv As Long
Dim DriveType As Long
Dim c  As Long
Dim d As Long
Dim e As Long
Dim f As Long
Dim h As Long
Dim Counter As Integer
Dim CompareTo
Dim tmpDrvLet As String
Dim SectorsPerCluster&, BytesPerSector&, NumberOfFreeClustors&, TotalNumberOfClustors&
Dim BytesFreeas, BytesTotal, FreeBytes, TotalBytes As Variant
Dim dl&, lpVolumeSerialNumber&, lpMaximumComponentLength&, lpFileSystemFlags&
Dim lpVolumeNameBuffer As String
Dim rc
Dim A As String
Dim b As String
Dim g As String
Dim s$, sz&
' *** get the logical Drives
rv = 0
rv = GetLogicalDrives&()
If rv = 0 Then
    MsgBoxText = "No Logical Drives Found. Program will stop."
    MsgBoxButton = MB_OK + MB_ICONSTOP
    MsgBoxTitle = "Error"
    MsgBox MsgBoxText, MsgBoxButton, MsgBoxTitle
    Stop
    Exit Sub
End If
' *** clear the VarArray
Erase vararyDriveInfo ' *** set the var
b = String$(255, 0)
c = 200
g = String$(255, 0)
h = 100
For Counter = 1 To 26
    CompareTo = (2 ^ (Counter - 1))
    If (rv And CompareTo) <> 0 Then
      vararyDriveInfo(Counter, 1) = True      ' Found a drive
      tmpDrvLet = Chr(Counter + 64)           ' Build a drive letter
      vararyDriveInfo(Counter, 2) = tmpDrvLet ' Save the drive letter
      tmpDrvLet = tmpDrvLet & ":\"            ' Add the root stuff
      DriveType = GetDriveType&(tmpDrvLet)    ' Get the drive type
      vararyDriveInfo(Counter, 3) = DriveType ' Save the drive type
      If DriveType = 3 Or DriveType = 4 Then  ' local or network drives only
              ' *** get the vol name
              A = tmpDrvLet 'DriveLtr & "\:"
        rc = GetVolumeInformation(A, b, c, d, e, f, g, h)
        vararyDriveInfo(Counter, 11) = b
        ' *** let's get the Drive info for this HardDrive
        dl& = GetDiskFreeSpace(tmpDrvLet, SectorsPerCluster, BytesPerSector, _
              NumberOfFreeClustors, TotalNumberOfClustors)
        vararyDriveInfo(Counter, 4) = Format(SectorsPerCluster, "#,0")
        vararyDriveInfo(Counter, 5) = Format(BytesPerSector, "#,0")
        vararyDriveInfo(Counter, 6) = Format(NumberOfFreeClustors, "#,0")
        vararyDriveInfo(Counter, 7) = Format(TotalNumberOfClustors, "#,0")
        TotalBytes = (TotalNumberOfClustors / 100) * (SectorsPerCluster / 100) * (BytesPerSector / 100)
        vararyDriveInfo(Counter, 8) = Format(TotalBytes, "#,0")
        FreeBytes = (NumberOfFreeClustors / 100) * (SectorsPerCluster / 100) * (BytesPerSector / 100)
        vararyDriveInfo(Counter, 9) = Format(FreeBytes, "#,0")
        vararyDriveInfo(Counter, 10) = Format(FreeBytes / TotalBytes, "Percent")
      End If
    Else      ' *** no drive? then set to false
        vararyDriveInfo(Counter, 1) = False
    End If
Next Counter
End Sub

