Attribute VB_Name = "NetworkRoutines"
Option Explicit

Private mAPIErrName As String
Private mAPIErrNo   As Byte

Private Declare Function WNetGetUserA Lib "mpr" (ByVal lpName As String, ByVal lpUserName As String, lpnLength As Long) As Long
Private Declare Function GetComputerNameA Lib "kernel32" (ByVal lpBuffer As String, nSize As Long) As Long
Private Declare Function GetWindowsDirectory& Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long)
Private Declare Function NetGetDCName Lib "NETAPI32.DLL" (strServerName As Any, strDomainName As Any, pBuffer As Long) As Long
Private Declare Function NetApiBufferFree Lib "NETAPI32.DLL" (buffer As Any) As Long
Private Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, ByVal hpvSource As Long, ByVal cbCopy As Long)
Private Declare Function lstrlenW Lib "kernel32" (ByVal lpString As Long) As Long
Private Declare Function lstrcpyW Lib "kernel32" (lpString1 As Byte, ByVal lpString2 As Long) As Long
Private Declare Function MultiByteToWideChar Lib "kernel32" (ByVal CodePage As Long, ByVal dwFlags As Long, ByVal lpMultiByteStr As String, ByVal cchMultiByte As Long, ByVal lpWideCharStr As String, ByVal cchWideChar As Long) As Long
Declare Function GetUserName Lib "advapi32.dll" Alias "GetUserNameA" (ByVal lpBuffer As String, nSize As Long) As Long


'--------------- WindowsVersion Declarations --------------------------------
Private Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long           '1 = Windows 95/98.
                                 '2 = Windows NT
  szCSDVersion As String * 128
End Type

Private Declare Function GetVersionExA Lib "kernel32" (lpVersionInformation As OSVERSIONINFO) As Integer


'--------------- WSOCK32.DLL Declarations --------------------------------
Private Const WS_VERSION_REQD = &H101
Private Const WS_VERSION_MAJOR = WS_VERSION_REQD \ &H100 And &HFF&
Private Const WS_VERSION_MINOR = WS_VERSION_REQD And &HFF&
Private Const MIN_SOCKETS_REQD = 1
Private Const SOCKET_ERROR = -1
Private Const WSADescription_Len = 256
Private Const WSASYS_Status_Len = 128

Private Type HOSTENT
    hName As Long
    hAliases As Long
    hAddrType As Integer
    hLength As Integer
    hAddrList As Long
End Type

Private Type WSADATA
    wversion As Integer
    wHighVersion As Integer
    szDescription(0 To WSADescription_Len) As Byte
    szSystemStatus(0 To WSASYS_Status_Len) As Byte
    iMaxSockets As Integer
    iMaxUdpDg As Integer
    lpszVendorInfo As Long
End Type

Private Declare Function WSAGetLastError Lib "WSOCK32.DLL" () As Long
Private Declare Function WSAStartup Lib "WSOCK32.DLL" (ByVal wVersionRequired&, lpWSAData As WSADATA) As Long
Private Declare Function WSACleanup Lib "WSOCK32.DLL" () As Long
Private Declare Function gethostname Lib "WSOCK32.DLL" (ByVal hostname$, HostLen&) As Long
Private Declare Function gethostbyname Lib "WSOCK32.DLL" (ByVal hostname$) As Long
Private Declare Sub RtlMoveMemory Lib "kernel32" (hpvDest As Any, ByVal hpvSource&, ByVal cbCopy&)


'--------------- ServerTime declares Constants --------------------------------
Private Declare Function NetRemoteTOD Lib "NETAPI32.DLL" (ByVal server As String, buffer As Any) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)

Private Type TIME_OF_DAY
  t_elapsedt As Long
  t_msecs As Long
  t_hours As Long
  t_mins As Long
  t_secs As Long
  t_hunds As Long
  t_timezone As Long
  t_tinterval As Long
  t_day As Long
  t_month As Long
  t_year As Long
  t_weekday As Long
End Type

Public Function PDCName() As String
  Dim szServer   As String
  Dim ptmpBuffer As Long
  Dim sByte()    As Byte
  Dim lGotNameOK As Long
  Dim lBufferOK  As Long
      
  '# this will return nothing if the machine is not in a domain
  lGotNameOK = NetGetDCName(vbNullString, vbNullString, ptmpBuffer)
  
  If lGotNameOK = 0 Then ' success
    ReDim sByte(256)

    ' ptmpbuffer is a pointer so copy contents using API call
    MoveMemory sByte(0), ptmpBuffer, 256
    
    ' free ptmpbuffer - not in other samples but mentioned in documentation
    lBufferOK = NetApiBufferFree(ptmpBuffer)
    
'   If lBufferOK = 0 Then
      ' strip off trailing rubbish
      szServer = sByte
      szServer = szServer & vbNullChar
      PDCName = Left$(szServer, InStr(szServer, vbNullChar) - 1)
'   End If
  Else
    PDCName = ""
  End If

End Function

Public Function WorkstationID() As String
  Dim sBuffer As String * 255

  If GetComputerNameA(sBuffer, 255&) > 0 Then
    WorkstationID = Left$(sBuffer, InStr(sBuffer, vbNullChar) - 1)
  Else
    WorkstationID = "?"
  End If

End Function

Public Function WindowsDir() As String
  
  WindowsDir = Space(256)
  WindowsDir = Left$(WindowsDir, GetWindowsDirectory(WindowsDir, 256&))

End Function


'--------------------------------------------------------------------------------------
Private Function hibyte(ByVal wParam As Integer)
  hibyte = wParam \ &H100 And &HFF&
End Function

Private Function lobyte(ByVal wParam As Integer)
  lobyte = wParam And &HFF&
End Function
 
Private Sub SocketsInitialize()
  Dim WSAD As WSADATA
  Dim iReturn As Integer
  Dim sLowByte As String, sHighByte As String, sMsg As String
 
  iReturn = WSAStartup(WS_VERSION_REQD, WSAD)

  If iReturn <> 0 Then
    mAPIErrName = "Winsock.dll is not responding."
    Exit Sub
  End If

  If lobyte(WSAD.wversion) < WS_VERSION_MAJOR Or (lobyte(WSAD.wversion) = WS_VERSION_MAJOR And hibyte(WSAD.wversion) < WS_VERSION_MINOR) Then
    sHighByte = Trim$(Str$(hibyte(WSAD.wversion)))
    sLowByte = Trim$(Str$(lobyte(WSAD.wversion)))
    sMsg = "Windows Sockets version " & sLowByte & "." & sHighByte
    sMsg = sMsg & " is not supported by winsock.dll "
    mAPIErrName = sMsg
    Exit Sub
  End If

  If WSAD.iMaxSockets < MIN_SOCKETS_REQD Then
    sMsg = "This application requires a minimum of "
    sMsg = sMsg & Trim$(Str$(MIN_SOCKETS_REQD)) & " supported sockets."
    mAPIErrName = sMsg
    Exit Sub
  End If

End Sub
 
Private Sub SocketsCleanup()
  Dim lReturn As Long
 
  lReturn = WSACleanup()

  If lReturn <> 0 Then
    mAPIErrName = "Socket error " & Trim$(Str$(lReturn)) & " occurred in Cleanup """
  End If

End Sub
 
Public Function IPAddress() As String
  Dim hostname As String * 256
  Dim hostent_addr As Long
  Dim host As HOSTENT
  Dim hostip_addr As Long
  Dim temp_tIPAddress() As Byte
  Dim i As Integer
  Dim tIPAddress As String
 
 
  Call SocketsInitialize
  
  If gethostname(hostname, 256) = SOCKET_ERROR Then
    MsgBox "Windows Sockets error " & Str(WSAGetLastError())
    Exit Function
  Else
    hostname = Trim$(hostname)
  End If

  hostent_addr = gethostbyname(hostname)

  If hostent_addr = 0 Then
    MsgBox "Winsock.dll is not responding."
    Exit Function
  End If

  Call RtlMoveMemory(host, hostent_addr, LenB(host))
  Call RtlMoveMemory(hostip_addr, host.hAddrList, 4)

  ReDim temp_tIPAddress(1 To host.hLength)
  Call RtlMoveMemory(temp_tIPAddress(1), hostip_addr, host.hLength)

  For i = 1 To host.hLength
    tIPAddress = tIPAddress & temp_tIPAddress(i) & "."
  Next
  IPAddress = Mid$(tIPAddress, 1, Len(tIPAddress) - 1)

  Call SocketsCleanup
  
End Function

Public Function ServerTime(ByVal pServerName As String) As Variant
  Dim t As TIME_OF_DAY
  Dim tPtr As Long
  Dim Result As Long
  Dim szServer As String
  Dim ServDate As Date
  
  'Convert the server name to unicode
  If Left(pServerName, 2) = "\\" Then
    szServer = StrConv(pServerName, vbUnicode)
  Else
    szServer = StrConv("\\" & pServerName, vbUnicode)
  End If
    
  Result = NetRemoteTOD(szServer, tPtr)  'You could also pass vbNullString for the server name
  
  If Result = 0 Then
    Call CopyMemory(t, ByVal tPtr, Len(t))  'Copy the pointer returned to a TIME_OF_DAY structure
    ServDate = DateSerial(70, 1, 1) + (t.t_elapsedt / 60 / 60 / 24)  'Convert the elapsed time since 1/1/70 to a date
    ServDate = ServDate - (t.t_timezone / 60 / 24)  'Adjust for TimeZone differences
    NetApiBufferFree (tPtr) 'Free the memory at the pointer
    ServerTime = ServDate
  Else
    If Result = 53 Then mAPIErrName = "Cannot find server " & pServerName
  End If
    
End Function

Public Function WindowsVersion() As String
  Dim osinfo   As OSVERSIONINFO
  Dim retvalue As Integer
  
  osinfo.dwOSVersionInfoSize = 148
  osinfo.szCSDVersion = Space$(128)
  retvalue = GetVersionExA(osinfo)
  
  Select Case osinfo.dwPlatformId
    Case Is = 1: WindowsVersion = "Windows 95/98"
    Case Is = 2: WindowsVersion = "Windows NT"
    Case Else: WindowsVersion = "Unknown"
  End Select
  
End Function

Public Function BuildNo() As String
  Dim osinfo   As OSVERSIONINFO
  Dim retvalue As Integer
  
  osinfo.dwOSVersionInfoSize = 148
  osinfo.szCSDVersion = Space$(128)
  retvalue = GetVersionExA(osinfo)
  
  BuildNo = osinfo.dwMajorVersion & "." & osinfo.dwMinorVersion & "." & osinfo.dwBuildNumber
  
End Function

Public Function SPInfo() As String
  Dim osinfo   As OSVERSIONINFO
  Dim retvalue As Integer
  
  osinfo.dwOSVersionInfoSize = 148
  osinfo.szCSDVersion = Space$(128)
  retvalue = GetVersionExA(osinfo)
  
  SPInfo = osinfo.szCSDVersion
  
End Function

Public Function NetworkUserName() As String
  Dim lpBuff   As String * 25
  Dim retval   As Long

  retval = GetUserName(lpBuff, 25)
  ' trim off any trailing spaces found in the name
  NetworkUserName = Left(lpBuff, InStr(lpBuff, Chr(0)) - 1)

End Function
