Attribute VB_Name = "modGlobal"
    Option Explicit
    Option Base 0

       ' ' for dwPriv '
    Public Const USER_PRIV_MASK = &H3
    Public Const USER_PRIV_GUEST = &H0
    Public Const USER_PRIV_USER = &H1
    Public Const USER_PRIV_ADMIN = &H2
    
    ' ' for dwFlags '
    Public Const UF_SCRIPT = &H1
    Public Const UF_ACCOUNTDISABLE = &H2
    Public Const UF_HOMEDIR_REQUIRED = &H8
    Public Const UF_LOCKOUT = &H10
    Public Const UF_PASSWD_NOTREQD = &H20
    Public Const UF_PASSWD_CANT_CHANGE = &H40
    Public Const UF_DONT_EXPIRE_PASSWD = &H10000
    Private Const STILL_ACTIVE = &H103
    Private Const PROCESS_QUERY_INFORMATION = &H400
    Public Const UF_NORMAL_ACCOUNT = &H200      ' Needs to be ORed with the
                                                ' other flags
    
    ' for lFilter '
    Public Const FILTER_NORMAL_ACCOUNT = &H2
    
    'Other Flags
    Public Const TIMEQ_FOREVER = -1
    Public Const USER_MAXSTORAGE_UNLIMITED = -1
    Public Const DOMAIN_GROUP_RID_USERS = &H201
    Public Const MAX_PATH = 260
    Public Const INIFILE = "USERMGNT.INI"
    
    Public Const ERROR_NO_MORE_FILES = 18&
    Public Const INVALID_HANDLE_VALUE = -1
    Public Const FILE_NOTIFY_CHANGE_ATTRIBUTES = &H4
    Public Const FILE_NOTIFY_CHANGE_DIR_NAME = &H2
    Public Const FILE_NOTIFY_CHANGE_FILE_NAME = &H1
    Public Const FILE_NOTIFY_CHANGE_LAST_WRITE = &H10
    Public Const FILE_NOTIFY_CHANGE_SECURITY = &H100
    Public Const FILE_NOTIFY_CHANGE_SIZE = &H8

    Public Type MungeLong
      X As Long
      Dummy As Integer
    End Type
    
    Public Type MungeInt
      XLo As Integer
      XHi As Integer
      Dummy As Integer
    End Type
    
    Public Type LOCALGROUP_MEMBERS_INFO_3
        lgrmi3_domainandname As Long
    End Type
    
    Public Type USER_INFO_0                     ' Level 0
      ptrName As Long
    End Type
    
    Public Type USER_INFO_1                     ' Level 1
      ptrName As Long
      ptrPassword As Long
      dwPasswordAge As Long
      dwPriv As Long
      ptrHomeDir As Long
      ptrComment As Long
      dwFlags As Long
      ptrScriptPath As Long
    End Type
    

    Public Type USER_INFO_3
       ptrName As Long           'LPWSTR in SDK
       ptrPassword As Long       'LPWSTR in SDK
       dwPasswordAge As Long      'DWORD in SDK
       dwPriv As Long           'DWORD in SDK
       ptrHomeDir As Long       'LPWSTR in SDK
       ptrComment As Long        'LPWSTR in SDK
       dwFlags As Long          'DWORD in SDK
       ptrScriptPath As Long    'LPWSTR in SDK
       dwAuthFlags As Long        'DWORD in SDK
       ptrFullName As Long         'LPWSTR in SDK
       ptrUserComment As Long    'LPWSTR in SDK
       ptrParms As Long          'LPWSTR in SDK
       ptrWorkstations As Long      'LPWSTR in SDK
       dwLastLogon As Long        'DWORD in SDK
       dwLastLogoff As Long    'DWORD in SDK
       dwAcctExpires As Long      'DWORD in SDK
       dwMaxStorage As Long    'DWORD in SDK
       dwUnitsPerWeek As Long    'DWORD in SDK
       pbLogonHours As Long    'PBYTE in SDK
       dwBadPwCount As Long      'DWORD in SDK
       dwNumLogons As Long        'DWORD in SDK
       ptrLogonServer As Long      'LPWSTR in SDK
       dwCountryCode As Long      'DWORD in SDK
       dwCodePage As Long         'DWORD in SDK
       dwUserId As Long        'DWORD in SDK
       dwPrimaryGroupId As Long  'DWORD in SDK
       ptrProfile As Long        'LPWSTR in SDK
       ptrHomeDirDrive As Long    'LPWSTR in SDK
       dwPasswordExpired As Long  'DWORD in SDK
    End Type
    
    Type USER_INFO_10
        ptrName As Long           'LPWSTR in SDK
        ptrComment As Long        'LPWSTR in SDK
        ptrUserComment As Long    'LPWSTR in SDK
        ptrFullName As Long         'LPWSTR in SDK
    End Type
    
    Type SECURITY_ATTRIBUTES
            nLength As Long
            lpSecurityDescriptor As Long
            bInheritHandle As Long
    End Type
Type FILETIME
        dwLowDateTime As Long
        dwHighDateTime As Long
End Type
Type WIN32_FIND_DATA
        dwFileAttributes As Long
        ftCreationTime As FILETIME
        ftLastAccessTime As FILETIME
        ftLastWriteTime As FILETIME
        nFileSizeHigh As Long
        nFileSizeLow As Long
        dwReserved0 As Long
        dwReserved1 As Long
        cFileName As String * MAX_PATH
        cAlternate As String * 14
End Type

    
    Public sName() As String
    Public sPwd() As String
    Public sID() As String
    Public iDeleteItem() As Integer
    Public sInputFile As String
    Public sOutputFile As String
    Public sFilePath As String
    Public dDate As Double
    Public filename$
    Public sMachine As String
    Public sDomain As String
    Public sPDC As String
    Public sUserName As String
    Public sGroup As String
    Public sScript As String
    Public sComment As String
    Public sRandom As String
    Public lFlags As Long
    Public lMaxDiskSpace As Long
    
    Public bCannotChangePwd As Boolean
    Public bNeverExpirePwd As Boolean
    Public bLimitDiskSpace As Boolean
    
       Declare Function GetPrivateProfileString Lib "kernel32" _
        Alias "GetPrivateProfileStringA" _
        (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, ByVal lpDefault As String, _
        ByVal lpReturnedString As String, ByVal nSize As Long, _
        ByVal lpFileName As String) As Long
        
    Declare Function WritePrivateProfileString Lib "kernel32" _
        Alias "WritePrivateProfileStringA" _
        (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, ByVal lpString As Any, _
        ByVal lpFileName As String) As Long

    '***** Network API Declarations******************
    Declare Function NetGetDCName Lib "netapi32.dll" _
        (ServerName As Byte, _
        DomainName As Byte, DCNPtr As Long) As Long
        
    Declare Function GetComputerName Lib "kernel32" _
        Alias "GetComputerNameA" _
        (ByVal lpBuffer As String, nSize As Long) As Long
        
        
    '**************** Working with USERS *****
    
    Declare Function NetUserChangePassword Lib "netapi32.dll" _
        (strServerName As Any, strUserName As Any, strOldPassword As Any, _
        strNewPassword As Any) As Long
        
    Declare Function WNetGetUser Lib "mpr.dll" _
        Alias "WNetGetUserA" (ByVal lpName As String, _
        ByVal lpUserName As String, lpnLength As Long) As Long
        
    ' Add using Level 1 user structure
     Declare Function NetUserAdd1 Lib "netapi32.dll" _
        Alias "NetUserAdd" (ServerName As Byte, _
        ByVal Level As Long, Buffer As USER_INFO_1, ParmError As Long) As Long
        
    ' Add using Level 3 user structure
    Declare Function NetUserAdd3 Lib "netapi32.dll" _
        Alias "NetUserAdd" (ServerName As Byte, _
        ByVal Level As Long, Buffer As USER_INFO_3, ParmError As Long) As Long

    Declare Function NetUserDel Lib "netapi32.dll" _
        (ServerName As Byte, _
        UserName As Byte) As Long
    ' Enumerate using Level 0 user structure
    
    Declare Function NetUserEnum0 Lib "netapi32.dll" _
        Alias "NetUserEnum" (ServerName As Byte, _
        ByVal Level As Long, ByVal lFilter As Long, _
        Buffer As Long, ByVal PrefMaxLen As Long, EntriesRead As Long, _
        TotalEntries As Long, ResumeHandle As Long) As Long
        
    Declare Function NetUserGetInfo Lib "netapi32.dll" _
        (strServerName As Any, strUserName As Any, ByVal dwLevel As Long, _
        pBuffer As Long) As Long
        
    Declare Function NetUserSetInfo Lib "netapi32.dll" _
        (strServerName As Any, strUserName As Any, ByVal dwLevel As Long, _
        pBuffer As Long) As Long
        
    '*********** working with GROUPS *********
    
    Declare Function NetGroupAddUser Lib "netapi32.dll" _
        (ServerName As Byte, _
        GroupName As Byte, UserName As Byte) As Long
        
    Declare Function NetLocalGroupAddMembers3 Lib "netapi32.dll" _
        Alias "NetLocalGroupAddMembers" _
        (ServerName As Any, LGroupName As Any, ByVal Level As Long, _
        Buffer As LOCALGROUP_MEMBERS_INFO_3, ByVal mCount As Long) As Long
 
    Declare Function NetGroupDelUser Lib "netapi32.dll" _
        (ServerName As Byte, _
        GroupName As Byte, UserName As Byte) As Long
        
    Declare Function NetGroupEnumUsers0 Lib "netapi32.dll" _
        Alias "NetGroupGetUsers" (ServerName As Byte, GroupName As Byte, _
        ByVal Level As Long, Buffer As Long, ByVal PrefMaxLen As Long, _
        EntriesRead As Long, TotalEntries As Long, ResumeHandle As Long) As Long
    
    Declare Function NetGroupEnum0 Lib "netapi32.dll" _
        Alias "NetGroupEnum" (ServerName As Byte, _
        ByVal Level As Long, Buffer As Long, _
        ByVal PrefMaxLen As Long, EntriesRead As Long, _
        TotalEntries As Long, ResumeHandle As Long) As Long
    
    Declare Function NetUserGetGroups0 Lib "netapi32.dll" _
        Alias "NetUserGetGroups" (ServerName As Byte, _
        UserName As Byte, ByVal Level As Long, _
        Buffer As Long, ByVal PrefMaxLen As Long, _
        EntriesRead As Long, TotalEntries As Long) As Long
        
    '************ Memory Management *********
    Declare Function NetAPIBufferFree Lib "netapi32.dll" _
        Alias "NetApiBufferFree" (ByVal Ptr As Long) As Long
    
    Declare Function NetAPIBufferAllocate Lib "netapi32.dll" _
        Alias "NetApiBufferAllocate" (ByVal ByteCount As Long, _
        Ptr As Long) As Long
    
    Declare Function PtrToStr Lib "kernel32" _
        Alias "lstrcpyW" (RetVal As Byte, ByVal Ptr As Long) As Long
    
    Declare Function StrToPtr Lib "kernel32" _
        Alias "lstrcpyW" (ByVal Ptr As Long, Source As Byte) As Long
    
    Declare Function PtrToInt Lib "kernel32" Alias _
        "lstrcpynW" (RetVal As Any, ByVal Ptr As Long, _
        ByVal nCharCount As Long) As Long
    
    Declare Function StrLen Lib "kernel32" Alias _
        "lstrlenW" (ByVal Ptr As Long) As Long
        
    Declare Sub CopyMemory Lib "kernel32" _
        Alias "RtlMoveMemory" (hpvDest As Any, _
        ByVal hpvSource As Long, ByVal cbCopy As Long)
        

    Declare Function CreateDirectory Lib "kernel32" _
        Alias "CreateDirectoryA" (ByVal lpPathName As String, _
        ByVal lpSecurityAttributes As Long) As Long
    
    Declare Function CreateDirectoryEx Lib "kernel32" _
        Alias "CreateDirectoryExA" (ByVal lpTemplateDirectory As String, _
        ByVal lpNewDirectory As String, _
        ByVal lpSecurityAttributes As Long) As Long
        
    'Declare Function CreateDirectoryEx Lib "kernel32" _
    '    Alias "CreateDirectoryExA" (ByVal lpTemplateDirectory As String, _
    '    ByVal lpNewDirectory As String, _
    '    lpSecurityAttributes As SECURITY_ATTRIBUTES) As Long
    
    Declare Function RemoveDirectory Lib "kernel32" _
        Alias "RemoveDirectoryA" (ByVal lpPathName As String) As Long
        
    Declare Function DeleteFile Lib "kernel32" _
        Alias "DeleteFileA" (ByVal lpFileName As String) As Long
        
    Declare Function GetLastError Lib "kernel32" () As Long
    
    Declare Function FindFirstFile Lib "kernel32" _
        Alias "FindFirstFileA" (ByVal lpFileName As String, _
        lpFindFileData As WIN32_FIND_DATA) As Long
    
    Declare Function FindNextFile Lib "kernel32" _
        Alias "FindNextFileA" (ByVal hFindFile As Long, _
        lpFindFileData As WIN32_FIND_DATA) As Long
    
    Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
    
    Declare Function FindFirstChangeNotification Lib "kernel32" _
        Alias "FindFirstChangeNotificationA" (ByVal lpPathName As String, _
        ByVal bWatchSubtree As Long, ByVal dwNotifyFilter As Long) As Long
        
    Declare Function FindCloseChangeNotification Lib "kernel32" _
        (ByVal hChangeHandle As Long) As Long
    
    Declare Function FindNextChangeNotification Lib "kernel32" _
        (ByVal hChangeHandle As Long) As Long
        
    Declare Function OpenProcess Lib "kernel32" _
       (ByVal dwDesiredAccess As Long, ByVal bInheritHandle _
       As Long, ByVal dwProcessId As Long) As Long
    
    Declare Function GetExitCodeProcess Lib "kernel32" _
       (ByVal hProcess As Long, lpExitCode As Long) As Long
    
    Declare Sub Sleep Lib "kernel32" _
        (ByVal dwMilliseconds As Long)
        
    Declare Function CloseHandle Lib "kernel32" _
        (ByVal hObject As Long) As Long
        
Function VBGetPrivateProfileString(section$, key$, File$) As String
    Dim KeyValue$
        Dim characters As Integer
    KeyValue$ = String$(128, 0)
    
    characters = GetPrivateProfileString(section$, key$, "", KeyValue$, 127, File$)

    If characters > 1 Then
        KeyValue$ = Left$(KeyValue$, characters)
    End If
    
    VBGetPrivateProfileString = KeyValue$

End Function
 Sub Shell32Bit(ByVal JobToDo As String)
        Dim hProcess As Long
        Dim RetVal As Long
        'The next line launches JobToDo as icon,
        'captures process ID
        hProcess = OpenProcess(PROCESS_QUERY_INFORMATION, False, Shell(JobToDo, 0))
        Do
            'Get the status of the process
            GetExitCodeProcess hProcess, RetVal
            'Sleep command recommended as well
            'as DoEvents
            DoEvents: Sleep 100
        'Loop while the process is active
        Loop While RetVal = STILL_ACTIVE

    End Sub
    
   
Function AddUserToGroup(ByVal sName As String, _
    ByVal GName As String, ByVal UName As String) As Long
    ' ' This only adds users to global groups - not to local groups
    Dim SNArray() As Byte
    Dim GNArray() As Byte
    Dim UNArray() As Byte
    Dim result As Long

  SNArray = sName & vbNullChar
  GNArray = GName & vbNullChar
  UNArray = UName & vbNullChar
  result = NetGroupAddUser(SNArray(0), GNArray(0), UNArray(0))
  If result = 2220 Then Debug.Print _
"There is no **GLOBAL** group '" & GName & "'"
  AddUserToGroup = result
End Function
Function DelUser(ByVal sName As String, ByVal _
    UName As String) As Long
    Dim UNArray() As Byte
    Dim SNArray() As Byte
    Dim sBackupDir As String
    Dim sKillFile As String
    Dim JobToDo As String
    
    Dim result As Long
        sBackupDir = Trim(sPDC)
        sBackupDir = Left(sBackupDir, InStr(sBackupDir, vbNullChar) - 1)
        sBackupDir = sBackupDir & sFilePath & UName & vbNullChar
        'result = DelFiles(Left(sBackupDir, Len(sBackupDir) - 1))
        'result = RemoveDirectory(sBackupDir)
        sKillFile = Trim(sPDC)
        sKillFile = Left(sKillFile, InStr(sKillFile, vbNullChar) - 1)
        sKillFile = sKillFile & sFilePath & UName
   
   Open App.Path & "\DELALL.BAT" For Output As #1    ' Open file for output.
    Print #1, "RMDIR /S /Q " & sKillFile
    Close #1    ' Close file.
        
        JobToDo = "DELALL.BAT"
        Shell32Bit (JobToDo)
  UNArray = UName & vbNullChar
  SNArray = sName & vbNullChar
  DelUser = NetUserDel(SNArray(0), UNArray(0))
  

End Function

Function DelUserFromGroup(ByVal sName As String, _
    ByVal GName As String, ByVal UName As String) As Long
' ' This only deletes users from global groups - not local groups '
    Dim SNArray() As Byte
    Dim GNArray() As Byte
    Dim UNArray() As Byte
    Dim result As Long

  SNArray = sName & vbNullChar
  GNArray = GName & vbNullChar
  UNArray = UName & vbNullChar
  result = NetGroupDelUser(SNArray(0), GNArray(0), UNArray(0))
  If result = 2220 Then Debug.Print _
"There is no **GLOBAL** group '" & GName & "'"
  DelUserFromGroup = result
  
End Function

Function EnumerateGroups(ByVal sName As String, _
    ByVal UName As String) As Long
    ' ' Enumerates global groups only - not local groups '
    ' The buffer is filled from the left with pointers to user names that
    ' are filled from the right side. For example: '

'     ptr1|ptr2|...|ptrn|<garbage>|strn|...|str2|str1
'     ^-------------- BufPtr buffer ----------------^
' ' On NT, TotalEntries is the number of entries left to be read including
' the currently read entries. '
' On LanMan and OS/2, it is the total number of entries, period. Code
' would have to be changed to reflect this if the Domain controller
' wasn't an NT machine. '
' BufPtr gets the address of the buffer (or ptr1 - add 4 to BufPtr for
' each additional pointer) '

    Dim result As Long, BufPtr As Long, EntriesRead As Long, _
    TotalEntries As Long, ResumeHandle As Long, BufLen As Long, _
    SNArray() As Byte, GNArray(99) As Byte, UNArray() As Byte, _
    GName As String, i As Integer, UNPtr As Long, _
    TempPtr As MungeLong, TempStr As MungeInt
    
  SNArray = sName & vbNullChar       ' Move to byte array
  UNArray = UName & vbNullChar       ' Move to Byte array
  BufLen = 255                       ' Buffer size
  ResumeHandle = 0                   ' Start with the first entry

  Do
    If UName = "" Then
      result = NetGroupEnum0(SNArray(0), 0, BufPtr, BufLen, _
EntriesRead, TotalEntries, ResumeHandle)
    Else
      result = NetUserGetGroups0(SNArray(0), UNArray(0), 0, BufPtr, _
BufLen, EntriesRead, TotalEntries)
    End If
    EnumerateGroups = result
    If result <> 0 And result <> 234 Then    ' 234 means multiple reads
                                             ' required
      Debug.Print "Error " & result & " enumerating group " & _
EntriesRead & " of " & TotalEntries
      Exit Function
    End If
    For i = 1 To EntriesRead
      ' Get pointer to string from beginning of buffer
      ' Copy 4 byte block of memory in 2 steps
      result = PtrToInt(TempStr.XLo, BufPtr + (i - 1) * 4, 2)
      result = PtrToInt(TempStr.XHi, BufPtr + (i - 1) * 4 + 2, 2)
      LSet TempPtr = TempStr ' munge 2 Integers to a Long
      ' Copy string to array and convert to a string
      result = PtrToStr(GNArray(0), TempPtr.X)
      GName = Left(GNArray, StrLen(TempPtr.X))
      Debug.Print "Group: " & GName
    Next i
  Loop Until EntriesRead = TotalEntries
' The above condition only valid for reading accounts on NT ' but not OK for OS/2 or LanMan

  result = NetAPIBufferFree(BufPtr)         ' Don't leak memory
    result = 10
End Function

Function EnumerateUsers(ByVal sName As String, _
    ByVal GName As String) As Long
    ' ' If a group name is specified, it must be a global group
    ' and not a local group. '
    ' The buffer is filled from the left with pointers to user names that
    ' are filled from the right side. For example: '

'     ptr1|ptr2|...|ptrn|<garbage>|strn|...|str2|str1
'     ^-------------- BufPtr buffer ----------------^
' ' On Windows NT, TotalEntries is the number of entries left to be read,
' including the currently read entries.
' On LanMan and OS/2, it is the total number of entries, period. Code
' would have to be changed to reflect this if the Domain controller
' wasn't an NT machine. '
' BufPtr gets the address of the buffer (or ptr1 - add 4 to BufPtr for
' each additional pointer) '
' SName should be "\\servername" '
Dim result As Long, BufPtr As Long, EntriesRead As Long, _
TotalEntries As Long, ResumeHandle As Long, BufLen As Long, _
SNArray() As Byte, GNArray() As Byte, UNArray(99) As Byte, _
UName As String, i As Integer, UNPtr As Long, TempPtr As MungeLong, _
TempStr As MungeInt

  SNArray = sName & vbNullChar       ' Move to byte array
  GNArray = GName & vbNullChar       ' Move to Byte array
  BufLen = 255                       ' Buffer size
  ResumeHandle = 0                   ' Start with the first entry

  Do
    If GName = "" Then
      result = NetUserEnum0(SNArray(0), 0, FILTER_NORMAL_ACCOUNT, _
BufPtr, BufLen, EntriesRead, TotalEntries, ResumeHandle)
    Else
      result = NetGroupEnumUsers0(SNArray(0), GNArray(0), 0, BufPtr, _
BufLen, EntriesRead, TotalEntries, ResumeHandle)
    End If
    EnumerateUsers = result
    If result <> 0 And result <> 234 Then    ' 234 means multiple reads
                                             ' required
      Debug.Print "Error " & result & " enumerating user " _
& EntriesRead & " of " & TotalEntries
      If result = 2220 Then Debug.Print _
"There is no **GLOBAL** group '" & GName & "'"
      Exit Function
    End If
    For i = 1 To EntriesRead
      ' Get pointer to string from beginning of buffer
      ' Copy 4-byte block of memory in 2 steps
      result = PtrToInt(TempStr.XLo, BufPtr + (i - 1) * 4, 2)
      result = PtrToInt(TempStr.XHi, BufPtr + (i - 1) * 4 + 2, 2)
      LSet TempPtr = TempStr ' munge 2 integers into a Long
      ' Copy string to array
      result = PtrToStr(UNArray(0), TempPtr.X)
      UName = Left(UNArray, StrLen(TempPtr.X))
      Debug.Print "User: " & UName
    Next i
  Loop Until EntriesRead = TotalEntries
' The above condition is only valid for reading accounts on Windows NT, ' but is not OK for OS/2 or LanMan

  result = NetAPIBufferFree(BufPtr)         ' Don't leak memory

End Function

Function GetPrimaryDCName(ByVal MName As String, _
    ByVal DName As String) As String
    
    Dim result As Long
    Dim DCName As String
    Dim DCNPtr As Long
    Dim DNArray() As Byte
    Dim MNArray() As Byte
    Dim DCNArray(100) As Byte

  MNArray = MName & vbNullChar
  DNArray = DName & vbNullChar
  
  result = NetGetDCName(MNArray(0), DNArray(0), DCNPtr)
  If result <> 0 Then
    Debug.Print "Error: " & result
    If result = 2453 Then
        Dim msg$
        msg$ = "Can't find Primary Domain Controller! Check:" & vbCrLf & vbCrLf _
            & "UsrMgnt.ini file for errors" & vbCrLf & vbCrLf _
            & "You are connected to the domain" & vbCrLf & vbCrLf _
            & "You are logged to the domain" & vbCrLf & vbCrLf _
            & "Cannot continue"
        MsgBox msg$, , App.Title
        End
        
        
    End If
  End If
  result = PtrToStr(DCNArray(0), DCNPtr)
  result = NetAPIBufferFree(DCNPtr)
  DCName = DCNArray()
  GetPrimaryDCName = DCName
End Function
Function AddUser(ByVal sName As String, ByVal UName As String, _
    ByVal PWD As String, ByVal FullName As String) As Long
    
    Dim result As Long
    Dim UNPtr As Long
    Dim PWDPtr As Long
    Dim FNPtr As Long
    Dim CMTPtr As Long
    Dim SCRPtr As Long
    Dim ParmError As Long
    Dim sBackupDir As String
    
    Dim SNArray() As Byte
    Dim UNArray() As Byte
    Dim FNArray() As Byte
    Dim PWDArray() As Byte
    Dim SCRArray() As Byte
    Dim CMTArray() As Byte
    
    Dim UserStruct As USER_INFO_3
    
    ' ' Move to byte arrays '
        sBackupDir = Trim(sPDC)
        sBackupDir = Left(sBackupDir, InStr(sBackupDir, vbNullChar) - 1)
        
        sBackupDir = sBackupDir & sFilePath & UName & vbNullChar
               
        result = CreateDirectory(sBackupDir, 0&)
       

  SNArray = sName & vbNullChar
  UNArray = UName & vbNullChar
  FNArray = FullName & vbNullChar
  PWDArray = PWD & vbNullChar
  SCRArray = sScript & vbNullChar
  CMTArray = sComment & vbNullChar
  
' ' Allocate buffer space '
  result = NetAPIBufferAllocate(UBound(UNArray) + 1, UNPtr)
  result = NetAPIBufferAllocate(UBound(FNArray) + 1, FNPtr)
  result = NetAPIBufferAllocate(UBound(PWDArray) + 1, PWDPtr)
  result = NetAPIBufferAllocate(UBound(SCRArray) + 1, SCRPtr)
  result = NetAPIBufferAllocate(UBound(CMTArray) + 1, CMTPtr)
' ' Copy arrays to the buffer '
  result = StrToPtr(UNPtr, UNArray(0))
  result = StrToPtr(FNPtr, FNArray(0))
  result = StrToPtr(PWDPtr, PWDArray(0))
  result = StrToPtr(SCRPtr, SCRArray(0))
  result = StrToPtr(CMTPtr, CMTArray(0))
' ' Fill the structure '
  With UserStruct
    .ptrName = UNPtr
    .ptrPassword = PWDPtr
    .dwPasswordAge = 0
    .dwPriv = USER_PRIV_USER
    .ptrHomeDir = 0
    .ptrComment = CMTPtr
    .dwFlags = lFlags   'UF_NORMAL_ACCOUNT Or UF_SCRIPT Or UF_DONT_EXPIRE_PASSWD
    .ptrScriptPath = SCRPtr
    .dwAuthFlags = 0
    .ptrFullName = FNPtr
    .ptrUserComment = 0
    .ptrParms = 0
    .ptrWorkstations = 0
    .dwLastLogon = 0
    .dwLastLogoff = 0
    .dwAcctExpires = TIMEQ_FOREVER
    .dwMaxStorage = lMaxDiskSpace   'USER_MAXSTORAGE_UNLIMITED
    .dwUnitsPerWeek = 0
    .pbLogonHours = 0
    .dwBadPwCount = 0
    .dwNumLogons = 0
    .ptrLogonServer = 0
    .dwCountryCode = 0
    .dwCodePage = 0
    .dwUserId = 0
    .dwPrimaryGroupId = DOMAIN_GROUP_RID_USERS
    .ptrProfile = 0
    .ptrHomeDir = 0
    .dwPasswordExpired = 0
  End With
' ' Add the user '
  result = NetUserAdd3(SNArray(0), 3, UserStruct, ParmError)
  AddUser = result
    If result <> 0 Then
            Debug.Print "Error " & result & " in parameter " & ParmError _
        & " when adding user " & UName
     Else
      
     End If
' ' Release buffers from memory '
  result = NetAPIBufferFree(UNPtr)
  result = NetAPIBufferFree(PWDPtr)

End Function


Public Function MakePassword() As String

    'Dim sPassword As String
    
    Dim iRnd As Integer
    Dim X As Integer
    Dim sPassword As String
    
    Do While X < 8
        Randomize
        iRnd = Int((42 * Rnd) + 48)
        If iRnd < 58 Or iRnd > 64 Then
            X = X + 1
            sPassword = sPassword & Chr$(iRnd)
            
        End If
              
    Loop
        MakePassword = LCase(sPassword)
        
End Function


Public Function GetUser() As String
   
    Dim sUserNameBuff As String * 255
    sUserNameBuff = Space(255)
    
    Call WNetGetUser(vbNullString, sUserNameBuff, 255&)
    GetUser = Left$(sUserNameBuff, InStr(sUserNameBuff, _
        vbNullChar) - 1)

End Function

Public Function GetComputer() As String


    Dim sComputerNameBuff As String * 255
    sComputerNameBuff = Space(255)
    
    Call GetComputerName(sComputerNameBuff, 255&)
    GetComputer = Left$(sComputerNameBuff, InStr(sComputerNameBuff, _
        vbNullChar) - 1)

End Function

Public Function DelFiles(SDirectory As String)
Dim ThisFile As WIN32_FIND_DATA
Dim X&
Dim Y&
Dim E&
Dim result&
Dim changed&
Dim sDelFileName$

    Y = -1
    X = -1
    changed = FindFirstChangeNotification(SDirectory & vbNullChar, _
        0, FILE_NOTIFY_CHANGE_FILE_NAME)

    result = FindFirstFile(SDirectory & "\*.*" & vbNullChar, ThisFile)
    
Do While X <> 0
    X = FindNextFile(result, ThisFile)
    Debug.Print ThisFile.cFileName
        If X = 0 Then
            Exit Do
        End If
        
        sDelFileName = SDirectory & "\" & Left(ThisFile.cFileName, _
            InStr(ThisFile.cFileName, vbNullChar) - 1)
            
        If Left(ThisFile.cFileName, 2) <> ".." Then
            Y = DeleteFile(sDelFileName & vbNullChar)
        End If
        ThisFile.cFileName = ""
Loop
    X = FindClose(result)
    X = FindCloseChangeNotification(changed)

End Function

Public Function UserChangePassword(ByVal sName As String, ByVal UName As String, _
    ByVal oldPWD As String, ByVal newPWD As String) As Long
   
    Dim result As Long
    Dim SNArray() As Byte   'Server Name MUST BE PDC
    Dim UNArray() As Byte   'Username
    Dim oPWDArray() As Byte 'Old Password
    Dim nPWDArray() As Byte 'New Password
    
    SNArray = sName & vbNullChar
    UNArray = UName & vbNullChar
    oPWDArray = oldPWD & vbNullChar
    nPWDArray = newPWD & vbNullChar

    result = NetUserChangePassword(SNArray(0), UNArray(0), _
                oPWDArray(0), oPWDArray(0))
    UserChangePassword = result
    If result <> 0 Then
        Debug.Print "Error " & result & " when changing password for " & UName
    End If
 
End Function


Public Function AddUserToLGroup(ByVal sName As String, ByVal LGroupName As String, _
    ByVal UName As String) As Long
    
    Dim result As Long
    Dim SNPtr As Long
    Dim LGPPtr As Long
    Dim DUNPtr As Long

    
    Dim sTemp As String
    
    Dim SNArray() As Byte
    Dim DUNArray() As Byte
    Dim LGPArray() As Byte
    
    Dim LGPStruct As LOCALGROUP_MEMBERS_INFO_3
    sTemp = UName & vbNullChar  'sDomain & "\" &
    SNArray = sName
    DUNArray = sTemp
    LGPArray = LGroupName & vbNullChar
    ' Allocate buffer space '
    result = NetAPIBufferAllocate(UBound(SNArray) + 1, SNPtr)
    result = NetAPIBufferAllocate(UBound(LGPArray) + 1, LGPPtr)
    result = NetAPIBufferAllocate(UBound(DUNArray) + 1, DUNPtr)
    ' ' Copy array to the buffer '
    result = StrToPtr(SNPtr, SNArray(0))
    result = StrToPtr(LGPPtr, LGPArray(0))
    result = StrToPtr(DUNPtr, DUNArray(0))
    ' ' Fill the structure '
    With LGPStruct
        .lgrmi3_domainandname = DUNPtr
    End With

    result = NetLocalGroupAddMembers3(SNArray(0), LGPArray(0), 3&, LGPStruct, 1&)

    AddUserToLGroup = result
    If result <> 0 Then
        Debug.Print "Error " & result & " when adding user " & UName
    End If
' ' Release buffer from memory '
    result = NetAPIBufferFree(SNPtr)
    result = NetAPIBufferFree(LGPPtr)
    result = NetAPIBufferFree(DUNPtr)
End Function
