Attribute VB_Name = "VBtris"
'-------------------------------------------------------
'VBtris32
'Created by Eric Griffith
'This is freeware.  Feel free to distribute it.
'-------------------------------------------------------
Option Explicit
'-------------------------------------------------------
'This module contains all global declerations for the
'game and all the procedures used to run the game.
'-------------------------------------------------------

'-------------------------------------------------------
'This function is used to "paste" together the squares
'onto the gameboard to create what the player sees
'-------------------------------------------------------
Declare Function BitBlt Lib "GDI32" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer

'-------------------------------------------------------
'This constant is used with BitBlt for dwRop.  This
'tells it to copy the source image and paste it over
'the destination image at the prespecified coordinates
'-------------------------------------------------------
Global Const SRCCOPY = &HCC0020

'-------------------------------------------------------
'These functions are used to read and write to the
'program's .INI file
'-------------------------------------------------------
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long

'-------------------------------------------------------
'This function the constants are used to play the game's
'sounds
'-------------------------------------------------------
Declare Function sndPlaySound Lib "winmm" Alias "sndPlaySoundA" (ByVal lpszSoundName As String, ByVal uFlags As Long) As Long
Declare Function mciSendString Lib "winmm" Alias "mciSendStringA" (ByVal lpstrCommand As String, ByVal lpstrReturnString As Any, ByVal uReturnLength As Long, ByVal hwndCallback As Long) As Long

Global Const NEXT_LEVEL = "Sound1.wav"
Global Const PIECE_STOP = "Sound2.wav"
Global Const PIECE_DOWN = "Sound3.wav"
Global Const ONE_LINE = "Sound4.wav"
Global Const TWO_LINES = "Sound5.wav"
Global Const THREE_LINES = "Sound6.wav"
Global Const FOUR_LINES = "Sound7.wav"

Global Const MUSIC = "VBtris32.mid"

'-------------------------------------------------------
'This is a type created to contain all the information
'used pertaining to the gameboard and the pieces on it
'except for a few boolean variables
'-------------------------------------------------------
Type GameBoard
    'Variable representation of the board the player sees
    Square(1 To 10, 1 To 18) As Integer
    'The hDc of the pictures containing the colored
    'square.  To be used with BitBlt
    PieceDC(0 To 7) As Integer
    'The number of lines the player has cleared
    Rows As Integer
    'What kind of piece is currently falling
    CurPiece As Integer
    'What kind of piece the next one will be
    NextPiece As Integer
    'What the X position of the piece is
    PieceX As Integer
    'What the Y position of the piece is
    PieceY As Integer
    'What the pieces orientation is (Pertaining to
    'rotation)
    PiecePos As Integer
    'The players score
    Score As Variant
    'The level the player is on
    Level As Integer
    'The hDc of the board the player sees
    BoardDC As Integer
    'The hDc of the board the player doesn't see
    B2DC As Integer
    'A boolean expression telling whether or not a game is
    'in progress
    Game As Integer
End Type
'-------------------------------------------------------
'Variables pertaining to what the board looks
'like and what it just looked like, whether or not a
'new piece is needed, whether or not the game is over,
'whether or not a piece's descent is being accelerated,
'the number of seconds to pause between downward
'movement of pieces, what Y position the accelerated
'descent of a piece began at, the names of the people
'with high scores and their scores, whether or not
'the game is paused, what level to start the games on,
'whether or not to fill in some of the bottom lines,
'whether or not to immediately hide frmSplash, and
'whether or not to play sounds.
'-------------------------------------------------------
Global Board As GameBoard, OldBoard As GameBoard, NewPiece, GameOver
Global FallPiece, PL, FallY, ScoreN(1 To 10), Scores(1 To 10)
Global PauseTheGame, StartingLevel, FillLines, HideSplash
Global PlaySounds, MIDITime
Sub CheckForHighScore()
'-------------------------------------------------------
'Reads in the list of high scores and then it
'checks to see if the score the player got in the game
'he or she just played is a high score.  If it is, the
'scores below it are moved down one place, the player's
'name is read in, the updated list is composed and
'written to the disk and the new list is displayed
'-------------------------------------------------------
Dim I, J, N
'Read in the high scores
GetScores
For I = 1 To 5
    'Checking for the score
    If Board.Score >= Scores(I) Then
        If I < 5 Then
            'Moving the scores and names down one place
            For J = 5 To I + 1 Step -1
                Scores(J) = Scores(J - 1)
                ScoreN(J) = ScoreN(J - 1)
            Next
        End If
        'Reading in the player's name
        N = InputBox("Congratulations!" & Chr$(13) & Chr$(10) & "You got a High Score!" & Chr$(13) & Chr$(10) & "Enter your name:", "Tetris")
        'Inserting the player's name and score
        Scores(I) = Board.Score
        ScoreN(I) = N
        'Writng the scores to disk and displaying them
        WriteScores
        DisplayHighScores
        Exit For
    End If
Next

End Sub

Sub CheckForRows()
'-------------------------------------------------------
'This procedure goes through the board and checks to
'see if the player as filled in any rows.  Any rows that
'were filled in are recorded and emptied, the nonfilled
'rows are collapsed down, it is determined if the
'player has advanced to another level, and points are
'awarded as necessary
'-------------------------------------------------------
Dim I, J, R, L, GoBackOne, RCount
ReDim Rows(1 To 18)
RCount = 0
'Record what the board looks like in case it changes
OldBoard = Board
For J = 18 To 1 Step -1
    'Checks to see if Row J is filled
    R = True
    For I = 1 To 10
        If Board.Square(I, J) = 0 Then
            R = False
            Exit For
        End If
    Next
    'If R is still True then the row is filled and it is
    'recorded
    Rows(J) = R
    If R Then
        'The filled row is then emptied
        RCount = RCount + 1
        For I = 1 To 10
            Board.Square(I, J) = 0
        Next
    End If
Next
'The board is drawn with the empty rows
DrawBoard
Pause 0.1
'Play the appropriate sounds
If PlaySounds Then
    If RCount = 1 Then
        PlayWAV ONE_LINE
    ElseIf RCount = 2 Then
        PlayWAV TWO_LINES
    ElseIf RCount = 3 Then
        PlayWAV THREE_LINES
    ElseIf RCount = 4 Then
        PlayWAV FOUR_LINES
    End If
End If
    
For L = 18 To 2 Step -1
    'If a row has just been collapsed, it goes over it
    'again to make sure an empty row has not been put in
    'its place
    If GoBackOne Then
        L = L + 1
        GoBackOne = False
    End If
    If Rows(L) Then
        'Record the board before the row is collapsed
        OldBoard = Board
        For J = L To 2 Step -1
            For I = 1 To 10
                'Collapse Row L
                Board.Square(I, J) = Board.Square(I, J - 1)
            Next
            Rows(J) = Rows(J - 1)
            GoBackOne = True
        Next
        Pause 0.1
        'Draw the board now that the row has been collapsed
        DrawBoard
    End If
Next
'Check to see if the player has advanced to the next level
If Board.Rows \ 10 < (Board.Rows + RCount) \ 10 Then
    'Play the sound if appropriate
    If PlaySounds Then PlayWAV NEXT_LEVEL
    Board.Level = Board.Level + 1
    If Board.Level <= 9 Then PL = PL - 0.0472
End If
'Adjust the rows cleared by the player as necessary
Board.Rows = Board.Rows + RCount
'Award points based on how many rows the player filled
'with the last piece they used and what level they are on
If RCount = 1 Then
    Board.Score = Board.Score + (50 * (Board.Level + 1))
ElseIf RCount = 2 Then
    Board.Score = Board.Score + (150 * (Board.Level + 1))
ElseIf RCount = 3 Then
    Board.Score = Board.Score + (500 * (Board.Level + 1))
ElseIf RCount = 4 Then
    Board.Score = Board.Score + (1000 * (Board.Level + 1))
End If

End Sub

Sub DisplayHighScores()
'-------------------------------------------------------
'Puts the data from the high scores arrays into labels
'on frmHighScore and then shows that form
'-------------------------------------------------------
Dim I
For I = 1 To 5
    'Put the name in frmHighScore.lblName
    frmHighScore.lblName(I) = ScoreN(I)
    'Put the score in frmHighScore.lblScore
    frmHighScore.lblScore(I) = Scores(I)
Next
'Display the form modally
frmHighScore.Show 1

End Sub


Sub DrawBoard()
'-------------------------------------------------------
'Go through what the board looks like (Board.Square) and
'compare it to what it looked like before any changes,
'if any, were made.  Where ever differences are found,
'the changes are drawn on the board the player doesn't
'see (frmVBtris.picBoard2).  This is done to save time
'rather than redrawing every square every time.  Once
'the changes are drawn on the hidden board, that whole
'board is pasted over the board the player does see
'(frmVBtris.picBoard).  The two board method is done to
'prevent flickering or domino effect drawing of the
'squares.
'-------------------------------------------------------
Dim I, J, Temp
For I = 1 To 10
    For J = 1 To 18
        'Check one square for differences
        If Board.Square(I, J) <> OldBoard.Square(I, J) Then
            'Draw that square onto the hidden board
            Temp = BitBlt(Board.B2DC, ((I - 1) * 16) + 1, ((J - 1) * 16) + 1, 16, 16, Board.PieceDC(Board.Square(I, J)), 0, 0, SRCCOPY)
        End If
    Next
Next
'Make sure picBoard.AutoRedraw isn't true or else
'the board will not appear
If frmVBtris.picBoard.AutoRedraw Then
    frmVBtris.picBoard.AutoRedraw = False
End If
'Draw the hidden board onto the visible board
Temp = BitBlt(Board.BoardDC, 0, 0, 160, 288, Board.B2DC, 1, 1, SRCCOPY)

End Sub


Sub DrawPiece()
'-------------------------------------------------------
'Positions a new piece at the top of the board.  If it
'is being transposed any existing squares, then the game
'is over
'-------------------------------------------------------

'Piece 1
'    Y
'    Y
'X O O O O
'    Y
'    Y


'Piece 2
'    Y
'  O Y
'X O O O X
'    Y
'    Y

'Piece 3
'    Y
'    Y O
'X O O O X
'    Y
'    Y

'Piece 4
'    Y
'  O O
'X X O O X
'    Y
'    Y

'Piece 5
'    Y
'    O O
'X O O X X
'    Y
'    Y

'Piece 6
'    Y
'    O
'X O O O X
'    Y
'    Y

'Piece 7
'    Y
'    O O
'X X O O X
'    Y
'    Y
Dim I

Select Case Board.CurPiece
    'Draw Piece 1
    Case 1
        For I = 4 To 7
            If Board.Square(I, 1) <> 0 Then GameOver = True
            Board.Square(I, 1) = 1
        Next
    'Draw Piece 2
    Case 2
        If Board.Square(4, 1) <> 0 Then GameOver = True
        Board.Square(4, 1) = 2
        For I = 4 To 6
            If Board.Square(I, 2) <> 0 Then GameOver = True
            Board.Square(I, 2) = 2
        Next
    'Draw Piece 3
    Case 3
        If Board.Square(6, 1) <> 0 Then GameOver = True
        Board.Square(6, 1) = 3
        For I = 4 To 6
            If Board.Square(I, 2) <> 0 Then GameOver = True
            Board.Square(I, 2) = 3
        Next
    'Draw Piece 4
    Case 4
        If Board.Square(4, 1) <> 0 Then GameOver = True
        If Board.Square(5, 1) <> 0 Then GameOver = True
        If Board.Square(5, 2) <> 0 Then GameOver = True
        If Board.Square(6, 2) <> 0 Then GameOver = True
        Board.Square(4, 1) = 4
        Board.Square(5, 1) = 4
        Board.Square(5, 2) = 4
        Board.Square(6, 2) = 4
    'Draw Piece 5
    Case 5
        If Board.Square(5, 1) <> 0 Then GameOver = True
        If Board.Square(6, 1) <> 0 Then GameOver = True
        If Board.Square(4, 2) <> 0 Then GameOver = True
        If Board.Square(5, 2) <> 0 Then GameOver = True
        Board.Square(5, 1) = 5
        Board.Square(6, 1) = 5
        Board.Square(4, 2) = 5
        Board.Square(5, 2) = 5
    'Draw Piece 6
    Case 6
        If Board.Square(5, 1) <> 0 Then GameOver = True
        Board.Square(5, 1) = 6
        For I = 4 To 6
            If Board.Square(I, 2) <> 0 Then GameOver = True
            Board.Square(I, 2) = 6
        Next
    'Draw Piece 7
    Case 7
        If Board.Square(5, 1) <> 0 Then GameOver = True
        If Board.Square(6, 1) <> 0 Then GameOver = True
        If Board.Square(5, 2) <> 0 Then GameOver = True
        If Board.Square(6, 2) <> 0 Then GameOver = True
        Board.Square(5, 1) = 7
        Board.Square(6, 1) = 7
        Board.Square(5, 2) = 7
        Board.Square(6, 2) = 7
End Select

End Sub

Sub GenerateINIFile()
'-------------------------------------------------------
'Initializes the variables that are recorded in the INI
'file and then calls the WriteINIFile procedure
'-------------------------------------------------------
StartingLevel = 0
FillLines = False
PlaySounds = False
HideSplash = False
WriteINIFile

End Sub

Sub GetScores()
'-------------------------------------------------------
'Read in the list of scores from the file called
'"scores.list" which is located in the same directory
'as the program.  If it is not there, the program will
'create a new one
'-------------------------------------------------------
Dim CurLine, N, S, I, Spot
'Open the file and create one if it doesn't exist
On Error GoTo NeedNewFile
Open App.Path & "\scores.lst" For Input As #1
On Error GoTo 0
For I = 1 To 5
    'Read in Line I
    Line Input #1, CurLine
    'Find the ":" which denotates the end of the name
    'and the beginning of the score
    Spot = InStr(CurLine, ":")
    'Put the name into N
    N = Mid(CurLine, 1, Spot - 1)
    'Put the score into S
    S = Val(Mid(CurLine, Spot + 1, Len(CurLine)))
    'Put the name and the score into the appropriate array
    ScoreN(I) = N
    Scores(I) = S
Next
'Close the file
Close #1
Exit Sub
NeedNewFile:
Dim Msg As String
'Create the file
Open App.Path & "\scores.lst" For Binary As #1
For I = 1 To 5
    'Create generic scores
    Msg = Msg & "None:0" & Chr$(13) & Chr$(10)
Next
'Store the new list in the file
Put 1, , Msg
'Close the file and reopen it for input to be used above
Close #1
Open App.Path & "\scores.lst" For Input As #1
Resume Next
End Sub

Sub MovePieceDown()
'-------------------------------------------------------
'Moves the piece down one space provided nothing stops
'it from doing so.  If something does, it tells the game
'that it needs a new piece
'-------------------------------------------------------

'Piece 1
'  Pos 1       Pos 2
'    X           X
'    X           O
'Y O O O O   Y Y O Y Y
'    X           O
'    X           O
'
'Piece 2
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'  O X           O O         X           O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O           X O       O O
'    X           X           X           X
'
'Piece 3
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    X O         O           X         O O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O O       O X           O
'    X           X           X           X
'
'Piece 4
'  Pos 1       Pos 2
'    X           X
'  O O           X O
'Y Y O O Y   Y Y O O Y
'    X           O
'    X           X
'
'Piece 5
'  Pos 1       Pos 2
'    X           X
'    O O         O
'Y O O Y Y   Y Y O O Y
'    X           X O
'    X           X
'
'Piece 6
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    O           O           X           O
'Y O O O Y   Y Y O O Y   Y O O O Y   Y O O Y Y
'    X           O           O           O
'    X           X           X           X
'
'Piece 7
'  Pos 1
'    X
'    O O
'Y Y O O Y
'    X
'    X

Dim I
'Determines what piece is currently moving and what
'position it is in.  This tells it where to look for things
'that are in its way.  Provided nothing is there and it has
'not reached the bottom, it moves down.  Plays the appropriate
'sound as well.

Select Case Board.CurPiece
    Case 1
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 0 Then
                    For I = Board.PieceX - 1 To Board.PieceX + 2
                        Board.Square(I, Board.PieceY) = 0
                        Board.Square(I, Board.PieceY + 1) = 1
                    Next
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceY <= 15 Then
                If Board.Square(Board.PieceX, Board.PieceY + 3) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 3) = 1
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        End If
    Case 2
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    For I = Board.PieceX - 1 To Board.PieceX + 1
                        If I <> Board.PieceX - 1 Then Board.Square(I, Board.PieceY) = 0
                        Board.Square(I, Board.PieceY + 1) = 2
                    Next
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 2
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 2
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 0 Then
                    For I = Board.PieceX - 1 To Board.PieceX + 1
                        Board.Square(I, Board.PieceY) = 0
                        If I <> Board.PieceX + 1 Then Board.Square(I, Board.PieceY + 1) = 2
                    Next
                    Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 2
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX, Board.PieceY + 2) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 2
                    Board.Square(Board.PieceX - 1, Board.PieceY + 2) = 2
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        End If
    Case 3
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    For I = Board.PieceX - 1 To Board.PieceX + 1
                        If I <> Board.PieceX + 1 Then Board.Square(I, Board.PieceY) = 0
                        Board.Square(I, Board.PieceY + 1) = 3
                    Next
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX, Board.PieceY + 2) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 3
                    Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 3
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    For I = Board.PieceX - 1 To Board.PieceX + 1
                        Board.Square(I, Board.PieceY) = 0
                        If I <> Board.PieceX - 1 Then Board.Square(I, Board.PieceY + 1) = 3
                    Next
                    Board.Square(Board.PieceX - 1, Board.PieceY + 2) = 3
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 3
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 3
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        End If
    Case 4
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 4
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 4
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 4
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 4
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 4
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        End If
    Case 5
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 5
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 5
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 5
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 5
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 5
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        End If
    Case 6
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    For I = Board.PieceX - 1 To Board.PieceX + 1
                        If I <> Board.PieceX Then Board.Square(I, Board.PieceY) = 0
                        Board.Square(I, Board.PieceY + 1) = 6
                    Next
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 6
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 6
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 2) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    For I = Board.PieceX - 1 To Board.PieceX + 1
                        Board.Square(I, Board.PieceY) = 0
                        If I <> Board.PieceX Then Board.Square(I, Board.PieceY + 1) = 6
                    Next
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 6
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceY <= 16 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 2) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 6
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 6
                    Board.PieceY = Board.PieceY + 1
                Else
                    NewPiece = True
                End If
            Else
                NewPiece = True
            End If
        End If
    Case 7
        If Board.PieceY <= 17 Then
            If Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 7
                Board.Square(Board.PieceX, Board.PieceY + 1) = 7
                Board.PieceY = Board.PieceY + 1
            Else
                NewPiece = True
            End If
        Else
            NewPiece = True
        End If
End Select
If PlaySounds Then
    If NewPiece Then
        PlayWAV PIECE_STOP
    Else
        If Not FallPiece Then PlayWAV PIECE_DOWN
    End If
End If
End Sub

Sub MovePieceLeft()
'-------------------------------------------------------
'Moves the piece to the left provided that nothing is in
'the way
'-------------------------------------------------------

'Piece 1
'  Pos 1       Pos 2
'    X           X
'    X           O
'Y O O O O   Y Y O Y Y
'    X           O
'    X           O
'
'Piece 2
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'  O X           O O         X           O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O           X O       O O
'    X           X           X           X
'
'Piece 3
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    X O         O           X         O O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O O       O X           O
'    X           X           X           X
'
'Piece 4
'  Pos 1       Pos 2
'    X           X
'  O O           X O
'Y Y O O Y   Y Y O O Y
'    X           O
'    X           X
'
'Piece 5
'  Pos 1       Pos 2
'    X           X
'    O O         O
'Y O O Y Y   Y Y O O Y
'    X           X O
'    X           X
'
'Piece 6
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    O           O           X           O
'Y O O O Y   Y Y O O Y   Y O O O Y   Y O O Y Y
'    X           O           O           O
'    X           X           X           X
'
'Piece 7
'  Pos 1
'    X
'    O O
'Y Y O O Y
'    X
'    X
Dim I
'Record what the board looks like before the piece is moved
OldBoard = Board
'Determines what piece is currently moving and what
'position it is in.  This tells it where to look for things
'that are in its way.  Provided nothing is there it moves
'to the left.
Select Case Board.CurPiece
    Case 1
        If Board.PiecePos = 1 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 1
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY + 2) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 2
                        Board.Square(Board.PieceX, I) = 0
                        Board.Square(Board.PieceX - 1, I) = 1
                    Next
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        End If
    Case 2
        If Board.PiecePos = 1 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 2
                    Board.Square(Board.PieceX - 2, Board.PieceY - 1) = 2
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX - 1, I) = 2
                        If I <> Board.PieceY - 1 Then Board.Square(Board.PieceX, I) = 0
                    Next
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 2
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 2
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 2, Board.PieceY + 1) = 2
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX, I) = 0
                        If I <> Board.PieceY + 1 Then Board.Square(Board.PieceX - 1, I) = 2
                    Next
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        End If
    Case 3
        If Board.PiecePos = 1 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 3
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 3
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX - 1, I) = 3
                        If I <> Board.PieceY + 1 Then Board.Square(Board.PieceX, I) = 0
                    Next
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 3
                    Board.Square(Board.PieceX - 2, Board.PieceY + 1) = 3
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 2, Board.PieceY - 1) = 3
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX, I) = 0
                        If I <> Board.PieceY - 1 Then Board.Square(Board.PieceX - 1, I) = 3
                    Next
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        End If
    Case 4
        If Board.PiecePos = 1 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 4
                    Board.Square(Board.PieceX - 2, Board.PieceY - 1) = 4
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 4
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 4
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 4
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        End If
    Case 5
        If Board.PiecePos = 1 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 5
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 5
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 5
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 5
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 5
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        End If
    Case 6
        If Board.PiecePos = 1 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 6
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 6
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
               If Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        If I <> Board.PieceY Then Board.Square(Board.PieceX, I) = 0
                        Board.Square(Board.PieceX - 1, I) = 6
                    Next
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceX >= 3 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 6
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 6
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX >= 3 Then
                 If Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 2, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX, I) = 0
                        If I <> Board.PieceY Then Board.Square(Board.PieceX - 1, I) = 6
                    Next
                    Board.Square(Board.PieceX - 2, Board.PieceY) = 6
                    Board.PieceX = Board.PieceX - 1
                End If
            End If
        End If
    Case 7
        If Board.PieceX >= 2 Then
            If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                Board.Square(Board.PieceX - 1, Board.PieceY) = 7
                Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 7
                Board.PieceX = Board.PieceX - 1
            End If
        End If
End Select
'Draw the board
DrawBoard

End Sub

Sub MovePieceRight()
'-------------------------------------------------------
'Moves the piece to the right provided that nothing is
'in the way
'-------------------------------------------------------
'Piece 1
'  Pos 1       Pos 2
'    X           X
'    X           O
'Y O O O O   Y Y O Y Y
'    X           O
'    X           O
'
'Piece 2
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'  O X           O O         X           O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O           X O       O O
'    X           X           X           X
'
'Piece 3
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    X O         O           X         O O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O O       O X           O
'    X           X           X           X
'
'Piece 4
'  Pos 1       Pos 2
'    X           X
'  O O           X O
'Y Y O O Y   Y Y O O Y
'    X           O
'    X           X
'
'Piece 5
'  Pos 1       Pos 2
'    X           X
'    O O         O
'Y O O Y Y   Y Y O O Y
'    X           X O
'    X           X
'
'Piece 6
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    O           O           X           O
'Y O O O Y   Y Y O O Y   Y O O O Y   Y O O Y Y
'    X           O           O           O
'    X           X           X           X
'
'Piece 7
'  Pos 1
'    X
'    O O
'Y Y O O Y
'    X
'    X
Dim I
'Record what the board looks like before the piece is moved
OldBoard = Board
'Determines what piece is currently moving and what
'position it is in.  This tells it where to look for things
'that are in its way.  Provided nothing is there it moves
'to the right.
Select Case Board.CurPiece
    Case 1
        If Board.PiecePos = 1 Then
            If Board.PieceX <= 7 Then
                If Board.Square(Board.PieceX + 3, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 3, Board.PieceY) = 1
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 2) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 2
                        Board.Square(Board.PieceX, I) = 0
                        Board.Square(Board.PieceX + 1, I) = 1
                    Next
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        End If
    Case 2
        If Board.PiecePos = 1 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 2
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 2
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX, I) = 0
                        If I <> Board.PieceY - 1 Then Board.Square(Board.PieceX + 1, I) = 2
                    Next
                    Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 2
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 2
                    Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 2
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        If I <> Board.PieceY + 1 Then Board.Square(Board.PieceX, I) = 0
                        Board.Square(Board.PieceX + 1, I) = 2
                    Next
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        End If
    Case 3
        If Board.PiecePos = 1 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 3
                    Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 3
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX, I) = 0
                        If I <> Board.PieceY + 1 Then Board.Square(Board.PieceX + 1, I) = 3
                    Next
                    Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 3
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 3
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 3
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        If I <> Board.PieceY - 1 Then Board.Square(Board.PieceX, I) = 0
                        Board.Square(Board.PieceX + 1, I) = 3
                    Next
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        End If
    Case 4
        If Board.PiecePos = 1 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 4
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 4
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 4
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 4
                    Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 4
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        End If
    Case 5
        If Board.PiecePos = 1 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 5
                    Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 5
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 5
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 5
                    Board.Square(Board.PieceX + 2, Board.PieceY + 1) = 5
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        End If
    Case 6
        If Board.PiecePos = 1 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 6
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 6
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 Then
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        Board.Square(Board.PieceX, I) = 0
                        If I <> Board.PieceY Then Board.Square(Board.PieceX + 1, I) = 6
                    Next
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 6
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceX <= 8 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 6
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 6
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    For I = Board.PieceY - 1 To Board.PieceY + 1
                        If I <> Board.PieceY Then Board.Square(Board.PieceX, I) = 0
                        Board.Square(Board.PieceX + 1, I) = 6
                    Next
                    Board.PieceX = Board.PieceX + 1
                End If
            End If
        End If
    Case 7
        If Board.PieceX <= 8 Then
            If Board.Square(Board.PieceX + 2, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 0 Then
                Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                Board.Square(Board.PieceX, Board.PieceY) = 0
                Board.Square(Board.PieceX + 2, Board.PieceY) = 7
                Board.Square(Board.PieceX + 2, Board.PieceY - 1) = 7
                Board.PieceX = Board.PieceX + 1
            End If
        End If
End Select
'Draw the board
DrawBoard

End Sub

Sub NewGame()
'-------------------------------------------------------
'Initializes all variables to their starting values and
'then starts the game
'-------------------------------------------------------
Dim I, J, RndNum
Randomize
'Record what the board looks like so it can be cleared if
'a game was just played
OldBoard = Board
For I = 1 To 10
    For J = 1 To 18
        'Clear the board
        Board.Square(I, J) = 0
    Next
Next

'Get the hDc values of the squares
frmPics.Tetris0.AutoRedraw = True
Board.PieceDC(0) = frmPics.Tetris0.hDC
frmPics.Tetris0.AutoRedraw = False
frmPics.Tetris1.AutoRedraw = True
Board.PieceDC(1) = frmPics.Tetris1.hDC
frmPics.Tetris1.AutoRedraw = False
frmPics.Tetris2.AutoRedraw = True
Board.PieceDC(2) = frmPics.Tetris2.hDC
frmPics.Tetris2.AutoRedraw = False
frmPics.Tetris3.AutoRedraw = True
Board.PieceDC(3) = frmPics.Tetris3.hDC
frmPics.Tetris3.AutoRedraw = False
frmPics.Tetris4.AutoRedraw = True
Board.PieceDC(4) = frmPics.Tetris4.hDC
frmPics.Tetris4.AutoRedraw = False
frmPics.Tetris5.AutoRedraw = True
Board.PieceDC(5) = frmPics.Tetris5.hDC
frmPics.Tetris5.AutoRedraw = False
frmPics.Tetris6.AutoRedraw = True
Board.PieceDC(6) = frmPics.Tetris6.hDC
frmPics.Tetris6.AutoRedraw = False
frmPics.Tetris7.AutoRedraw = True
Board.PieceDC(7) = frmPics.Tetris7.hDC
frmPics.Tetris7.AutoRedraw = False
'Get the hDc values of the boards
Board.BoardDC = frmVBtris.picBoard.hDC
Board.B2DC = frmVBtris.picBoard2.hDC
'Clear all variables
Board.Rows = 0
Board.CurPiece = 0
Board.NextPiece = 0
Board.Score = 0
Board.Level = StartingLevel
Board.PiecePos = 0
Board.PieceX = 0
Board.PieceY = 0
'Tell it a game is now going on
Board.Game = True
'Tell it no pieces are falling rapidly
FallPiece = False
'Tell it the game is not paused
PauseTheGame = False
'Clear the labels on frmVBtris
frmVBtris.lblScore = 0
frmVBtris.lblLines = 0
frmVBtris.lblLevel = StartingLevel
'Initialize the pause length
PL = 0.5 - (0.0472 * StartingLevel)
FallY = 0
'Fill in lines if the option is set
If FillLines Then
    For I = 1 To 10
        For J = 1 To 18
            If J >= 10 Then
                RndNum = Int(Rnd * 30)
                If RndNum <= StartingLevel Then
                    Board.Square(I, J) = Int(Rnd * 7) + 1
                    DrawBoard
                    OldBoard = Board
                End If
            End If
        Next
    Next
End If
'Draw the Board
DrawBoard
'Initialize OldBoard
OldBoard = Board
'Start the game
VBtris32

End Sub

Sub Pause(LenOfTime As Variant)
'-------------------------------------------------------
'Pause for LenOfTime seconds or until the game is
'unpaused if it is paused.  Also, redraw the board if
'the form has been restored after being minimized
'-------------------------------------------------------
Dim X As Variant, OldWinState, Temp, T As Long
If FallPiece Then Exit Sub
X = Timer
OldWinState = frmVBtris.WindowState
Do While ((Timer - X < LenOfTime) And (Timer >= X)) Or (PauseTheGame)
    If PlaySounds And Timer - MIDITime >= 150 Or Timer - MIDITime < 0 Then
        If InStr(App.Path, " ") Then
            T = mciSendString("play " & Chr(34) & App.Path & "\" & MUSIC & Chr(34), 0&, 0, 0)
        Else
            T = mciSendString("play " & App.Path & "\" & MUSIC, 0&, 0, 0)
        End If
        MIDITime = Timer
    End If
    'This is here to prevent a delay from when the player
    'pushes down and when the piece begins to fall rapidly
    If FallPiece Or GameOver Then Exit Sub
    If PauseTheGame Then
        'Make sure the caption of the form says
        '" - Paused" if the game is paused
        If frmVBtris.Caption <> "VBtris32 - Paused" Then
            frmVBtris.Caption = "VBtris32 - Paused"
        End If
        If frmVBtris.WindowState <> OldWinState Then
            'Draw the hidden board onto the visible board
            Temp = BitBlt(Board.BoardDC, 0, 0, 160, 288, Board.B2DC, 0, 0, SRCCOPY)
        End If
        OldWinState = frmVBtris.WindowState
    End If
    DoEvents
Loop
'Change the caption back if it says " - Paused"
If frmVBtris.Caption = "VBtris32 - Paused" Then
    frmVBtris.Caption = "VBtris32"
End If
End Sub

Sub PlayWAV(WAVtoPlay As String)
'-------------------------------------------------------
'Plays the wav specified by WAVtoPlay if PlaySounds is
'true
'-------------------------------------------------------
'Prevent errors in case the WAVs aren't there
On Error Resume Next
Dim Temp
Const SYNC = 1
If PlaySounds Then
    Temp = sndPlaySound(App.Path & "\" & WAVtoPlay, SYNC)
End If

End Sub

Sub ReadINIFile()
'-------------------------------------------------------
'Reads the game options in from the INI file and creates
'an INI file if one doesn't exist
'-------------------------------------------------------
Dim AppName As String, CurSection As String
Dim SectionVal As String, FileName As String
Dim Temp
'Info needed to find the file and where in it to look
AppName = "VBtris32"
FileName = "VBtris32.ini"

'Read in the value for StartingLevel
CurSection = "Starting Level"
SectionVal = Space(1)
Temp = GetPrivateProfileString(AppName, CurSection, "", SectionVal, 2, FileName)
If SectionVal = " " Then
    GenerateINIFile
    StartingLevel = 0
Else
    StartingLevel = Val(SectionVal)
End If

'Read in the value for FillLines
CurSection = "Fill Lines"
SectionVal = Space(1)
Temp = GetPrivateProfileString(AppName, CurSection, "", SectionVal, 2, FileName)
If SectionVal = "T" Then
    FillLines = True
Else
    FillLines = False
End If

'Read in the value for PlaySounds
CurSection = "Play Sounds"
SectionVal = Space(1)
Temp = GetPrivateProfileString(AppName, CurSection, "", SectionVal, 2, FileName)
If SectionVal = "T" Then
    PlaySounds = True
Else
    PlaySounds = False
End If

'Read in the value for HideSplash
CurSection = "Hide Splash"
SectionVal = Space(1)
Temp = GetPrivateProfileString(AppName, CurSection, "", SectionVal, 2, FileName)
If SectionVal = "T" Then
    HideSplash = True
Else
    HideSplash = False
End If

End Sub
Sub RotatePiece()
'-------------------------------------------------------
'Causes the user to see the piece rotate by changing the
'variable Board.PiecePos
'-------------------------------------------------------
'Piece 1
'  Pos 1       Pos 2
'    X           X
'    X           O
'Y O O O O   Y Y O Y Y
'    X           O
'    X           O
'
'Piece 2
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'  O X           O O         X           O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O           X O       O O
'    X           X           X           X
'
'Piece 3
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    X O         O           X         O O
'Y O O O Y   Y Y O Y Y   Y O O O Y   Y Y O Y Y
'    X           O O       O X           O
'    X           X           X           X
'
'Piece 4
'  Pos 1       Pos 2
'    X           X
'  O O           X O
'Y Y O O Y   Y Y O O Y
'    X           O
'    X           X
'
'Piece 5
'  Pos 1       Pos 2
'    X           X
'    O O         O
'Y O O Y Y   Y Y O O Y
'    X           X O
'    X           X
'
'Piece 6
'  Pos 1       Pos 2       Pos 3       Pos 4
'    X           X           X           X
'    O           O           X           O
'Y O O O Y   Y Y O O Y   Y O O O Y   Y O O Y Y
'    X           O           O           O
'    X           X           X           X
'
'Piece 7
'  Pos 1
'    X
'    O O
'Y Y O O Y
'    X
'    X
Dim I
'Records what the board looks like before the piece is
'rotated, if it is
OldBoard = Board
'Determines what position the piece is currently in.  This
'tells it what position to move it to.  It then checks to
'make sure the spaces it will occupy are empty.  If they
'are, the piece is rotated
Select Case Board.CurPiece
    Case 1
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 16 And Board.PieceY > 1 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 2) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 1
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 1
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 1
                    Board.PiecePos = 2
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX <= 8 And Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 2, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 1
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 1
                    Board.Square(Board.PieceX + 2, Board.PieceY) = 1
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 2) = 0
                    Board.PiecePos = 1
                End If
            End If
        End If
    Case 2
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 2
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 2
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 2
                    Board.PiecePos = 2
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 2
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 2
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 2
                    Board.PiecePos = 3
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceY >= 2 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 2
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 2
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 2
                    Board.PiecePos = 4
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 2
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 2
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 2
                    Board.PiecePos = 1
                End If
            End If
        End If
    Case 3
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 3
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 3
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 3
                    Board.PiecePos = 2
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 3
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 3
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 3
                    Board.PiecePos = 3
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceY >= 2 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 3
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 3
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 3
                    Board.PiecePos = 4
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 3
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 3
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 3
                    Board.PiecePos = 1
                End If
            End If
        End If
    Case 4
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX, Board.PieceY + 1) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 4
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 4
                    Board.PiecePos = 2
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY - 1) = 4
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 4
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.PiecePos = 1
                End If
            End If
        End If
    Case 5
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY) = 0 And Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 5
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 5
                    Board.PiecePos = 2
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 0 And Board.Square(Board.PieceX - 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 5
                    Board.Square(Board.PieceX + 1, Board.PieceY - 1) = 5
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY + 1) = 0
                    Board.PiecePos = 1
                End If
            End If
        End If
    Case 6
        If Board.PiecePos = 1 Then
            If Board.PieceY <= 17 Then
                If Board.Square(Board.PieceX, Board.PieceY + 1) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 6
                    Board.PiecePos = 2
                End If
            End If
        ElseIf Board.PiecePos = 2 Then
            If Board.PieceX >= 2 Then
                If Board.Square(Board.PieceX - 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX - 1, Board.PieceY) = 6
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 0
                    Board.PiecePos = 3
                End If
            End If
        ElseIf Board.PiecePos = 3 Then
            If Board.PieceY >= 2 Then
                If Board.Square(Board.PieceX, Board.PieceY - 1) = 0 Then
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 0
                    Board.Square(Board.PieceX, Board.PieceY - 1) = 6
                    Board.PiecePos = 4
                End If
            End If
        ElseIf Board.PiecePos = 4 Then
            If Board.PieceX <= 9 Then
                If Board.Square(Board.PieceX + 1, Board.PieceY) = 0 Then
                    Board.Square(Board.PieceX, Board.PieceY + 1) = 0
                    Board.Square(Board.PieceX + 1, Board.PieceY) = 6
                    Board.PiecePos = 1
                End If
            End If
        End If
End Select
'Draw the board
DrawBoard

End Sub

Sub VBtris32()
'-------------------------------------------------------
'The actual game.  This goes through and puts in new
'pieces as necessary, displays the score, lines cleared,
'and the level on, moves the pieces down, creates the
'delay between downward movements, and ends the game
'when necessary
'-------------------------------------------------------
Dim Temp As Long
'Temp = mciSendString("play " & App.Path & "\" & MUSIC, 0&, 0, 0)
If PlaySounds Then
    If InStr(App.Path, " ") Then
        Temp = mciSendString("open " & Chr(34) & App.Path & "\" & MUSIC & Chr(34), 0&, 0, 0)
        Temp = mciSendString("play " & Chr(34) & App.Path & "\" & MUSIC & Chr(34), 0&, 0, 0)
    Else
        Temp = mciSendString("open " & App.Path & "\" & MUSIC, 0&, 0, 0)
        Temp = mciSendString("play " & App.Path & "\" & MUSIC, 0&, 0, 0)
    End If
    MIDITime = Timer
End If
DoEvents
Randomize
'Initialize GameOver
GameOver = False
'Get the first piece and determine what that will be
NewPiece = True
Board.NextPiece = Int(Rnd * 7) + 1
Do
    'Record what the board looks like
    OldBoard = Board
    If NewPiece = True Then
        'Make the current piece what the nextpiece was and
        'get a new nextpiece
        Board.CurPiece = Board.NextPiece
        Board.NextPiece = Int(Rnd * 7) + 1
        'Set the coordinates of the piece
        Board.PieceX = 5
        If Board.CurPiece <> 1 Then
            Board.PieceY = 2
        Else
            Board.PieceY = 1
        End If
        Board.PiecePos = 1
        'Put the piece on the board
        DrawPiece
        'Display the next piece in the next piece box
        '(frmVBtris.picNext)
        frmVBtris.picNext = frmPics.Next(Board.NextPiece)
        NewPiece = False
    Else
        'Move the piece down
        MovePieceDown
    End If
    'Draw the board
    DrawBoard
    If NewPiece Then
        'Check to see if any rows were filled with the last
        'piece
        CheckForRows
        'Update the labels
        frmVBtris.lblScore = Board.Score
        frmVBtris.lblLevel = Board.Level
        frmVBtris.lblLines = Board.Rows
    End If
    If FallPiece Then
        If NewPiece = True Then
            'Stop the accelerated falling
            FallPiece = False
            If FallY <> 0 Then
                'Award points for each row the piece fell
                'while accelerated
                Board.Score = Board.Score + (Board.PieceY - FallY)
                'Update the score label
                frmVBtris.lblScore = Board.Score
                FallY = 0
            End If
        End If
    Else
        'Wait for the next trip through
        Pause PL
    End If
Loop Until GameOver = True
'Tell it a game is no longer in progress
Board.Game = False
If PlaySounds Then
    If InStr(App.Path, " ") Then
        Temp = mciSendString("close " & Chr(34) & App.Path & "\" & MUSIC & Chr(34), 0&, 0, 0)
    Else
        Temp = mciSendString("close " & App.Path & "\" & MUSIC, 0&, 0, 0)
    End If
End If
MsgBox "Game Over", , "VBtris32"
'Check to see if the player received a high score
CheckForHighScore
'Reset the menus
frmVBtris.mnuNewGame.Enabled = True
frmVBtris.mnuEndGame.Enabled = False
frmVBtris.mnuHighScore.Enabled = True
frmVBtris.mnuPause.Enabled = False

End Sub


Sub WriteINIFile()
'-------------------------------------------------------
'Writes the game options to the INI file
'-------------------------------------------------------
'Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Dim AppName As String, CurSection As String
Dim SectionVal As String, FileName As String
Dim Temp
'Info needed to find the file and where in it to look
AppName = "VBtris32"
FileName = "VBtris32.ini"

'Read in the value for StartingLevel
CurSection = "Starting Level"
SectionVal = StartingLevel
Temp = WritePrivateProfileString(AppName, CurSection, SectionVal, FileName)

'Read in the value for FillLines
CurSection = "Fill Lines"
SectionVal = FillLines
Temp = WritePrivateProfileString(AppName, CurSection, SectionVal, FileName)

'Read in the value for PlaySounds
CurSection = "Play Sounds"
SectionVal = PlaySounds
Temp = WritePrivateProfileString(AppName, CurSection, SectionVal, FileName)

'Read in the value for HideSplash
CurSection = "Hide Splash"
SectionVal = HideSplash
Temp = WritePrivateProfileString(AppName, CurSection, SectionVal, FileName)

End Sub

Sub WriteScores()
'-------------------------------------------------------
'Writes the high score list to a file
'-------------------------------------------------------
Dim ScoreText As String, I
ScoreText = ""
'Open the file
Open App.Path & "\scores.lst" For Binary As #1
For I = 1 To 5
    'Create the string containing the information
    ScoreText = ScoreText & CStr(ScoreN(I)) & ":" & CStr(Scores(I)) & Chr$(13) & Chr$(10)
Next
'Put the string into the file
Put 1, , ScoreText
'Close the file
Close #1

End Sub

