VERSION 5.00
Begin VB.UserControl TilePuzzle 
   AutoRedraw      =   -1  'True
   ClientHeight    =   2805
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2940
   ScaleHeight     =   187
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   196
   Begin VB.Timer timSolved 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   840
      Top             =   1200
   End
   Begin VB.Menu mnuContext 
      Caption         =   "mnuContext"
      Visible         =   0   'False
      Begin VB.Menu mnuAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "TilePuzzle"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

' Change to 1 for debugging.
#Const DEBUG_EVENTS = 0

' Error codes.
Public Enum tpuzErrors
    tpuzInvalidRows
    tpuzInvalidCols
    tpuzInvalidPicture
End Enum

'Default Property Values:
Private Const m_def_PictureURL = ""
Private Const m_def_Cols = 4
Private Const m_def_Rows = 4

'Property Variables:
Private m_PictureURL As String
Private m_Picture As Picture
Private m_Cols As Integer
Private m_Rows As Integer
Private m_LineColor As OLE_COLOR
Private m_LineWidth As Integer

'Event Declarations:
Event PictureLoaded()
Event Moved()
Event Solved()
Event Speak(txt As Variant)

Private SquareHgt As Integer
Private SquareWid As Integer
Private FromC() As Integer
Private FromR() As Integer
Private EmptyR As Integer
Private EmptyC As Integer
Private PuzzleIsSolved As Boolean
Private Flashes As Integer
' Return true if the user solved the puzzle.
Private Function PuzzleSolved() As Boolean
Dim r As Integer
Dim c As Integer

    PuzzleSolved = False
    For r = 1 To Rows
        For c = 1 To Cols
            If FromR(r, c) > 0 Then
                If FromR(r, c) <> r Or _
                   FromC(r, c) <> c _
                        Then Exit Function
            End If
        Next c
    Next r

    ' The puzzle was solved. Flash the picture.
    Flashes = 0
    timSolved.Enabled = True

    PuzzleIsSolved = True
    PuzzleSolved = True
End Function
' Draw the puzzle in its current configuration.
Private Sub DrawPuzzle()
Dim r As Integer
Dim c As Integer
Dim x1 As Integer
Dim y1 As Integer
Dim x2 As Integer
Dim y2 As Integer

#If DEBUG_EVENTS = 1 Then
    RaiseEvent Speak("DrawPuzzle")
    Debug.Print "DrawPuzzle"
#End If

    Cls
    If Rows < 1 Then Exit Sub
    If Cols < 1 Then Exit Sub
    If m_Picture Is Nothing Then Exit Sub
    
    If PuzzleIsSolved Then
        ' Draw the whole picture.
        PaintPicture m_Picture, _
            0, 0, _
            m_Picture.Width, m_Picture.Height, _
            0, 0, _
            m_Picture.Width, m_Picture.Height, _
            vbSrcCopy
    Else
        ' Draw the puzzle pieces.
        y1 = 0
        For r = 1 To Rows
            x1 = 0
            For c = 1 To Cols
                If FromR(r, c) > 0 Then
                    y2 = SquareHgt * (FromR(r, c) - 1)
                    x2 = SquareWid * (FromC(r, c) - 1)
                    PaintPicture m_Picture, _
                        x1, y1, SquareWid, SquareHgt, _
                        x2, y2, SquareWid, SquareHgt, vbSrcCopy
                End If
                x1 = x1 + SquareWid
            Next c
            y1 = y1 + SquareHgt
        Next r
        
        ' Draw the lines between the pieces.
        x2 = Width
        For r = 1 To Rows - 1
            Line (0, r * SquareHgt)-Step(x2, 0)
        Next r
        y2 = Height
        For c = 1 To Cols - 1
            Line (c * SquareWid, 0)-Step(0, y2)
        Next c
    End If
End Sub

Public Property Get Picture() As Picture
Attribute Picture.VB_Description = "Returns/sets a graphic to be displayed in a control."
    Set Picture = m_Picture
End Property

Public Property Set Picture(ByVal New_Picture As Picture)
    Set m_Picture = New_Picture
    PropertyChanged "Picture"
    
    m_PictureURL = ""
    PropertyChanged "PictureURL"
    
    DrawAtDesignTime
End Property

' Prepare the puzzle.
Public Sub Randomize()
Dim r As Integer
Dim c As Integer
Dim wid As Integer
Dim hgt As Integer
Dim direction As Integer
Dim new_r As Integer
Dim new_c As Integer
Dim trials As Integer
Dim disallow As Integer

    If Rows < 1 Then _
        Err.Raise tpuzInvalidRows, _
            "TilePuzzle", _
            "Invalid number of rows."
    If Cols < 1 Then _
        Err.Raise tpuzInvalidCols, _
            "TilePuzzle", _
            "Invalid number of columns."
    If m_Picture Is Nothing Then _
        Err.Raise tpuzInvalidPicture, _
            "TilePuzzle", _
            "Invalid picture."

#If DEBUG_EVENTS = 1 Then
    RaiseEvent Speak("Randomize")
    Debug.Print "Randomize"
#End If
    
    ' Make the UserControl the same size as
    ' the picture.
    wid = ScaleX(m_Picture.Width, vbHimetric, vbPixels)
    hgt = ScaleY(m_Picture.Height, vbHimetric, vbPixels)
    SquareHgt = hgt \ Rows
    SquareWid = wid \ Cols
    hgt = SquareHgt * Rows
    wid = SquareWid * Cols
    Size ScaleX(wid, vbPixels, vbTwips), _
         ScaleX(hgt, vbPixels, vbTwips)

    ' Initialize the arrangement array.
    ReDim FromR(1 To Rows, 1 To Cols)
    ReDim FromC(1 To Rows, 1 To Cols)
    For r = 1 To Rows
        For c = 1 To Cols
            FromR(r, c) = r
            FromC(r, c) = c
        Next c
    Next r
    
    ' Pick a random tile to remove.
    VBA.Randomize
    EmptyR = Int(Rnd * Rows) + 1
    EmptyC = Int(Rnd * Cols) + 1
    FromR(EmptyR, EmptyC) = 0
    FromC(EmptyR, EmptyC) = 0

    ' Randomly move the empty position around.
    disallow = -1
    trials = (Rows * Cols) ^ 2
    Do While trials > 0
        new_r = EmptyR
        new_c = EmptyC
        
        direction = Int(Rnd * 4)
        If direction <> disallow Then
            Select Case direction
                Case 0
                    If new_r > 1 Then
                        new_r = new_r - 1
                        disallow = 1
                    End If
                Case 1
                    If new_r < Rows Then
                        new_r = new_r + 1
                        disallow = 0
                    End If
                Case 2
                    If new_c > 1 Then
                        new_c = new_c - 1
                        disallow = 3
                    End If
                Case 3
                    If new_c < Cols Then
                        new_c = new_c + 1
                        disallow = 2
                    End If
            End Select
            If new_r <> EmptyR Or new_c <> EmptyC _
            Then
                FromR(EmptyR, EmptyC) = FromR(new_r, new_c)
                FromC(EmptyR, EmptyC) = FromC(new_r, new_c)
                EmptyR = new_r
                EmptyC = new_c
                trials = trials - 1
            End If
        End If
    Loop
    
    FromR(EmptyR, EmptyC) = 0
    FromC(EmptyR, EmptyC) = 0
    
    PuzzleIsSolved = False
    DrawPuzzle
End Sub
Public Property Get Cols() As Integer
    Cols = m_Cols
End Property

Public Property Let Cols(ByVal New_Cols As Integer)
    If New_Cols < 1 Then Exit Property
    
    m_Cols = New_Cols
    PropertyChanged "Cols"
    DrawAtDesignTime
End Property
Public Property Get Rows() As Integer
    Rows = m_Rows
End Property

Public Property Let Rows(ByVal New_Rows As Integer)
    If New_Rows < 1 Then Exit Property
    
    m_Rows = New_Rows
    PropertyChanged "Rows"
    DrawAtDesignTime
End Property
' Prepare the picture for display unscrambled.
Private Sub DrawAtDesignTime()
Dim r As Integer
Dim c As Integer
Dim wid As Integer
Dim hgt As Integer
Dim direction As Integer
Dim new_r As Integer
Dim new_c As Integer

    If Ambient.UserMode Then Exit Sub
    If Rows < 1 Then Exit Sub
    If Cols < 1 Then Exit Sub
    If m_Picture Is Nothing Then Exit Sub

#If DEBUG_EVENTS = 1 Then
    RaiseEvent Speak("DrawAtDesignTime")
    Debug.Print "DrawAtDesignTime"
#End If

    ' Make the UserControl the same size as
    ' the picture.
    wid = ScaleX(m_Picture.Width, vbHimetric, vbPixels)
    hgt = ScaleY(m_Picture.Height, vbHimetric, vbPixels)
    SquareHgt = hgt \ Rows
    SquareWid = wid \ Cols
    hgt = SquareHgt * Rows
    wid = SquareWid * Cols
    Size ScaleX(wid, vbPixels, vbTwips), _
         ScaleX(hgt, vbPixels, vbTwips)

    ' Initialize the arrangement array.
    ReDim FromR(1 To Rows, 1 To Cols)
    ReDim FromC(1 To Rows, 1 To Cols)
    For r = 1 To Rows
        For c = 1 To Cols
            FromR(r, c) = r
            FromC(r, c) = c
        Next c
    Next r
    
    ' Draw the puzzle.
    DrawPuzzle
End Sub

' Show the about dialog.
Public Sub ShowAbout()
Attribute ShowAbout.VB_UserMemId = -552
    AboutForm.Show vbModal
End Sub

' Display the About dialog.
Private Sub mnuAbout_Click()
    AboutForm.Show vbModal
End Sub
' Flash the picture a few times.
Private Sub timSolved_Timer()
    If (Flashes Mod 2) = 0 Then
        DrawPuzzle
    Else
        Line (0, 0)-(ScaleWidth, ScaleHeight), _
            BackColor, BF
    End If

    Flashes = Flashes + 1
    If Flashes > 4 Then timSolved.Enabled = False
End Sub

' We finished reading a picture URL.
Private Sub UserControl_AsyncReadComplete(AsyncProp As AsyncProperty)
    On Error Resume Next
    Set Picture = AsyncProp.Value
    If Err.Number <> 0 Then Set Picture = Nothing

    RaiseEvent PictureLoaded
    DrawAtDesignTime
End Sub
'Initialize Properties for User Control
Private Sub UserControl_InitProperties()
    m_Cols = m_def_Cols
    m_Rows = m_def_Rows
    m_PictureURL = m_def_PictureURL
    Set m_Picture = LoadPicture("")
End Sub

' Move this tile into the hole of possible.
Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim r As Integer
Dim c As Integer

    ' If this is the right button, present the
    ' context menu.
    If Button = vbRightButton Then
        PopupMenu mnuContext
    Else
        ' See which tile was clicked.
        r = Y \ SquareHgt + 1
        c = X \ SquareWid + 1
        
        ' See if it's legal to move this tile.
        If ((Abs(r - EmptyR) = 1) And (c = EmptyC)) Or _
           ((Abs(c - EmptyC) = 1) And (r = EmptyR)) _
        Then
            ' Move the square.
            FromR(EmptyR, EmptyC) = FromR(r, c)
            FromC(EmptyR, EmptyC) = FromC(r, c)
            FromR(r, c) = 0
            FromC(r, c) = 0
            EmptyR = r
            EmptyC = c
            DrawPuzzle
            RaiseEvent Moved
            
            If PuzzleSolved Then RaiseEvent Solved
        End If
    End If
End Sub
'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    m_Cols = PropBag.ReadProperty("Cols", m_def_Cols)
    m_Rows = PropBag.ReadProperty("Rows", m_def_Rows)
    UserControl.ForeColor = PropBag.ReadProperty("LineColor", &H80000012)
    UserControl.DrawWidth = PropBag.ReadProperty("LineWidth", 1)
    PictureURL = PropBag.ReadProperty("PictureURL", m_def_PictureURL)
    Set Picture = PropBag.ReadProperty("Picture", Nothing)
End Sub
'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    Call PropBag.WriteProperty("Cols", m_Cols, m_def_Cols)
    Call PropBag.WriteProperty("Rows", m_Rows, m_def_Rows)
    Call PropBag.WriteProperty("LineColor", UserControl.ForeColor, &H80000012)
    Call PropBag.WriteProperty("LineWidth", UserControl.DrawWidth, 1)
    Call PropBag.WriteProperty("PictureURL", m_PictureURL, m_def_PictureURL)
    Call PropBag.WriteProperty("Picture", m_Picture, Nothing)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,ForeColor
Public Property Get LineColor() As OLE_COLOR
Attribute LineColor.VB_Description = "Returns/sets the foreground color used to display text and graphics in an object."
    LineColor = UserControl.ForeColor
End Property

Public Property Let LineColor(ByVal New_LineColor As OLE_COLOR)
    UserControl.ForeColor() = New_LineColor
    PropertyChanged "LineColor"
    DrawAtDesignTime
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,DrawWidth
Public Property Get LineWidth() As Integer
    LineWidth = UserControl.DrawWidth
End Property

Public Property Let LineWidth(ByVal New_LineWidth As Integer)
    UserControl.DrawWidth() = New_LineWidth
    PropertyChanged "LineWidth"
    DrawAtDesignTime
End Property

Public Property Get PictureURL() As String
    PictureURL = m_PictureURL
End Property

Public Property Let PictureURL(ByVal New_PictureURL As String)
    m_PictureURL = New_PictureURL
    PropertyChanged "PictureURL"
    
    If m_PictureURL = "" Then
        ' URL is "". Clear the picture.
        Set Picture = Nothing
    Else
        ' Load the URL.
        AsyncRead m_PictureURL, vbAsyncTypePicture
    End If
End Property
