VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Blue and Gray"
   ClientHeight    =   6030
   ClientLeft      =   960
   ClientTop       =   660
   ClientWidth     =   9000
   Height          =   6435
   Icon            =   BLUEGRAY.FRX:0000
   Left            =   900
   LinkTopic       =   "Form1"
   ScaleHeight     =   402
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   600
   Top             =   315
   Width           =   9120
   Begin PictureBox picInfo 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   495
      Left            =   6360
      ScaleHeight     =   495
      ScaleWidth      =   2295
      TabIndex        =   4
      Tag             =   "/3d_inset/"
      Top             =   480
      Width           =   2295
   End
   Begin CommandButton btnStart 
      Caption         =   "&New Game"
      Height          =   315
      Left            =   6180
      TabIndex        =   2
      Top             =   4920
      Width           =   2655
   End
   Begin PictureBox picField 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00808080&
      Height          =   3195
      Left            =   120
      Picture         =   BLUEGRAY.FRX:0302
      ScaleHeight     =   211
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   289
      TabIndex        =   0
      Tag             =   "/3d_inset/"
      Top             =   120
      Width           =   4365
      Begin Shape shpHilite 
         BackColor       =   &H00FFFFFF&
         BorderColor     =   &H00FFFFFF&
         BorderWidth     =   2
         Height          =   435
         Index           =   1
         Left            =   180
         Top             =   720
         Visible         =   0   'False
         Width           =   495
      End
      Begin Image imgDefense 
         Height          =   480
         Index           =   0
         Left            =   1800
         Top             =   720
         Visible         =   0   'False
         Width           =   480
      End
      Begin Image imgOffense 
         Height          =   480
         Index           =   0
         Left            =   1140
         Top             =   720
         Visible         =   0   'False
         Width           =   480
      End
      Begin Shape shpHilite 
         BackColor       =   &H00FFFFFF&
         BorderColor     =   &H000000FF&
         BorderWidth     =   2
         Height          =   435
         Index           =   0
         Left            =   180
         Top             =   180
         Visible         =   0   'False
         Width           =   495
      End
   End
   Begin Label lblPrompt 
      Alignment       =   2  'Center
      BackColor       =   &H0080FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Game Over"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000080&
      Height          =   315
      Left            =   6180
      TabIndex        =   9
      Tag             =   "/3d_raised/"
      Top             =   4500
      Width           =   2655
   End
   Begin Label Label5 
      BackStyle       =   0  'Transparent
      Caption         =   "Result:"
      Height          =   195
      Left            =   6360
      TabIndex        =   1
      Top             =   2760
      Width           =   1215
   End
   Begin Label lblResult 
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00FF0000&
      Height          =   1215
      Left            =   6360
      TabIndex        =   8
      Tag             =   "/3d_inset/"
      Top             =   3000
      Width           =   2295
   End
   Begin Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "Action:"
      Height          =   195
      Left            =   6360
      TabIndex        =   7
      Top             =   1140
      Width           =   1215
   End
   Begin Label lblAction 
      BackStyle       =   0  'Transparent
      ForeColor       =   &H00FF0000&
      Height          =   1215
      Left            =   6360
      TabIndex        =   6
      Tag             =   "/3d_inset/"
      Top             =   1380
      Width           =   2295
   End
   Begin Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Game Piece:"
      Height          =   195
      Left            =   6360
      TabIndex        =   5
      Top             =   240
      Width           =   1815
   End
   Begin Label lbl3DFrame1 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Height          =   4275
      Left            =   6180
      TabIndex        =   3
      Tag             =   "/3d_inset/"
      Top             =   120
      Width           =   2655
   End
End
Option Explicit
'----------------------------------------------------------------------
' CW.FRM
'----------------------------------------------------------------------

Function Attack (Attacker As tPiece, Defender As tPiece) As Integer
'----------------------------------------------------------------------
' One player attacks another.  This routine is used by both sides to
' determine the outcome of an attack by one piece against another.
'----------------------------------------------------------------------
Dim OldStrength As Integer
Dim Distance As Double
Dim i As Integer
Dim AppPath As String
Dim SoundFile As String
Dim rc As Integer

    AppPath = App.Path
    If Right$(AppPath, 1) <> "\" Then AppPath = AppPath & "\"

    OldStrength = Defender.strength
    Describe Attacker, Defender
    Select Case Attacker.type
        Case INFANTRY:
            Select Case Defender.type
                Case INFANTRY:
                    Defender.strength = Defender.strength - 1
                Case ARTILLERY, CAVALRY:
                    If (Attacker.strength > Defender.strength) Then
                        Defender.strength = Defender.strength - 1
                    End If
            End Select
            SoundFile = "GUNFIRE.WAV"
        Case ARTILLERY:
            Distance = GetDistance(Attacker, Defender)
            If Distance <= (Attacker.strength * 2) Then
                Defender.strength = Defender.strength - 1
            End If
            SoundFile = "CANNON.WAV"
        Case CAVALRY:
            Select Case Defender.type
                Case INFANTRY:
                    Defender.strength = Defender.strength - 2
                Case ARTILLERY, CAVALRY:
                    Defender.strength = Defender.strength - 1
            End Select
            SoundFile = "GALLOP.WAV"
        Case SPY:
            SoundFile = "THUNDER.WAV"
    End Select

    ' Give the spy a chance...
    If Defender.type = SPY Then
        If (Rnd * 15) = 3 Then
            Defender.strength = 0
        End If
    ' The player got the flag!
    ElseIf (Defender.type = FLAG) And (Attacker.type <> SPY) Then
        gGameState = GAME_OVER
        lblPrompt = "Game Over"

    End If

    If (SoundFile <> "") Then rc = sndPlaySound(AppPath & SoundFile, SND_ASYNC)

    If Attacker.side = OFFENSE Then
        lblResult.ForeColor = BLUE
    Else
        lblResult.ForeColor = RED
    End If

    ' Describe the results of the attack in the lblResult label.
    lblResult = gSideName(Defender.side) & " "
    lblResult = lblResult & gPieceName(Defender.type)
    If Defender.strength <= 0 Then
        Defender.strength = 0
        Attack = True
        lblResult = lblResult & " defeated."
    ElseIf OldStrength > Defender.strength Then
        Attack = False
        lblResult = lblResult & " sustains casualties."
    Else
        Attack = False
        If Attacker.type = SPY Then
            lblResult = gSideName(Attacker.side) & " Spy observes that enemy "
            lblResult = lblResult & gPieceName(Defender.type) & " strength is "
            lblResult = lblResult & gStrengthName(Defender.strength) & "."
        Else
            If Attacker.type = ARTILLERY Then
                lblResult = gSideName(Attacker.side) & " Artillery missed the target. " & lblResult
            End If
            lblResult = lblResult & " holds fast against enemy " & gPieceName(Attacker.type)
        End If
    End If

    ' Blink the attacker and attacked pieces.
    For i = 1 To 5
        Highlight 1, Defender.row, Defender.col, True
        Highlight 0, Attacker.row, Attacker.col, True
        Pause .25
        Highlight 1, Defender.row, Defender.col, False
        Highlight 0, Attacker.row, Attacker.col, False
        Pause .25
    Next
End Function

Sub btnStart_Click ()
'----------------------------------------------------------------------
' Start a new game.
'----------------------------------------------------------------------
    
    SetupOffense
    SetupDefense
    gGameState = SELECT_PIECE
    lblPrompt = "Select a Piece to Move"
    Me.Show
End Sub

Sub DefenseMove ()
'----------------------------------------------------------------------
' Defense Counter-attacks.  The computer plays defense, so we must
' try to make the computer relatively intelligent.
'----------------------------------------------------------------------
Dim i As Integer
Dim r As Integer
Dim c As Integer
Dim side As Integer
Dim element As Integer
Dim Defeated As Integer
Dim WorkingArtillery As Integer
Dim NearestTarget As Integer
Dim NearestDistance As Double
Dim Distance As Double

    element = -1
    gGameState = DEFENSE_MOVE
    lblPrompt = "Defense Counter-Attacks"

    ' Look for enemy adjacent to us.
    For i = 1 To gLastDefense
        r = gDefense(i).row
        c = gDefense(i).col
        If imgDefense(i).Visible Then
            ' N
            If WhatPieceHere(side, element, r - 1, c) = OFFENSE Then
            ' NE
            ElseIf WhatPieceHere(side, element, r - 1, c + 1) = OFFENSE Then
            ' E
            ElseIf WhatPieceHere(side, element, r, c + 1) = OFFENSE Then
            ' SE
            ElseIf WhatPieceHere(side, element, r + 1, c + 1) = OFFENSE Then
            ' S
            ElseIf WhatPieceHere(side, element, r + 1, c) = OFFENSE Then
            ' SW
            ElseIf WhatPieceHere(side, element, r + 1, c - 1) = OFFENSE Then
            ' W
            ElseIf WhatPieceHere(side, element, r - 1, c) = OFFENSE Then
            ' NW
            ElseIf WhatPieceHere(side, element, r - 1, c - 1) = OFFENSE Then
            End If

            If side > 0 Then Exit For
        End If
    Next

    ' If someone is close by, attack him.
    If side > 0 Then
        Defeated = Attack(gDefense(i), gOffense(element))
        If Defeated Then
            imgOffense(element).Visible = False
            If Not (gDefense(i).type = ARTILLERY) Then
                MovePiece gDefense(i), i, gMouseRow, gMouseCol
            End If
        End If
    Else
        ' Look for target to shoot artillery at.
        WorkingArtillery = -1
        For i = 1 To gLastDefense
            If gDefense(i).type = ARTILLERY And imgDefense(i).Visible Then
                WorkingArtillery = i
                Exit For
            End If
        Next
        NearestDistance = 100
        If WorkingArtillery > 0 Then
            For i = 1 To gLastOffense
                If imgOffense(i).Visible Then
                    Distance = GetDistance(gDefense(WorkingArtillery), gOffense(i))
                    If Distance < NearestDistance Then
                        NearestDistance = Distance
                        NearestTarget = i
                    End If
                End If
            Next
            Defeated = Attack(gDefense(WorkingArtillery), gOffense(NearestTarget))
            If Defeated Then
                imgOffense(NearestTarget).Visible = False
            End If
        End If
    End If
End Sub

Sub Describe (Attacker As tPiece, Defender As tPiece)
'----------------------------------------------------------------------
' Describe (in the lblAction label) what action the attacker is taking.
'----------------------------------------------------------------------
Dim Desc As String
Dim ActionVerb As String

    Desc = ""
    
    If Attacker.type = SPY Then
        ActionVerb = "spies on"
    Else
        ActionVerb = "attacks"
    End If
    
    
    Desc = gSideName(Attacker.side)
    Desc = Desc & " " & gPieceName(Attacker.type)
    Desc = Desc & " (" & gStrengthName(Attacker.strength) & " strength) "
    Desc = Desc & ActionVerb & " "
    Desc = Desc & gSideName(Defender.side) & " "
    Desc = Desc & gPieceName(Defender.type) & " ("
    Desc = Desc & gStrengthName(Defender.strength) & " strength). "

    If Attacker.side = OFFENSE Then
        lblAction.ForeColor = BLUE
    Else
        lblAction.ForeColor = RED
    End If

    lblAction = Desc

End Sub

Sub DrawIcon (AnImage As Image, r As Integer, c As Integer)
'----------------------------------------------------------------------
' Move an icon (stored in an image control) to a row/column location.
'----------------------------------------------------------------------
    
    AnImage.Move c * P_WIDTH + 2, r * P_WIDTH + 2
End Sub

Sub Form_Load ()
'----------------------------------------------------------------------
' Set up the playing board and initialize variables used throughout
' the game.
'----------------------------------------------------------------------
Dim i As Integer
Dim TitleHeight As Integer
Dim BorderWidth As Integer

    Randomize

    ' Calculate the main form's dimensions
    Me.ScaleMode = TWIPS
    BorderWidth = (Me.Width - Me.ScaleWidth)
    TitleHeight = (Me.Height - Me.ScaleHeight - BorderWidth)
    Me.ScaleMode = PIXELS

    picField.Width = BOARD_DIM * P_WIDTH + 1
    picField.Height = picField.Width

    Me.Height = (picField.Height + (picField.Top * 2)) * Screen.TwipsPerPixelY + BorderWidth + TitleHeight

    ' Initialize the highlighting boxes
    shpHilite(0).Width = P_WIDTH + 2
    shpHilite(0).Height = P_WIDTH + 2
    shpHilite(0).ZOrder 0

    shpHilite(1).Width = P_WIDTH + 2
    shpHilite(1).Height = P_WIDTH + 2
    shpHilite(1).ZOrder 0

    ' Center the form on the screen.
    Me.Move (Screen.Width - Me.Width) / 2, (Screen.Height - Me.Height) / 2
    Me.Hide

    ' Set up the playing board.
    For i = 1 To BOARD_DIM - 1
        picField.Line (0, i * P_WIDTH)-(picField.ScaleWidth, i * P_WIDTH), RGB(0, 128, 0), BF
        picField.Line (i * P_WIDTH, 0)-(i * P_WIDTH, picField.ScaleHeight), RGB(0, 128, 0), BF
    Next

    gLastOffense = 0
    gLastDefense = 0

    ' Piece names used in descriptions.
    gPieceName(INFANTRY) = "Infantry"
    gPieceName(ARTILLERY) = "Artillery"
    gPieceName(CAVALRY) = "Cavalry"
    gPieceName(SPY) = "Spy"
    gPieceName(FLAG) = "Flag"

    ' Strength levels used in descriptions.
    gStrengthName(NONE) = "gone"
    gStrengthName(LOW) = "low"
    gStrengthName(MODERATE) = "moderate"
    gStrengthName(HIGH) = "high"

    ' Names of the sides used in descriptions.
    gSideName(OFFENSE) = "Offensive"
    gSideName(DEFENSE) = "Defensive"

    ' Prepare for the first game.
    btnStart_Click
End Sub

Sub Form_Paint ()
'----------------------------------------------------------------------
' Put a 3D border around any control tagged "/3D_INSET/" or "/3D_RAISED/.
'----------------------------------------------------------------------
Dim i As Integer

    For i = 0 To Me.Controls.Count - 1
        If UCase$(Me.Controls(i).Tag) = "/3D_RAISED/" Then
            Make3D Me, Me.Controls(i), BORDER_RAISED, 1
        ElseIf UCase$(Me.Controls(i).Tag) = "/3D_INSET/" Then
            Make3D Me, Me.Controls(i), BORDER_INSET, 1
        End If
    Next

End Sub

Function GetDistance (A As tPiece, B As tPiece) As Double
'----------------------------------------------------------------------
' Calculate the linear distance between two squares.
'----------------------------------------------------------------------
    
    GetDistance = Sqr((Abs(A.row - B.row) ^ 2) + (Abs(A.col - B.col) ^ 2))
End Function

Sub Highlight (index As Integer, r As Integer, c As Integer, OnOff As Integer)
'----------------------------------------------------------------------
' Turn on or off the highlight square.
'----------------------------------------------------------------------
    
    shpHilite(index).Visible = OnOff
    shpHilite(index).Move c * P_WIDTH, r * P_WIDTH
End Sub

Sub imgDefense_Click (index As Integer)
'----------------------------------------------------------------------
' Clicking on a defensive piece indicates an attack on that piece by
' the player (offense), if the game state is MOVE_PIECE. After the
' offensive move is completed, Defense counter-attacks.
'----------------------------------------------------------------------
Dim row As Integer
Dim col As Integer
Dim Defeated As Integer
Dim LegalMove As Integer

    If gGameState = MOVE_PIECE Then
        row = gOffense(gCurrentPiece).row
        col = gOffense(gCurrentPiece).col
        ' If it's a legal move.
        LegalMove = ((Abs(row - gMouseRow) <= 1) And (Abs(col - gMouseCol) <= 1))

        If LegalMove Or (gOffense(gCurrentPiece).type = ARTILLERY) Then
            Highlight 0, gMouseRow, gMouseCol, False
            gGameState = SELECT_PIECE
            lblPrompt = "Select a Piece to Move"

            ' Execute offensive moves
            Defeated = Attack(gOffense(gCurrentPiece), gDefense(index))
            If Defeated Then
                imgDefense(index).Visible = False
                If Not (gOffense(gCurrentPiece).type = ARTILLERY) Then
                    MovePiece gOffense(gCurrentPiece), gCurrentPiece, gDefense(index).row, gDefense(index).col
                End If
            End If
            
            If gGameState = GAME_OVER Then Exit Sub

            Pause 3
            
            ' Execute defensive moves
            DefenseMove
            gGameState = SELECT_PIECE
            lblPrompt = "Select a Piece to Move"
            
        End If
    End If

End Sub

Sub imgDefense_MouseMove (index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'----------------------------------------------------------------------
' Display the name of the Defensive piece when the mouse moves over it.
'----------------------------------------------------------------------
    
    gMouseRow = gDefense(index).row
    gMouseCol = gDefense(index).col

    picInfo.Cls
    picInfo.ForeColor = BLUE
    picInfo.Print "Defensive "; gPieceName(gDefense(index).type)

End Sub

Sub imgOffense_Click (index As Integer)
'----------------------------------------------------------------------
' If the game is in SELECT_PIECE or MOVE_PIECE state, clicking on an
' offensive piece has the effect of making it the currently selected
' piece.
'----------------------------------------------------------------------

    If (gGameState = SELECT_PIECE) Or (gGameState = MOVE_PIECE) Then
        Highlight 0, gMouseRow, gMouseCol, True
        gCurrentPiece = index
        gGameState = MOVE_PIECE
        lblPrompt = "Move Selected Piece"
    End If
End Sub

Sub imgOffense_MouseMove (index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'----------------------------------------------------------------------
' Give the player information about one of his pieces when the mouse
' is over it.
'----------------------------------------------------------------------
    
    gMouseRow = gOffense(index).row
    gMouseCol = gOffense(index).col

    picInfo.Cls
    picInfo.ForeColor = BLUE
    picInfo.Print "Offensive "; gPieceName(gOffense(index).type)

    picInfo.Print "Strength is ";
    Select Case gOffense(index).strength
        Case NONE: picInfo.ForeColor = BLACK
        Case LOW: picInfo.ForeColor = RED
        Case MODERATE: picInfo.ForeColor = YELLOW
        Case HIGH: picInfo.ForeColor = GREEN

    End Select
    picInfo.Print UCase$(gStrengthName(gOffense(index).strength))

End Sub

Sub InitPiece (PieceNum As Integer, ASide As Integer, AType As Integer, AStrength As Integer, ARow As Integer, ACol As Integer)
'----------------------------------------------------------------------
' Initialize a game piece's data structure in preparation for a new
' game.
'----------------------------------------------------------------------
Dim APiece As tPiece
Dim AppPath As String

    APiece.side = ASide
    APiece.type = AType
    APiece.strength = AStrength
    APiece.row = ARow
    APiece.col = ACol

    AppPath = App.Path
    If (Right$(AppPath, 1) <> "\") Then AppPath = AppPath & "\"

    If ASide = OFFENSE Then
        Load imgOffense(PieceNum)
        Select Case AType
            Case INFANTRY:
                imgOffense(PieceNum).Picture = LoadPicture(AppPath & "O_INFTRY.ICO")
            Case CAVALRY:
                imgOffense(PieceNum).Picture = LoadPicture(AppPath & "O_CAVLRY.ICO")
            Case ARTILLERY:
                imgOffense(PieceNum).Picture = LoadPicture(AppPath & "O_ARTLRY.ICO")
            'Case GENERAL:
            '    imgOffense(PieceNum).Picture = LoadPicture(AppPath & "O_GENRL.ICO")
            Case SPY:
                imgOffense(PieceNum).Picture = LoadPicture(AppPath & "O_SPY.ICO")
        End Select
        gOffense(PieceNum) = APiece
        DrawIcon imgOffense(PieceNum), ARow, ACol
        imgOffense(PieceNum).Visible = True
    ElseIf ASide = DEFENSE Then
        Load imgDefense(PieceNum)
        Select Case AType
            Case INFANTRY:
                imgDefense(PieceNum).Picture = LoadPicture(AppPath & "D_INFTRY.ICO")
            Case CAVALRY:
                imgDefense(PieceNum).Picture = LoadPicture(AppPath & "D_CAVLRY.ICO")
            Case ARTILLERY:
                imgDefense(PieceNum).Picture = LoadPicture(AppPath & "D_ARTLRY.ICO")
            'Case GENERAL:
            '    imgDefense(PieceNum).Picture = LoadPicture(AppPath & "D_GENRL.ICO")
            Case FLAG:
                imgDefense(PieceNum).Picture = LoadPicture(AppPath & "D_FLAG.ICO")
        End Select
        gDefense(PieceNum) = APiece
        DrawIcon imgDefense(PieceNum), ARow, ACol
        imgDefense(PieceNum).Visible = True
    End If
End Sub

Sub MovePiece (APiece As tPiece, Elem As Integer, row As Integer, col As Integer)
'----------------------------------------------------------------------
' Move a game piece to a specified row and column.
'----------------------------------------------------------------------
    
    APiece.row = row
    APiece.col = col
    If APiece.side = OFFENSE Then
        DrawIcon imgOffense(Elem), row, col
    Else
        DrawIcon imgDefense(Elem), row, col
    End If
End Sub

Sub Pause (Seconds As Single)
'----------------------------------------------------------------------
' Pause for a specified number of seconds.
'----------------------------------------------------------------------
Dim StartTime As Single
    
    StartTime = Timer

    Do
        DoEvents
    Loop Until (Timer - StartTime) >= Seconds
End Sub

Sub picField_Click ()
'----------------------------------------------------------------------
' If player is in process of moving a piece, clicking on an empty
' adjacent field will move the piece to that location.  This counts
' as a move, so defense will counter-attack afterwards.
'----------------------------------------------------------------------
Dim row As Integer
Dim col As Integer

    If gGameState = MOVE_PIECE Then
        gGameState = DEFENSE_MOVE
        row = gOffense(gCurrentPiece).row
        col = gOffense(gCurrentPiece).col

        ' If it's a legal move.
        If ((Abs(row - gMouseRow) <= 1) And (Abs(col - gMouseCol) <= 1)) Then
            Highlight 0, gMouseRow, gMouseCol, False
            MovePiece gOffense(gCurrentPiece), gCurrentPiece, gMouseRow, gMouseCol

            lblAction = "Offense moves " & gPieceName(gOffense(gCurrentPiece).type) & "."
            lblResult = ""
            Pause 1
            
            ' Execute defensive moves
            DefenseMove
            gGameState = SELECT_PIECE
            lblPrompt = "Select a Piece to Move"
        Else
            gGameState = MOVE_PIECE
            gMouseRow = gOffense(gCurrentPiece).row
            gMouseCol = gOffense(gCurrentPiece).col
        End If
    End If

End Sub

Sub picField_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
'----------------------------------------------------------------------
' Set the current board row and column, and clear any information
' displayed in picInfo.
'----------------------------------------------------------------------
Dim r As Integer, c As Integer

    XYtoRC X, Y, gMouseRow, gMouseCol
    picInfo.Cls
End Sub

Sub SetupDefense ()
'----------------------------------------------------------------------
' Set up the pieces used by the Defense.
'----------------------------------------------------------------------
Dim i As Integer
Dim MaxStrength As Integer

    For i = 1 To gLastDefense
        Unload imgDefense(i)
    Next
    
    gLastDefense = 1
    
    InitPiece gLastDefense, DEFENSE, FLAG, LOW, 0, 6
    
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, INFANTRY, NONE, 0, 4
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, INFANTRY, NONE, 0, 7
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, INFANTRY, NONE, 1, 4
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, INFANTRY, NONE, 1, 5
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, INFANTRY, NONE, 1, 6
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, INFANTRY, NONE, 1, 7
    
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, CAVALRY, NONE, 2, 5
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, CAVALRY, NONE, 2, 6
    
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, ARTILLERY, NONE, 2, 3
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, ARTILLERY, NONE, 2, 8
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, ARTILLERY, NONE, 3, 2
    gLastDefense = gLastDefense + 1
    InitPiece gLastDefense, DEFENSE, ARTILLERY, NONE, 3, 9

    MaxStrength = 24
    For i = 2 To gLastDefense
        gDefense(i).strength = Rnd * 2 + 1
        MaxStrength = MaxStrength - gDefense(i).strength
    Next
    For i = 2 To gLastDefense
        If (MaxStrength > 0) And (gDefense(i).strength < HIGH) Then
            gDefense(i).strength = gDefense(i).strength + 1
            MaxStrength = MaxStrength + 1
        End If
    Next

End Sub

Sub SetupOffense ()
'----------------------------------------------------------------------
' Set up the pieces used by the Offense.
'----------------------------------------------------------------------
Dim i As Integer

    For i = 1 To gLastOffense
        Unload imgOffense(i)
    Next
    
    gLastOffense = 1
    InitPiece gLastOffense, OFFENSE, INFANTRY, HIGH, 10, 4
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, CAVALRY, MODERATE, 9, 5
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, ARTILLERY, HIGH, 9, 3
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, INFANTRY, MODERATE, 10, 6
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, SPY, LOW, 11, 5
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, CAVALRY, HIGH, 9, 6
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, INFANTRY, MODERATE, 10, 7
    
    gLastOffense = gLastOffense + 1
    InitPiece gLastOffense, OFFENSE, ARTILLERY, MODERATE, 9, 8

End Sub

Function WhatPieceHere (side As Integer, element As Integer, r As Integer, c As Integer) As Integer
'----------------------------------------------------------------------
' Determine what piece (if any) is at this row and column.
'----------------------------------------------------------------------
Dim i As Integer

    side = NEITHER

    ' Check Offense
    For i = 1 To gLastOffense
        If (gOffense(i).row = r) And (gOffense(i).col = c) And (imgOffense(i).Visible) Then
            side = OFFENSE
            element = i
            Exit For
        End If
    Next

    ' Check Defense
    For i = 1 To gLastDefense
        If (gDefense(i).row = r) And (gDefense(i).col = c) And (imgDefense(i).Visible) Then
            side = DEFENSE
            element = i
            Exit For
        End If
    Next
    WhatPieceHere = side
End Function

Sub XYtoRC (ByVal X As Integer, ByVal Y As Integer, r As Integer, c As Integer)
'----------------------------------------------------------------------
' Translate an x-y coordinate into a board row and column.
'----------------------------------------------------------------------

    r = Y \ P_WIDTH
    c = X \ P_WIDTH
End Sub

