Option Explicit
'----------------------------------------------------------------------
' global constants, variables and functions used by project.
'----------------------------------------------------------------------

Global Const P_WIDTH = 32        ' Width (in pixels) of playing piece.
Global Const BOARD_DIM = 12      ' Number of playing squares on board.

' ScaleMode constants
Global Const TWIPS = 1
Global Const PIXELS = 3

' RGB color constants
Global Const BLUE = &HFF0000
Global Const RED = &HFF&
Global Const BLACK = &H0&
Global Const YELLOW = &HFFFF&
Global Const GREEN = &HFF00&

' Game States
Global Const GAME_OVER = 0
Global Const SELECT_PIECE = 1
Global Const MOVE_PIECE = 2
Global Const DEFENSE_MOVE = 3

' Maximum number of playing pieces per side.
Global Const MAX_PIECES = 15

' Which side?
Global Const NEITHER = -1
Global Const DEFENSE = 0
Global Const OFFENSE = 1

' Game Piece Types
Global Const INFANTRY = 1
Global Const CAVALRY = 2
Global Const ARTILLERY = 3
Global Const SPY = 5
Global Const FLAG = 6

' Strength Constants
Global Const NONE = 0
Global Const LOW = 1
Global Const MODERATE = 2
Global Const HIGH = 3

' Constants for 3D Borders
Global Const BORDER_INSET = 0
Global Const BORDER_RAISED = 1

' Data type that holds the state of a
' single playing piece.
Type tPiece
    side As Integer
    type As Integer
    strength As Integer
    row As Integer
    col As Integer
    ImageEl As Integer
End Type

' The current mouse location in board rows and columns
Global gMouseRow As Integer
Global gMouseCol As Integer

' Array of offensive pieces
Global gOffense(1 To MAX_PIECES)  As tPiece
Global gLastOffense As Integer

' Array of defensive pieces
Global gDefense(1 To MAX_PIECES)  As tPiece
Global gLastDefense As Integer

' Arrays with descriptions of different game properties
' stored as strings
Global gPieceName(1 To 6)  As String
Global gStrengthName(0 To 3) As String
Global gSideName(0 To 1)  As String

' The current game state
Global gGameState As Integer

' The currently selected game piece
Global gCurrentPiece As Integer

' Functions and constants used to play sounds.
Declare Function sndPlaySound Lib "MMSystem" (ByVal lpsound As String, ByVal FLAG As Integer) As Integer

Global Const SND_SYNC = &H0        ' Return when sound ends (the default)
Global Const SND_ASYNC = &H1       ' Return as soon as sound starts

Sub Make3D (AForm As Form, ctl As Control, ByVal BorderStyle As Integer, ByVal BorderWidth As Integer)
'----------------------------------------------------------------------
' Wrap a 3D effect around a control on a form.
'----------------------------------------------------------------------
' Color Constants
Const DARK_GRAY = &H808080
Const WHITE = &HFFFFFF
Const BLACK = &H0

Dim AdjustX As Integer, AdjustY As Integer
Dim RightSide As Single
Dim BW As Integer
Dim LeftTopColor As Long, RightBottomColor As Long
Dim i As Integer
Dim SaveMode As Integer

    If Not ctl.Visible Then Exit Sub

    SaveMode = AForm.ScaleMode
    AForm.ScaleMode = TWIPS

    AdjustX = Screen.TwipsPerPixelX
    AdjustY = Screen.TwipsPerPixelY

    Select Case BorderStyle
	Case 0: ' Inset
	    LeftTopColor = DARK_GRAY
	    RightBottomColor = WHITE
	Case 1: ' Raised
	    LeftTopColor = WHITE
	    RightBottomColor = DARK_GRAY
    End Select

    ' Set the top shading line.
    For BW = 1 To BorderWidth
	' Top
	AForm.CurrentX = ctl.Left - (AdjustX * BW)
	AForm.CurrentY = ctl.Top - (AdjustY * BW)
	AForm.Line -(ctl.Left + ctl.Width + (AdjustX * (BW - 1)), ctl.Top - (AdjustY * BW)), LeftTopColor
	' Right
	AForm.Line -(ctl.Left + ctl.Width + (AdjustX * (BW - 1)), ctl.Top + ctl.Height + (AdjustY * (BW - 1))), RightBottomColor
	' Bottom
	AForm.Line -(ctl.Left - (AdjustX * BW), ctl.Top + ctl.Height + (AdjustY * (BW - 1))), RightBottomColor
	' Left
	AForm.Line -(ctl.Left - (AdjustX * BW), ctl.Top - (AdjustY * BW)), LeftTopColor
    Next

    AForm.ScaleMode = SaveMode
End Sub

