VERSION 2.00
Begin Form frmShootOut 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Shoot-Out"
   ClientHeight    =   5400
   ClientLeft      =   1620
   ClientTop       =   1755
   ClientWidth     =   6135
   Height          =   5805
   Icon            =   SHOOTOUT.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1560
   LinkTopic       =   "Form2"
   ScaleHeight     =   540
   ScaleWidth      =   540
   Top             =   1410
   Width           =   6255
   Begin Timer tmrMouseCntl 
      Interval        =   22
      Left            =   1380
      Top             =   3780
   End
   Begin CommandButton btnStart 
      Caption         =   "&Start"
      Height          =   375
      Left            =   2580
      TabIndex        =   1
      Top             =   3840
      Width           =   1095
   End
   Begin Timer Timer1 
      Left            =   900
      Top             =   3780
   End
   Begin PictureBox picDesert 
      BackColor       =   &H00C0FFC0&
      Height          =   3315
      Left            =   180
      ScaleHeight     =   3285
      ScaleWidth      =   5745
      TabIndex        =   0
      Top             =   360
      Width           =   5775
      Begin Image imgRBullet 
         Height          =   480
         Index           =   0
         Left            =   5100
         Picture         =   SHOOTOUT.FRX:0302
         Top             =   1440
         Visible         =   0   'False
         Width           =   480
      End
      Begin Image imgLBullet 
         Height          =   480
         Index           =   0
         Left            =   420
         Picture         =   SHOOTOUT.FRX:0604
         Top             =   1440
         Visible         =   0   'False
         Width           =   480
      End
      Begin Image imgCactus 
         Height          =   480
         Index           =   1
         Left            =   2880
         Picture         =   SHOOTOUT.FRX:0906
         Top             =   2160
         Width           =   480
      End
      Begin Image imgCactus 
         Height          =   480
         Index           =   0
         Left            =   2160
         Picture         =   SHOOTOUT.FRX:0C08
         Top             =   480
         Width           =   480
      End
      Begin Image imgPlayer 
         Height          =   480
         Index           =   1
         Left            =   4920
         Picture         =   SHOOTOUT.FRX:0F0A
         Top             =   300
         Width           =   480
      End
      Begin Image imgPlayer 
         Height          =   480
         Index           =   0
         Left            =   360
         Picture         =   SHOOTOUT.FRX:120C
         Top             =   2280
         Width           =   480
      End
   End
   Begin Label Label4 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Player 2 uses the mouse: left button and right button clicks move player, and left mouse double-click fires gun."
      Height          =   495
      Left            =   180
      TabIndex        =   5
      Top             =   4860
      Width           =   5775
   End
   Begin Label Label3 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Player 1 uses the keyboard: up and down arrow keys move player, and space bar fires gun."
      Height          =   495
      Left            =   180
      TabIndex        =   4
      Top             =   4380
      Width           =   5835
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Player 2"
      Height          =   195
      Left            =   4680
      TabIndex        =   3
      Top             =   120
      Width           =   1215
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Player 1"
      Height          =   195
      Left            =   180
      TabIndex        =   2
      Top             =   120
      Width           =   1215
   End
   Begin Image imgRIP 
      Height          =   480
      Left            =   180
      Picture         =   SHOOTOUT.FRX:150E
      Top             =   3780
      Visible         =   0   'False
      Width           =   480
   End
End
Option Explicit
'----------------------------------------------------------
' SHOOTOUT.FRM
'----------------------------------------------------------

' KeyCodes for keyboard action.
Const KEY_SPACE = &H20
Const KEY_UP = &H26
Const KEY_DOWN = &H28

' Number of Twips to move player on each key or mouse event.
Const PlayerIncrement = 45

' Constants for mouse action.
Const NO_BUTTON = 0
Const LBUTTON = 1
Const RBUTTON = 2

' Boolean that indicates if mouse button has been pressed down.
Dim MouseButtonDown As Integer

' Number of bullets either player can have in use at one time.
Const NUM_BULLETS = 6

' Booleans indicating if player 0 or player 1 have just fired.
Dim GunFired(0 To 1) As Integer

Sub btnStart_Click ()
'----------------------------------------------------------
' Start the game by enabling the main timer and hiding
' the start button.
'----------------------------------------------------------
    
    Timer1.Enabled = True
    btnStart.Visible = False
End Sub

Function Collided (imgA As Image, imgB As Image) As Integer
'--------------------------------------------------
' Check if the two Images intersect, using the
' IntersectRect API call.
'--------------------------------------------------
Dim A As tRect
Dim B As tRect
Dim ResultRect As tRect

    ' Copy information into tRect structure
    A.Left = imgA.Left
    A.Top = imgA.Top
    B.Left = imgB.Left
    B.Top = imgB.Top

    ' Calculate the right and bottoms of rectangles needed by the API call.
    A.Right = A.Left + imgA.Width - 1
    A.Bottom = A.Top + imgA.Height - 1

    B.Right = B.Left + imgB.Width - 1
    B.Bottom = B.Top + imgB.Height - 1

    ' IntersectRect will only return 0 (false) if the
    ' two rectangles do NOT intersect.
    Collided = IntersectRect(ResultRect, A, B)
End Function

Sub Form_DblClick ()
'----------------------------------------------------------
' Double-clicking the mouse fires Player 1's gun.
'----------------------------------------------------------
Dim rc As Integer

    If Not Timer1.Enabled Then Exit Sub

    GunFired(1) = True
    rc = sndPlaySound(App.Path & "\BANG.WAV", SND_ASYNC)
End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
'----------------------------------------------------------
' This event handles Player 0's game action via the
' keyboard.
'----------------------------------------------------------
Dim rc As Integer
Static InKeyDown As Integer

    If Not Timer1.Enabled Then Exit Sub

    If InKeyDown Then Exit Sub
    InKeyDown = True
    
    ' Don't hog the cycles...
    DoEvents
    
    Select Case KeyCode
        Case KEY_UP
            imgPlayer(0).Top = imgPlayer(0).Top - PlayerIncrement
            If imgPlayer(0).Top < 0 Then imgPlayer(0).Top = 0
        Case KEY_SPACE
            GunFired(0) = True
            rc = sndPlaySound(App.Path & "\BANG.WAV", SND_ASYNC)
        Case KEY_DOWN
            imgPlayer(0).Top = imgPlayer(0).Top + PlayerIncrement
            If imgPlayer(0).Top > (picDesert.ScaleHeight - imgPlayer(0).Height) Then
                imgPlayer(0).Top = picDesert.ScaleHeight - imgPlayer(0).Height
            End If
    End Select

    InKeyDown = False
End Sub

Sub Form_Load ()
'----------------------------------------------------------
' Set the main timer's interval and make sure it's disabled.
' Load 5 more bullets for each player from the bullet images
' created at design time.
'----------------------------------------------------------
Dim i As Integer

    Timer1.Interval = 22
    Timer1.Enabled = False
    MouseButtonDown = NO_BUTTON

    For i = 1 To NUM_BULLETS - 1
        Load imgLBullet(i)
        Load imgRBullet(i)
    Next
End Sub

Sub Form_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
'----------------------------------------------------------
' Set the module-level MouseButtonDown variable, so that
' the Mouse Control timer knows a button was pushed.
'----------------------------------------------------------

    MouseButtonDown = Button
End Sub

Sub Form_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
'----------------------------------------------------------
' Let the Mouse Control timer know the button has been
' released.
'----------------------------------------------------------

    MouseButtonDown = NO_BUTTON
End Sub

Sub Timer1_Timer ()
'----------------------------------------------------------
' The main game timer.
'----------------------------------------------------------
Const CactusIncrement = 30
Const BulletIncrement = 300
Const NumCacti = 2

Dim i As Integer
Dim rc As Integer


    ' Move the roving cacti.
    For i = 0 To NumCacti - 1
        imgCactus(i).Top = imgCactus(i).Top - CactusIncrement
        If imgCactus(i).Top < -imgCactus(i).Height Then
            imgCactus(i).Top = picDesert.Height
        End If
    Next

    ' Did player 0 fire a bullet?
    If GunFired(0) Then
        GunFired(0) = False

        ' Find a spare (invisible) bullet.
        For i = 0 To NUM_BULLETS - 1
            If Not imgLBullet(i).Visible Then
                imgLBullet(i).Top = imgPlayer(0).Top
                imgLBullet(i).Left = imgPlayer(0).Left + (imgPlayer(0).Width / 2)
                imgLBullet(i).Visible = True
                Exit For
            End If
        Next
    End If
    ' Did player 1 fire a bullet?
    If GunFired(1) Then
        GunFired(1) = False

        ' Find a spare (invisible) bullet.
        For i = 0 To NUM_BULLETS - 1
            If Not imgRBullet(i).Visible Then
                imgRBullet(i).Top = imgPlayer(1).Top
                imgRBullet(i).Left = imgPlayer(1).Left - (imgPlayer(1).Width / 2)
                imgRBullet(i).Visible = True
                Exit For
            End If
        Next
    End If

    ' Move Visible Bullets
    For i = 0 To NUM_BULLETS - 1
        ' Move player 0's bullets.
        If imgLBullet(i).Visible Then
            imgLBullet(i).Left = imgLBullet(i).Left + BulletIncrement
            If Collided(imgLBullet(i), imgCactus(0)) Then
                imgLBullet(i).Visible = False
            ElseIf Collided(imgLBullet(i), imgCactus(1)) Then
                imgLBullet(i).Visible = False
            ElseIf imgLBullet(i).Left > picDesert.ScaleWidth Then
                imgLBullet(i).Visible = False
            ElseIf Collided(imgLBullet(i), imgPlayer(1)) Then
                imgLBullet(i).Visible = False
                imgPlayer(1).Picture = imgRIP.Picture
                Timer1.Enabled = False
                rc = sndPlaySound(App.Path & "\OH!!.WAV", SND_ASYNC)
            End If
        End If
        ' Move player 1's bullets.
        If imgRBullet(i).Visible Then
            imgRBullet(i).Left = imgRBullet(i).Left - BulletIncrement
            If Collided(imgRBullet(i), imgCactus(0)) Then
                imgRBullet(i).Visible = False
            ElseIf Collided(imgRBullet(i), imgCactus(1)) Then
                imgRBullet(i).Visible = False
            ElseIf imgRBullet(i).Left < -imgRBullet(i).Width Then
                imgRBullet(i).Visible = False
            ElseIf Collided(imgRBullet(i), imgPlayer(0)) Then
                imgRBullet(i).Visible = False
                imgPlayer(0).Picture = imgRIP.Picture
                Timer1.Enabled = False
                rc = sndPlaySound(App.Path & "\OH!!.WAV", SND_ASYNC)
            End If
        End If
    Next


End Sub

Sub tmrMouseCntl_Timer ()
'----------------------------------------------------------
' Handle Player 1's movement (up and down).
'----------------------------------------------------------

    If Not Timer1.Enabled Then Exit Sub
    
    Select Case MouseButtonDown
        Case RBUTTON
            imgPlayer(1).Top = imgPlayer(1).Top - PlayerIncrement
            If imgPlayer(1).Top < 0 Then imgPlayer(1).Top = 0
        Case LBUTTON
            imgPlayer(1).Top = imgPlayer(1).Top + PlayerIncrement
            If imgPlayer(1).Top > (picDesert.ScaleHeight - imgPlayer(1).Height) Then
                imgPlayer(1).Top = picDesert.ScaleHeight - imgPlayer(1).Height
            End If
    End Select

End Sub

