VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Saving Game States"
   ClientHeight    =   3780
   ClientLeft      =   1920
   ClientTop       =   1635
   ClientWidth     =   6240
   Height          =   4185
   Left            =   1860
   LinkTopic       =   "Form1"
   ScaleHeight     =   3780
   ScaleWidth      =   6240
   Top             =   1290
   Width           =   6360
   Begin TextBox txtStringData 
      Height          =   285
      Left            =   300
      TabIndex        =   2
      Text            =   "Enter some text here."
      Top             =   2760
      Width           =   5655
   End
   Begin PictureBox picField 
      BackColor       =   &H00E0FFFF&
      Height          =   2325
      Left            =   240
      ScaleHeight     =   2295
      ScaleWidth      =   5805
      TabIndex        =   1
      Top             =   360
      Width           =   5835
      Begin Image imgObject 
         Height          =   480
         Index           =   2
         Left            =   1860
         Picture         =   STATE.FRX:0000
         Top             =   600
         Width           =   480
      End
      Begin Image imgObject 
         Height          =   480
         Index           =   1
         Left            =   3840
         Picture         =   STATE.FRX:0302
         Top             =   1380
         Width           =   480
      End
      Begin Image imgObject 
         Height          =   480
         Index           =   0
         Left            =   600
         Picture         =   STATE.FRX:0604
         Top             =   1080
         Width           =   480
      End
   End
   Begin CommandButton btnSwitch 
      Caption         =   "&Switch"
      Height          =   375
      Left            =   2640
      TabIndex        =   0
      Top             =   3240
      Width           =   1275
   End
   Begin Label lblCurrentState 
      BackStyle       =   0  'Transparent
      Caption         =   "Label1"
      Height          =   195
      Left            =   240
      TabIndex        =   3
      Top             =   120
      Width           =   2595
   End
End
Option Explicit
'--------------------------------------------------
' STATE.FRM
'--------------------------------------------------

' Number of states we're tracking in this program.
Const NUM_STATES = 2

' Boolean indicating if we're currently dragging
' an object.
Dim Dragging(0 To NUM_OBJECTS) As Integer

' Used while dragging an object.
Dim Ofs As tPoint

' Boolean that indicates if we are allowed to
' change the border style of an object.
Dim ChangeStyle As Integer

' An array of state structures. In practice, each
' element corresponds to a player.
Dim State(1 To NUM_STATES) As tState

' The state (or player, if you will) that is currently
' active.
Dim CurrentState As Integer


Sub btnSwitch_Click ()
'--------------------------------------------------
' Switch between the two game states (Players 1 and 2).
'--------------------------------------------------

    If CurrentState = 1 Then
        SaveState 1
        LoadState 2
        CurrentState = 2
    Else
        SaveState 2
        LoadState 1
        CurrentState = 1
    End If
    lblCurrentState = "State " & Format$(CurrentState)
End Sub

Sub Form_Load ()
'--------------------------------------------------
' Set the initial active state to Player 1.
'--------------------------------------------------
    
    CurrentState = 1
    lblCurrentState = "State " & Format$(CurrentState)
End Sub

Sub imgObject_Click (Index As Integer)
'--------------------------------------------------
' If the user clicks once on an object, then toggle
' that image's border style.
'--------------------------------------------------

    If ChangeStyle Then
        imgObject(Index).BorderStyle = (imgObject(Index).BorderStyle + 1) Mod 2
    End If
    ChangeStyle = True
End Sub

Sub imgObject_MouseDown (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'--------------------------------------------------
' If the mouse is held down over an object, prepare
' to drag that object.
'--------------------------------------------------

    Dragging(Index) = True
    Ofs.X = X
    Ofs.Y = Y
End Sub

Sub imgObject_MouseMove (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'--------------------------------------------------
' Drag an object if the mouse is clicked and
' dragged over it.
'--------------------------------------------------
    
    If Dragging(Index) Then
        imgObject(Index).Move imgObject(Index).Left + (X - Ofs.X), imgObject(Index).Top + (Y - Ofs.Y)
        ChangeStyle = False
    End If
End Sub

Sub imgObject_MouseUp (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'--------------------------------------------------
' End the drag process.
'--------------------------------------------------

    Dragging(Index) = False

End Sub

Sub LoadState (StateNum As Integer)
'--------------------------------------------------
' Take information for a particular state (ie,, player)
' and display it on the screen, in effect activating
' the player.
'--------------------------------------------------
Dim i As Integer

    For i = 0 To NUM_OBJECTS - 1
        imgObject(i).Left = State(StateNum).Object(i).Pos.X
        imgObject(i).Top = State(StateNum).Object(i).Pos.Y
        imgObject(i).BorderStyle = State(StateNum).Object(i).BorderStyle
    Next

    txtStringData = State(StateNum).TextData

End Sub

Sub SaveState (StateNum As Integer)
'--------------------------------------------------
' Save information about the current screen back
' into a state structure.
'--------------------------------------------------
Dim i As Integer

    For i = 0 To NUM_OBJECTS - 1
        State(StateNum).Object(i).Pos.X = imgObject(i).Left
        State(StateNum).Object(i).Pos.Y = imgObject(i).Top
        State(StateNum).Object(i).BorderStyle = imgObject(i).BorderStyle
    Next

    State(StateNum).TextData = txtStringData
End Sub

