VERSION 5.00
Begin VB.Form frmMenace 
   Appearance      =   0  'Flat
   BackColor       =   &H00000000&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Menace3D"
   ClientHeight    =   8790
   ClientLeft      =   1095
   ClientTop       =   1035
   ClientWidth     =   9645
   DrawMode        =   1  'Blackness
   FillColor       =   &H00FFFFFF&
   FillStyle       =   2  'Horizontal Line
   ForeColor       =   &H00000000&
   KeyPreview      =   -1  'True
   LinkTopic       =   "&H80000001&"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   439.5
   ScaleMode       =   2  'Point
   ScaleWidth      =   482.25
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
End
Attribute VB_Name = "frmMenace"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function GetTickCount Lib "kernel32" () As Long

Dim ox%, oy%, block%
Dim curframe%, dwn%
Dim mode%, hv!
Dim D3DRM As Direct3DRM2

Dim Clipper As DirectDrawClipper
Dim Device As Direct3DRMDevice2
Dim Viewport As Direct3DRMViewPort

Dim Scene As Direct3DRMFrame
Dim Camera As Direct3DRMFrame
Dim LightFrame1 As Direct3DRMFrame
Dim WorldFrame As Direct3DRMFrame
Dim animframe As Direct3DRMFrame

Dim bframe(50) As Direct3DRMFrame 'max 50 blocks
Dim bx(50) As Double
Dim by(50) As Double
Dim bz(50) As Double
Dim btyp(50) As Integer

Dim Light1 As Direct3DRMLight
Dim anim As Direct3DRMAnimationSet

Dim screenheight As Integer: Dim screenwidth As Integer
Dim defaultheight As Integer: Dim defaultwidth As Integer
Dim zoom As Single

Dim vvel!

Dim angle_increment As Single: Dim movement_increment As Single


Dim worldclock As Long
Dim walkclock As Long
Dim animclock As Long

Dim keycodeflags(1000) As Boolean

Private Static Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    
    On Error Resume Next

    Select Case KeyCode
        Case vbKeyEscape
             'quit the program
             Set WorldFrame = Nothing
             Set Scene = Nothing
             Set Camera = Nothing
             Set Viewport = Nothing
             Set Device = Nothing
             Set D3DRM = Nothing
             Set Clipper = Nothing
             End
        Case Else
            keycodeflags(KeyCode) = True
    End Select
    
End Sub

Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
    keycodeflags(KeyCode) = False
End Sub

Private Sub Form_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
dwn% = True
ox% = X: oy% = Y
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
If dwn% Then
    If Button = 1 Then
        'move the camera as the user drags the mouse
        Camera.AddTranslation D3DRMCOMBINE_BEFORE, ((X - ox%) * 5), 0, (Y - oy%) * 10
    ElseIf Button = 2 Then
        'rotate the viewpoint
        Camera.AddRotation D3DRMCOMBINE_AFTER, 0, -1, 0, ((X - ox%) / 100)
        'Camera.AddRotation D3DRMCOMBINE_AFTER, -1, 0, -1, ((Y - oy%) / 500)
    End If
    ox% = X: oy% = Y
End If
End Sub

Private Sub Form_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
dwn% = False
End Sub

Private Sub Form_Resize()
    
    'clip for the current window size
    DirectDrawCreateClipper 0, Clipper, Nothing
    Clipper.SetHWnd 0, hWnd
       
    D3DRM.CreateDeviceFromClipper Clipper, ByVal 0&, screenwidth, screenheight, Device
    
    'set up gourand shading
    Device.SetQuality D3DRMLIGHT_ON Or D3DRMFILL_SOLID Or D3DRMSHADE_GOURAUD
 
    'initalise viewport
    D3DRM.CreateViewport Device, Camera, 0, 0, screenwidth, screenheight, Viewport
    Viewport.SetBack 10000
    Viewport.Clear
    Viewport.Configure (screenwidth - defaultwidth) / 2, (screenheight - defaultheight) / 2, defaultwidth, defaultheight
    DoEvents
     
    'LOOP until user quits
    On Error Resume Next
    Do
        'process keystrokes and
        'perform animation
        doanimation
        
        Scene.Move 1
        Viewport.Clear
        Viewport.Render Scene
        Device.Update
        DoEvents
    Loop
    
End Sub
Sub doanimation()
    Dim lasttick As Double
    Dim pos_start As D3DVECTOR
    Dim pos_end As D3DVECTOR
    'find the length of the last tick
    'this is so animation is processor / 3d card independant
    'e.g. move and animate on time - not frame basis
    '     because some PC's will do more frames per second
    lasttick = GetTickCount - worldclock
    'lasttick = 20 'use this for testing
    'update world clock
    worldclock = GetTickCount
    
    'first get the current actor position
    animframe.GetPosition WorldFrame, pos_start
    
    Select Case mode%
    Case 0
        '*****************************************
        '  normal Walking mode, fames 1-20 (loop)
        '*****************************************
        If keycodeflags(vbKeyLeft) Then  'ROTATE LEFT
            animframe.AddRotation D3DRMCOMBINE_BEFORE, 0, -1, 0, angle_increment * lasttick
        End If
        If keycodeflags(vbKeyRight) Then  'ROTATE RIGHT
            animframe.AddRotation D3DRMCOMBINE_BEFORE, 0, 1, 0, angle_increment * lasttick
        End If
        If keycodeflags(vbKeyUp) Then 'MOVE FOWARD
            animframe.AddTranslation D3DRMCOMBINE_BEFORE, 0, 0, movement_increment * lasttick
            'animate the walk
            walkclock = walkclock + lasttick
            curframe% = ((walkclock \ 40) Mod 20) + 1
        End If
        If keycodeflags(vbKeyDown) Then 'MOVE BACKWARD
            animframe.AddTranslation D3DRMCOMBINE_BEFORE, 0, 0, -movement_increment * lasttick
            'animate the walk
            walkclock = walkclock - lasttick
            curframe% = 20 - ((walkclock \ 40) Mod 20)
        End If
        If keycodeflags(vbKeySpace) Then 'JUMP
            mode% = 1: animclock = 0
        End If
        If keycodeflags(vbKeyShift) Then 'PUSH
            mode% = 5: animclock = 0
        End If
    Case 1
        '*****************************
        '  Crouch, 21-25 (stop)
        '*****************************
        If curframe% < 25 Then
            animclock = animclock + lasttick
            curframe% = ((animclock \ 80) Mod 6) + 21
        Else
            mode% = 2: animclock = 0
            vvel! = -20 ' initial jump speed
            hv! = 1 'horizontal velocity
        End If
    Case 2
        '*******************************
        '  Jump (horizontal progress
        '  is constant unless hit block)
        '*******************************
        vvel! = vvel! + movement_increment * lasttick * 0.1
        animframe.AddTranslation D3DRMCOMBINE_BEFORE, 0, -vvel * lasttick * 0.1, movement_increment * lasttick * 2 * hv!
        If vvel! < 0 Then 'jumping up
            'or until hit ceiling
            animclock = animclock + lasttick
            curframe% = ((animclock \ 80) Mod 4) + 26
        Else 'falling down
            'till hit floor
            animclock = animclock + lasttick
            curframe% = ((animclock \ 80) Mod 6) + 30
        End If
    Case 4
        '*****************************
        '  Land, 35-40 (stop)
        '*****************************
        If curframe% < 40 Then
            animclock = animclock + lasttick
            curframe% = ((animclock \ 80) Mod 6) + 36
        Else
            mode% = 0: animclock = 0
            curframe% = 0
            vvel! = 0
        End If
    Case 5
        '*****************************
        '  Push (down), 40 - 50 (stop)
        '*****************************
        If curframe% < 50 Then
            animclock = animclock + lasttick
            curframe% = ((animclock \ 40) Mod 10) + 41
        Else
            mode% = 6: animclock = 0
        End If
    Case 6
        '*****************************
        '  Push (up), 50 - 65 (stop)
        '*****************************
        If curframe% < 60 Then
            animclock = animclock + lasttick
            curframe% = ((animclock \ 40) Mod 10) + 51
        Else
            mode% = 0
            curframe% = 0
        End If
    End Select
    
    'now get the new actor position
    animframe.GetPosition WorldFrame, pos_end
    
    'check if hit the floor
    If pos_end.Y < 0 Then 'hit the floor
        animframe.SetPosition WorldFrame, pos_end.X, 0, pos_end.z
        animframe.GetPosition WorldFrame, pos_end
        mode% = 4
    End If
    
    'make sure we haven't hit a box
    Dim a%, b%, highest!, walkflag%, highblock%
    b% = False
    For a% = 0 To block% - 1
        If ((pos_end.X >= bx(a%) - 280) And (pos_end.X <= bx(a%) + 280) And (pos_end.z >= bz(a%) - 280) And (pos_end.z <= bz(a%) + 280)) Then
            b% = True
            'now in the column of a box
            'check if you are walking into it
            If pos_end.Y > by(a%) - 200 And pos_end.Y < by(a%) + 359 Then
                'walk into it
                walkflag% = True
            End If
            'record the highest box for this level
            If by(a%) + 360 > highest! Then
                highest! = by(a%) + 360
                highblock% = a%
            End If
        End If
    Next
    If pos_end.Y < pos_start.Y And pos_end.Y < highest! And pos_start.Y > highest! Then
        'land on the top of a box
        animframe.SetPosition WorldFrame, pos_end.X, highest!, pos_end.z
        animframe.GetPosition WorldFrame, pos_end
        mode = 4 'land
        'now decide what to do that we have landed on block
        Select Case btyp(highblock%)
            Case 2 'die
                Beep
                MsgBox ("Radioactive Block" & Chr$(13) & "You Lose")
            Case 4 'win
                Beep
                MsgBox ("You landed on the win Block!" & Chr$(13) & "You Win")
        End Select
    ElseIf walkflag% Then
        'walk into the side of a box - so reset horizontal motion
        animframe.SetPosition WorldFrame, pos_start.X, pos_end.Y, pos_start.z
    End If
    If Not b% And vvel! = 0 And pos_end.Y > highest! Then
        'if walked into space, then start falling
        vvel! = 1 'initial vertical velocity
        hv! = 0   'no horizontal velocity
        mode% = 2 'falling
    End If
    'update character animation
    anim.SetTime curframe%
End Sub
Private Sub Form_Load()
    
    movement_increment = 0.5
    angle_increment = 0.002
    zoom = 1
    walkclock = 100000

    
    'screenwidth = 640: screenheight = 480
    screenwidth = 800: screenheight = 600
    

    defaultwidth = screenwidth: defaultheight = screenheight
   
    'make scene and world
    Direct3DRMCreate D3DRM
    D3DRM.CreateFrame Nothing, Scene
    D3DRM.CreateFrame Scene, WorldFrame
    D3DRM.CreateFrame WorldFrame, Camera
    Camera.SetPosition WorldFrame, 0, 0, -2000
    Camera.AddRotation D3DRMCOMBINE_AFTER, 1, 0, 0, 0.2

    'make a directional light
    D3DRM.CreateFrame WorldFrame, LightFrame1
    LightFrame1.SetOrientation WorldFrame, 1, -1, -0.5, 0, 1, 0
    D3DRM.CreateLightRGB D3DRMLIGHT_DIRECTIONAL, 0.5, 1, 0, Light1
    LightFrame1.AddLight Light1
    Set Light1 = Nothing
    
    'make ambient lights
    Dim ambientlight As Direct3DRMLight
    D3DRM.CreateLightRGB D3DRMLIGHT_AMBIENT, 0.3, 0.3, 0.3, ambientlight
    Scene.AddLight ambientlight
    Set ambientlight = Nothing
        
    'add animated menace
    D3DRM.CreateFrame WorldFrame, animframe
    D3DRM.CreateAnimationSet anim
    anim.Load App.Path & "\menace.x", 0, 0, 0, 0, animframe
    'animframe.SetPosition WorldFrame, 200, 0, 2500
    
    ' set up background
    Scene.SetSceneBackground 0
    Scene.SetZbufferMode D3DRMZBUFFER_ENABLE
    Scene.SetSortMode D3DRMSORT_BACKTOFRONT
        
    loadmap Form1.Tag

End Sub

Sub loadmap(file$)
    Dim title$, i%
    Dim mesh As Direct3DRMMeshBuilder
    Dim txt(4) As Direct3DRMTexture
    'load up the default textures
    For i% = 1 To 4
        D3DRM.LoadTexture App.Path & "\txt" & i% & ".bmp", txt(i%)
    Next
        
    block% = 0
    Open file$ For Input As #1
        Input #1, title$
        Do
            Input #1, btyp(block%), bx(block%), bz(block%), by(block%)
            
            'make a mesh and a frame to hold it
            D3DRM.CreateMeshBuilder mesh
            D3DRM.CreateFrame WorldFrame, bframe(block%)
            
            'now load the mesh as set the texture
            'the 256 is flags loadfromfile and instancebyreference
            mesh.Load App.Path & "\menbox" & btyp(block%) & ".x", 0, 256, 0, 0
            mesh.SetTexture txt(btyp(block%))
            
            'add the mesh to the frame, and scale it
            bframe(block%).AddVisual mesh
            bframe(block%).AddScale D3DRMCOMBINE_BEFORE, 3, 3, 3
            
            'scale positions
            bx(block%) = bx(block%) * 300
            by(block%) = by(block%) * 300 - 60
            bz(block%) = bz(block%) * 300 '+ 2000
            
            'position the frame based on the map
            bframe(block%).SetPosition WorldFrame, bx(block%), by(block%), bz(block%)
            Set mesh = Nothing
            
            block% = block% + 1
        Loop Until EOF(1)
    Close
End Sub


