VERSION 4.00
Begin VB.Form Form1 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Form1"
   ClientHeight    =   3510
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   4125
   Height          =   3915
   KeyPreview      =   -1  'True
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   234
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   275
   Top             =   1170
   Width           =   4245
   Begin VB.PictureBox picPlayer 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   225
      Left            =   120
      Picture         =   "Form1.frx":0000
      ScaleHeight     =   225
      ScaleWidth      =   225
      TabIndex        =   0
      Top             =   120
      Visible         =   0   'False
      Width           =   225
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' The maze information.
Private NumRows As Integer
Private NumCols As Integer
Private LegalMove() As Boolean

' The size of a square.
Private Const SQUARE_WID = 20
Private Const SQUARE_HGT = 20

' The player's position.
Private PlayerR As Integer
Private PlayerC As Integer


' Initialize the maze.
Private Sub LoadMaze()
Dim fnum As Integer
Dim r As Integer
Dim c As Integer
Dim row_info As String

    ' Open the maze file.
    fnum = FreeFile
    Open App.Path & "\maze.dat" For Input As #fnum

    ' Read the player's initiali position.
    Input #fnum, PlayerR, PlayerC

    ' Read the number of rows and columns.
    Input #fnum, NumRows, NumCols
    ReDim LegalMove(1 To NumRows, 1 To NumCols)
    
    ' Read the data.
    For r = 1 To NumRows
        Line Input #fnum, row_info
        For c = 1 To NumCols
            LegalMove(r, c) = (Mid$(row_info, c, 1) = " ")
        Next c
    Next r

    ' Close the file.
    Close #fnum

    ' Size the form.
    Width = ScaleX(SQUARE_WID * NumCols, ScaleMode, vbTwips) + _
        Width - ScaleX(ScaleWidth, ScaleMode, vbTwips)
    Height = ScaleY(SQUARE_HGT * NumRows, ScaleMode, vbTwips) + _
        Height - ScaleY(ScaleHeight, ScaleMode, vbTwips)

    ' Draw the maze.
    DrawMaze

    ' Position the player.
    PositionPlayer PlayerR, PlayerC
End Sub

' Draw the player.
Private Sub PositionPlayer(r As Integer, c As Integer)
Dim x As Single
Dim y As Single

    ' Erase the player's old position.
    If PlayerR > 0 Then
        x = (PlayerC - 1) * SQUARE_WID + (SQUARE_WID - picPlayer.Width) / 2
        y = (PlayerR - 1) * SQUARE_HGT + (SQUARE_HGT - picPlayer.Height) / 2
        Line (x - 1, y - 1)-Step(picPlayer.Width, picPlayer.Height), vbWhite, BF
    End If
    
    ' Move the player.
    PlayerR = r
    PlayerC = c

    ' Draw the player.
    x = (c - 1) * SQUARE_WID + (SQUARE_WID - picPlayer.Width) / 2
    y = (r - 1) * SQUARE_HGT + (SQUARE_HGT - picPlayer.Height) / 2
    PaintPicture picPlayer.Picture, x, y
End Sub

' Look for movement keys.
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
Dim r As Integer
Dim c As Integer

    r = PlayerR
    c = PlayerC
    Select Case KeyCode
        Case vbKeyLeft
            c = PlayerC - 1
        Case vbKeyRight
            c = PlayerC + 1
        Case vbKeyDown
            r = PlayerR + 1
        Case vbKeyUp
            r = PlayerR - 1
        Case Else
            Exit Sub
    End Select

    If LegalMove(r, c) Then PositionPlayer r, c
End Sub
' Initialize the maze and player.
Private Sub Form_Load()
    ' Initialize the maze.
    LoadMaze
End Sub
' Draw the maze.
Private Sub DrawMaze()
Dim r As Integer
Dim c As Integer
Dim clr As Long

    ' Start from scratch.
    Cls
    
    For r = 1 To NumRows
        For c = 1 To NumCols
            If LegalMove(r, c) Then
                clr = vbWhite
            Else
                clr = RGB(128, 128, 128)
            End If
            Line (c * SQUARE_WID, r * SQUARE_HGT)-Step(-SQUARE_WID, -SQUARE_HGT), clr, BF
        Next c
    Next r
End Sub




