VERSION 2.00
Begin Form frmLander 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Lunar Lander"
   ClientHeight    =   6405
   ClientLeft      =   810
   ClientTop       =   1155
   ClientWidth     =   6630
   FillColor       =   &H0000C000&
   Height          =   6810
   Left            =   750
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   Picture         =   LANDER.FRX:0000
   ScaleHeight     =   540
   ScaleWidth      =   540
   Top             =   810
   Width           =   6750
   Begin PictureBox picThrustV_m 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   480
      Left            =   5940
      Picture         =   LANDER.FRX:1F31A
      ScaleHeight     =   480
      ScaleWidth      =   360
      TabIndex        =   17
      Top             =   7080
      Width           =   360
   End
   Begin PictureBox picThrustV_s 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   480
      Left            =   5520
      Picture         =   LANDER.FRX:1F514
      ScaleHeight     =   480
      ScaleWidth      =   360
      TabIndex        =   16
      Top             =   7080
      Width           =   360
   End
   Begin PictureBox picThrustH_m 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   240
      Left            =   5520
      Picture         =   LANDER.FRX:1F70E
      ScaleHeight     =   240
      ScaleWidth      =   480
      TabIndex        =   15
      Top             =   6780
      Width           =   480
   End
   Begin PictureBox picThrustH_s 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   240
      Left            =   5520
      Picture         =   LANDER.FRX:1F888
      ScaleHeight     =   240
      ScaleWidth      =   480
      TabIndex        =   14
      Top             =   6480
      Width           =   480
   End
   Begin PictureBox picScanner 
      BackColor       =   &H00808080&
      Height          =   195
      Left            =   360
      ScaleHeight     =   165
      ScaleWidth      =   2985
      TabIndex        =   13
      Top             =   5460
      Width           =   3015
      Begin Shape shpPad 
         FillColor       =   &H000000FF&
         FillStyle       =   0  'Solid
         Height          =   135
         Left            =   1380
         Top             =   0
         Width           =   135
      End
      Begin Shape shpLander 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Left            =   240
         Top             =   0
         Width           =   135
      End
   End
   Begin PictureBox picWork 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      Height          =   5115
      Left            =   120
      ScaleHeight     =   5115
      ScaleWidth      =   3615
      TabIndex        =   7
      Top             =   8520
      Width           =   3615
   End
   Begin Timer Timer1 
      Enabled         =   0   'False
      Interval        =   55
      Left            =   6060
      Top             =   5700
   End
   Begin CommandButton btnStart 
      Caption         =   "&Start"
      Height          =   315
      Left            =   4620
      TabIndex        =   6
      Top             =   2880
      Width           =   1815
   End
   Begin PictureBox picPad_m 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   960
      Left            =   3300
      Picture         =   LANDER.FRX:1FA02
      ScaleHeight     =   960
      ScaleWidth      =   2145
      TabIndex        =   5
      Top             =   7500
      Width           =   2145
   End
   Begin PictureBox picPad_s 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   960
      Left            =   3300
      Picture         =   LANDER.FRX:20C7C
      ScaleHeight     =   960
      ScaleWidth      =   2145
      TabIndex        =   4
      Top             =   6480
      Width           =   2145
   End
   Begin PictureBox picLander_m 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   1725
      Left            =   1680
      Picture         =   LANDER.FRX:234B6
      ScaleHeight     =   1725
      ScaleWidth      =   1575
      TabIndex        =   3
      Top             =   6480
      Width           =   1575
   End
   Begin PictureBox picLander_s 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   1725
      Left            =   60
      Picture         =   LANDER.FRX:24E58
      ScaleHeight     =   1725
      ScaleWidth      =   1575
      TabIndex        =   2
      Top             =   6480
      Width           =   1575
   End
   Begin PictureBox picBG 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   10500
      Left            =   6720
      Picture         =   LANDER.FRX:28316
      ScaleHeight     =   10500
      ScaleWidth      =   9600
      TabIndex        =   1
      Top             =   120
      Width           =   9600
   End
   Begin PictureBox picViewer 
      Height          =   5115
      Left            =   360
      ScaleHeight     =   5085
      ScaleWidth      =   3585
      TabIndex        =   0
      Top             =   360
      Width           =   3615
   End
   Begin SSPanel panInfo 
      Alignment       =   0  'Left Justify - TOP
      BackColor       =   &H00C0C0C0&
      BevelInner      =   1  'Inset
      BevelOuter      =   1  'Inset
      Font3D          =   0  'None
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   2595
      Left            =   4620
      TabIndex        =   19
      Top             =   120
      Width           =   1815
   End
   Begin SSPanel panFuel 
      BackColor       =   &H00C0C0C0&
      BevelInner      =   1  'Inset
      BevelOuter      =   1  'Inset
      BorderWidth     =   2
      Caption         =   "SSPanel1"
      FloodColor      =   &H000000FF&
      FloodShowPct    =   0   'False
      FloodType       =   1  'Left To Right
      Font3D          =   3  'Inset w/light shading
      ForeColor       =   &H00FF0000&
      Height          =   375
      Left            =   4620
      TabIndex        =   11
      Top             =   4440
      Width           =   1815
   End
   Begin SSCommand btnUp 
      Caption         =   "Retro"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   5040
      TabIndex        =   10
      Top             =   5700
      Width           =   915
   End
   Begin SSCommand btnRight 
      Caption         =   "Starboard"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   5580
      TabIndex        =   9
      Top             =   5280
      Width           =   855
   End
   Begin SSCommand btnLeft 
      Caption         =   "Port"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   4620
      TabIndex        =   8
      Top             =   5280
      Width           =   855
   End
   Begin Label Label6 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Descent:"
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   4560
      TabIndex        =   25
      Top             =   3780
      Width           =   855
   End
   Begin Label lblDescent 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   5400
      TabIndex        =   24
      Top             =   3780
      Width           =   1035
   End
   Begin Label lblElevation 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   5460
      TabIndex        =   23
      Top             =   3300
      Width           =   975
   End
   Begin Label lblTargetLoc 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   5400
      TabIndex        =   22
      Top             =   3540
      Width           =   1035
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Target Loc:"
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   4560
      TabIndex        =   21
      Top             =   3540
      Width           =   855
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Elevation:"
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   4500
      TabIndex        =   20
      Top             =   3300
      Width           =   915
   End
   Begin Label Label2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Thruster Controls"
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   4680
      TabIndex        =   18
      Top             =   4980
      Width           =   1755
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Thruster Fuel"
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   4920
      TabIndex        =   12
      Top             =   4140
      Width           =   1215
   End
End
Option Explicit
'------------------------------------------------------------
' LANDER.FRM
'------------------------------------------------------------

' Color constant.
Const BLACK = 0

' Game state constants
Const GAME_OVER = 0
Const GAME_RUNNING = 1
Const GAME_PAUSED = 2

' Information about the lander
Dim mLander As tLander

' Location of the landing pad.
Dim mPad As tPosition

' Location of upper-left corner of visible
' background relative to the large background
' bitmap.
Dim mBG As tPosition

' Current state of each thruster.
Dim mLeftThrusterOn As Integer
Dim mRightThrusterOn As Integer
Dim mBottomThrusterOn As Integer

' Buffers that hold the Wave Audio for the
' thruster sounds
Dim mSndThrust1 As String
Dim mSndThrust2 As String

' Game state (eg., Paused, Running...)
Dim mCurrentState As Integer

' Used to keep lander positioned in center of screen.
Dim mCentered As tPosition

Sub Adjust_Background ()
'------------------------------------------------------------
' Adjust the background to keep the ship in the center of the screen.
'------------------------------------------------------------
    
    If (mLander.xPos > mCentered.x) And (mLander.xPos < (picBG.ScaleWidth - picLander_s.ScaleWidth - mCentered.x)) Then
        mBG.x = mLander.xPos - mCentered.x
    End If
    
    If (mLander.yPos > mCentered.y) And (mLander.yPos < (picBG.ScaleHeight - picLander_s.ScaleHeight - mCentered.y)) Then
        mBG.y = mLander.yPos - mCentered.y
    End If
End Sub

Sub Adjust_Fuel ()
'------------------------------------------------------------
' Adjust the gas gauge.
'------------------------------------------------------------
    
    If mLander.FuelAmount > 0 Then
        panFuel.FloodPercent = mLander.FuelAmount
    Else
        panFuel.FloodPercent = 0
    End If
End Sub

Sub Apply_Gravity ()
'------------------------------------------------------------
' Increase ship speed (due to gravity)
'------------------------------------------------------------
    
    If mLander.ySpeed > 0 Then
        mLander.ySpeed = mLander.ySpeed * 1.05
    Else
        mLander.ySpeed = mLander.ySpeed + .09
    End If
End Sub

Sub Apply_Inertia ()
'------------------------------------------------------------
' Horizontal Inertia
'------------------------------------------------------------
    
    If mLander.xSpeed > 0 Then
        mLander.xSpeed = mLander.xSpeed - .02
    ElseIf mLander.xSpeed < 0 Then
        mLander.xSpeed = mLander.xSpeed + .02
    End If
End Sub

Sub btnLeft_Click ()
'------------------------------------------------------------
' Fire left (port) thruster.
'------------------------------------------------------------
    
    ' No fuel, no thrust.
    If mLander.FuelAmount <= 0 Then Exit Sub
    
    NoisePlay mSndThrust2
    mLeftThrusterOn = True

    ' Increase speed in x direction.
    mLander.xSpeed = mLander.xSpeed + .4

    ' Decrease fuel.
    mLander.FuelAmount = mLander.FuelAmount - 1
End Sub

Sub btnRight_Click ()
'------------------------------------------------------------
' Fire right (starboard) thruster.
'------------------------------------------------------------
    
    ' Uh Oh! No fuel left...
    If mLander.FuelAmount <= 0 Then Exit Sub
    
    NoisePlay mSndThrust2
    mRightThrusterOn = True

    ' Increase speed in the -x direction.
    mLander.xSpeed = mLander.xSpeed - .4

    ' Decrease fuel.
    mLander.FuelAmount = mLander.FuelAmount - 1
End Sub

Sub btnStart_Click ()
'------------------------------------------------------------
' Start, pause, or resume the game.
'------------------------------------------------------------

    ' Check the current game state.
    Select Case mCurrentState
        ' Start a new game.
        Case GAME_OVER:
            mLander.yPos = 5     ' Position the lander
            Position_Pad         ' Position the landing pad.
            
            ' Set initial speed, position, and fuel
            ' for the lander.
            mLander.xSpeed = 0
            mLander.ySpeed = 1
            mLander.xPos = mCentered.x
            mLander.yPos = 5
            mLander.FuelAmount = 100
            
            ' ViewPort shows the far upper-left corner
            ' of the landscape.
            mBG.x = 0
            mBG.y = 0
            
            mCurrentState = GAME_RUNNING
            EnableThrusterControls True
            btnStart.Caption = "&Pause"
            GameInfo

            ' Start generating Timer events.
            Timer1.Enabled = True

        ' Pause the game.
        Case GAME_RUNNING:
            Timer1.Enabled = False
            EnableThrusterControls False
            btnStart.Caption = "&Resume"
            mCurrentState = GAME_PAUSED

        ' Resume a paused game.
        Case GAME_PAUSED:
            Timer1.Enabled = True
            EnableThrusterControls True
            btnStart.Caption = "&Pause"
            mCurrentState = GAME_RUNNING
    End Select
End Sub

Sub btnUp_Click ()
'------------------------------------------------------------
' Fire the bottom thruster.
'------------------------------------------------------------
    
    ' No fuel, no thrust.
    If mLander.FuelAmount <= 0 Then Exit Sub
    
    NoisePlay mSndThrust1
    mBottomThrusterOn = True

    ' Adjust vertical speed.
    If mLander.ySpeed > .8 Then
        mLander.ySpeed = mLander.ySpeed * .75
    Else
        mLander.ySpeed = mLander.ySpeed - .9
    End If

    ' Decrease fuel
    mLander.FuelAmount = mLander.FuelAmount - 2
End Sub

Sub Calculate_Lander_X ()
'------------------------------------------------------------
' Calculate the ship's next x position.
'------------------------------------------------------------
    
    mLander.xPos = mLander.xPos + mLander.xSpeed
End Sub

Sub Calculate_Lander_Y ()
'------------------------------------------------------------
' Calculate the Lander's next Y Position.
'------------------------------------------------------------
Dim prevYPos As Integer
    
    prevYPos = mLander.yPos
    
    ' Calculate the ship's next y position.
    mLander.yPos = mLander.yPos + mLander.ySpeed
    
    ' Make sure the ship can't just sit still...
    If prevYPos = mLander.yPos Then
        If mLander.ySpeed < 0 Then
            mLander.yPos = mLander.yPos - 1
        Else
            mLander.yPos = mLander.yPos + 1
        End If
    End If
End Sub

Sub Draw_Background ()
'------------------------------------------------------------
' Draw the Background into the work area PictureBox.
'------------------------------------------------------------
Dim rc As Integer
    
    ' Copy a section of the landscape bitmap into the work area.
    rc = BitBlt(picWork.hDC, 0, 0, picViewer.ScaleWidth, picViewer.ScaleHeight, picBG.hDC, mBG.x, mBG.y, SRCCOPY)
    ' Overlay the Landing Pad onto the background.
    SpriteBlt picWork, picPad_s, picPad_m, mPad.x - mBG.x, mPad.y - mBG.y
End Sub

Sub Draw_Lander ()
'------------------------------------------------------------
' Copy the Lander into the work area bitmap.
'------------------------------------------------------------

    SpriteBlt picWork, picLander_s, picLander_m, mLander.xPos - mBG.x, mLander.yPos - mBG.y
End Sub

Sub Draw_Thrusters ()
'------------------------------------------------------------
' Draw the Lander's thrusters onto the background, if they're on.
'------------------------------------------------------------

    If Timer1.Enabled Then
        ' Horizontal Left Thrusters
        If mLeftThrusterOn Then
            SpriteBlt picWork, picThrustH_s, picThrustH_m, mLander.xPos - mBG.x + 5, mLander.yPos - mBG.y + 40
            mLeftThrusterOn = False
        End If
        
        ' Horizontal Right Thrusters
        If mRightThrusterOn Then
            SpriteBlt picWork, picThrustH_s, picThrustH_m, (mLander.xPos - mBG.x) + (picLander_s.ScaleWidth - picThrustH_m.ScaleWidth) - 5, mLander.yPos - mBG.y + 40
            mRightThrusterOn = False
        End If
        
        ' Bottom Thruster
        If mBottomThrusterOn Then
            SpriteBlt picWork, picThrustV_s, picThrustV_m, mLander.xPos - mBG.x + ((picLander_s.ScaleWidth - picThrustV_s.ScaleWidth) / 2), mLander.yPos - mBG.y + (picLander_s.ScaleHeight - picThrustV_s.ScaleHeight)
            mBottomThrusterOn = False
        End If
    End If
End Sub

Sub EnableThrusterControls (ABoolean As Integer)
'------------------------------------------------------------
' Enable or disable the thruster buttons based on true/false
' value, ABoolean.
'------------------------------------------------------------
    
    btnLeft.Enabled = ABoolean
    btnRight.Enabled = ABoolean
    btnUp.Enabled = ABoolean
End Sub

Sub Form_Load ()
'------------------------------------------------------------
' Prepare the form.
'------------------------------------------------------------
Dim AppPath As String
Dim rc As Integer

    ' Initialize the random number generator.
    Randomize
    
    ' Center the form on the screen.
    Me.Move (Screen.Width - Me.Width) / 2, (Screen.Height - Me.Height) / 2
    
    picViewer.BackColor = BLACK
    
    ' Make sure all bitmaps are set to pixel scale modes.
    ' This is what BitBlt expects.
    picBG.ScaleMode = PIXELS
    picViewer.ScaleMode = PIXELS
    picLander_s.ScaleMode = PIXELS
    picLander_m.ScaleMode = PIXELS
    picPad_s.ScaleMode = PIXELS
    picPad_m.ScaleMode = PIXELS
    picThrustH_s.ScaleMode = PIXELS
    picThrustH_m.ScaleMode = PIXELS
    picThrustV_s.ScaleMode = PIXELS
    picThrustV_m.ScaleMode = PIXELS
    
    ' Load Sound Effects
    AppPath = App.Path
    If Right$(AppPath, 1) <> "\" Then AppPath = AppPath & "\"
    rc = NoiseGet(AppPath & "THRUSTR1.WAV", mSndThrust1)
    rc = NoiseGet(AppPath & "THRUSTR2.WAV", mSndThrust2)
    
    ' Display game information.
    GameInfo
    
    ' Calculate the center of the Viewer.
    mCentered.x = (picViewer.ScaleWidth - picLander_s.ScaleWidth) \ 2
    mCentered.y = (picViewer.ScaleHeight - picLander_s.ScaleHeight) \ 2
End Sub

Sub GameInfo ()
'------------------------------------------------------------
' Display brief playing instructions.
'------------------------------------------------------------
    
    panInfo.Caption = "Use the thruster controls to bring your "
    panInfo.Caption = panInfo.Caption & "Lander to a soft landing on the Target "
    panInfo.Caption = panInfo.Caption & "Pad. The scope at the bottom of the view "
    panInfo.Caption = panInfo.Caption & "screen shows your position relative to the pad."
End Sub

Sub Have_We_Landed (Elevation As Integer, DistanceToTarget As Integer)
'------------------------------------------------------------
' Check to see if the lander has hit the ground yet.
'------------------------------------------------------------
Dim GroundYPos As Integer
    
    ' Have we hit the ground?
    GroundYPos = (picBG.ScaleHeight) - (picPad_s.ScaleHeight \ 2)
    Elevation = GroundYPos - (mLander.yPos + picLander_s.ScaleHeight) + 20
    DistanceToTarget = (mPad.x + (picPad_s.ScaleWidth \ 2)) - (mLander.xPos + (picLander_s.ScaleWidth \ 2))
    
    If (mLander.yPos + picLander_s.ScaleHeight - 20) >= GroundYPos Then
        EnableThrusterControls False
        btnStart.Caption = "&Start"
        mCurrentState = GAME_OVER
        Timer1.Enabled = False
        ShowGameRating mLander.ySpeed, DistanceToTarget, mLander.FuelAmount
    End If
End Sub

Sub Position_Pad ()
'------------------------------------------------------------
' Randomly place the landing pad on the background.
'------------------------------------------------------------

    mPad.x = (picBG.ScaleWidth - picPad_s.ScaleWidth) * Rnd
    mPad.y = picBG.ScaleHeight - picPad_m.ScaleHeight
    
End Sub

Sub ShowGameRating (ByVal Speed As Single, ByVal Distance As Integer, Fuel As Integer)
'------------------------------------------------------------
' When the game is over, rate the player based on amount of
' fuel remaining, distance from the pad, and how softly
' the player touched down.
'------------------------------------------------------------
Dim Rating As Integer
Dim rc As Integer
Dim Info As String
Dim CRLF As String
Dim Direction As String

    CRLF = Chr$(13) & Chr$(10)

    Info = "Rank: "
    
    ' Calculate a numeric rating based on speed, distance
    ' from target, and remaining fuel.
    Rating = Abs(Speed) + Abs(Distance \ 10) + (10 - (Fuel \ 10))
    
    ' Really bad ratings get a "bad" landing noise.
    If Rating < 20 Then
        rc = sndPlaySound(App.Path & "\LAND_OK.WAV", SND_ASYNC)
    Else
        rc = sndPlaySound(App.Path & "\LAND_BAD.WAV", SND_ASYNC)
    End If
    
    ' Assign a "rank" to the player.
    If Rating < 5 Then
        Info = Info & "Captain"
    ElseIf Rating < 10 Then
        Info = Info & "Commander"
    ElseIf Rating < 15 Then
        Info = Info & "Lieutenant"
    ElseIf Rating < 20 Then
        Info = Info & "Ensign"
    ElseIf Rating < 25 Then
        Info = Info & "Freighter Pilot"
    ElseIf Rating < 30 Then
        Info = Info & "Rookie"
    Else
        Info = Info & "Kamikaze"
    End If
    
    ' Give helpful advice and encouragement to the player.
    If Speed < 2 Then
        Info = Info & CRLF & CRLF & "That was a very soft landing. "
    ElseIf Speed < 3.5 Then
        Info = Info & CRLF & CRLF & "That landing was a bit bumpy. "
    ElseIf Speed < 6 Then
        Info = Info & CRLF & CRLF & "Not a bad landing, but keep practicing. "
    ElseIf Speed < 10 Then
        Info = Info & CRLF & CRLF & "Too fast!  Your landing caused minor structural damage to the ship. "
    ElseIf Speed < 20 Then
        Info = Info & CRLF & CRLF & "Ouch!  This lander has major damage. "
    Else
        Info = Info & CRLF & CRLF & "Nice work, loser.  You just totaled another Lander. "
    End If
    
    If Distance > 0 Then
        Direction = "right"
    ElseIf Distance < 0 Then
        Direction = "left"
    End If
    Distance = Abs(Distance)
    
    ' Give still more encouragement and advice to the player.
    If Distance < 7 Then
        Info = Info & CRLF & CRLF & "Your accuracy is amazing. "
    ElseIf Distance < 24 Then
        Info = Info & CRLF & CRLF & "Your accuracy is pretty good. "
    ElseIf Distance < 90 Then
        Info = Info & CRLF & CRLF & "The Target Pad is a little to your " & Direction & ". "
    ElseIf Distance < 200 Then
        Info = Info & CRLF & CRLF & "Have the base doctor fit you with a new pair of glasses. "
    Else
        Info = Info & CRLF & CRLF & "Where the heck were you going?  The Target is way over to your " & Direction & ". "
    End If
    
    panInfo = Info
End Sub

Sub SpriteBlt (Dest As PictureBox, Sprite As PictureBox, Mask As PictureBox, Dx As Integer, Dy As Integer)
'------------------------------------------------------------
' Draw a sprite onto background Dest at x-y locations Dx
' and Dy, using Mask and Sprite.
'------------------------------------------------------------
Dim rc As Integer

    rc = BitBlt(Dest.hDC, Dx, Dy, Mask.ScaleWidth, Mask.ScaleHeight, Mask.hDC, 0, 0, SRCAND)
    rc = BitBlt(Dest.hDC, Dx, Dy, Sprite.ScaleWidth, Sprite.ScaleHeight, Sprite.hDC, 0, 0, SRCPAINT)
End Sub

Sub Timer1_Timer ()
'------------------------------------------------------------
' The Timer event handles most of the game action.
'------------------------------------------------------------
Dim DistanceToTarget As Integer
Dim Elevation As Integer

    ' Adjust the gas gauge.
    Adjust_Fuel
        
    ' Increase ship speed (due to gravity)
    Apply_Gravity
    
    ' Horizontal Inertia
    Apply_Inertia
    
    ' Calculate the ship's next y position.
    Calculate_Lander_Y
    
    ' Have we hit the ground?
    Have_We_Landed Elevation, DistanceToTarget

    ' Update the status indicators on the screen.
    Update_Status Elevation, DistanceToTarget
    
    ' Calculate the ship's next x position.
    Calculate_Lander_X
    
    ' Adjust the background to keep the ship in the center of the screen.
    Adjust_Background
        
    ' Draw the Background into the work area PictureBox.
    Draw_Background

    ' Draw the Lander's thrusters onto the background, if they're on.
    Draw_Thrusters
    
    ' Copy the Lander into the work area bitmap.
    Draw_Lander
    
    ' Copy everything into viewer.
    Update_Viewer
                
    ' Update the scanner at the bottom of the Viewer.
    Update_Scanner
End Sub

Sub Update_Scanner ()
'------------------------------------------------------------
' Update the scanner at the bottom of view screen.
'------------------------------------------------------------
    
    shpLander.Left = ((mLander.xPos + (picLander_s.ScaleWidth \ 2)) / picBG.ScaleWidth) * picScanner.ScaleWidth
    shpPad.Left = ((mPad.x + (picPad_s.ScaleWidth \ 2)) / picBG.ScaleWidth) * picScanner.ScaleWidth
End Sub

Sub Update_Status (Elevation As Integer, DistanceToTarget As Integer)
'------------------------------------------------------------
' Update the status indicators on the screen.
'------------------------------------------------------------
    
    lblDescent = Format$(mLander.ySpeed, "00.00") & " mps"
    If Elevation > 0 Then
        lblElevation = Format$(Elevation) & " m"
    Else
        lblElevation = "0 m"
    End If
    If DistanceToTarget > 0 Then
        lblTargetLoc = Format$(Abs(DistanceToTarget)) & " m Stbd"
    ElseIf DistanceToTarget < 0 Then
        lblTargetLoc = Format$(Abs(DistanceToTarget)) & " m Port"
    Else
        lblTargetLoc = "Directly Below"
    End If
End Sub

Sub Update_Viewer ()
'------------------------------------------------------------
' Copy everything into viewer.
'------------------------------------------------------------
Dim rc As Integer

    rc = BitBlt(picViewer.hDC, 0, 0, picViewer.ScaleWidth, picViewer.ScaleHeight, picWork.hDC, 0, 0, SRCCOPY)
End Sub

