Option Explicit
'------------------------------------------------------------
' LANDER.BAS
'------------------------------------------------------------

' Data type that stores information about the
' state of the lander.
Type tLander
    xPos As Integer
    yPos As Integer
    xSpeed As Single
    ySpeed As Single
    FuelAmount As Integer
End Type

' Data type to store x-y coordinates.
Type tPosition
    x As Integer
    y As Integer
End Type

' ScaleMode property constant
Global Const PIXELS = 3

' Constants used in BitBlt Windows API Call
Global Const SRCCOPY = &HCC0020
Global Const SRCAND = &H8800C6
Global Const SRCPAINT = &HEE0086

' Windows API call used to copy bitmaps
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal DestX As Integer, ByVal DestY As Integer, ByVal DestWidth As Integer, ByVal DestHeight As Integer, ByVal hSrcDC As Integer, ByVal SrcX As Integer, ByVal SrcY As Integer, ByVal RasterOp As Long) As Integer

' Functions and constants used to play sounds.
Global Const SND_SYNC = &H0        ' Return when sound ends (the default)
Global Const SND_ASYNC = &H1       ' Return as soon as sound starts
Global Const SND_NODEFAULT = &H2   ' Don't play default sound if not found
Global Const SND_MEMORY = &H4      ' lpszSoundName -> memory image of file
Global Const SND_LOOP = &H8        ' Loop continuously; needs SND_ASYNC
Global Const SND_NOSTOP = &H10     ' Don't interrupt sound to play new one

Declare Function sndPlaySound Lib "MMSystem" (ByVal lpsound As String, ByVal flag As Integer) As Integer
Declare Function sndKillSound Lib "MMSystem" Alias "sndPlaySound" (ByVal lpszNull As Long, ByVal flags As Integer) As Integer

Function NoiseGet (ByVal FileName, ASoundBuffer As String) As Integer
'------------------------------------------------------------
' Load a sound file into the global string variable
' SoundBuffer.  This must be called before NoisePlay
'------------------------------------------------------------
Dim buffer As String
Dim f As Integer

    On Error GoTo NoiseGet_Error

    buffer = Space$(1024)
    ASoundBuffer = ""
    f = FreeFile
    Open FileName For Binary As f
    Do While Not EOF(f)
        Get #f, , buffer     ' Load in 1K chunks
        ASoundBuffer = ASoundBuffer & buffer
    Loop
    Close f
    ASoundBuffer = Trim$(ASoundBuffer)

Exit Function

NoiseGet_Error:
    NoiseGet = False
    ASoundBuffer = ""
    Exit Function
End Function

Sub NoisePlay (ASoundBuffer As String)
'------------------------------------------------------------
' Plays a sound previously loaded into memory with function
' NoiseGet().
'------------------------------------------------------------
Dim r As Integer  ' asynchronously

    If ASoundBuffer = "" Then Exit Sub
    r = sndPlaySound(ASoundBuffer, SND_ASYNC Or SND_MEMORY)

End Sub

