VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Press Up, Down, Left, Right, or Space"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer tmrCheckFlags 
      Interval        =   1
      Left            =   120
      Top             =   2640
   End
   Begin VB.Label lblKeys 
      AutoSize        =   -1  'True
      Height          =   195
      Left            =   1800
      TabIndex        =   0
      Top             =   1320
      Width           =   45
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'(C) Richard C. Yarnell
'    ryarnell@andrew.cmu.edu

'This project shows how to set flags when keystrokes are pressed so
'you can monitor certain keys and allow your program to act accordingly.

'variable to keep track of keys pressed
Dim iKeys As Integer

'CONSTs to be used as the flags.  These all must be different powers of 2.
Const KEY_UP_FLAG = 1
Const KEY_RIGHT_FLAG = 2
Const KEY_DOWN_FLAG = 4
Const KEY_LEFT_FLAG = 8
Const KEY_SPACE_FLAG = 16
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
'Branch depending upon which key is being pressed.

'OR the iKeys variable with the appropriate flag so the iKeys variable now
'contains whatever flags were in it before and the new flag for the key pressed.
Select Case KeyCode
    Case vbKeyUp: iKeys = (iKeys Or KEY_UP_FLAG)
    Case vbKeyRight: iKeys = (iKeys Or KEY_RIGHT_FLAG)
    Case vbKeyDown: iKeys = (iKeys Or KEY_DOWN_FLAG)
    Case vbKeyLeft: iKeys = (iKeys Or KEY_LEFT_FLAG)
    Case vbKeySpace: iKeys = (iKeys Or KEY_SPACE_FLAG)
End Select

'Detailed description of how flags are set:
'This is not necessary to read.  It is just a detailed explanation of the
'above code intended to give a fuller understanding of how such flags work.

'The flag CONSTs are all powers of 2.  So in binary each has exactly one 1 bit.
'(Assume all variables are integers which consist of 16 bits.)
'KEY_UP_FLAG    =  1 = 0000000000000001
'KEY_RIGHT_FLAG =  2 = 0000000000000010
'KEY_DOWN_FLAG  =  4 = 0000000000000100
'KEY_LEFT_FLAG  =  8 = 0000000000001000
'KEY_SPACE_FLAG = 16 = 0000000000010000

'When a key is pressed, the iKeys variable is ORed with the appropriate flag.
'The result is stored back in iKeys.

'Let's assume that we start with iKeys(in binary) = abcdefghijklmnop.
'The letters a through p just represent what the bits in iKeys are,
'or in other words what flags are currently set.

'Now the down arrow key is pressed.
'iKeys is ORed with KEY_DOWN_FLAG and the result is stored in iKeys.

'iKeys          = abcdefghijklmnop
'KEY_DOWN_FLAG  = 0000000000000100
'              OR ----------------
'                 abcdefghijklm1op

'Anything ORed with 0 is just itself.
'Anything ORed with 1 is always 1.
'The bits are ORed individually, so when all the original bits are ORed
'with 0, they remain as they were.  But when the 3rd bit from the right is
'ORed with the 1 in KEY_DOWN_FLAG, the result is 1, which is stored back in iKeys,
'effectively setting that flag.

'To see how flags are unset or read, see Form_KeyUp and tmrCheckFlags_Timer.
End Sub
Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
'Branch depending upon which key is being released.

'AND the iKeys variable with the negated appropriate flag
'so the iKeys variable now contains whatever flags were
'in it before minus the flag for the key being released.
Select Case KeyCode
    Case vbKeyUp: iKeys = (iKeys And Not KEY_UP_FLAG)
    Case vbKeyRight: iKeys = (iKeys And Not KEY_RIGHT_FLAG)
    Case vbKeyDown: iKeys = (iKeys And Not KEY_DOWN_FLAG)
    Case vbKeyLeft: iKeys = (iKeys And Not KEY_LEFT_FLAG)
    Case vbKeySpace: iKeys = (iKeys And Not KEY_SPACE_FLAG)
End Select

'Detailed description of how flags are unset:
'This is not necessary to read.  It is just a detailed explanation of the
'above code intended to give a fuller understanding of how such flags work.

'The flag CONSTs are all powers of 2.  So in binary each has exactly one 1 bit.
'(Assume all variables are integers which consist of 16 bits.)
'KEY_UP_FLAG    =  1 = 0000000000000001
'KEY_RIGHT_FLAG =  2 = 0000000000000010
'KEY_DOWN_FLAG  =  4 = 0000000000000100
'KEY_LEFT_FLAG  =  8 = 0000000000001000
'KEY_SPACE_FLAG = 16 = 0000000000010000

'When a key is released, the iKeys variable is ANDed with the
'negation of the appropriate flag.  The result is stored back in iKeys.

'Let's assume that we start with iKeys(in binary) = abcdefghijklm1op.
'The letters a through p just represent what the bits in iKeys are,
'or in other words what flags are currently set.  There is a 1 in the
'third bit from the right, indicating that the KEY_DOWN_FLAG is currently set.

'Now the down arrow key is released.
'iKeys is ANDed with the negation of KEY_DOWN_FLAG and
'the result is stored in iKeys.

'iKeys              = abcdefghijklm1op
'not KEY_DOWN_FLAG  = 1111111111111011  (just reverse all bits)
'                 AND ----------------
'                     abcdefghijklm0op

'Anything ANDed with 1 is just itself.
'Anything ANDed with 0 is always 0.
'The bits are ANDed individually, so when all the original bits are ANDed
'with 1, they remain as they were.  But when the 3rd bit from the right is
'ANDed with the 0 in the negated KEY_DOWN_FLAG, the result is 0,
'which is stored back in iKeys, effectively unsetting that flag.

'To see how flags are set or read, see Form_KeyDown and tmrCheckFlags_Timer.
End Sub
Private Sub tmrCheckFlags_Timer()
'Clear the label.
lblKeys.Caption = ""

'See which flags are set and show which keys are pressed in the label.
'AND the iKeys variable with each flag to see which flags it contains.
If (iKeys And KEY_UP_FLAG) = KEY_UP_FLAG Then lblKeys.Caption = lblKeys.Caption & "UP" & vbCrLf
If (iKeys And KEY_RIGHT_FLAG) = KEY_RIGHT_FLAG Then lblKeys.Caption = lblKeys.Caption & "RIGHT" & vbCrLf
If (iKeys And KEY_DOWN_FLAG) = KEY_DOWN_FLAG Then lblKeys.Caption = lblKeys.Caption & "DOWN" & vbCrLf
If (iKeys And KEY_LEFT_FLAG) = KEY_LEFT_FLAG Then lblKeys.Caption = lblKeys.Caption & "LEFT" & vbCrLf
If (iKeys And KEY_SPACE_FLAG) = KEY_SPACE_FLAG Then lblKeys.Caption = lblKeys.Caption & "SPACE" & vbCrLf

'Detailed description of how flags are read:
'This is not necessary to read.  It is just a detailed explanation of the
'above code intended to give a fuller understanding of how such flags work.

'The flag CONSTs are all powers of 2.  So in binary each has exactly one 1 bit.
'(Assume all variables are integers which consist of 16 bits.)
'KEY_UP_FLAG    =  1 = 0000000000000001
'KEY_RIGHT_FLAG =  2 = 0000000000000010
'KEY_DOWN_FLAG  =  4 = 0000000000000100
'KEY_LEFT_FLAG  =  8 = 0000000000001000
'KEY_SPACE_FLAG = 16 = 0000000000010000

'When a flag is read, the iKeys variable is ANDed with the appropriate flag.
'The result is then compared to the same flag.  If they match, it is known
'that that flag is set.

'Let's assume that we start with iKeys (in binary) = abcdefghijklmnop.
'The letters a through p just represent what the bits in iKeys are,
'or in other words what flags are currently set.  Each letter may represent
'a 0 or a 1.


'We want to see if KEY_DOWN_FLAG is set.
'iKeys is ANDed with KEY_DOWN_FLAG and the result is compared to KEY_DOWN_FLAG.

'iKeys          = abcdefghijklmnop
'KEY_DOWN_FLAG  = 0000000000000100
'             AND ----------------
'                 0000000000000n00

'Anything ANDed with 1 is just itself.
'Anything ANDed with 0 is always 0.
'The bits are ANDed individually, so when all the original bits are ANDed
'with 0, they become 0s.  But when the 3rd bit from the right is ANDed
'with the 1 in KEY_DOWN_FLAG, the result is whatever that bit was
'originally in iKeys.

'So the result is 0000000000000100 (or KEY_DOWN_FLAG) if that flag
'was set and 0000000000000000 if it was not.  Just compare this result with
'KEY_DOWN_FLAG to determine whether or not the flag was set.

'To see how flags are set or unset, see Form_KeyDown and Form_KeyUp.
End Sub
