Attribute VB_Name = "VisualEffects"
Private Type Anims
  Active As Boolean
  Position As Point3D
  SpriteNum As Integer
  CurrentFrame As Integer
End Type
Global Const MaxAnims = 200
Global Animations(MaxAnims) As Anims
Global AnimsActive As Integer
Type Spark
  Position As Point3D
  Health As Integer
  Active As Boolean
  Pallete As Integer
  Yaw As Integer
  Speedup As Single
  Speed As Single
  Decay As Integer
  Weight As Integer
End Type
Global Const MaxSparks = 500
Global Sparks(MaxSparks) As Spark
Global SparksActive As Integer
Type Sparkler
  Position As Point3D
  Health As Integer
  Active As Boolean
  Pallete As Integer
  Yaw As Integer
  Speedup As Single
  Speed As Single
  Decay As Integer
  Weight As Single
End Type
Global Const MaxSparkles = 500
Global Sparkles(MaxSparkles) As Sparkler
Global SparklesActive As Integer
Type Fire
  Position As Point3D
  Health As Integer
  Active As Boolean
  Size As Integer
  Decay As Integer
End Type
Global Const MaxFires = 500
Global Fires(MaxFires) As Fire
Global FiresActive As Integer
Type AnimSpewer
  Position As Point3D
  Health As Integer
  Active As Boolean
  Size As Integer
  SpriteNum As Integer
End Type
Global Const MaxAnimSpewers = 500
Global AnimSpewers(MaxAnimSpewers) As AnimSpewer
Global AnimSpewersActive As Integer
Public Sub SpawnAnimationSpewer(X, Y, SpriteNum, Size, Duration)
For I = 1 To MaxAnimSpewers
  If AnimSpewers(I).Active = False Then
    CurrAnimSpewer = I
    Exit For
  End If
Next I
With AnimSpewers(CurrAnimSpewer)
  .Active = True
  .Position.X = X
  .Position.Y = Y
  .Position.Z = 0
  .Health = Duration
  .Size = Size
  .SpriteNum = SpriteNum
End With
If AnimSpewersActive < CurrAnimSpewer Then AnimSpewersActive = CurrAnimSpewer
End Sub
Public Sub RunVisualEffects()
Call RunFires
Call RunSparks
Call RunSparkles
Call RunAnimations
Call RunAnimationSpewers
End Sub
Public Sub RunAnimationSpewers()
For I = 1 To AnimSpewersActive
  If AnimSpewers(I).Active = True Then
    With AnimSpewers(I)
      .Health = .Health - 1
      If .Health < 1 Then .Active = False
      If Int(2 * Rnd) = 1 Then
        Call SpawnAnimation(.Position.X + Int((.Size * Rnd) - (.Size / 2)), .Position.Y + Int((.Size * Rnd) - (.Size / 2)), .SpriteNum)
      End If
    End With
  End If
Next I
End Sub
Public Sub RunFires()
For I = 1 To FiresActive
  If Fires(I).Active = True Then
    With Fires(I)
      .Health = .Health - .Decay
      If .Health < 1 Then .Active = False
      For I2 = 1 To .Size
        Call SpawnSpark(.Position.X, .Position.Y, .Position.Z, PALLETE_YELLOW, 360 * Rnd, 1.5, 35, 4, 0)
      Next I2
    End With
  End If
Next I
End Sub
Public Sub SpawnFire(X, Y, Z, Size, Decay)
For I = 1 To MaxFires
  If Fires(I).Active = False Then
    CurrFire = I
    Exit For
  End If
Next I
With Fires(CurrFire)
  .Active = True
  .Position.X = X
  .Position.Y = Y
  .Position.Z = Z
  .Health = 100
  .Decay = Decay
  .Size = Size
End With
If FiresActive < CurrFire Then FiresActive = CurrFire
End Sub
Public Sub SpawnSparkleExplosion(X, Y, Z, Pallete, Number)
For I = 1 To Number
  Call SpawnSparkle(X, Y, Z, Pallete, Int(360 * Rnd), 3, 20, 3, 1)
Next I
End Sub
Public Sub SpawnSparkle(X, Y, Z, Pallete, Yaw, SpeedMax, Decay, Speedup, Weight)
For I = 1 To MaxSparkles
  If Sparkles(I).Active = False Then
    CurrSparkle = I
    Exit For
  End If
Next I
With Sparkles(CurrSparkle)
  .Active = True
  .Speedup = (Speedup * Rnd) + 3
  .Position.X = X
  .Position.Y = Y
  .Position.Z = Z
  .Yaw = Yaw
  .Health = 255
  .Pallete = Pallete
  .Speed = (SpeedMax * Rnd) + 1
  .Decay = Decay
  .Weight = Weight
End With
If SparklesActive < CurrSparkle Then SparklesActive = CurrSparkle
End Sub

Public Sub SpawnSparkExplosion(X, Y, Z, Pallete, Size, Intensity)
For I = 1 To Intensity
  Call SpawnSpark(X, Y, Z, Pallete, Int(360 * Rnd), Size, 20, 6, 1)
Next I
End Sub
Public Sub SpawnSparkDirectionalExplosion(X, Y, Z, Pallete, Size, Intensity, Direction)
For I = 1 To Intensity
  Call SpawnSpark(X, Y, Z, Pallete, CheckYaw(Direction + (Int(140 * Rnd) - 80)), Size, 20, 4, 1)
Next I
End Sub
Public Sub SpawnSpark(X, Y, Z, Pallete, Yaw, SpeedMax, Decay, Speedup, Weight)
For I = 1 To MaxSparks
  If Sparks(I).Active = False Then
    CurrSpark = I
    Exit For
  End If
Next I
With Sparks(CurrSpark)
  .Active = True
  .Speedup = (Speedup * Rnd) + 0.3
  .Position.X = X
  .Position.Y = Y
  .Position.Z = Z
  .Yaw = Yaw
  .Health = 255
  .Pallete = Pallete
  .Speed = SpeedMax * Rnd + 0.01
  .Decay = Decay
  .Weight = Weight
End With
If SparksActive < CurrSpark Then SparksActive = CurrSpark
End Sub
Public Sub RunSparkles()
For I = 1 To SparklesActive
  With Sparkles(I)
    If .Active = True Then
      .Health = .Health - .Decay
      .Position = Math.GetPropelCoordinates(.Position, .Yaw, 0, .Speed)
      .Position.Z = .Position.Z + .Speedup
      .Speedup = .Speedup - .Weight
      Call SpawnSpark(.Position.X, .Position.Y, .Position.Z, .Pallete, 360 * Rnd, 1, 50, 0, 0.5)
      If .Position.Z < 0 Then
        .Position.Z = 0
        .Speed = .Speed / 1.2
      End If
      If .Health < 1 Then
        .Active = False
        For I2 = 1 To SparklesActive
          If Sparkles(I2).Active = True Then
            SparklesNum = I2
          End If
        Next I2
        SparklesActive = SparklesNum
      End If
    End If
  End With
Next I
End Sub

Public Sub RunSparks()
For I = 1 To SparksActive
  With Sparks(I)
    If .Active = True Then
      .Health = .Health - .Decay
      .Position = Math.GetPropelCoordinates(.Position, .Yaw, 0, .Speed)
      .Position.Z = .Position.Z + .Speedup
      .Speedup = .Speedup - .Weight
      If .Position.Z < 0 Then
        .Position.Z = 0
        .Speed = .Speed / 1.2
      End If
      If .Health < 1 Then
        .Active = False
        For I2 = 1 To SparksActive
          If Sparks(I2).Active = True Then
            SparksNum = I2
          End If
        Next I2
        SparksActive = SparksNum
      End If
    End If
  End With
Next I
End Sub
Public Sub RunAnimations()
For I = 1 To AnimsActive
  With Animations(I)
    If .Active = True Then
      .CurrentFrame = .CurrentFrame + 1
      If .CurrentFrame > Sprites(.SpriteNum).SpriteGroups(1).FrameMax Then
        .Active = False
        For I2 = 1 To AnimsActive
          If Animations(I2).Active = True Then
            AnimNum = I2
          End If
        Next I2
        AnimsActive = AnimNum
      End If
    End If
  End With
Next I
End Sub
Public Sub SpawnAnimation(X, Y, SpriteNum)
For I = 1 To MaxAnims
  If Animations(I).Active = False Then
    CurrAnim = I
    Exit For
  End If
Next I
With Animations(CurrAnim)
  .Active = True
  .Position.X = X
  .Position.Y = Y
  .SpriteNum = SpriteNum
  .CurrentFrame = 1
End With
If AnimsActive < CurrAnim Then AnimsActive = CurrAnim
End Sub
Public Sub Effect_RailgunTrail(SourcePoint As Point3D, DestinationPoint As Point3D)
Dim DrawPoint As Point3D
Const StepDistance = 2
Yaw = Math.GetYawFromPoints(SourcePoint, DestinationPoint)
DrawPoint = SourcePoint
For I = 1 To Math.GetDistance(SourcePoint, DestinationPoint) / StepDistance
  DrawPoint.X = DrawPoint.X + (SinTable(Yaw) * StepDistance)
  DrawPoint.Y = DrawPoint.Y + (CosTable(Yaw) * StepDistance)
  TrailRotation = TrailRotation + 60
  If TrailRotation > 360 Then TrailRotation = TrailRotation - 360
  XOffset = SinTable(TrailRotation)
  YOffset = CosTable(TrailRotation)
  If Int(2 * Rnd) = 1 Then Call SpawnSpark(DrawPoint.X, DrawPoint.Y, 4, PALLETE_RED, Int(360 * Rnd), 0.1, 15, 0, 0)
  Call SpawnSpark(DrawPoint.X + XOffset, DrawPoint.Y + YOffset, 5, PALLETE_SKYBLUE, TrailRotation, 0.3, 15, 0, 0)
Next I
End Sub
