Attribute VB_Name = "SpriteStuff"
Global Const PALLETE_RED = 1
Global Const PALLETE_GREEN = 2
Global Const PALLETE_BLUE = 3
Global Const PALLETE_WHITE = 4
Global Const PALLETE_YELLOW = 5
Global Const PALLETE_SKYBLUE = 6

Global Const NOSPRITE = -999

Global Const MAXPICZ = 200
Global Const MAXLIBS = 100
Private Type GrphxLib
  Active As Boolean
  LibName As String
  Width As Integer
  Height As Integer
  HalfWidth As Integer
  HalfHeight As Integer
End Type
Global GraphicsLibs(MAXLIBS) As GrphxLib
Type SpriteDefType
  SpriteNumber As Integer
  SpriteGroupNumber As Integer
  SpriteFrameNumber As Integer
  SpriteFrameTicks As Integer
End Type
Private Type Pcz
  Active As Boolean
  GraphicsLib As Integer
  SourceRect As RECT
  Width As Integer
  Height As Integer
  HalfWidth As Integer
  HalfHeight As Integer
  PicName As String
End Type
Global Pics(MAXPICZ) As Pcz
Private Type Frme
  PicNum As Integer
  FrameDuration As Integer
  FrameName As String
End Type
Global Const MAXSPRITEFRAMES = 10
Private Type SpriteGrps
  GroupName As String
  Frames(1 To MAXSPRITEFRAMES) As Frme
  FrameMax As Integer
  RepeatSequence As Boolean
End Type
Global Const MAXSPRITEGROUPS = 10
Private Type Spritez
  Active As Boolean
  SpriteName As String
  SpriteGroups(0 To MAXSPRITEGROUPS) As SpriteGrps
  SpriteGroupMax As Integer
End Type
Global Const MAXSPRITES = 100
Global Sprites(0 To MAXSPRITES) As Spritez
Global SpriteMax As Integer
Public Function GetSpriteIndex(SpriteName$) As Integer
GetSpriteIndex = -999
For I = 1 To MAXSPRITES
  If Sprites(I).Active = True Then
    If Sprites(I).SpriteName = SpriteName$ Then
      GetSpriteIndex = I
      Exit For
    End If
  End If
Next I
End Function
Public Function GetPicIndex(PName)
GetPicIndex = -1
For I = 1 To MAXPICZ
  If Pics(I).Active = True Then
    If Pics(I).PicName = PName Then
      GetPicIndex = I
      Exit For
    End If
  End If
Next I
End Function
Public Function GetGraphicsLibIndex(PName)
GetGraphicsLibIndex = -1
For I = 1 To MAXLIBS
  If GraphicsLibs(I).Active = True Then
    If GraphicsLibs(I).LibName = PName Then
      GetGraphicsLibIndex = I
      Exit For
    End If
  End If
Next I
End Function
Public Sub LoadSpriteData()
SpriteMax = 0
For I = 1 To MAXSPRITES
  Sprites(I).Active = False
Next I
Call FileFunctions.OpenGameFile(File_SpriteDefinitions, 1)
Do
  Line Input #1, a$
  propvalue$ = MiscFunctions.GetPropertyValue(a$)
  Select Case MiscFunctions.GetPropertyName(a$)
  Case FILETAG_ENDFILE
    Exit Do
  Case "[SPRITEDEF]"
    SpriteMax = SpriteMax + 1
    Sprites(SpriteMax).SpriteGroupMax = 0
    Sprites(SpriteMax).Active = True
    Line Input #1, a$
    Sprites(SpriteMax).SpriteName = GetPropertyValue(a$)
    Do
      Line Input #1, a$
      Select Case MiscFunctions.GetPropertyName(a$)
      Case "[ENDSPRITEDEF]"
        Exit Do
      Case "-FRAMEGROUP-"
        Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).FrameMax = 0
        Sprites(SpriteMax).SpriteGroupMax = Sprites(SpriteMax).SpriteGroupMax + 1
        Line Input #1, a$
        Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).GroupName = GetPropertyValue(a$)
        Line Input #1, a$
        Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).RepeatSequence = ConvertTrueFalse(a$)
        Do
          Line Input #1, a$
          Select Case MiscFunctions.GetPropertyName(a$)
          Case "-ENDFRAMEGROUP-"
            Exit Do
          Case "-FRAME-"
            Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).FrameMax = Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).FrameMax + 1
            Line Input #1, a$
            Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).Frames(Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).FrameMax).FrameName = GetPropertyValue(a$)
            Line Input #1, a$
            Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).Frames(Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).FrameMax).FrameDuration = Val(GetPropertyValue(a$))
            Line Input #1, a$
            Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).Frames(Sprites(SpriteMax).SpriteGroups(Sprites(SpriteMax).SpriteGroupMax).FrameMax).PicNum = SpriteStuff.GetPicIndex(GetPropertyValue(a$))
          End Select
        Loop
      End Select
    Loop
  End Select
Loop
Close #1
End Sub
Public Sub LoadPictureData()
'Loads all the picture definitions for the game
'like the X and Ys of them.
Libnum = 0
Call FileFunctions.OpenGameFile(File_PictureDefinitions, 3)
  Do
    Line Input #3, a$
    Select Case a$
    Case FILETAG_ENDFILE
      Exit Do
    Case "[PICDEF]"
      PicNum = PicNum + 1
      Pics(PicNum).Active = True
      Line Input #3, a$
      Pics(PicNum).PicName = MiscFunctions.GetPropertyValue(a$)
      Line Input #3, a$
      Pics(PicNum).GraphicsLib = GetGraphicsLibIndex(MiscFunctions.GetPropertyValue(a$))
      Line Input #3, a$
      Pics(PicNum).SourceRect.Left = Val(MiscFunctions.GetPropertyValue(a$))
      Line Input #3, a$
      Pics(PicNum).SourceRect.Top = Val(MiscFunctions.GetPropertyValue(a$))
      Line Input #3, a$
      Pics(PicNum).Width = Val(MiscFunctions.GetPropertyValue(a$))
      Pics(PicNum).HalfWidth = Int(Pics(PicNum).Width / 2)
      Pics(PicNum).SourceRect.Right = Pics(PicNum).SourceRect.Left + Pics(PicNum).Width
      Line Input #3, a$
      Pics(PicNum).Height = Val(MiscFunctions.GetPropertyValue(a$))
      Pics(PicNum).HalfHeight = Int(Pics(PicNum).Height / 2)
      Pics(PicNum).SourceRect.bottom = Pics(PicNum).SourceRect.Top + Pics(PicNum).Height
    End Select
  Loop
Close #3
End Sub
Public Sub LoadGraphicLibData()
'Loads all the picture files for the game
Libnum = 0
Call FileFunctions.OpenGameFile(File_GraphicLibDefinitions, 3)
  Do
    Line Input #3, a$
    Select Case a$
    Case FILETAG_ENDFILE
      Exit Do
    Case "[GRAPHICSLIBRARYDEF]"
      Libnum = Libnum + 1
      GraphicsLibs(Libnum).Active = True
      Line Input #3, a$
      GraphicsLibs(Libnum).LibName = MiscFunctions.GetPropertyValue(a$)
      Line Input #3, a$
      Filename = MiscFunctions.GetPropertyValue(a$)
      Call GraphicsEngine.LoadGraphic(Libnum, Directory_GameData & Directory_Graphics & Filename)
    End Select
  Loop
Close #3
End Sub
Public Sub UnloadGraphicLibraries()
For I = 1 To MAXLIBS
  If GraphicsLibs(I).Active = True Then
    GraphicsLibs(I).Active = False
    Set GraphicSurfaces(I) = Nothing
  End If
Next I
End Sub
