Attribute VB_Name = "Program"
Type ProgramDat
  UsesSystemMemoryForBackbuffer As Boolean
End Type
Global ProgramData As ProgramDat
Sub LoadVersion()
Open Directory_GameData & GameEngine.GameDataFile$ For Input As #1
  Line Input #1, a$
  VERSION = MiscFunctions.GetPropertyValue(a$)
Close #1
End Sub
Sub LoadGamePatch()
ProgramData.UsesSystemMemoryForBackbuffer = MiscFunctions.ConvertTrueFalse(FileFunctions.GetPropertyValueFromFile(File_Patch, "UsesSystemMemoryForBackBuffer:"))
End Sub
Sub Initialize_Program()
Call GameEngine.Initialize_GameEngine
Call GameEngine.Initialize_GameWindows
CHARACTER_QOUTE = Chr$(34)
GameEngine.GameDataFile$ = Directory_DefaultGameData
Call Math.InitializeTables
Call ProcessCommandLineArguements
Call LoadGamePatch
Call LoadGameINI
Call GraphicsEngine.OpenGraphicsDevice
Call Sound.InitializeSound
Call LoadJPIData
Call LoadInGameConstants
GameInterface.Mouse.CursorPic = SpriteStuff.GetPicIndex("CURSOR_SELECT")
Call LoadVersion
End Sub
Sub LoadInGameConstants()
InGameConstants(InGameConstant_PICINDEX_FontLib) = SpriteStuff.GetGraphicsLibIndex("Font")
InGameConstants(InGameConstant_PICINDEX_MessageWindowPic) = SpriteStuff.GetPicIndex("MessageWindowPic")
InGameConstants(InGameConstant_PICINDEX_ControlPanelBackground) = SpriteStuff.GetPicIndex("ControlPanelBackground")
InGameConstants(InGameConstant_PICINDEX_ClearBackground) = SpriteStuff.GetPicIndex("ProgramBackground")
InGameConstants(InGameConstant_PICINDEX_RadarBackground) = SpriteStuff.GetPicIndex("RadarBackground")
InGameConstants(InGameConstant_PICINDEX_JPILogoRed) = SpriteStuff.GetPicIndex("JPILogoRed")
InGameConstants(InGameConstant_PICINDEX_ProgramBackground) = SpriteStuff.GetPicIndex("InterfaceBackground")
InGameConstants(InGameConstant_PICINDEX_RadarButtonPic) = SpriteStuff.GetPicIndex("RadarButton")
InGameConstants(InGameConstant_PICINDEX_BuildDisabledPic) = SpriteStuff.GetPicIndex("BuildDisabledPic")
InGameConstants(InGameConstant_PICINDEX_BuildReadyPic) = SpriteStuff.GetPicIndex("BuildReadyPic")
InGameConstants(InGameConstant_PICINDEX_ButtonLarge) = SpriteStuff.GetPicIndex("INTERFACE_BUTTONLARGE")
End Sub
Sub LoadJPIData()
Call SpriteStuff.LoadGraphicLibData
Call SpriteStuff.LoadPictureData
Call SpriteStuff.LoadSpriteData
Call Music.InitializeMusic
Call Entities.LoadMapImprints
Call Sound.LoadSoundData
Call Entities.LoadObjectData
Call Map.LoadSeasonProfiles
End Sub
Sub Main()
Call ProgramScript
End Sub
Sub LaunchAboutScreen()
Call GameInterface.ClearMouseButtons
texty = ResolutionMidY - 100 + 3
Do
  TextPos = 0
  Call GraphicsEngine.ClearBackBuffer
  Call GraphicsEngine.SplashGraphic(InGameConstants(InGameConstant_PICINDEX_ProgramBackground))
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("-xion is-", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("Michael " & CHARACTER_QOUTE & "ZBAD" & CHARACTER_QOUTE & " Jennings", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("Programmer", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("3D Graphics", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("John " & CHARACTER_QOUTE & "DARK" & CHARACTER_QOUTE & " Sampson", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("Game Design", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("Storyline", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("-EXTREMELY special Thanks to-", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("Incredible help: Mark Davis", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("Beta tester: Dave Scouten", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  Call GraphicsEngine.SwapScreen
  DoEvents
  If Mouse.ButtonStates(1) = True Then
    Call GameInterface.ClearMouseButtons
    Exit Do
  End If
Loop

Do
  TextPos = 0
  Call GraphicsEngine.ClearBackBuffer
  Call GraphicsEngine.SplashGraphic(InGameConstants(InGameConstant_PICINDEX_ProgramBackground))
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("Very very special thanks:", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("Dave " & CHARACTER_QOUTE & "ZoneMaster" & CHARACTER_QOUTE & " Scouten", texty + (TextPos * FONT_SPACINGY), PALLETE_YELLOW)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("You have no idea how many times", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("he let me crash his computer and", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("didn't complain he he he", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("PATRICE SCRIBE", texty + (TextPos * FONT_SPACINGY), PALLETE_YELLOW)
  TextPos = TextPos + 1
  Call DisplayTextCenter("for bringing directx", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  Call DisplayTextCenter("to visual basic", texty + (TextPos * FONT_SPACINGY), PALLETE_WHITE)
  TextPos = TextPos + 1
  TextPos = TextPos + 1
  Call DisplayTextCenter("-Xion-", texty + (TextPos * FONT_SPACINGY), PALLETE_YELLOW)
  
  
  Call GraphicsEngine.SwapScreen
  DoEvents
  If Mouse.ButtonStates(1) = True Then
    Call GameInterface.ClearMouseButtons
    Exit Do
  End If
Loop

End Sub
Sub ShowInformation()
WndTxt = ""
WndTxt = WndTxt & "          -XION-          "
WndTxt = WndTxt & "This is a beta version of "
WndTxt = WndTxt & "     Jump-Point: Ion.     "
WndTxt = WndTxt & "                          "
WndTxt = WndTxt & "       ICQ: 3565855       "
WndTxt = WndTxt & "   digital-zbad@usa.net   "
Call PopupMessageWindow("JPI " & VERSION, WndTxt)
End Sub
Sub ProgramScript()
Call Initialize_Program
Call ShowLoadingScreen
Call ShowInformation
ProgScript:
Call GameInterface.ClearMouseButtons
MenuItemPressed = LaunchMainMenu
Select Case MenuItemPressed
Case 3
  Call ShowLoadingScreen
  Call GameEngine.StartNewGame(1, 1, FACTION_EDF)
  GoTo ProgScript:
Case 7
  Call Internet.NewInternetGameConsole
  GoTo ProgScript:
Case 9
  Call LaunchAboutScreen
  GoTo ProgScript:
Case 10
  Call Program.QuitProgram
Case Else
  GoTo ProgScript:
End Select
End Sub
Sub ShowLoadingScreen()
Call GraphicsEngine.SplashGraphic(InGameConstants(InGameConstant_PICINDEX_ProgramBackground))
MessageWindow.Caption = "JPI"
MessageWindow.Text = "Loading..."
Call GraphicsEngine.DisplayMessageWindow
Call SwapScreen
End Sub

Function LaunchMainMenu() As Integer
Dim MenuInterface As GameInterface.InterfaceObj, ReturnedInterface As InterfaceReturnObj
texty = (GameInterface.HALFINTERFACEHEIGHT - 95) + 1
PicY = texty + (1 * FONT_SPACINGY) + (FONT_SPACINGY / 2)
FontX = GameInterface.HALFINTERFACEWIDTH - 58
FontY = (texty) + Pics(InGameConstants(InGameConstant_PICINDEX_JPILogoRed)).Height + 4
BTNSIZE = FONT_SPACINGY - 1
TEXTSPACING = FONT_SPACINGY + 3
MenuInterface.BackgroundPic = InGameConstants(InGameConstant_PICINDEX_ProgramBackground)
MenuInterface.Controls.ControlAmount = 13
ControlNumber = ControlNumber + 1
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(GameInterface.CONTROLTYPE_PICTUREBOX, GameInterface.HALFINTERFACEWIDTH, PicY, Pics(InGameConstants(InGameConstant_PICINDEX_JPILogoRed)).Width, Pics(InGameConstants(InGameConstant_PICINDEX_JPILogoRed)).Height, InGameConstants(InGameConstant_PICINDEX_JPILogoRed))
ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Single player"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_LABEL, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Start New Game"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Save Game"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Load Game"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

linenumber = linenumber + 1

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Multiplayer"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_LABEL, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Connect To Server"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Host A Game"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "About"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)

ControlNumber = ControlNumber + 1: texty = FontY + (linenumber * TEXTSPACING): linenumber = linenumber + 1
Text = "Exit"
MenuInterface.Controls.ControlObjects(ControlNumber) = GameInterface.CreateControl(CONTROLTYPE_BUTTONLARGE, HALFINTERFACEWIDTH - 70, texty, 140, BTNSIZE, Text)
MenuInterface.BackgroundSound = "MainMenu"
ReturnedInterface = GameInterface.RunStaticInterface(MenuInterface)
For I = 1 To ReturnedInterface.Controls.ControlAmount
  If ReturnedInterface.Controls.ControlObjects(I).ControlProperties.Properties(CONTROLPROPERTY_STATE) = True Then
    ButtonPressed = I
    
    Exit For
  End If
  If ReturnedInterface.Canceled = True Then
    ButtonPressed = 10
    Exit For
  End If
Next I
LaunchMainMenu = ButtonPressed
End Function

Sub ProcessCommandLineArguements()
IsGameDiff = MiscFunctions.GetCommandLineArg("-game")
If IsGameDiff = "NULL" Then
  GameEngine.GameDataFile$ = DefaultGameDataFile$ & GameDataFileExtention$
  Directory_GameData = Directory_DefaultGameData
Else
  Directory_GameData = IsGameDiff
  GameEngine.GameDataFile$ = IsGameDiff & GameDataFileExtention$
End If
End Sub
Sub UnInitialize_Program()
Call Sound.UnInitializeSound
Call GraphicsEngine.CloseGraphicsDevice
Call Music.CloseMusicDevice
End Sub
Sub QuitProgram()
Call SaveGameINI
Call UnInitialize_Program
End
End Sub
Sub SaveGameINI()
Close
Open GameINIFile$ For Output As #1
Print #1, "Seed: " & 200 * Rnd
Print #1, "[Player Settings]"
Print #1, "Nickname: " & LocalPlayer.NickName
Print #1, "IP: " & Internet.ServerData.ServerIP
Print #1, "Port: " & Internet.ServerData.ServerPort
Print #1, "MusicOn: " & Music.MusicOn
Print #1, "SoundOn: " & Sound.SoundData.DeviceOn
Print #1, "[ENDOFFILE]"
Close #1
End Sub
Sub LoadGameINI()
On Error GoTo loaderr
'just checks and makes sure that the INI file
'is there. if it isn't, it writes a new one.
Open GameINIFile$ For Input As #1
Close #1
'getts the values from the file
Randomize FileFunctions.GetPropertyValueFromFile(GameINIFile$, "Seed:")
LocalPlayer.NickName = FileFunctions.GetPropertyValueFromFile(GameINIFile$, "Nickname:")
Internet.ServerData.ServerIP = FileFunctions.GetPropertyValueFromFile(GameINIFile$, "IP:")
Internet.ServerData.ServerPort = Val(FileFunctions.GetPropertyValueFromFile(GameINIFile$, "Port:"))
Music.MusicOn = MiscFunctions.ConvertTrueFalse(FileFunctions.GetPropertyValueFromFile(GameINIFile$, "MusicOn:"))
Sound.SoundData.DeviceOn = MiscFunctions.ConvertTrueFalse(FileFunctions.GetPropertyValueFromFile(GameINIFile$, "SoundOn:"))
Exit Sub
loaderr:
Call WriteDefaultINI
End Sub
Sub WriteDefaultINI()
LocalPlayer.NickName = "Player"
Internet.ServerData.ServerIP = ""
Internet.ServerData.ServerPort = Internet.DefaultPort
Music.MusicOn = True
Sound.SoundData.DeviceOn = True
Call SaveGameINI
End Sub
