Attribute VB_Name = "Players"
Global Const FACTION_EDF = 1
Global Const FACTION_ = 1
Global Const PLAYERTYPE_COMPUTER = 1
Global Const PLAYERTYPE_PERSON = 2
Global Const PLAYERTYPE_GAMESCRIPT = 3
Private Type PlayerData
  PlayerIndex As Integer
  NickName As String
End Type
Global LocalPlayer As PlayerData

Private Type BuildClass
  Active As Boolean
  Enabled As Boolean
  ClassReference As Integer
End Type
Private Type BuildingType
  Enabled As Boolean
  CanBePlaced As Boolean
  GoldRequired As Integer
  GoldGathered As Integer
  ClassReference As Integer
  Active As Boolean
End Type
Private Type Side
  Active As Boolean
  Money As Long
  NickName As String
  PlayerType As Integer
  BuildClasses(MaxObjModels) As BuildClass
  BuildClassesActive As Integer
  BuildsInProgress(MaxObjModels) As BuildingType
  BuildsInProgressesActive As Integer
  PrimaryBuildObjects(MAXBEHAVIORMODES) As Integer
  BuildSpeeds(MAXBEHAVIORMODES) As Integer
  TechLevel As Integer
  Faction As Integer
  CurrentlySelectedBuildClass As Integer
End Type
Global Const MAXPLAYERS = 10
Global PlayerMax As Integer
Global Player(MAXPLAYERS) As Side
Global Const SIDE_SCENERY = -1 'For scenery
Sub EvaluateBuildingAbility(PlayerIndex)
Dim BuildableTypes(MaxObjModels) As Boolean
For I = 1 To ObjectsActive
  If Objects(I).Side = PlayerIndex Then
    If CheckObject(I, OBJCHECK_ALIVE) = True Then
      If ObjModels(Objects(I).ModelIndex).Abilities(ABILITY_BUILDS) = True Then
        BuildableTypes(ObjModels(Objects(I).ModelIndex).Attributes(ATTRIBUTE_OBJECTBUILDTYPE)) = True
      End If
    End If
  End If
Next I
For I = 1 To Player(PlayerIndex).BuildsInProgressesActive
  If BuildableTypes(ObjModels(Player(PlayerIndex).BuildsInProgress(I).ClassReference).BehaviorType) = False Then
    Call RemoveFromBuildStack(PlayerIndex, I)
  End If
Next I
End Sub
Sub KillAllPlayers()
For I = 1 To PlayerMax
  Call KillPlayer(I)
Next I
PlayerMax = 0
End Sub
Sub KillPlayer(PlayerIndex)
Player(PlayerIndex).Active = False
End Sub
Function SpawnPlayer(Faction, Money, TechLevel)
For I = 1 To MAXPLAYERS
  If Player(I).Active = False Then
    NewIndex = I
    Exit For
  End If
Next I
With Player(NewIndex)
  .Active = True
  .CurrentlySelectedBuildClass = 1
  .Faction = Faction
  .Money = Money
  .TechLevel = TechLevel
End With
PlayerMax = PlayerMax + 1
SpawnPlayer = NewIndex
End Function
Sub RecompilePrimaryBuildObjects(PlayerIndex)
For I = 1 To MAXBEHAVIORMODES
  If Player(PlayerIndex).PrimaryBuildObjects(I) = NOOBJECT Then
    For I2 = 1 To ObjectsActive
      If ObjModels(Objects(I2).ModelIndex).Abilities(ABILITY_BUILDS) = True Then
        If ObjModels(Objects(I2).ModelIndex).Attributes(ATTRIBUTE_OBJECTBUILDTYPE) = I Then
          If Objects(I2).Side = PlayerIndex Then
            If CheckObject(I2, OBJCHECK_ALIVE) = True Then
              Player(PlayerIndex).PrimaryBuildObjects(I) = I2
              Exit For
            End If
          End If
        End If
      End If
    Next I2
  Else 'If it's already got an object
    KeepIt = False
    If CheckObject(Player(PlayerIndex).PrimaryBuildObjects(I), OBJCHECK_ALIVE) = True Then
      If ObjModels(Objects(Player(PlayerIndex).PrimaryBuildObjects(I)).ModelIndex).Abilities(ABILITY_BUILDS) = True Then
        If ObjModels(Objects(Player(PlayerIndex).PrimaryBuildObjects(I)).ModelIndex).Attributes(ATTRIBUTE_OBJECTBUILDTYPE) = I Then
          KeepIt = True
        End If
      End If
    End If
    If KeepIt = False Then
      Player(PlayerIndex).PrimaryBuildObjects(I) = NOOBJECT
    End If
  End If
Next I
End Sub
Sub RecompileBuildEnables(PlayerIndex)
For I = 1 To Player(PlayerIndex).BuildClassesActive
  Player(PlayerIndex).BuildClasses(I).Enabled = True
  For I2 = 1 To Player(PlayerIndex).BuildsInProgressesActive
    If ObjModels(Player(PlayerIndex).BuildClasses(I).ClassReference).BehaviorType = ObjModels(Player(PlayerIndex).BuildsInProgress(I2).ClassReference).BehaviorType Then
      Player(PlayerIndex).BuildClasses(I).Enabled = False
    End If
  Next I2
Next I
End Sub
Sub RecompileBuildOptions(PlayerIndex)
Player(PlayerIndex).BuildClassesActive = 0
For I = 1 To ObjectsActive
  If Objects(I).Side = PlayerIndex Then
    If Objects(I).Active = True Then
      If ObjModels(Objects(I).ModelIndex).Abilities(ABILITY_BUILDS) = True Then
        For I2 = 1 To MaxObjModTypes
          If Player(PlayerIndex).TechLevel >= ObjModels(I2).Attributes(ATTRIBUTE_TECHLEVEL) Then
            If ObjModels(I2).BehaviorType = ObjModels(Objects(I).ModelIndex).Attributes(ATTRIBUTE_OBJECTBUILDTYPE) Then
              If ObjModels(I2).Abilities(ABILITY_BUILDABLE) = True Then
                If ObjModels(I2).Attributes(ATTRIBUTE_SIDE) = Player(PlayerIndex).Faction Then
                  BuildIt = True
                  If ObjModels(I2).Attributes(ATTRIBUTE_REQUIREDBEFOREBUILD) <> NOOBJECT Then
                    BuildIt = False
                    For i3 = 1 To ObjectsActive
                      If Objects(i3).Side = PlayerIndex Then
                        If Objects(i3).Active = True Then
                          If Objects(i3).ModelIndex = ObjModels(I2).Attributes(ATTRIBUTE_REQUIREDBEFOREBUILD) Then
                            BuildIt = True
                          End If
                        End If
                      End If
                    Next i3
                  End If
                  For i3 = 1 To Player(PlayerIndex).BuildClassesActive
                    If Player(PlayerIndex).BuildClasses(i3).ClassReference = I2 Then
                      BuildIt = False
                      Exit For
                    End If
                  Next i3
                  If BuildIt = True Then
                    Player(PlayerIndex).BuildClassesActive = Player(PlayerIndex).BuildClassesActive + 1
                    Player(PlayerIndex).BuildClasses(Player(PlayerIndex).BuildClassesActive).Active = True
                    Player(PlayerIndex).BuildClasses(Player(PlayerIndex).BuildClassesActive).ClassReference = I2
                  End If
                End If
              End If
            End If
          End If
        Next I2
      End If
    End If
  End If
Next I
Call RecompileBuildEnables(PlayerIndex)

If Player(PlayerIndex).CurrentlySelectedBuildClass > Player(PlayerIndex).BuildClassesActive Then Player(PlayerIndex).CurrentlySelectedBuildClass = Player(PlayerIndex).BuildClassesActive
If Player(PlayerIndex).CurrentlySelectedBuildClass = 0 Then Player(PlayerIndex).CurrentlySelectedBuildClass = 1
Call RecompileBuildSpeeds(PlayerIndex)
If PlayerIndex = LocalPlayer.PlayerIndex Then
  Call RedrawControlPanel
End If
End Sub
Sub BuildObjectsChanged(PlayerIndex)
Call RecompileBuildSpeeds(PlayerIndex)
Call Players.RecompilePrimaryBuildObjects(PlayerIndex)
Call Players.EvaluateBuildingAbility(PlayerIndex)
Call Players.RecompileBuildOptions(PlayerIndex)
Call Players.RecompileBuildSpeeds(PlayerIndex)
If PlayerIndex = LocalPlayer.PlayerIndex Then
  Call RedrawControlPanel
End If
End Sub
Sub RecompileBuildSpeeds(PlayerIndex)
For I = 1 To MAXBEHAVIORMODES
  Player(PlayerIndex).BuildSpeeds(I) = 1
Next I
End Sub
Function StartBuilding(PlayerIndex, ClassOptionsIndex) As Integer
For I = 1 To Player(PlayerIndex).BuildsInProgressesActive
  If ObjModels(Player(PlayerIndex).BuildsInProgress(I).ClassReference).BehaviorType = ObjModels(Player(PlayerIndex).BuildClasses(ClassOptionsIndex).ClassReference).BehaviorType Then
    If Player(PlayerIndex).BuildsInProgress(I).Active = True Then
      DoNotBuild = True
    End If
  End If
Next I
If DoNotBuild = False Then
  Player(PlayerIndex).BuildsInProgressesActive = Player(PlayerIndex).BuildsInProgressesActive + 1
  Player(PlayerIndex).BuildsInProgress(Player(PlayerIndex).BuildsInProgressesActive).Enabled = True
  Player(PlayerIndex).BuildsInProgress(Player(PlayerIndex).BuildsInProgressesActive).Active = True
  Player(PlayerIndex).BuildsInProgress(Player(PlayerIndex).BuildsInProgressesActive).GoldGathered = 0
  Player(PlayerIndex).BuildsInProgress(Player(PlayerIndex).BuildsInProgressesActive).GoldRequired = ObjModels(Player(PlayerIndex).BuildClasses(ClassOptionsIndex).ClassReference).Attributes(ATTRIBUTE_COST)
  Player(PlayerIndex).BuildsInProgress(Player(PlayerIndex).BuildsInProgressesActive).ClassReference = Player(PlayerIndex).BuildClasses(ClassOptionsIndex).ClassReference
  Call RecompileBuildEnables(PlayerIndex)
  Call RedrawBuildWindows
  StartBuilding = Player(PlayerIndex).BuildsInProgressesActive
Else
  StartBuilding = NOOBJECT
End If
End Function
Sub RunBuilds()
For I = 1 To PlayerMax
  If Player(I).Active = True Then
    For I2 = 1 To Player(I).BuildsInProgressesActive
      If Player(I).BuildsInProgress(I2).GoldGathered < Player(I).BuildsInProgress(I2).GoldRequired Then
        Player(I).BuildsInProgress(I2).GoldGathered = Player(I).BuildsInProgress(I2).GoldGathered + Withdraw(I, Player(I).BuildSpeeds(ObjModels(Player(I).BuildsInProgress(I2).ClassReference).BehaviorType))
        If Player(I).BuildsInProgress(I2).GoldGathered >= Player(I).BuildsInProgress(I2).GoldRequired Then
          If ObjModels(Player(I).BuildsInProgress(I2).ClassReference).BehaviorType = BEHAVIORMODE_BUILDING Then
            If Player(I).BuildsInProgress(I2).CanBePlaced = False Then
              Player(I).BuildsInProgress(I2).CanBePlaced = True
              Call RedrawBuildWindows
            End If
          Else
            ReturnGold = (Player(I).BuildsInProgress(I2).GoldGathered - Player(I).BuildsInProgress(I2).GoldRequired) + 1
            Call Deposit(I, ReturnGold)
            Call ObjectCommand_BuildThis(Player(I).PrimaryBuildObjects(ObjModels(Player(I).BuildsInProgress(I2).ClassReference).BehaviorType), Player(I).BuildsInProgress(I2).ClassReference)
            Player(I).BuildsInProgress(I2).GoldGathered = 0
            Call RemoveFromBuildStack(I, I2)
            Call RecompileBuildEnables(I)
            Call RedrawBuildWindows
          End If
        End If
      End If
    Next I2
  End If
Next I
End Sub
Sub RemoveFromBuildStack(PlayerIndex, Buildnum)
Call Deposit(PlayerIndex, Player(PlayerIndex).BuildsInProgress(Buildnum).GoldGathered)
For I = Buildnum To Player(PlayerIndex).BuildsInProgressesActive - 1
  Player(PlayerIndex).BuildsInProgress(I) = Player(PlayerIndex).BuildsInProgress(I + 1)
Next I
Player(PlayerIndex).BuildsInProgress(Player(PlayerIndex).BuildsInProgressesActive).Active = False
Player(PlayerIndex).BuildsInProgressesActive = Player(PlayerIndex).BuildsInProgressesActive - 1
If Player(PlayerIndex).BuildsInProgressesActive < 0 Then Player(PlayerIndex).BuildsInProgressesActive = 0
Call RecompileBuildEnables(PlayerIndex)
End Sub
Sub CancelBuild(PlayerIndex, Buildnum)
For I = 1 To Player(PlayerIndex).BuildsInProgressesActive
  If Player(PlayerIndex).BuildsInProgress(I).ClassReference = Player(PlayerIndex).BuildClasses(Buildnum).ClassReference Then
    If Player(PlayerIndex).BuildsInProgress(I).Active = True Then
      Call RemoveFromBuildStack(PlayerIndex, I)
      Exit For
    End If
  End If
Next I
Call GraphicsEngine.RedrawBuildWindows
End Sub
Function Withdraw(PlayerIndex, GoldAmount) As Integer
Withdraw = GoldAmount
Player(PlayerIndex).Money = Player(PlayerIndex).Money - GoldAmount
If Player(PlayerIndex).Money < 0 Then
  Player(PlayerIndex).Money = 0
  Withdraw = Withdraw + Player(PlayerIndex).Money
End If
End Function
Sub Deposit(PlayerIndex, GoldAmount)
Player(PlayerIndex).Money = Player(PlayerIndex).Money + GoldAmount
End Sub
Public Sub BuildBuilding(X, Y, Side)
For I = 1 To Player(Side).BuildsInProgressesActive
  Call SpawnObject(Player(Side).BuildsInProgress(I).ClassReference, Side, X, Y, 0, 0, 0)
  If Side = LocalPlayer.PlayerIndex Then
    InterfaceFlags.PlacingABuilding = False
    InterfaceFlags.PlaceIndex = I
    Player(Side).BuildsInProgress(I).CanBePlaced = False
  End If
  Call RemoveFromBuildStack(Side, I)
  Exit For
Next I
Call RecompileBuildEnables(Side)
Call RedrawBuildWindows
End Sub

