Attribute VB_Name = "Math"
Global SinTable(360) As Single
Global CosTable(360) As Single
Public Function MovePoint2D(PointToMove As Point2D, DirectionToMove) As Point2D
Select Case DirectionToMove
Case DIRECTION_LEFT
  MovePoint2D.X = PointToMove.X - 1
  MovePoint2D.Y = PointToMove.Y
Case DIRECTION_UP
  MovePoint2D.X = PointToMove.X
  MovePoint2D.Y = PointToMove.Y - 1
Case DIRECTION_RIGHT
  MovePoint2D.X = PointToMove.X + 1
  MovePoint2D.Y = PointToMove.Y
Case DIRECTION_DOWN
  MovePoint2D.X = PointToMove.X
  MovePoint2D.Y = PointToMove.Y + 1
End Select
End Function
Public Sub InitializeTables()
For I = 0 To 360
  SinTable(I) = Sin(I / (180 / 3.1415926))
  CosTable(I) = -Cos(I / (180 / 3.1415926))
Next I
End Sub
Function GetCollidePosition(LineObj As Line3D, ObjPosition As Point3D, ObjYaw As Integer, CollidePosition As Point3D) As Boolean
Dim TempLine As Line3D
Point1Yaw = Math.GetYawFromPoints(LineObj.Point1, ObjPosition)
Point2Yaw = Math.GetYawFromPoints(LineObj.Point2, ObjPosition)
If Math.IsYawWithinDirections(ObjYaw, Point1Yaw, Point2Yaw) = True Then
  TempLine.Point1 = RotatePointAroundPoint(LineObj.Point1, ObjPosition, 360 - ObjYaw)
  TempLine.Point2 = RotatePointAroundPoint(LineObj.Point2, ObjPosition, 360 - ObjYaw)
  CollidePosition.Y = ((TempLine.Point1.Y - TempLine.Point2.Y) / (TempLine.Point2.X - TempLine.Point1.X)) * (TempLine.Point2.X)
  CollidePosition = RotatePointAroundPoint(CollidePosition, ObjPosition, ObjYaw)
  GetCollidePosition = True
End If
End Function
Public Function RotatePointAroundPoint(Point1 As Point3D, PointToRotateAround As Point3D, Yaw As Integer) As Point3D
X1 = Point1.X - PointToRotateAround.X
Y1 = Point1.Y - PointToRotateAround.Y
RotatePointAroundPoint.Y = (X1 * SinTable(Yaw) + Y1 * CosTable(Yaw)) + PointToRotateAround.Y
RotatePointAroundPoint.X = (X1 * CosTable(Yaw) + Y1 * SinTable(Yaw)) + PointToRotateAround.X
End Function
Public Function IsYawWithinDirections(ObjYaw, Point1Yaw, Point2Yaw) As Boolean
Yaw1 = ObjYaw + 180
PYaw1 = Point1Yaw + 180
PYaw2 = Point2Yaw + 180
If Yaw1 < 360 Then Yaw1 = 360 - Yaw1
If PYaw1 < 360 Then PYaw1 = 360 - PYaw1
If PYaw2 < 360 Then PYaw2 = 360 - PYaw2
If Yaw1 < PYaw2 Then
  If Yaw1 > PYaw1 Then
    IsYawWithinDirections = True
    Exit Function
  End If
End If
If Yaw1 < PYaw1 Then
  If Yaw1 > PYaw2 Then
    IsYawWithinDirections = True
    Exit Function
  End If
End If
End Function
Public Function GetZIncline(X1, Y1, Z1, X2, Y2, Z2)
Dim P1 As Point3D, P2 As Point3D
P1.X = X1
P1.Y = Y1
P1.Z = Z1
P2.X = X2
P2.Y = Y2
P2.Z = Z2
GetZIncline = (Z1 - Z2) / GetDistance(P1, P2)
End Function
Public Function GetPercentage(MaxVal, VarVal) As Integer
GetPercentage = VarVal * (100 / MaxVal)
End Function
Function GetYawFromPoints(Point1 As Point3D, Point2 As Point3D) As Integer
GetYawFromPoints = GetYawFromXY(Point1.X, Point1.Y, Point2.X, Point2.Y)
End Function
Function GetYawFromXY(X1, Y1, X2, Y2) As Integer
XDiff = X2 - X1
YDiff = Y2 - Y1
If XDiff = 0 Then XDiff = 1
If YDiff = 0 Then YDiff = 1
If XDiff > 0 Then
  If YDiff > XDiff Then
    Ratio = -((XDiff / YDiff) * 45) + 180
  Else
    YDiff = -YDiff
    If YDiff > XDiff Then
      Ratio = (90 + ((XDiff / YDiff) * 45)) - 90
    Else
      YDiff = -YDiff
      Ratio = 90 + ((YDiff / XDiff) * 45)
    End If
  End If
Else
  XDiff = -XDiff
  If YDiff > XDiff Then
    Ratio = -((XDiff / YDiff) * 45) + 180
  Else
    YDiff = -YDiff
    If YDiff > XDiff Then
      Ratio = (90 + ((XDiff / YDiff) * 45)) - 90
    Else
      YDiff = -YDiff
      Ratio = 90 + ((YDiff / XDiff) * 45)
    End If
  End If
  Ratio = 360 - Ratio
End If
GetYawFromXY = Ratio
End Function
Public Function GetDistance(Point1 As Point3D, Point2 As Point3D) As Integer
GetDistance = Sqr((Point1.X - Point2.X) ^ 2 + (Point1.Y - Point2.Y) ^ 2)
End Function
Public Function GetPropelCoordinates(ObjPos As Point3D, Yaw, ZInclination, Distance) As Point3D
GetPropelCoordinates.X = ObjPos.X + (SinTable(Yaw) * Distance)
GetPropelCoordinates.Y = ObjPos.Y + (CosTable(Yaw) * Distance)
GetPropelCoordinates.Z = ObjPos.Z + ZInclination
End Function
Public Sub CheckVector(Vector As Vect3D)
If Vector.Yaw < 1 Then Vector.Yaw = 360 + Vector.Yaw
If Vector.Yaw > 360 Then Vector.Yaw = Vector.Yaw - 360
End Sub
Public Function CheckYaw(Yaw)
CheckYaw = Yaw
If Yaw < 1 Then CheckYaw = 360 + Yaw
If Yaw > 360 Then CheckYaw = Yaw - 360
End Function

