Attribute VB_Name = "GameInterface"
Global Const EXTRABORDER = 5
Global Const MouseDragThreshhold = 4

Global Const MAXMOUSEBUTTONS = 5
'Mouse
Type MousePoint
  DragStartPosition As Point3D
  DragCurrentPosition As Point3D
  IsDragging As Boolean
  Position As Point3D
  OldButtonStates(1 To MAXMOUSEBUTTONS) As Boolean
  ButtonStates(1 To MAXMOUSEBUTTONS) As Boolean
  CursorPic As Integer
End Type
Public Mouse As MousePoint

'Keyboard
Global Const KEY_SHIFT = 16
Global Const KEY_ENTER = 13
Global Const KEY_ESCAPE = 27
Global Const KEY_T = 84
Global Const KEY_S = 83
Global Const KEY_D = 68
Global Const KEY_CONTROL = 17
Global Const KEY_ALT = 18
Global Const KEY_TAB = 9

Global Const KEY_UP = 38
Global Const KEY_DOWN = 40
Global Const KEY_LEFT = 37
Global Const KEY_RIGHT = 39


Global KeyStates(250) As Boolean

Type ObjectSelect
  MaxSelected As Integer
  SelectedList(MAXOBJECTS) As Integer
End Type
Type Interflags
  WritingAMessage As Boolean
  Message As String
  PlacingABuilding As Boolean
  PlaceIndex As Integer
End Type
Global InterfaceFlags As Interflags
Global ObjectSelectedList As IndexGroup
'Real stuff
Public Const INTERFACEWIDTH = 320
Public Const INTERFACEHEIGHT = 200
Public Const HALFINTERFACEWIDTH = INTERFACEWIDTH / 2
Public Const HALFINTERFACEHEIGHT = INTERFACEHEIGHT / 2
Private Const NOCONTROL = 0


Private Const MAXPROPERTIES = 10
Public Const CONTROLPROPERTY_TEXT = 1
Public Const CONTROLPROPERTY_PICTURE = 2
Public Const CONTROLPROPERTY_STATE = 3

Type PropertyArray
  Properties(MAXPROPERTIES) As Variant
End Type
Type ControlObject
  Outline As RECT
  ControlProperties As PropertyArray
  ControlType As Integer
End Type
Private Const MAXCONTROLAMOUNT = 30
Type ControlGroup
  ControlAmount As Integer
  ControlObjects(MAXCONTROLAMOUNT) As ControlObject
End Type
Type InterfaceReturnObj
  Controls As ControlGroup
  Canceled As Boolean
End Type
Type InterfaceObj
  BackgroundPic As Integer
  BackgroundSound As String
  MouseCursorPic As Integer
  Controls As ControlGroup
  ControlFocus As Integer
End Type
Public Const CONTROLTYPE_PICTUREBOX = 1
Public Const CONTROLTYPE_BUTTONLARGE = 2
Public Const CONTROLTYPE_LABEL = 3
Public Const CONTROLTYPE_TEXTBOX = 4
Public Function CreateControl(ControlType, X, Y, Width, Height, Content) As ControlObject
Dim NewControl As ControlObject
NewControl.ControlType = ControlType
Select Case ControlType
Case CONTROLTYPE_PICTUREBOX
  NewControl.ControlProperties.Properties(CONTROLPROPERTY_PICTURE) = Content
  NewControl.Outline.Top = Y - Int(Height / 2)
  NewControl.Outline.bottom = Y + Int(Height / 2)
  NewControl.Outline.Left = X - Int(Width / 2)
  NewControl.Outline.Right = X + Int(Width / 2)
Case CONTROLTYPE_BUTTONLARGE
  NewControl.ControlProperties.Properties(CONTROLPROPERTY_TEXT) = Content
  NewControl.ControlProperties.Properties(CONTROLPROPERTY_STATE) = False
  NewControl.Outline.Top = Y
  NewControl.Outline.bottom = Y + Height
  NewControl.Outline.Left = X
  NewControl.Outline.Right = X + Width
Case CONTROLTYPE_LABEL
  NewControl.ControlProperties.Properties(CONTROLPROPERTY_TEXT) = Content
  NewControl.Outline.Top = Y
  NewControl.Outline.bottom = Y + Height
  NewControl.Outline.Left = X
  NewControl.Outline.Right = X + Width
Case CONTROLTYPE_TEXTBOX
  NewControl.ControlProperties.Properties(CONTROLPROPERTY_TEXT) = Content
  NewControl.Outline.Top = Y - Int((Height * FONT_SPACINGY) / 2)
  NewControl.Outline.bottom = Y + Int((Height * FONT_SPACINGY) / 2)
  NewControl.Outline.Left = X - Int((Width * FONT_SPACINGX) / 2)
  NewControl.Outline.Right = X + Int((Width * FONT_SPACINGX) / 2)
End Select
CreateControl = NewControl
End Function
Public Function ProjectRectToCenterScreen(RectToConvert As RECT) As RECT
ProjectRectToCenterScreen.Left = (RectToConvert.Left - HALFINTERFACEWIDTH) + ResolutionMidX
ProjectRectToCenterScreen.Right = (RectToConvert.Right - HALFINTERFACEWIDTH) + ResolutionMidX
ProjectRectToCenterScreen.Top = (RectToConvert.Top - HALFINTERFACEHEIGHT) + ResolutionMidY
ProjectRectToCenterScreen.bottom = (RectToConvert.bottom - HALFINTERFACEHEIGHT) + ResolutionMidY
End Function
Private Sub DrawInterface(Interface As InterfaceObj)
Call GraphicsEngine.SplashGraphic(InGameConstants(InGameConstant_PICINDEX_ProgramBackground))
Call GraphicsEngine.DisplayText("JPI v" & VERSION, ResolutionMidX - HALFINTERFACEWIDTH, ResolutionMidY - HALFINTERFACEHEIGHT, PALLETE_YELLOW)
For I = 1 To Interface.Controls.ControlAmount
  'Display controls
  With Interface.Controls.ControlObjects(I)
    Select Case .ControlType
    Case CONTROLTYPE_PICTUREBOX
      Call GraphicsEngine.PutGraphicOntoBackBuffer(.Outline.Left + Pics(.ControlProperties.Properties(CONTROLPROPERTY_PICTURE)).HalfWidth, .Outline.Top + Pics(.ControlProperties.Properties(CONTROLPROPERTY_PICTURE)).HalfHeight, .ControlProperties.Properties(CONTROLPROPERTY_PICTURE), BltType_Mask)
    Case CONTROLTYPE_BUTTONLARGE
      Call GraphicsEngine.PutGraphicOntoBackBuffer(.Outline.Left + Pics(InGameConstants(InGameConstant_PICINDEX_ButtonLarge)).HalfWidth, .Outline.Top + Pics(InGameConstants(InGameConstant_PICINDEX_ButtonLarge)).HalfHeight, InGameConstants(InGameConstant_PICINDEX_ButtonLarge), BltType_Fast)
      Call GraphicsEngine.DisplayTextCenterRelative(.ControlProperties.Properties(CONTROLPROPERTY_TEXT), .Outline.Left + 70, .Outline.Top + 6, PALLETE_WHITE)
    Case CONTROLTYPE_TEXTBOX
      Call GraphicsEngine.DisplayText(.ControlProperties.Properties(CONTROLPROPERTY_TEXT), .Outline.Left, .Outline.Top + 1, PALLETE_YELLOW)
      Call GraphicsEngine.GethDC
      Call GraphicsEngine.DrawBox(.Outline.Left, .Outline.Top + 2, .Outline.Right, .Outline.bottom - 1, 255, 255, 255, 0, 0, 0, LINEMODE_NORMAL)
      Call GraphicsEngine.ReleasehDC
    Case CONTROLTYPE_LABEL
      Call GraphicsEngine.DisplayTextCenterRelative(.ControlProperties.Properties(CONTROLPROPERTY_TEXT), .Outline.Left + ((.Outline.Right - .Outline.Left) / 2), .Outline.Top + ((.Outline.bottom - .Outline.Top) / 2), PALLETE_YELLOW)
    End Select
  End With
Next I
End Sub
Public Function RunStaticInterface(InterfaceToRun As InterfaceObj) As InterfaceReturnObj
Dim InterfaceReturn As InterfaceReturnObj, Interface As InterfaceObj
ViewForm.KeyboardInputBox.Text = ""
Interface = InitializeInterfaceObj(InterfaceToRun)
Call ClearKeyStates
If InterfaceToRun.BackgroundSound <> "" Then Call Sound.Play_LoopSound(Sound.GetSoundIndex(InterfaceToRun.BackgroundSound), 100)
Do
  
  DoEvents
  If Interface.ControlFocus <> NOCONTROL Then
    If RunControlKeyboardInput(Interface.Controls.ControlObjects(Interface.ControlFocus)) = True Then
      Interface.ControlFocus = NOCONTROL
    End If
  End If
  For I = 1 To Interface.Controls.ControlAmount
    If RunControlMouseInput(Interface.Controls.ControlObjects(I)) = True Then
      Select Case Interface.Controls.ControlObjects(I).ControlType
      Case CONTROLTYPE_TEXTBOX
        Interface.ControlFocus = I
        ViewForm.KeyboardInputBox.Text = Interface.Controls.ControlObjects(I).ControlProperties.Properties(CONTROLPROPERTY_TEXT)
        ViewForm.KeyboardInputBox.SelStart = Len(ViewForm.KeyboardInputBox.Text)
        ViewForm.KeyboardInputBox.MaxLength = (Interface.Controls.ControlObjects(I).Outline.Right - Interface.Controls.ControlObjects(I).Outline.Left) / FONT_SPACINGX
      End Select
      If Interface.Controls.ControlObjects(I).ControlType = CONTROLTYPE_BUTTONLARGE Then
        Exit Do
      End If
    End If
  Next I
  Call GraphicsEngine.ClearBackBuffer
  Call DrawInterface(Interface)
  GraphicsEngine.SwapScreen
  'Display mouse cursor (make a sub DisplayMousecursor(CursorPic)
  If KeyStates(KEY_ESCAPE) = True Then
    RunStaticInterface.Canceled = True
    Exit Do
  End If
Loop
Call Sound.Stop_Sounds
RunStaticInterface.Controls = Interface.Controls
ViewForm.KeyboardInputBox.MaxLength = 0
End Function
Public Sub RunImmediateInterface(Interface As InterfaceObj)
For I = 1 To Interface.Controls.ControlAmount
'  Call RunControl(Interface.Controls.ControlObjects(I))
Next I
Call DrawInterface(Interface)
End Sub
Private Function RunControlMouseInput(Control As ControlObject) As Boolean
If InClipper(Mouse.Position.X, Mouse.Position.Y, Control.Outline) = True Then
  'run the mouse input
  If Mouse.ButtonStates(1) = True Then
    Mouse.ButtonStates(1) = False
    RunControlMouseInput = True
    If Control.ControlProperties.Properties(CONTROLPROPERTY_STATE) = False Then
      Control.ControlProperties.Properties(CONTROLPROPERTY_STATE) = True
    Else
      Control.ControlProperties.Properties(CONTROLPROPERTY_STATE) = False
    End If
  End If
End If
End Function
Private Function RunControlKeyboardInput(Control As ControlObject) As Boolean
'run the keyboard input
Control.ControlProperties.Properties(CONTROLPROPERTY_TEXT) = ViewForm.KeyboardInputBox.Text
If KeyStates(KEY_ENTER) = True Then
  RunControlKeyboardInput = True
End If
End Function
Public Function InitializeInterfaceObj(Interface As InterfaceObj) As InterfaceObj
InitializeInterfaceObj = Interface
For I = 1 To InitializeInterfaceObj.Controls.ControlAmount
  InitializeInterfaceObj.Controls.ControlObjects(I).Outline = ProjectRectToCenterScreen(InitializeInterfaceObj.Controls.ControlObjects(I).Outline)
Next I
End Function
Public Function ConstructInterface(InterfaceFile As String) As InterfaceObj
Dim NewInterface As InterfaceObj
'put load interface crap here!
NewInterface = InitializeInterfaceObj(NewInterface)
ConstructInterface = NewInterface
End Function
Public Sub ClearKeyStates()
For I = 0 To 250
  KeyStates(I) = False
Next I
End Sub
Public Sub InitializeInterface()
ViewForm.KeyboardInputBox.SetFocus
End Sub
Public Sub ClearMouseButtons()
For I = 1 To MAXMOUSEBUTTONS
  Mouse.ButtonStates(I) = False
  Mouse.OldButtonStates(I) = False
Next I
End Sub
Public Sub SelectUnits(StartPoint As Point3D, ClickPoint As Point3D)
If ClickPoint.X < StartPoint.X Then
  TmpX = ClickPoint.X
  ClickPoint.X = StartPoint.X
  StartPoint.X = TmpX
End If
If ClickPoint.Y < StartPoint.Y Then
  TmpY = ClickPoint.Y
  ClickPoint.Y = StartPoint.Y
  StartPoint.Y = TmpY
End If
GameInterface.ObjectSelectedList.IndexesActive = 0
For I = 1 To ObjectsActive
  If CheckObject(I, OBJCHECK_ALIVE) = True Then
    If CheckObject(I, OBJCHECK_CANBESELECTED) = True Then
      If Objects(I).Side = LocalPlayer.PlayerIndex Then
        If Objects(I).Position.X <= ClickPoint.X Then
          If Objects(I).Position.X >= StartPoint.X Then
            If Objects(I).Position.Y <= ClickPoint.Y Then
              If Objects(I).Position.Y >= StartPoint.Y Then
                If ObjModels(Objects(I).ModelIndex).BehaviorType = BEHAVIORMODE_TANK Then
                  GameInterface.ObjectSelectedList.IndexesActive = GameInterface.ObjectSelectedList.IndexesActive + 1
                  GameInterface.ObjectSelectedList.Indexes(GameInterface.ObjectSelectedList.IndexesActive) = I
                End If
              End If
            End If
          End If
        End If
      End If
    End If
  End If
Next I
End Sub
Public Sub DetermineMouseDrag()
Mouse.IsDragging = True
If Mouse.Position.X < Mouse.DragStartPosition.X + MouseDragThreshhold Then
  If Mouse.Position.X > Mouse.DragStartPosition.X - MouseDragThreshhold Then
    If Mouse.Position.Y < Mouse.DragStartPosition.Y + MouseDragThreshhold Then
      If Mouse.Position.Y > Mouse.DragStartPosition.Y - MouseDragThreshhold Then
        Mouse.IsDragging = False
      End If
    End If
  End If
End If
If Mouse.IsDragging = True Then
  Mouse.IsDragging = False
  If Mouse.DragStartPosition.X > BattleViewPort.PortRect.Left - 1 Then
    If Mouse.DragStartPosition.Y > BattleViewPort.PortRect.Top - 1 Then
      If Mouse.DragStartPosition.X < BattleViewPort.PortRect.Right Then
        If Mouse.DragStartPosition.Y < BattleViewPort.PortRect.bottom Then
          Mouse.IsDragging = True
        End If
      End If
    End If
  End If
End If
End Sub
Sub SelectSingleUnit(Mouse3D As Point3D)
Dim Temppoint As Point3D
For I = 1 To ObjectsActive
  If CheckObject(I, OBJCHECK_ALIVE) = True Then
    If CheckObject(I, OBJCHECK_CANBESELECTED) = True Then
      If CheckIfPointIsOnUnit(I, Mouse3D) = True Then
        If KeyStates(KEY_SHIFT) = True Then
          ObjectSelectedList.IndexesActive = ObjectSelectedList.IndexesActive + 1
          ObjectSelectedList.Indexes(ObjectSelectedList.IndexesActive) = I
        Else
          ObjectSelectedList.IndexesActive = 1
          ObjectSelectedList.Indexes(1) = I
          Exit For
        End If
      End If
    End If
  End If
Next I
End Sub
Public Function CheckIfPointIsOnUnit(ObjIndex, PointPosition As Point3D) As Boolean
Dim Temppoint As Point3D
With Objects(ObjIndex)
    Temppoint = ProjectPointToView(.Position)
    SpriteXOffset = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SPRITEPOSITIONX)
    SpriteYOffset = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SPRITEPOSITIONY)
    PicIndex = SpriteStuff.Sprites(.Sprite.SpriteNumber).SpriteGroups(.Sprite.SpriteGroupNumber).Frames(.Sprite.SpriteFrameNumber).PicNum
    If PointPosition.X > Temppoint.X - SpriteXOffset Then
      If PointPosition.X < (Temppoint.X - SpriteXOffset) + Pics(PicIndex).Width Then
        If PointPosition.Y > Temppoint.Y - SpriteYOffset Then
          If PointPosition.Y < (Temppoint.Y - SpriteYOffset) + Pics(PicIndex).Height Then
            CheckIfPointIsOnUnit = True
          End If
        End If
      End If
    End If
End With
End Function
Public Function InClipper(X, Y, ClipRect As RECT) As Boolean
With ClipRect
  If X <= .Right + EXTRABORDER Then
    If X >= .Left - EXTRABORDER Then
      If Y >= .Top - EXTRABORDER Then
        If Y <= .bottom + EXTRABORDER Then
          InClipper = True
        End If
      End If
    End If
  End If
End With
End Function
Public Sub ProcessMouseInput()
'View Scrolling
If InClipper(Mouse.Position.X, Mouse.Position.Y, BattleViewPort.PortRect) = True Then
  Call ProcessWindow_BattleViewPort
End If
If InClipper(Mouse.Position.X, Mouse.Position.Y, GameControlPanel.PortRect) = True Then
  If Mouse.IsDragging = True Then
    Call ProcessWindow_BattleViewPort
  Else
    Call ProcessWindow_ControlPanel
  End If
End If
Call ProcessMiscMouse
For I = 1 To 5
  Mouse.OldButtonStates(I) = Mouse.ButtonStates(I)
Next I
End Sub
Sub ProcessWindow_ControlPanel()
Dim Building As Boolean
For I = 1 To MAXBUILDWINDOWS
  If InClipper(Mouse.Position.X, Mouse.Position.Y, BuildWindows(I).PortRect) = True Then
    If Player(LocalPlayer.PlayerIndex).CurrentlySelectedBuildClass + (I - 1) <= Player(LocalPlayer.PlayerIndex).BuildClassesActive Then
      If Mouse.ButtonStates(1) = True Then
        If Players.StartBuilding(LocalPlayer.PlayerIndex, Player(LocalPlayer.PlayerIndex).CurrentlySelectedBuildClass + (I - 1)) = False Then
          For I2 = 1 To Player(LocalPlayer.PlayerIndex).BuildsInProgressesActive
            If Player(LocalPlayer.PlayerIndex).BuildClasses(Player(LocalPlayer.PlayerIndex).CurrentlySelectedBuildClass + (I - 1)).ClassReference = Player(LocalPlayer.PlayerIndex).BuildsInProgress(I2).ClassReference Then
              If Player(LocalPlayer.PlayerIndex).BuildsInProgress(I2).CanBePlaced = True Then
                InterfaceFlags.PlaceIndex = Player(LocalPlayer.PlayerIndex).BuildsInProgress(I2).ClassReference
                InterfaceFlags.PlacingABuilding = True
              End If
              Exit For
            End If
          Next I2
        End If
        Mouse.ButtonStates(1) = False
      ElseIf Mouse.ButtonStates(2) = True Then
        Call CancelBuild(LocalPlayer.PlayerIndex, Player(LocalPlayer.PlayerIndex).CurrentlySelectedBuildClass + (I - 1))
        Mouse.ButtonStates(2) = False
      End If
    End If
  End If
Next I
If InClipper(Mouse.Position.X, Mouse.Position.Y, RadarButton.PortRect) = True Then
  If Mouse.ButtonStates(1) = True Then
    If RadarWindow.Enabled = True Then
      RadarWindow.Enabled = False
    Else
      RadarWindow.Enabled = True
    End If
    Call GraphicsEngine.RedrawControlPanel
    Mouse.ButtonStates(1) = False
  End If
End If
End Sub
Sub ProcessMiscMouse()
If Mouse.IsDragging = True Then
    Mouse.DragCurrentPosition = Mouse.Position
    With BattleViewPort.PortRect
      If Mouse.Position.X < .Left Then
        Mouse.DragCurrentPosition.X = .Left
      End If
      If Mouse.Position.X > .Right - 1 Then
        Mouse.DragCurrentPosition.X = .Right - 1
      End If
      If Mouse.Position.Y < .Top - 1 Then
        Mouse.DragCurrentPosition.Y = .Top - 1
      End If
      If Mouse.Position.Y > .bottom - 1 Then
        Mouse.DragCurrentPosition.Y = .bottom - 1
      End If
    End With
Else
    With Mouse.Position
      If .X = 0 Then
        Call AddInertiaToScroll(DIRECTION_LEFT)
      End If
      If .Y = 0 Then
        Call AddInertiaToScroll(DIRECTION_UP)
      End If
      If .X = ResolutionX - 1 Then
        Call AddInertiaToScroll(DIRECTION_RIGHT)
      End If
      If .Y = ResolutionY - 1 Then
        Call AddInertiaToScroll(DIRECTION_DOWN)
      End If
    End With
End If
End Sub
Sub ProcessWindow_BattleViewPort()
If InterfaceFlags.PlacingABuilding = True Then
  If Mouse.ButtonStates(1) = True Then
    If ObjectSelectedList.IndexesActive = NOOBJECT Then
      Mouse.ButtonStates(1) = False
      MouseX = Map.ProjectToMapX(ProjectXToBattlefield(Mouse.Position.X))
      MouseY = Map.ProjectToMapY(ProjectYToBattlefield(Mouse.Position.Y))
      If Map.IsImprintSpaceOccupied(MouseX, MouseY, ObjModels(Player(PlayerIndex).BuildsInProgress(InterfaceFlags.PlaceIndex).ClassReference).MapImprintNumber) = False Then
        Call BuildBuilding(MouseX, MouseY, LocalPlayer.PlayerIndex)
      Else
        Beep
      End If
    End If
  End If
End If
If Mouse.OldButtonStates(1) = True Then
  'mouse has been pressed down
  If Mouse.ButtonStates(1) = False Then
    'Mouse has just been pressed and let go
    Call DetermineMouseDrag
    If Mouse.IsDragging = False Then
      If ObjectSelectedList.IndexesActive = NOOBJECT Then
        Call SelectSingleUnit(Mouse.Position)
      Else
        Call HandleUnitGroupInstructions(ProjectPointToBattlefield(Mouse.Position))
      End If
    Else
      Call SelectUnits(ProjectPointToBattlefield(Mouse.DragStartPosition), ProjectPointToBattlefield(Mouse.DragCurrentPosition))
    End If
  Else
    Call DetermineMouseDrag
  End If
Else
  Mouse.IsDragging = False
End If
If Mouse.ButtonStates(2) = True Then
  'Deselect Units
  GameInterface.ObjectSelectedList.IndexesActive = NOOBJECT
End If
End Sub
Public Sub StandbyMinimized()
Call TempCloseGraphicsDevice
ViewForm.WindowState = 1
Do
  DoEvents
  If ViewForm.WindowState <> 1 Then Exit Do
Loop
DoEvents
Call TempOpenGraphicsDevice
DoEvents
GraphicsEngine.GraphicsEngineData.TotalRefresh = True
End Sub
Sub MiscKeyboardProcessing()
Call CheckAltTab
End Sub
Public Sub CheckAltTab()
If KeyStates(KEY_TAB) = True Then
  If KeyStates(KEY_ALT) = True Then
    Call StandbyMinimized
    Call ClearKeyStates
  End If
End If
End Sub
Public Sub ProcessKeyboardEvents()
If InterfaceFlags.WritingAMessage = True Then
    InterfaceFlags.Message = ViewForm.KeyboardInputBox.Text
    If KeyStates(KEY_ESCAPE) = True Then
      InterfaceFlags.WritingAMessage = False
    End If
    If KeyStates(KEY_ENTER) = True Then
      Call Internet.TransmitMessage(ViewForm.KeyboardInputBox.Text)
      InterfaceFlags.WritingAMessage = False
      ViewForm.KeyboardInputBox.Text = ""
    End If
    For I = 1 To 127
      KeyStates(I) = False
    Next I
Else
    If KeyStates(KEY_T) = True Then
      InterfaceFlags.WritingAMessage = True
      ViewForm.KeyboardInputBox.Text = ""
    End If
    If KeyStates(KEY_UP) = True Then
      Call AddInertiaToScroll(DIRECTION_UP)
    End If
    If KeyStates(KEY_DOWN) = True Then
      Call AddInertiaToScroll(DIRECTION_DOWN)
    End If
    If KeyStates(KEY_LEFT) = True Then
      Call AddInertiaToScroll(DIRECTION_LEFT)
    End If
    If KeyStates(KEY_RIGHT) = True Then
      Call AddInertiaToScroll(DIRECTION_RIGHT)
    End If
    If KeyStates(KEY_ESCAPE) = True Then
      Call GameEngine.CauseEngineInterrupt(IR_PLAYEREXITEDGAME)
    End If
End If
End Sub
Public Sub ClearSelectedListEntry(EntryNum)
For I = EntryNum To ObjectSelectedList.IndexesActive - 1
  ObjectSelectedList.Indexes(I) = ObjectSelectedList.Indexes(I + 1)
Next I
ObjectSelectedList.IndexesActive = ObjectSelectedList.IndexesActive - 1
End Sub
Public Function GetManualInstruction()
If KeyStates(KEY_CONTROL) = True Then
  If KeyStates(KEY_ALT) = True Then
    GetManualInstruction = INSTRUCTION_FORCEPROTECT
  Else
    GetManualInstruction = INSTRUCTION_FORCEATTACK
  End If
ElseIf KeyStates(KEY_ALT) = True Then
  GetManualInstruction = INSTRUCTION_FORCEMOVE
End If
End Function
Public Sub HandleUnitGroupInstructions(RealMouseClickPoint As Point3D)
Dim ClickPoint As Point3D
If ObjectSelectedList.IndexesActive < 1 Then Exit Sub
ManualInstruction = GetManualInstruction
For I = 1 To GameInterface.ObjectSelectedList.IndexesActive
  If CheckObject(ObjectSelectedList.Indexes(I), OBJCHECK_SELECTABLE) = True Then
    IgnoreCommand = False
    If ObjModels(Objects(ObjectSelectedList.Indexes(I)).ModelIndex).Abilities(ABILITY_DEPLOYS) Then
      If CheckIfPointIsOnUnit(ObjectSelectedList.Indexes(I), GameInterface.ProjectPointToView(RealMouseClickPoint)) = True Then
        If Objects(ObjectSelectedList.Indexes(I)).Side = LocalPlayer.PlayerIndex Then
          Objects(ObjectSelectedList.Indexes(I)).Frozen = True
          Call Events.SpawnEvent(Events.Event_DeployUnit, ObjectSelectedList.Indexes(I))
          IgnoreCommand = True
        End If
      End If
    End If
    If IgnoreCommand = False Then Call Events.SpawnEvent(Events.Event_DirectUnit, GameInterface.ObjectSelectedList.Indexes(I), RealMouseClickPoint.X, RealMouseClickPoint.Y, ManualInstruction)
  End If
Next I
End Sub
Function ProjectXToView(XVal) As Integer
ProjectXToView = (XVal - GameEngine.View.Left)
End Function
Function ProjectYToView(YVal) As Integer
ProjectYToView = (YVal - GameEngine.View.Top)
End Function
Function ProjectXToBattlefield(XVal) As Integer
ProjectXToBattlefield = (GameEngine.View.Left + XVal) - BattleViewPort.PortRect.Left
End Function
Function ProjectYToBattlefield(YVal) As Integer
ProjectYToBattlefield = (GameEngine.View.Top + YVal) - BattleViewPort.PortRect.Top
End Function
Public Function ProjectPointToView(OrigPoint As Point3D) As Point3D
ProjectPointToView.X = ProjectXToView(OrigPoint.X)
ProjectPointToView.Y = ProjectYToView(OrigPoint.Y)
ProjectPointToView.Z = OrigPoint.Z
End Function
Public Function ProjectPointToBattlefield(OrigPoint As Point3D) As Point3D
ProjectPointToBattlefield.X = ProjectXToBattlefield(OrigPoint.X)
ProjectPointToBattlefield.Y = ProjectYToBattlefield(OrigPoint.Y)
ProjectPointToBattlefield.Z = OrigPoint.Z
End Function

