Attribute VB_Name = "GameEngine"
Type MsgWindow
  Caption As String
  Active As Boolean
  Text As String
End Type
Global MessageWindow As MsgWindow
Type EngineCntrls
  InterruptGame As Boolean
  ReasonForInterrupt As Integer
End Type
Public EngineControls As EngineCntrls
Type GameWindow
  PortRect As RECT
  Enabled As Boolean
  Height As Integer
  Width As Integer
End Type
Public RadarWindow As GameWindow
Public BattleViewPort As GameWindow
Public GameControlPanel As GameWindow
Public RadarButton As GameWindow
Public Const MAXBUILDWINDOWS = 3
Public BuildWindows(MAXBUILDWINDOWS) As GameWindow
Type ViewProperties
  MaxScrollSpeed As Integer
  ScrollSpeedEW As Integer
  ScrollSpeedNS As Integer
  Left As Integer
  Top As Integer
  MaxLeft As Integer
  MaxTop As Integer
  Width As Integer
  Height As Integer
End Type
Public View As ViewProperties
Global Const DIRECTION_UP = 1
Global Const DIRECTION_RIGHT = 2
Global Const DIRECTION_DOWN = 3
Global Const DIRECTION_LEFT = 4
'Interrupt Reasons
Public Const IR_PLAYEREXITEDGAME = 1
Type EngDat
  Episode As Integer
  Level As Integer
  HeartBeat As Integer
End Type
Public EngineData As EngDat
Public GameDataFile$
Global Const GameCycleTime = 0.02
Private Type LevelSettingsType
  AirFriction As Single
  Seed As Integer
  Description As String
  GravityAmount As Integer
  Episode As Integer
  Level As Integer
End Type
Global LevelSettings As LevelSettingsType
Public Sub ResetGame()
For I = 1 To ObjectsActive
  Call Entities.ResetObject(I)
Next I
ObjectsActive = 0
Call ResetMap
End Sub
Public Sub Initialize_GameEngine()
End Sub
Public Sub LoadLevel(Episode, Level, Seed)
SoundData.DeviceOn = False
Randomize Seed
Call SpawnObject(Entities.GetClassNum("EDF_BASEBUILDER"), 1, 7, 7, 0, 0, 0)
For I = 1 To 6
  Putx = Int(MaxMapX * Rnd) + 1
  Puty = Int(MaxMapY * Rnd) + 1
  If GroundBlocks(Putx, Puty).Occupied = False Then
    If Int(2 * Rnd) = 1 Then
      Call SpawnObject(1, 2, Putx, Puty, 0, 0, 0)
    Else
      Call SpawnObject(4, 2, Putx, Puty, 0, 0, 0)
    End If
  End If
Next I
For I = 1 To 7
  Putx = Int(6 * Rnd) + 3
  Puty = Int(6 * Rnd) + 3
  If GroundBlocks(Putx, Puty).Occupied = False Then
    newobj = SpawnObject(1, LocalPlayer.PlayerIndex, Putx, Puty, 0, 0, 0)
    Objects(newobj).Position.Z = GroundBlocks(Objects(newobj).MapPosition.X, Objects(newobj).MapPosition.Y).Height
  End If
Next I
Call Map.GenerateRandomMap(MaxMapX - 12, MaxMapY - 12, SEASON_SUMMER, 5, 5, 10, 70, 3, 3, 5, 5, 3, 4, 30, 4, 3, 4, 6, 3, 10)
SoundData.DeviceOn = True
End Sub
Public Sub StartNewGame(StartingEpisode, StartingLevel, Faction)
Call ResetGame
Call ResetGameEngine
'Temporary
LocalPlayer.PlayerIndex = SpawnPlayer(FACTION_EDF, 9999, 1)
Player(LocalPlayer.PlayerIndex).Faction = Faction
NewCompPlayer = SpawnPlayer(FACTION_EDF, 9999, 1)
Call AI.GenerateComputerPlayer(1, NewCompPlayer)
LevelSettings.Episode = StartingEpisode
LevelSettings.Level = StartingLevel
Call LoadLevel(StartingEpisode, StartingLevel, 5 * Rnd)
GameResult = RunGame
End Sub
Public Sub StartNewInternetGame(Seed)
Call ResetGameEngine
Call Internet.GetCurrentGameFromServer
GameResult = RunGame
Call Internet.Disconnect
End Sub
Public Sub Initialize_GameWindows()
GameControlPanel.PortRect.Top = ResolutionY - GAMECONTROLPANELSIZE
GameControlPanel.PortRect.bottom = ResolutionY
GameControlPanel.PortRect.Left = 0
GameControlPanel.PortRect.Right = ResolutionX
GameControlPanel.Height = GameControlPanel.PortRect.bottom - GameControlPanel.PortRect.Top
GameControlPanel.Width = GameControlPanel.PortRect.Right - GameControlPanel.PortRect.Left
For I = 1 To MAXBUILDWINDOWS
  BuildWindows(I).PortRect.Top = Int(((GameControlPanel.Height / 2) - (BUILDWINDOWSIZE / 2)) + GameControlPanel.PortRect.Top)
  BuildWindows(I).PortRect.bottom = BuildWindows(I).PortRect.Top + BUILDWINDOWSIZE
  BuildWindows(I).PortRect.Left = ((BUILDWINDOWSIZE) * (I - 1)) + 5
  BuildWindows(I).PortRect.Right = BuildWindows(I).PortRect.Left + BUILDWINDOWSIZE
  BuildWindows(I).Height = BuildWindows(I).PortRect.bottom - BuildWindows(I).PortRect.Top
  BuildWindows(I).Width = BuildWindows(I).PortRect.Right - BuildWindows(I).PortRect.Left
Next I

BattleViewPort.PortRect.Top = 0
BattleViewPort.PortRect.bottom = ResolutionY - GAMECONTROLPANELSIZE
BattleViewPort.PortRect.Left = 0
BattleViewPort.PortRect.Right = ResolutionX
BattleViewPort.Height = BattleViewPort.PortRect.bottom - BattleViewPort.PortRect.Top
BattleViewPort.Width = BattleViewPort.PortRect.Right - BattleViewPort.PortRect.Left
RadarWindow.PortRect.Top = GameControlPanel.PortRect.Top - RADARWINDOWSIZE
RadarWindow.PortRect.bottom = RadarWindow.PortRect.Top + RADARWINDOWSIZE
RadarWindow.PortRect.Left = ResolutionX - RADARWINDOWSIZE
RadarWindow.PortRect.Right = RadarWindow.PortRect.Left + RADARWINDOWSIZE
RadarButton.PortRect.Top = GameControlPanel.PortRect.Top + (GameControlPanel.Height / 2) - 5
RadarButton.PortRect.bottom = RadarButton.PortRect.Top + 10
RadarButton.PortRect.Left = (ResolutionX - RADARWINDOWSIZE) - 10
RadarButton.PortRect.Right = ResolutionX
RadarButton.Height = RadarButton.PortRect.bottom - RadarButton.PortRect.Top
RadarButton.Width = RadarButton.PortRect.Right - RadarButton.PortRect.Left
End Sub

Public Sub Initialize_BattleView()
Select Case ResolutionY
Case 200
  GameEngine.View.MaxScrollSpeed = 10
  GraphicsEngineData.TerrainRefreshSize = 1
Case 400
  GameEngine.View.MaxScrollSpeed = 20
  GraphicsEngineData.TerrainRefreshSize = 2
Case 480
  GameEngine.View.MaxScrollSpeed = 20
  GraphicsEngineData.TerrainRefreshSize = 3
Case 600
  GameEngine.View.MaxScrollSpeed = 20
  GraphicsEngineData.TerrainRefreshSize = 4
End Select

GameEngine.View.Width = BattleViewPort.Width
GameEngine.View.Height = BattleViewPort.Height
GameEngine.View.MaxLeft = ((Map.BattleMap.Width * MapBlockSize) - GameEngine.View.Width) + MapBlockSize
GameEngine.View.MaxTop = ((Map.BattleMap.Height * MapBlockSize) - GameEngine.View.Height) + MapBlockSize
If GameEngine.View.MaxLeft < 0 Then GameEngine.View.MaxLeft = 0
If GameEngine.View.MaxTop < 0 Then GameEngine.View.MaxTop = 0
End Sub
Public Sub ResetEngine()
EngineControls.InterruptGame = False
End Sub
Private Sub ResetGameEngine()
ViewForm.KeyboardInputBox.Text = ""
Call ResetEngine
Call KillAllPlayers
Call GameInterface.ClearKeyStates
Call GameInterface.InitializeInterface
End Sub
Public Function PopupMessageWindow(WndCap, WndTxt)
    MessageWindow.Active = True
MessageWindow.Caption = WndCap
MessageWindow.Text = WndTxt
Do
  DoEvents
  Call GraphicsEngine.ClearBackBuffer
  Call GraphicsEngine.SplashGraphic(InGameConstants(InGameConstant_PICINDEX_ProgramBackground))
  Call GraphicsEngine.DisplayMessageWindow
  Call GraphicsEngine.SwapScreen
  For I = 1 To 5
    If Mouse.ButtonStates(I) = True Then Exit Do
  Next I
Loop
Mouse.ButtonStates(I) = False
MessageWindow.Active = False
End Function
Public Function RunGame() As Integer
Const MAXTICKS = 1
Dim Ticks(MAXTICKS) As Integer, HeartBeatInt As Integer
MaxMessages = 4
Call Sound.Stop_Sounds
Call Sound.Play_LoopSound(Sound.GetSoundIndex("music"), 0)
Call GraphicsEngine.RedrawControlPanel
Call RenderTerrain
Do
                HeartBeatInt = HeartBeatInt + 10
                If HeartBeatInt > 360 Then HeartBeatInt = 1
                GameEngine.EngineData.HeartBeat = (SinTable(HeartBeatInt) * 100) + 155
                CounterStartTime = Timer
                
                DoEvents
                
  
  For I = 1 To MAXTICKS
    Ticks(I) = Ticks(I) + 1
  Next I
  If Ticks(1) > 20 Then
    Ticks(1) = 0
    For I = 1 To MaxMessages - 1
      InternetMessageBox.LinesActive(I) = InternetMessageBox.LinesActive(I + 1)
     InternetMessageBox.TextLines(I) = InternetMessageBox.TextLines(I + 1)
    Next I
    InternetMessageBox.LinesActive(MaxMessages) = False
  End If
  Call RunMisc
  If Internet.ServerData.ConnectedToServer = True Then
    Call Internet.IncomingDataHandler
  End If
  Call Players.RunBuilds
  Call Music.KeepMusicPlaying
  Call RunComputerPlayers
  Call RunVisualEffects
  Call ProcessInputEvents
  If EngineControls.InterruptGame = True Then Exit Do
  Call Entities.RunWorld
  Call GraphicsEngine.Render
  Do
    If Timer > CounterStartTime + GameCycleTime Then Exit Do
  
  Loop
Loop
RunGame = EngineControls.ReasonForInterrupt
Sound.Stop_Sounds
End Function
Public Sub RunMisc()
With GameEngine.View
  If .ScrollSpeedEW > 0 Then
    Call ScrollView(DIRECTION_RIGHT)
    .ScrollSpeedEW = .ScrollSpeedEW - 1
  End If
  If .ScrollSpeedEW < 0 Then
    Call ScrollView(DIRECTION_LEFT)
    .ScrollSpeedEW = .ScrollSpeedEW + 1
  End If
  If .ScrollSpeedNS < 0 Then
    Call ScrollView(DIRECTION_UP)
    .ScrollSpeedNS = .ScrollSpeedNS + 1
  End If
  If .ScrollSpeedNS > 0 Then
    Call ScrollView(DIRECTION_DOWN)
    .ScrollSpeedNS = .ScrollSpeedNS - 1
  End If
End With
End Sub
Public Function CauseEngineInterrupt(Reason As Integer)
EngineControls.InterruptGame = True
EngineControls.ReasonForInterrupt = Reason
End Function
Public Sub ProcessInputEvents()
'Mouse input
Call ProcessMouseInput
'Keyboard input
Call ProcessKeyboardEvents
End Sub
Public Sub ScrollView(Direction)
Select Case Direction
Case DIRECTION_UP
  If GameEngine.View.Top > 0 Then
    GameEngine.View.Top = GameEngine.View.Top + GameEngine.View.ScrollSpeedNS
    ScrollDistance = -GameEngine.View.ScrollSpeedNS
    If GameEngine.View.Top < 0 Then
      ScrollDistance = ScrollDistance + (GameEngine.View.Top)
      GameEngine.View.Top = 0
      Call RenderTerrain
    Else
      Call MoveTerrain(Direction, ScrollDistance)
    End If
  End If
Case DIRECTION_RIGHT
  If GameEngine.View.Left < GameEngine.View.MaxLeft Then
    GameEngine.View.Left = GameEngine.View.Left + GameEngine.View.ScrollSpeedEW
    ScrollDistance = GameEngine.View.ScrollSpeedEW
    If GameEngine.View.Left > GameEngine.View.MaxLeft Then
      ScrollDistance = ScrollDistance - (GameEngine.View.MaxLeft - GameEngine.View.Left)
      GameEngine.View.Left = GameEngine.View.MaxLeft
      Call RenderTerrain
    Else
      Call MoveTerrain(Direction, ScrollDistance)
    End If
  End If
Case DIRECTION_DOWN
  If GameEngine.View.Top < GameEngine.View.MaxTop Then
    GameEngine.View.Top = GameEngine.View.Top + GameEngine.View.ScrollSpeedNS
    ScrollDistance = GameEngine.View.ScrollSpeedNS
    If GameEngine.View.Top > GameEngine.View.MaxTop Then
      ScrollDistance = ScrollDistance - (GameEngine.View.MaxTop - GameEngine.View.Top)
      GameEngine.View.Top = GameEngine.View.MaxTop
      Call RenderTerrain
    Else
      Call MoveTerrain(Direction, ScrollDistance)
    End If
  End If
Case DIRECTION_LEFT
  If GameEngine.View.Left > 0 Then
    GameEngine.View.Left = GameEngine.View.Left + GameEngine.View.ScrollSpeedEW
    ScrollDistance = -GameEngine.View.ScrollSpeedEW
    If GameEngine.View.Left < 0 Then
      ScrollDistance = ScrollDistance + (GameEngine.View.Left)
      GameEngine.View.Left = 0
      Call RenderTerrain
    Else
      Call MoveTerrain(Direction, ScrollDistance)
    End If
  End If
End Select
End Sub
Sub AddInertiaToScroll(Direction)
Select Case Direction
Case DIRECTION_UP
  If -GameEngine.View.ScrollSpeedNS < GameEngine.View.MaxScrollSpeed Then GameEngine.View.ScrollSpeedNS = GameEngine.View.ScrollSpeedNS - 2
Case DIRECTION_RIGHT
  If GameEngine.View.ScrollSpeedEW < GameEngine.View.MaxScrollSpeed Then GameEngine.View.ScrollSpeedEW = GameEngine.View.ScrollSpeedEW + 2
Case DIRECTION_DOWN
  If GameEngine.View.ScrollSpeedNS < GameEngine.View.MaxScrollSpeed Then GameEngine.View.ScrollSpeedNS = GameEngine.View.ScrollSpeedNS + 2
Case DIRECTION_LEFT
  If -GameEngine.View.ScrollSpeedEW < GameEngine.View.MaxScrollSpeed Then GameEngine.View.ScrollSpeedEW = GameEngine.View.ScrollSpeedEW - 2
End Select
End Sub
