Attribute VB_Name = "Events"
Public Const Event_SpawnObject = 1
Public Const Event_ObjectFire = 2
Public Const Event_DestroyObject = 3
Public Const Event_DirectUnit = 4
Public Const Event_DeployUnit = 5
Public Const Event_UpdateUnit = 6

Public Const MaxEventParamaters = 10
Public Const EventDataLength = 4
Public Type EventObj
  EventType As Integer
  Paramaters(MaxEventParamaters) As String
End Type
Public Sub RegisterEvent(EventObject As EventObj)
If Internet.ServerData.ConnectedToServer = True Then
  SendString$ = Format$(EventObject.EventType, "0000")
  For I = 1 To MaxEventParamaters
    SendString$ = SendString$ & Format$(EventObject.Paramaters(I), "0000")
  Next I
  Call Internet.SendData(CODE_EVENT, SendString$)
  'Internet.WaitForIncomingData
Else
  Call RunEvent(EventObject)
End If
End Sub
Public Sub SpawnEvent(EventType, Optional ByRef Param1, Optional ByRef Param2, Optional ByRef Param3, Optional ByRef Param4, Optional ByRef Param5, Optional ByRef Param6, Optional ByRef Param7, Optional ByRef Param8, Optional ByRef Param9, Optional ByRef Param10)
Dim NewEvent As EventObj
On Error Resume Next
Select Case EventType
End Select
With NewEvent
  .EventType = EventType
  .Paramaters(1) = Param1
  .Paramaters(2) = Param2
  .Paramaters(3) = Param3
  .Paramaters(4) = Param4
  .Paramaters(5) = Param5
  .Paramaters(6) = Param6
  .Paramaters(7) = Param7
  .Paramaters(8) = Param8
  .Paramaters(9) = Param9
  .Paramaters(10) = Param10
End With
Call RegisterEvent(NewEvent)
End Sub
Public Sub RunEvent(EventObject As EventObj)
Select Case EventObject.EventType
Case Event_SpawnObject
  NewObject = Entities.SpawnObject(Val(EventObject.Paramaters(1)), Val(EventObject.Paramaters(2)), Val(EventObject.Paramaters(3)), Val(EventObject.Paramaters(4)), Val(EventObject.Paramaters(5)), Val(EventObject.Paramaters(6)), Val(EventObject.Paramaters(7)))
Case Event_ObjectFire
  Call Entities.ObjectCommand_Fire(Val(EventObject.Paramaters(1)), Val(EventObject.Paramaters(2)), Val(EventObject.Paramaters(3)), Val(EventObject.Paramaters(4)), Val(EventObject.Paramaters(5)))
Case Event_DestroyObject
  Call Entities.DestroyObject(Val(EventObject.Paramaters(1)))
Case Event_DirectUnit
  Call Entities.DirectUnit(Val(EventObject.Paramaters(1)), Val(EventObject.Paramaters(2)), Val(EventObject.Paramaters(3)), Val(EventObject.Paramaters(4)))
Case Event_DeployUnit
  Call Entities.ObjectCommand_Deploy(Val(EventObject.Paramaters(1)))
Case Event_UpdateUnit
  ObjIndex = Val(EventObject.Paramaters(1))
  Objects(ObjIndex).Position.X = Val(EventObject.Paramaters(1))
  Objects(ObjIndex).Position.Y = Val(EventObject.Paramaters(2))
  Objects(ObjIndex).Position.Z = Val(EventObject.Paramaters(3))
  Objects(ObjIndex).Vector.Yaw = Val(EventObject.Paramaters(4))
  Objects(ObjIndex).CurrentSpeed = Val(EventObject.Paramaters(5))
  Objects(ObjIndex).Objective.Goal = Val(EventObject.Paramaters(6))
  Objects(ObjIndex).States(Val(EventObject.Paramaters(7))) = True
  Objects(ObjIndex).Properties(PROPERTY_HEALTH) = Val(EventObject.Paramaters(8))
End Select
'If .Side = LocalPlayer.PlayerIndex Then Call Events.SpawnEvent(Events.Event_UpdateUnit, Objindex, .Position.X, .Position.Y, .Position.Z, .Vector.Yaw, .CurrentSpeed, .Objective.Goal, .State, .Properties(PROPERTY_HEALTH))
End Sub

