Attribute VB_Name = "Entities"
Private Type PointList
  PathPoints(200) As Point2D
  PathPointsActive As Integer
End Type
Private Type PathNode
  Points As PointList
  Stuck As Boolean
End Type
Private Type PathObj
  Points As PointList
End Type


Global Const DISTANCEBEFOREOUTOFWAY = 30
Global Const DELAYWEAPON = -1
Global Const NOOBJECT = 0
Global Const OBJCONST_ObjectStopDistance = 6
Global Const OBJCONST_MissileStopDistance = 8
Global Const OBJCONST_TimeTillAdjustDirection = 3

Global Const NOMAPIMPRINT = 0

Global Const IMPRINTSIZE = 10
Global Const HALFIMPRINTSIZE = IMPRINTSIZE / 2
Private Type MapTemplate
  ImprintName As String
  ImprintArray(IMPRINTSIZE, IMPRINTSIZE) As Boolean
End Type
Global Const MAXIMPRINTS = 80
Public MapImprints(MAXIMPRINTS) As MapTemplate

'Ability List
Global Const MAXABILITIES = 55
Global Const ABILITY_MOVES = 1
Global Const ABILITY_FLIES = 2
Global Const ABILITY_CANLANDONGROUND = 3 'For helicopters and such.  Everything can land on a landing pad.
Global Const ABILITY_SHOOTS = 4
Global Const ABILITY_HARVESTS = 5
Global Const ABILITY_CARRIESPEOPLE = 6
Global Const ABILITY_PANICS = 7
Global Const ABILITY_REPAIRABLE = 8
Global Const ABILITY_SELFHEALING = 9
Global Const ABILITY_CRAWLS = 10
Global Const ABILITY_RETREATS = 11
Global Const ABILITY_GETSPOWERUPS = 12
Global Const ABILITY_RELIESONELECTRICITY = 13
Global Const ABILITY_REACHESTARGETINSTANTLY = 14
Global Const ABILITY_UNLIMITEDAMMO = 15
Global Const ABILITY_FIRESDOUBLE = 16
Global Const ABILITY_LEAVESSPARKLETRAIL = 17
Global Const ABILITY_BLEEDSWHENHIT = 18
Global Const ABILITY_THROWSMETALWHENHIT = 19
Global Const ABILITY_THROWSBLOODATDEATH = 20
Global Const ABILITY_THROWSMETALATDEATH = 21
Global Const ABILITY_PROCESSESMATERIALS = 22
Global Const ABILITY_REPAIRSVEHICLES = 23
Global Const ABILITY_REPAIRSPEOPLE = 24
Global Const ABILITY_AIRCRAFTPAD = 25 'for landing aircraft
Global Const ABILITY_NAVALDOCK = 26 'for boats
Global Const ABILITY_RESSURECTS = 27
Global Const ABILITY_LEAVESWRECKAGE = 28
Global Const ABILITY_SELECTABLE = 29
Global Const ABILITY_FOLLOWSTARGET = 30
Global Const ABILITY_RELIESONSTRENGTH = 31
Global Const ABILITY_CANBECOMEINVISIBLE = 32
Global Const ABILITY_ENTERSBUILDINGS = 33
Global Const ABILITY_ISPHYSICAL = 34
Global Const ABILITY_GETTABLE = 35
Global Const ABILITY_HITTABLE = 36
Global Const ABILITY_INFECTABLE = 37
Global Const ABILITY_AFFECTEDBYDISEASE = 38
Global Const ABILITY_COMBUSTUBLE = 39
Global Const ABILITY_EXPLODESWITHFIRE = 40
Global Const ABILITY_DEPLOYS = 41
Global Const ABILITY_BUILDS = 42
Global Const ABILITY_BUILDABLE = 43
Global Const ABILITY_CANBEDAMAGED = 44
Global Const ABILITY_BODYISBISECTED = 45
Global Const ABILITY_THROWSSPARKLESATCOLLIDE = 46
Global Const ABILITY_FRAMES_SHOOTING = 47
Global Const ABILITY_SPLASHESWATER = 48
Global Const ABILITY_HASDNA = 49
Global Const ABILITY_EMOTIONS = 50
Global Const ABILITY_LEADER = 51
Global Const ABILITY_SHOOTSLIGHTNINGONBUILD = 52
Global Const ABILITY_REQUIRESTRACTION = 53
Global Const ABILITY_USESINERTIA = 54
Global Const ABILITY_HASSHADOW = 55

'Attribute List
Global Const MAXMODELATTRIBUTES = 52
Global Const ATTRIBUTE_SPRITE = 1
Global Const ATTRIBUTE_SIZE = 2
Global Const ATTRIBUTE_LENGTHX = 3
Global Const ATTRIBUTE_LENGTHY = 4
Global Const ATTRIBUTE_LENGTHZ = 5  'Higher up, more Z
Global Const ATTRIBUTE_MAXSPEED = 6
Global Const ATTRIBUTE_BULLETARMOR = 7
Global Const ATTRIBUTE_SHELLARMOR = 8
Global Const ATTRIBUTE_BOMBARMOR = 9
Global Const ATTRIBUTE_FIREARMOR = 10
Global Const ATTRIBUTE_ELECTROMAGNETICARMOR = 11
Global Const ATTRIBUTE_RADIATIONARMOR = 12
Global Const ATTRIBUTE_MAXAMMO = 13 'only effective if UnlimitedAmmo is False
Global Const ATTRIBUTE_EXPLOSIONTYPE = 14
Global Const ATTRIBUTE_EXPLOSIONINTENSITY = 15
Global Const ATTRIBUTE_EXPLOSIONRADIUS = 16 'Determines also how many sparks will fly
Global Const ATTRIBUTE_EXPLOSIONSPRITE = 17 'In the game, the Sprite Groups will be variations of the same Explosion type :)
Global Const ATTRIBUTE_POWERREQUIRED = 18
Global Const ATTRIBUTE_OBJECTBUILDTYPE = 19
Global Const ATTRIBUTE_COST = 20
Global Const ATTRIBUTE_HEALTH = 21
Global Const ATTRIBUTE_WEIGHT = 22
Global Const ATTRIBUTE_ACCURACY = 23
Global Const ATTRIBUTE_STRENGTH = 24
Global Const ATTRIBUTE_SHOOTRADIUS = 25
Global Const ATTRIBUTE_MINIMUMSHOOTRADIUS = 26
Global Const ATTRIBUTE_DIRECTIONAMOUNT = 27
Global Const ATTRIBUTE_SIGHTRADIUS = 28
Global Const ATTRIBUTE_SOUNDGROUP = 29
Global Const ATTRIBUTE_SIDE = 30
Global Const ATTRIBUTE_GETTABLEPOWERUPTYPE = 31
Global Const ATTRIBUTE_MAPIMPRINT = 32
Global Const ATTRIBUTE_SPRITEPOSITIONX = 33
Global Const ATTRIBUTE_SPRITEPOSITIONY = 34
Global Const ATTRIBUTE_COMBUSTIONTEMPERATURE = 35
Global Const ATTRIBUTE_DEPLOYOBJECT = 36
Global Const ATTRIBUTE_TECHLEVEL = 37
Global Const ATTRIBUTE_BUILDPICTURE = 38
Global Const ATTRIBUTE_TOPSPRITE = 39
Global Const ATTRIBUTE_TOPDIRECTIONAMOUNT = 40
Global Const ATTRIBUTE_TOPSPRITEPOSITIONX = 41
Global Const ATTRIBUTE_TOPSPRITEPOSITIONY = 42
Global Const ATTRIBUTE_BUILDATFRAME = 43
Global Const ATTRIBUTE_REQUIREDBEFOREBUILD = 44
Global Const ATTRIBUTE_IMPORTANCE = 45
Global Const ATTRIBUTE_ENGINEPOWER = 46
Global Const ATTRIBUTE_TURNSPEED = 47
Global Const ATTRIBUTE_SHADOWPIC = 48
Global Const ATTRIBUTE_WEAPONX = 49
Global Const ATTRIBUTE_WEAPONY = 50
Global Const ATTRIBUTE_DEFAULTWEAPONOBJECT = 51
Global Const ATTRIBUTE_WEAPONCHARGETIME = 52

'The Behavior types
Global Const MAXBEHAVIORMODES = 7
Global Const BEHAVIORMODE_NONE = -1
Global Const BEHAVIORMODE_INANIMATE = 0
Global Const BEHAVIORMODE_BUILDING = 1
Global Const BEHAVIORMODE_SOLDIER = 2
Global Const BEHAVIORMODE_SHIP = 3
Global Const BEHAVIORMODE_TANK = 4
Global Const BEHAVIORMODE_AIRCRAFT = 5
Global Const BEHAVIORMODE_SPACECRAFT = 6
Global Const BEHAVIORMODE_WEAPON = 7

'Explosion Behavior
Global Const EXPLODETYPE_BULLET = 1
Global Const EXPLODETYPE_SHELL = 2
Global Const EXPLODETYPE_BOMB = 3
Global Const EXPLODETYPE_FIRE = 4
Global Const EXPLODETYPE_ELECTROMAGNETIC = 5
Global Const EXPLODETYPE_RADIATION = 6

Global Const MAXCONSTS = 4
Global Const CONST_DIRECTIONDIV = 1
Global Const CONST_DIRECTIONDIVDIV = 2
Global Const CONST_TOPDIRECTIONDIV = 3
Global Const CONST_TOPDIRECTIONDIVDIV = 4

Type Objzmods
  Consts(MAXCONSTS) As Single
  BehaviorType As Integer
  ObjClassName As String
  ObjName As String
  Abilities(MAXABILITIES) As Boolean
  Attributes(MAXMODELATTRIBUTES) As Integer
  MapImprintNumber As Integer
  SoundGroup As SoundObj
End Type

Global Const MaxObjModels = 100 'for the following line
Global ObjModels(MaxObjModels) As Objzmods
Global MaxObjModTypes As Integer 'For the program
Global Const NOTARGET = -1 'For the PROPERTY_TARGET
Global Const TARGETGROUND = -2 'For the PROPERTY_TARGET

'Object Attributes
Global Const MAXOBJECTPROPERTIES = 17
Global Const PROPERTY_PEOPLECONTAINED = 1
Global Const PROPERTY_GEMSCONTAINED = 2
Global Const PROPERTY_HEALTH = 3
Global Const PROPERTY_TIMEUNTILADJUSTDIRECTION = 4
Global Const PROPERTY_OBJECTTOPATROL = 5
Global Const PROPERTY_HOMEOBJECT = 6
Global Const PROPERTY_WEAPONCHARGE = 7
Global Const PROPERTY_CRAWLING = 8 'true false
Global Const PROPERTY_BUILDOBJECTTYPE = 9
Global Const PROPERTY_BUILDPROGRESS = 10
Global Const PROPERTY_FUEL = 11
Global Const PROPERTY_LASTCOMMAND = 12
Global Const PROPERTY_CLASSTOBUILD = 13
Global Const PROPERTY_TIMEREMAININGONSITSTILL = 14
Global Const PROPERTY_POSITIONTEMPX = 15
Global Const PROPERTY_POSITIONTEMPY = 16
Global Const PROPERTY_WEAPONOBJECTTYPE = 17

'Goals
Global Const GOAL_NOTHING = 1
Global Const GOAL_MOVESOMEWHERE = 2
Global Const GOAL_STANDGROUND = 3
Global Const GOAL_ATTACK = 4
Global Const GOAL_GUARD = 5
Global Const GOAL_PATROL = 6
Global Const GOAL_HARVESTGEMS = 7
Global Const GOAL_INVADE = 8
Global Const GOAL_RETURNTOHOME = 9
Global Const GOAL_SCOUT = 10
Global Const GOAL_CAMP = 11
Global Const GOAL_BUILD = 12
Global Const GOAL_GETOUTOFTHEWAY = 13
Global Const GOAL_GETFARTHERAWAYFROMTARGET = 14
Global Const GOAL_SITSTILL = 15
Global Const GOAL_FOLLOWPATH = 16

Global Const MAXSTATES = 9
'States
Global Const STATE_MOVING = 2
Global Const STATE_FIRING = 3
Global Const STATE_CAMPING = 4
Global Const STATE_REPAIRING = 5
Global Const STATE_BUILDING = 6
Global Const STATE_TAKINGOFF = 7
Global Const STATE_LANDING = 8
Global Const STATE_MOVINGANDFIRING = 9

Global Const MAXGENETICS = 3
Global Const GENETIC_SPEED = 1
Global Const GENETIC_RESILIENCE = 2
Global Const GENETIC_INTELLIGENCE = 3

Global Const GeneticRange = 10
Global Const HalfGeneticRange = GeneticRange / 2

Public Type DNAType
  Genetics(MAXGENETICS) As Integer
End Type

Global Const MAXEMOTIONS = 4
Global Const EMOTION_HAPPY = 1
Global Const EMOTION_SAD = 2
Global Const EMOTION_SCARED = 3
Global Const EMOTION_HATE = 4

Private Type EmotionType
  EmotionsOn As Boolean
  Emotions(MAXEMOTIONS) As Integer
End Type

Private Type BrainType
  Emotions As EmotionType
End Type

Type UnitObjective
  Goal As Integer
  Target As Integer
  TargetPosition As Point3D
  MainDestination As Point3D
  CurrentDestination As Point3D
  Path As PathObj
  CurrentPathPoint As Integer
  Speed As Integer
End Type

Global Const MAXTAGS = 3
Global Const TAG_BLOCKED = 1

Type ObjThing
  Objective As UnitObjective
  Active As Boolean
  Brain As BrainType
  DNA As DNAType
  ModelIndex As Integer
  Side As Integer
  States(MAXSTATES) As Boolean
  Position As Point3D
  MapPosition As Point3D
  Vector As Vect3D
  CurrentSpeed As Integer
  DisplayDirection As Integer
  Properties(MAXOBJECTPROPERTIES) As Integer
  Sprite As SpriteDefType
  Frozen As Boolean
  TopSprite As SpriteDefType
  TopDirection As Integer
  TopDisplayDirection As Integer
  InertiaDirection As Vect3D
  InertiaSpeed As Integer
  InertiaSpeedUp As Single

  ObjectTags(MAXTAGS) As Boolean
End Type

Global Const MAXOBJECTS = 999
Global Objects(MAXOBJECTS) As ObjThing
Global ObjectsActive As Integer
Global Const OBJCHECK_ALIVE = 1
Global Const OBJCHECK_CANBEDIRECTED = 2
Global Const OBJCHECK_CANBESELECTED = 3
Global Const OBJCHECK_CANATTACK = 4
Global Const OBJCHECK_CANMOVE = 5
Global Const OBJCHECK_OCCUPIESMAPSPACE = 6
Global Const OBJCHECK_SELECTABLE = 7
Global Const OBJCHECK_HITTABLE = 8
Global Const OBJCHECK_VISIBLE = 9

Global Const INSTRUCTION_FORCEATTACK = 1
Global Const INSTRUCTION_FORCEMOVE = 2

Global Const SPRITEGROUP_NORMAL = 1
Global Const SPRITEGROUP_SHOOTING = 2
Global Const SPRITEGROUP_BUILDING = 3
Public Function FindPath(ObjIndex, X, Y, UnpassableTerrain) As PathObj
'Pathfinding algorithm

'FindPath.Points = PathNodes(FoundIndex).Points
End Function
Public Sub Assign_DNA(ObjIndex)
For I = 1 To MAXGENETICS
  Objects(I).DNA.Genetics(I) = Int(GeneticRange * Rnd) - HalfGeneticRange
Next I
End Sub
Public Function CheckObject(ObjIndex, CheckType) As Boolean
With ObjModels(Objects(ObjIndex).ModelIndex)
    Select Case CheckType
    Case OBJCHECK_ALIVE
      If Objects(ObjIndex).Active = True Then
        CheckObject = True
      End If
    Case OBJCHECK_CANBEDIRECTED
      If .Abilities(ABILITY_MOVES) = True Then
        CheckObject = True
      End If
    Case OBJCHECK_CANBESELECTED
      If .Abilities(ABILITY_SELECTABLE) = True Then
        CheckObject = True
      End If
    Case OBJCHECK_CANATTACK
      If .Abilities(ABILITY_SHOOTS) = True Then
        CheckObject = True
      End If
    Case OBJCHECK_CANMOVE
      If .Abilities(ABILITY_MOVES) = True Then
        CheckObject = True
      End If
    Case OBJCHECK_OCCUPIESMAPSPACE
      If .Abilities(ABILITY_ISPHYSICAL) = True Then
        CheckObject = True
      End If
    Case OBJCHECK_SELECTABLE
      If .Abilities(ABILITY_SELECTABLE) = True Then
        If Objects(ObjIndex).Side = LocalPlayer.PlayerIndex Then
          CheckObject = True
        End If
      End If
    Case OBJCHECK_HITTABLE
      If .Abilities(ABILITY_HITTABLE) = True Then
        CheckObject = True
      End If
    Case OBJCHECK_VISIBLE
      If .Attributes(ATTRIBUTE_SPRITE) <> NOSPRITE Then
        CheckObject = True
      End If
    End Select
End With
End Function
Public Sub DirectUnit(ObjIndex, XPoint, YPoint, ManualInstruction)
Const DONOTEXECUTEGOAL = 999
'Figure out what the instruction is
X = Map.ProjectToMapX(XPoint)
Y = Map.ProjectToMapY(YPoint)
If X < 0 Then X = 0
If Y < 0 Then Y = 0
Call Map.SetGroundUnOccupiedByObject(ObjIndex)

With GroundBlocks(X, Y)
    Instruction = GOAL_NOTHING
    If IsMapBlockEmptyXY(X, Y) = True Then
      Instruction = GOAL_NOTHING
    Else
      If Objects(.OccupyingObject).Side <> LocalPlayer.PlayerIndex Then
        If Objects(.OccupyingObject).Side <> SIDE_SCENERY Then
          If CheckObject(.OccupyingObject, OBJCHECK_HITTABLE) = True Then
            Instruction = GOAL_ATTACK
          End If
        End If
      End If
    End If
    For I = 1 To ObjectsActive
      If CheckObject(I, OBJCHECK_ALIVE) = True Then
        If Objects(I).Side <> LocalPlayer.PlayerIndex = True Then
          If Objects(I).Side <> SIDE_SCENERY = True Then
            Dim Temppoint As Point3D
            Temppoint.X = XPoint
            Temppoint.Y = YPoint
            If CheckObject(I, OBJCHECK_HITTABLE) = True Then
              If CheckIfPointIsOnUnit(I, Temppoint) = True Then
                Instruction = DONOTEXECUTEGOAL
                Call ObjectCommand_AttackObject(ObjIndex, I, X, Y)
              End If
            End If
          End If
        End If
      End If
    Next I
    If Instruction = GOAL_NOTHING Then
      If ObjModels(Objects(ObjIndex).ModelIndex).Abilities(ABILITY_HARVESTS) Then
        If .TerrainType = TERRAINTYPE_GEMS Then
          Instruction = GOAL_HARVESTGEMS
        End If
      End If
    End If
    If Instruction = GOAL_NOTHING Then Instruction = GOAL_MOVESOMEWHERE
    
    If ManualInstruction = INSTRUCTION_FORCEATTACK Then
      Instruction = GOAL_ATTACK
    End If
    
    If ManualInstruction = INSTRUCTION_FORCEMOVE Then
      Instruction = GOAL_MOVESOMEWHERE
    End If
    
    'Carry out the instruction
    Select Case Instruction
    Case GOAL_MOVESOMEWHERE
      If CheckObject(ObjIndex, OBJCHECK_CANBEDIRECTED) = True Then
        Call ObjectCommand_MoveSomewhere(ObjIndex, X, Y)
      End If
    Case GOAL_ATTACK
      If CheckObject(ObjIndex, OBJCHECK_CANBEDIRECTED) = True Then
        If CheckObject(ObjIndex, OBJCHECK_CANATTACK) = True Then
          OccupyObj = .OccupyingObject
          If .Occupied = False Then OccupyObj = TARGETGROUND
          Call ObjectCommand_AttackObject(ObjIndex, OccupyObj, X, Y)
        End If
      End If
    End Select
    Call Map.SetGroundOccupiedByObject(ObjIndex)
End With
End Sub
Public Sub ObjectEmitSound(ObjIndex, SoundNumber)
Dim SoundNum As Integer
SoundNum = SoundNumber
Call Sound.Play_Sound(SoundNum, 0, 0)
End Sub
Public Sub ObjectCommand_MoveSomewhere(ObjIndex, X, Y)
Call ClearObjectStates(ObjIndex)
With Objects(ObjIndex)
  .Objective.Goal = GOAL_MOVESOMEWHERE
  .Objective.Speed = 0
  .States(STATE_MOVING) = False
End With
Call ChangeObjectDestination(ObjIndex, X, Y, 0)
End Sub
Public Sub ObjectCommand_AvoidCollision(ObjIndex, X, Y)
Dim TempPos As Point3D, TempVector As Vect3D
With Objects(ObjIndex)
  TempVector.Yaw = .Vector.Yaw + 22
  CheckVector TempVector
  .Vector.Yaw = TempVector.Yaw
  TempPos = Math.GetPropelCoordinates(.Position, .Vector.Yaw, 0, 70)
  If .Objective.Goal <> GOAL_GETOUTOFTHEWAY Then .Properties(PROPERTY_LASTCOMMAND) = .Objective.Goal
  .Objective.Goal = GOAL_GETOUTOFTHEWAY
  If .Objective.CurrentDestination.X < 0 Then .Objective.CurrentDestination.X = 0
  If .Objective.CurrentDestination.Y < 0 Then .Objective.CurrentDestination.Y = 0
  .Objective.CurrentDestination = Map.ProjectToMap3DPoint(TempPos)
End With
Call Entities.SetObjectDirection(ObjIndex, TempPos)
SetDisplayDirection ObjIndex
End Sub
Sub ClearObjectStates(ObjIndex)
For I = 1 To MAXSTATES
  Objects(ObjIndex).States(I) = False
Next I
End Sub
Public Sub ObjectCommand_BuildThis(ObjIndex, ClassToBuild)
Call ClearObjectStates(ObjIndex)
Objects(ObjIndex).States(STATE_BUILDING) = True
Objects(ObjIndex).Properties(PROPERTY_BUILDPROGRESS) = 0
Objects(ObjIndex).Properties(PROPERTY_CLASSTOBUILD) = ClassToBuild
Objects(ObjIndex).Sprite.SpriteGroupNumber = SPRITEGROUP_BUILDING
Objects(ObjIndex).Sprite.SpriteFrameNumber = 1
End Sub
Public Sub ObjectCommand_SitStillForTime(ObjIndex, TimeLength)
With Objects(ObjIndex)
  .Properties(PROPERTY_LASTCOMMAND) = .Objective.Goal
  .Properties(PROPERTY_TIMEREMAININGONSITSTILL) = TimeLength
  .Objective.Goal = GOAL_SITSTILL
  .States(STATE_MOVING) = False
  .Objective.Speed = 0
End With
End Sub
Public Sub ObjectCommand_AttackObject(ObjIndex, ObjectToAttack, X, Y)
Dim Temppoint As Point3D, TempVector As Vect3D, TargetPosition As Point3D
Call ClearObjectStates(ObjIndex)
With Objects(ObjIndex)
  .Objective.Goal = GOAL_ATTACK
  .Objective.Target = ObjectToAttack
  .Objective.TargetPosition.X = X
  .Objective.TargetPosition.Y = Y
  .Objective.Speed = 0
  TargetPosition = Map.UnProjectToMap3DPoint(.Objective.TargetPosition)
  TempVector.Yaw = Math.GetYawFromXY(TargetPosition.X, TargetPosition.Y, .Position.X, .Position.Y)
  Call CheckVector(TempVector)
  If .Objective.Target = TARGETGROUND Then
    DistOffsetVal = 0
  Else
    DistOffsetVal = ObjModels(Objects(.Objective.Target).ModelIndex).Attributes(ATTRIBUTE_SIZE) * MapBlockSize
  End If
  DistanceFromTarget = Math.GetDistance(Objects(ObjIndex).Position, Objects(ObjIndex).Objective.TargetPosition) - DistOffsetVal
  If DistanceFromTarget < ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS) Then
    Call ObjectCommand_GetFartherAwayFromTarget(ObjIndex, Map.ProjectToMap3DPoint(TargetPosition))
  Else
    If DistanceFromTarget > ObjModels(Objects(ObjIndex).ModelIndex).Attributes(ATTRIBUTE_SHOOTRADIUS) Then
      Temppoint = Map.ProjectToMap3DPoint(Math.GetPropelCoordinates(TargetPosition, TempVector.Yaw, 0, ((ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SHOOTRADIUS) - ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS)) / 2) + ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS) + DistOffsetVal))
      Call ChangeObjectDestination(ObjIndex, Temppoint.X, Temppoint.Y, 0)
    End If
  End If
End With
End Sub
Public Sub ObjectCommand_ContinueAttack(ObjIndex, ObjectToAttack, X, Y)
Dim Temppoint As Point3D, TempVector As Vect3D, TargetPosition As Point3D
With Objects(ObjIndex)
  .Objective.Goal = GOAL_ATTACK
  .Objective.Target = ObjectToAttack
  .Objective.TargetPosition.X = X
  .Objective.TargetPosition.Y = Y
  TargetPosition = Map.UnProjectToMap3DPoint(.Objective.TargetPosition)
  TempVector.Yaw = Math.GetYawFromXY(TargetPosition.X, TargetPosition.Y, .Position.X, .Position.Y)
  Call CheckVector(TempVector)
  Temppoint = Map.ProjectToMap3DPoint(Math.GetPropelCoordinates(TargetPosition, TempVector.Yaw, 0, ((ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SHOOTRADIUS) - ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS)) / 2) + ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS)))
End With
Call ChangeObjectDestination(ObjIndex, Temppoint.X, Temppoint.Y, 0)
End Sub
Public Sub ObjectCommand_CeaseAttack(ObjIndex)
With Objects(ObjIndex)
  .Objective.Goal = GOAL_NOTHING
  Call ClearObjectStates(ObjIndex)
  .Objective.Speed = 0
  .Objective.Target = NOTARGET
  .Objective.TargetPosition.X = .MapPosition.X
  .Objective.TargetPosition.Y = .MapPosition.Y
End With
End Sub

Public Sub ObjectCommand_Deploy(ObjIndex)
With Objects(ObjIndex)
  OBJDEPLOY = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_DEPLOYOBJECT)
  Side = .Side
  X = .MapPosition.X
  Y = .MapPosition.Y
End With
Call DestroyObject(ObjIndex)
newobj = SpawnObject(OBJDEPLOY, Side, X, Y, 0, 0, 0)
End Sub
Public Sub RunObjectAnimation(ObjIndex)
With Objects(ObjIndex)
  If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then
    .TopSprite.SpriteFrameTicks = .TopSprite.SpriteFrameTicks + 1
    If .TopSprite.SpriteFrameTicks > Sprites(ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TOPSPRITE)).SpriteGroups(.TopSprite.SpriteFrameNumber).Frames(.TopSprite.SpriteFrameNumber).FrameDuration Then
      .TopSprite.SpriteFrameTicks = 1
      .TopSprite.SpriteFrameNumber = .TopSprite.SpriteFrameNumber + 1
      If .TopSprite.SpriteFrameNumber > Sprites(ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TOPSPRITE)).SpriteGroups(.TopSprite.SpriteGroupNumber).FrameMax Then
        If Sprites(ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TOPSPRITE)).SpriteGroups(.TopSprite.SpriteFrameNumber).RepeatSequence = True Then
          .TopSprite.SpriteFrameNumber = 1
        Else
          .TopSprite.SpriteFrameNumber = 1
          .TopSprite.SpriteGroupNumber = SPRITEGROUP_NORMAL
        End If
      End If
    End If
  Else
    .Sprite.SpriteFrameTicks = .Sprite.SpriteFrameTicks + 1
    If .Sprite.SpriteFrameTicks > Sprites(.Sprite.SpriteNumber).SpriteGroups(.Sprite.SpriteGroupNumber).Frames(.Sprite.SpriteFrameNumber).FrameDuration Then
      .Sprite.SpriteFrameTicks = 1
      .Sprite.SpriteFrameNumber = .Sprite.SpriteFrameNumber + 1
      If .Sprite.SpriteFrameNumber > Sprites(.Sprite.SpriteNumber).SpriteGroups(.Sprite.SpriteGroupNumber).FrameMax Then
        If Sprites(.Sprite.SpriteGroupNumber).SpriteGroups(.Sprite.SpriteGroupNumber).RepeatSequence = True Then
          .Sprite.SpriteFrameNumber = 1
        Else
          .Sprite.SpriteFrameNumber = 1
          .Sprite.SpriteGroupNumber = SPRITEGROUP_NORMAL
        End If
      End If
    End If
  End If
End With
End Sub
Public Sub ObjectCommand_Fire(ObjIndex, X, Y, Z, Target)
Dim Temppoint As Point3D, TempPosition As Point3D
Call Object_PlaySound(ObjIndex, SoundEvent_Fire)
With Temppoint
  .X = X
  .Y = Y
  .Z = Z
End With
With Objects(ObjIndex)
  If ObjModels(.ModelIndex).Abilities(ABILITY_FRAMES_SHOOTING) = True Then
    If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then
      .TopSprite.SpriteGroupNumber = SPRITEGROUP_SHOOTING
      .TopSprite.SpriteFrameNumber = 1
    Else
      .Sprite.SpriteGroupNumber = SPRITEGROUP_SHOOTING
      .Sprite.SpriteFrameNumber = 1
    End If
  End If
  If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_ACCURACY) <> 0 Then
    Offset = (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_ACCURACY) * Rnd) - (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_ACCURACY) / 2)
  End If
  If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then
    FireYaw = .TopDirection
    TempPosition.X = .Position.X - ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEAPONX)
    TempPosition.Y = .Position.Y - ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEAPONY)
    TempPosition = Math.RotatePointAroundPoint(TempPosition, .Position, .TopDirection + Offset)
  Else
    FireYaw = .Vector.Yaw
    TempPosition.X = .Position.X - ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEAPONX)
    TempPosition.Y = .Position.Y - ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEAPONY)
    TempPosition = Math.RotatePointAroundPoint(TempPosition, .Position, .Vector.Yaw + Offset)
  End If
  
  
  FireX = TempPosition.X
  FireY = TempPosition.Y
  FireZIncline = 0
  .Properties(PROPERTY_WEAPONCHARGE) = 0
  newobj = SpawnObject(.Properties(PROPERTY_WEAPONOBJECTTYPE), .Side, Map.ProjectToMapX(FireX), Map.ProjectToMapY(FireY), FireZ, FireYaw, FireZIncline)
  Call RelocateObject(newobj, FireX, FireY, .Position.Z)
End With
With Objects(newobj)
  .Position.Z = (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_LENGTHZ) / 2) + .Position.Z
  Call ChangeObjectDestination(newobj, X, Y, Z)
  .Objective.Target = Target
  .Objective.TargetPosition = Temppoint
  .Properties(PROPERTY_FUEL) = Math.GetDistance(Objects(ObjIndex).Position, Map.UnProjectToMap3DPoint(Temppoint)) / (ObjModels(Objects(ObjIndex).ModelIndex).Attributes(ATTRIBUTE_MAXSPEED))
End With
End Sub
Public Sub RelocateObject(ObjIndex, NewX, NewY, NewZ)
If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then Call Map.SetGroundUnOccupiedByObject(ObjIndex)
With Objects(ObjIndex)
  .Position.X = NewX
  .Position.Y = NewY
  .Position.Z = NewZ
  Call Entities.SetObjectMapPosition(ObjIndex)
End With
If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then Call Map.SetGroundOccupiedByObject(ObjIndex)
End Sub
Public Sub ObjectCommand_GetOutOfTheWay(Obj1, Obj2, GetOutOfWayLength)
Dim Temppoint As Point3D, TempVector As Vect3D
With Objects(Obj1)
  TempVector.Yaw = Math.GetYawFromXY(.Position.X, .Position.Y, Objects(Obj2).Position.X, Objects(Obj2).Position.Y) + 180
  If TempVector.Yaw > Objects(Obj1).Vector.Yaw - 15 Then
    If TempVector.Yaw < Objects(Obj1).Vector.Yaw + 15 Then
      If Int(2 * Rnd) = 1 Then
        TempVector.Yaw = TempVector.Yaw - 15
      Else
        TempVector.Yaw = TempVector.Yaw + 15
      End If
    End If
  End If
  Call CheckVector(TempVector)
  If .Objective.Goal <> GOAL_GETOUTOFTHEWAY Then .Properties(PROPERTY_LASTCOMMAND) = .Objective.Goal
  .Properties(PROPERTY_POSITIONTEMPX) = .MapPosition.X
  .Properties(PROPERTY_POSITIONTEMPY) = .MapPosition.Y
  .Objective.Goal = GOAL_GETOUTOFTHEWAY
  Temppoint = Map.ProjectToMap3DPoint(Math.GetPropelCoordinates(.Position, TempVector.Yaw, 0, GetOutOfWayLength))
  Call Entities.ChangeObjectDestination(Obj1, Temppoint.X, Temppoint.Y, Temppoint.Z)
End With
End Sub
Public Sub ObjectCommand_CreatePath(ObjIndex, X, Y)
With Objects(ObjIndex)
  If .Objective.Goal <> GOAL_GETOUTOFTHEWAY Then .Properties(PROPERTY_LASTCOMMAND) = .Objective.Goal
  .Objective.Goal = GOAL_FOLLOWPATH
  .Objective.CurrentPathPoint = 1
  .Objective.Path = FindPath(ObjIndex, X, Y, TERRAINTYPE_WATER)
End With
End Sub
Public Sub ObjectCommand_GetFartherAwayFromTarget(Obj1, TargetPosition As Point3D)
Dim Temppoint As Point3D, TempVector As Vect3D
With Objects(Obj1)
  
  
  TempVector.Yaw = Math.GetYawFromXY(Map.UnProjectToMapX(TargetPosition.X), Map.UnProjectToMapY(TargetPosition.Y), .Position.X, .Position.Y) '+ 180
  
  Call CheckVector(TempVector)
  .Objective.Goal = GOAL_GETFARTHERAWAYFROMTARGET
  If .Objective.Target <> TARGETGROUND Then
    TargetSize = (ObjModels(Objects(.Objective.Target).ModelIndex).Attributes(ATTRIBUTE_SIZE) * MapBlockSize)
  Else
    TargetSize = 0
  End If
  Temppoint = Map.ProjectToMap3DPoint(Math.GetPropelCoordinates(Map.UnProjectToMap3DPoint(TargetPosition), TempVector.Yaw, 0, TargetSize + ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS) + 20))
  Call Entities.ChangeObjectDestination(Obj1, Temppoint.X, Temppoint.Y, Temppoint.Z)
End With
End Sub
Public Sub RunObject(ObjIndex)
Dim TempPos As Point3D
If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then Call SetGroundOccupiedByObject(ObjIndex)
Call RunObjectAnimation(ObjIndex)
With Objects(ObjIndex)
    If ObjModels(.ModelIndex).Abilities(ABILITY_USESINERTIA) = True Then
      'Friction
      If .Position.Z = GroundBlocks(.MapPosition.X, .MapPosition.Y).Height Then
        .CurrentSpeed = .CurrentSpeed - (GroundBlocks(.MapPosition.X, .MapPosition.Y).Friction * ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEIGHT))
        If .CurrentSpeed < 0 Then .CurrentSpeed = 0
      Else
        .CurrentSpeed = .CurrentSpeed - LevelSettings.AirFriction
      End If
      If .Objective.Speed > .CurrentSpeed Then
        .CurrentSpeed = .CurrentSpeed + (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_ENGINEPOWER) / ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEIGHT))
        If .CurrentSpeed > .Objective.Speed Then .CurrentSpeed = .Objective.Speed
      End If
      If .InertiaSpeed > 0 Then
        If .Position.Z = GroundBlocks(.MapPosition.X, .MapPosition.Y).Height Then
          .InertiaSpeed = .InertiaSpeed - (GroundBlocks(.MapPosition.X, .MapPosition.Y).Friction / ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEIGHT))
        Else
          .InertiaSpeed = .InertiaSpeed - LevelSettings.AirFriction
        End If
      End If
      If .Position.Z > GroundBlocks(.MapPosition.X, .MapPosition.Y).Height Then
        .InertiaSpeedUp = .InertiaSpeedUp - (LevelSettings.GravityAmount * (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEIGHT) + 1))
      End If
      Entities.SteerInertialDirection ObjIndex, .Vector.Yaw, 7
      .Position.Z = .Position.Z + .InertiaSpeedUp
      If .Position.Z <= GroundBlocks(.MapPosition.X, .MapPosition.Y).Height Then
        If .InertiaSpeedUp < 0 Then
          .Position.Z = GroundBlocks(.MapPosition.X, .MapPosition.Y).Height
          .InertiaSpeedUp = -(.InertiaSpeedUp / 4) - LevelSettings.GravityAmount
          If .InertiaSpeedUp < 3 Then
            .InertiaSpeedUp = 0
          End If
        End If
      End If
    Else
      .CurrentSpeed = .Objective.Speed
    End If
    Call RunBehavior(ObjIndex, ObjModels(.ModelIndex).BehaviorType)
    If .States(STATE_FIRING) = True Then
      If .Properties(PROPERTY_WEAPONCHARGE) <> DELAYWEAPON Then
        .Properties(PROPERTY_WEAPONCHARGE) = .Properties(PROPERTY_WEAPONCHARGE) + 1
        If .Properties(PROPERTY_WEAPONCHARGE) > ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEAPONCHARGETIME) Then
          .Properties(PROPERTY_WEAPONCHARGE) = DELAYWEAPON
          Call Events.SpawnEvent(Events.Event_ObjectFire, ObjIndex, .Objective.TargetPosition.X, .Objective.TargetPosition.Y, .Objective.TargetPosition.Z)
        End If
      End If
    End If
    If .CurrentSpeed > 0 Or .InertiaSpeed > 0 Then
      If ObjModels(.ModelIndex).Abilities(ABILITY_SPLASHESWATER) = True Then
        If GroundBlocks(.MapPosition.X, .MapPosition.Y).TerrainOverlayAmount > 1 Then
          If .Position.Z = GroundBlocks(.MapPosition.X, .MapPosition.Y).Height Then
            SparkDirection = Int(360 * Rnd)
            TempPos = Math.GetPropelCoordinates(.Position, SparkDirection, 0, 7 + (5 * Rnd))
            Call SpawnSpark(TempPos.X, TempPos.Y, .Position.Z, PALLETE_BLUE, SparkDirection, 2, 10, 7, 1)
          End If
        End If
      End If
      If ObjModels(.ModelIndex).Abilities(ABILITY_LEAVESSPARKLETRAIL) = True Then
        Call SpawnSpark(.Position.X, .Position.Y, .Position.Z, PALLETE_YELLOW, Int(360 * Rnd), 1, 25, 0, 1)
      End If
      Call MoveObject(ObjIndex, .Vector.Yaw, .CurrentSpeed)
      Call MoveObject(ObjIndex, .InertiaDirection.Yaw, .InertiaSpeed)
    End If
End With
End Sub
Public Sub RunBehavior(ObjIndex, BehaveType)
With Objects(ObjIndex)
    Select Case BehaveType
    Case BEHAVIORMODE_TANK
        Dim TempPos As Point3D
        If .ObjectTags(TAG_BLOCKED) = True Then
          Call ObjectCommand_CreatePath(ObjIndex, .Objective.MainDestination.X, .Objective.MainDestination.Y)
          .ObjectTags(TAG_BLOCKED) = False
        End If
        Select Case .Objective.Goal
        Case GOAL_FOLLOWPATH
          If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination)) < OBJCONST_ObjectStopDistance Then
            If .Objective.CurrentPathPoint = .Objective.Path.Points.PathPointsActive Then
              .Objective.Speed = 0
              .States(STATE_MOVING) = False
              Select Case .Properties(PROPERTY_LASTCOMMAND)
              Case GOAL_NOTHING
                Call ObjectCommand_MoveSomewhere(ObjIndex, .Properties(PROPERTY_POSITIONTEMPX), .Properties(PROPERTY_POSITIONTEMPY))
              Case GOAL_MOVESOMEWHERE
                Call ObjectCommand_MoveSomewhere(ObjIndex, .Objective.MainDestination.X, .Objective.MainDestination.Y)
              Case GOAL_ATTACK
                Call ObjectCommand_AttackObject(ObjIndex, Objects(ObjIndex).Objective.Target, Objects(ObjIndex).Objective.TargetPosition.X, Objects(ObjIndex).Objective.TargetPosition.Y)
              Case GOAL_GETFARTHERAWAYFROMTARGET
                Call ObjectCommand_AttackObject(ObjIndex, Objects(ObjIndex).Objective.Target, Objects(ObjIndex).Objective.TargetPosition.X, Objects(ObjIndex).Objective.TargetPosition.Y)
              End Select
            Else
              .Objective.CurrentPathPoint = .Objective.CurrentPathPoint + 1
              .Objective.CurrentDestination.X = .Objective.Path.Points.PathPoints(.Objective.CurrentPathPoint).X
              .Objective.CurrentDestination.Y = .Objective.Path.Points.PathPoints(.Objective.CurrentPathPoint).Y
              .States(STATE_MOVING) = True
            End If
          End If
        Case GOAL_SITSTILL
          .Properties(PROPERTY_TIMEREMAININGONSITSTILL) = .Properties(PROPERTY_TIMEREMAININGONSITSTILL) - 1
          If .Properties(PROPERTY_TIMEREMAININGONSITSTILL) = 0 Then
            .Objective.Goal = .Properties(PROPERTY_LASTCOMMAND)
          End If
        Case GOAL_GETOUTOFTHEWAY
          If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination)) > OBJCONST_ObjectStopDistance Then
            .States(STATE_MOVING) = True
          Else
            .Objective.Speed = 0
            .States(STATE_MOVING) = False
            Select Case .Properties(PROPERTY_LASTCOMMAND)
            Case GOAL_NOTHING
              Call ObjectCommand_MoveSomewhere(ObjIndex, .Properties(PROPERTY_POSITIONTEMPX), .Properties(PROPERTY_POSITIONTEMPY))
            Case GOAL_MOVESOMEWHERE
              Call ObjectCommand_MoveSomewhere(ObjIndex, .Objective.MainDestination.X, .Objective.MainDestination.Y)
            Case GOAL_ATTACK
              Call ObjectCommand_AttackObject(ObjIndex, Objects(ObjIndex).Objective.Target, Objects(ObjIndex).Objective.TargetPosition.X, Objects(ObjIndex).Objective.TargetPosition.Y)
            Case GOAL_GETFARTHERAWAYFROMTARGET
              Call ObjectCommand_AttackObject(ObjIndex, Objects(ObjIndex).Objective.Target, Objects(ObjIndex).Objective.TargetPosition.X, Objects(ObjIndex).Objective.TargetPosition.Y)
            Case Else
              .Objective.Goal = GOAL_NOTHING
            End Select
          End If
        Case GOAL_GETFARTHERAWAYFROMTARGET
          If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination)) > OBJCONST_ObjectStopDistance Then
            .States(STATE_MOVING) = True
          Else
            If .Objective.Target <> NOTARGET Then
              .States(STATE_MOVING) = False
              Call ObjectCommand_AttackObject(ObjIndex, .Objective.Target, .Objective.TargetPosition.X, .Objective.TargetPosition.Y)
            End If
          End If
        Case GOAL_MOVESOMEWHERE
          If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then
            Call SteerTurretDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination))
          End If
          If .Objective.Speed > 0 Then
            If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination)) < OBJCONST_ObjectStopDistance Then
              .Objective.Speed = 0
              .States(STATE_MOVING) = False
              .Objective.Goal = GOAL_NOTHING
            Else
              IsOnCourse = SteerObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TURNSPEED))
              .States(STATE_MOVING) = True
            End If
          Else
            If SteerObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TURNSPEED)) = True Then
              .States(STATE_MOVING) = True
            End If
          End If
        Case GOAL_ATTACK
          '.States(STATE_MOVING) = False
          If .Objective.Target <> TARGETGROUND Then
            .Objective.TargetPosition = Objects(.Objective.Target).MapPosition
          End If
          If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then Steered = SteerTurretDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.TargetPosition))
          If .Objective.Target = TARGETGROUND Then
            DistOffsetVal = 0
          Else
            DistOffsetVal = ObjModels(Objects(.Objective.Target).ModelIndex).Attributes(ATTRIBUTE_SIZE) * MapBlockSize
          End If
          If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination)) < OBJCONST_ObjectStopDistance Then
            .Objective.CurrentDestination = .MapPosition
            .States(STATE_MOVING) = False
            .Objective.Speed = 0
          Else
            If .States(STATE_MOVING) = False Then
              blah = 43
            End If
            .States(STATE_MOVING) = True
          End If
            DistanceFromTarget = Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.TargetPosition)) - DistOffsetVal
            If DistanceFromTarget < ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SHOOTRADIUS) Then
              If DistanceFromTarget > ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS) Then
                If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then
                  If Steered = True Then
                    .States(STATE_FIRING) = True
                  End If
                Else
                  If SteerObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.TargetPosition), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TURNSPEED)) = True Then
                    .States(STATE_FIRING) = True
                  Else
                    .States(STATE_MOVING) = False
                  End If
                End If
              Else
                Call ObjectCommand_GetFartherAwayFromTarget(ObjIndex, .Objective.TargetPosition)
              End If
            Else
              If .Objective.Target <> TARGETGROUND Then
                Call ObjectCommand_ContinueAttack(ObjIndex, .Objective.Target, .Objective.TargetPosition.X, .Objective.TargetPosition.Y)
              End If
              .States(STATE_MOVING) = True
            End If
        End Select
        If .States(STATE_MOVING) = True Then
            If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination)) > OBJCONST_ObjectStopDistance Then
              If .Objective.Speed > 0 Then
                .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) - 1
                If .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = 0 Then
                  .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = OBJCONST_TimeTillAdjustDirection
                  If SteerObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TURNSPEED)) = False Then
                    .Objective.Speed = 0
                  End If
                End If
              Else
                If SteerObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TURNSPEED)) = True Then
                  .Objective.Speed = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MAXSPEED)
                End If
              End If
            Else
              .Objective.Speed = 0
              .States(STATE_MOVING) = False
            End If
          Else
            .Objective.Speed = 0
          End If
    Case BEHAVIORMODE_WEAPON
        .Properties(PROPERTY_FUEL) = .Properties(PROPERTY_FUEL) - 1
        If .Properties(PROPERTY_FUEL) < 0 Then Call ObjectEvent_MissileCollide(ObjIndex)
        .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) - 1
        If .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = 0 Then
          .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = OBJCONST_TimeTillAdjustDirection
          Call SetObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(.Objective.CurrentDestination))
        End If
        If ObjModels(.ModelIndex).Abilities(ABILITY_REACHESTARGETINSTANTLY) = True Then
          If ObjModels(.ModelIndex).Abilities(ABILITY_LEAVESSPARKLETRAIL) = True Then
            Call VisualEffects.Effect_RailgunTrail(.Position, Map.UnProjectToMap3DPoint(.Objective.TargetPosition))
            .Position = Map.UnProjectToMap3DPoint(.Objective.TargetPosition)
            Call ObjectEvent_MissileCollide(ObjIndex)
          End If
        Else
          .States(STATE_MOVING) = True
          If .Objective.Target <> TARGETGROUND Then
            If .Objective.Target <> NOTARGET Then
              If ObjModels(.ModelIndex).Abilities(ABILITY_FOLLOWSTARGET) = True Then
                Call ChangeObjectDestination(ObjIndex, Map.ProjectToMapX(Objects(.Objective.Target).Position.X), Map.ProjectToMapY(Objects(.Objective.Target).Position.Y), 0)
              End If
            End If
          End If
          If Math.GetDistance(.Position, Map.UnProjectToMap3DPoint(.Objective.TargetPosition)) < OBJCONST_MissileStopDistance Then
            Call ObjectEvent_MissileCollide(ObjIndex)
          End If
          .Objective.Speed = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MAXSPEED)
          If GroundBlocks(.MapPosition.X, .MapPosition.Y).Occupied = True Then
            OnObj = GroundBlocks(.MapPosition.X, .MapPosition.Y).OccupyingObject
            If Objects(OnObj).Position.Z = .Position.Z Then
              If CheckObject(OnObj, OBJCHECK_ALIVE) = True Then
                If CheckObject(OnObj, OBJCHECK_HITTABLE) = True Then
                  If Objects(OnObj).Side <> .Side Then
                    Call ObjectEvent_MissileCollide(ObjIndex)
                  End If
                End If
              End If
            End If
          End If
        End If
    Case BEHAVIORMODE_BUILDING
        If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MAPIMPRINT) <> NOMAPIMPRINT Then Call Map.PlaceMapImprint(ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MAPIMPRINT), .MapPosition.X, .MapPosition.Y, ObjIndex)
        If .States(STATE_BUILDING) = True Then
          .Properties(PROPERTY_BUILDPROGRESS) = .Properties(PROPERTY_BUILDPROGRESS) + 1
          If .Properties(PROPERTY_BUILDPROGRESS) = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_BUILDATFRAME) Then
            newobj = SpawnObject(.Properties(PROPERTY_CLASSTOBUILD), .Side, .MapPosition.X + 1, .MapPosition.Y + 1, 0, 90, 0)
            Call ChangeObjectDestination(newobj, .MapPosition.X + 2, .MapPosition.Y + 2, 0)
            Objects(newobj).States(STATE_MOVING) = True
            Objects(newobj).Objective.Goal = GOAL_MOVESOMEWHERE
            .States(STATE_MOVING) = False
          End If
        End If
    Case BEHAVIORMODE_INANIMATE
        If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MAPIMPRINT) <> NOMAPIMPRINT Then Call Map.PlaceMapImprint(ObjModels(.ModelIndex).Attributes(ATTRIBUTE_MAPIMPRINT), .MapPosition.X, .MapPosition.Y, ObjIndex)
    End Select
End With
End Sub
Public Sub ObjectEvent_MissileCollide(MissileObj)
With Objects(MissileObj)
  If ObjModels(.ModelIndex).Abilities(ABILITY_THROWSMETALATDEATH) = True Then
    Call SpawnSparkExplosion(.Position.X, .Position.Y, .Position.Z, PALLETE_WHITE, 5, 8)
  End If

  Intensity = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONINTENSITY)
  Size = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONRADIUS)

  If ObjModels(.ModelIndex).Abilities(ABILITY_THROWSSPARKLESATCOLLIDE) = True Then
    Call SpawnSparkleExplosion(.Position.X, .Position.Y, .Position.Z, PALLETE_YELLOW, 3)
  End If
  Call SpawnSparkDirectionalExplosion(.Position.X, .Position.Y, .Position.Z, PALLETE_YELLOW, Size, Intensity, .Vector.Yaw + 180)
  Call EnviromentEvent_Explosion(.Position, ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONRADIUS), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONINTENSITY), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONTYPE))
End With
Call Entities.DestroyObject(MissileObj)
End Sub
Public Sub EnviromentEvent_Explosion(ExplodePosition As Point3D, Radius, Intensity, ExplodeType)
If GroundBlocks(Map.ProjectToMapX(ExplodePosition.X), Map.ProjectToMapY(ExplodePosition.Y)).Occupied = True Then
  If ObjModels(Objects(GroundBlocks(Map.ProjectToMapX(ExplodePosition.X), Map.ProjectToMapY(ExplodePosition.Y)).OccupyingObject).ModelIndex).Abilities(ABILITY_CANBEDAMAGED) = True Then Call DamageObject(GroundBlocks(Map.ProjectToMapX(ExplodePosition.X), Map.ProjectToMapY(ExplodePosition.Y)).OccupyingObject, Intensity, DamageType)
End If
For I = 1 To ObjectsActive
  If CheckObject(I, OBJCHECK_ALIVE) = True Then
    If CheckObject(I, OBJCHECK_HITTABLE) = True Then
      With Objects(I)
        If Math.GetDistance(ExplodePosition, .Position) < Radius * 10 Then
          If ObjModels(.ModelIndex).Abilities(ABILITY_THROWSMETALWHENHIT) = True Then
            ExplodeYaw = Math.GetYawFromXY(.Position.X, .Position.Y, ExplodePosition.X, ExplodePosition.Y)
            ExplodeX = SinTable(ExplodeYaw) * (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SIZE) * HalfMapBlockSize)
            ExplodeY = CosTable(ExplodeYaw) * (ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SIZE) * HalfMapBlockSize)
            Call SpawnSparkDirectionalExplosion(.Position.X + ExplodeX, .Position.Y + ExplodeY, .Position.Z, PALLETE_WHITE, 2, 8, ExplodeYaw)
          End If
          If ObjModels(.ModelIndex).Abilities(ABILITY_CANBEDAMAGED) = True Then Call DamageObject(I, Intensity, DamageType)
        End If
      End With
    End If
  End If
Next I
End Sub
Public Sub DamageObject(ObjIndex, DamageAmount, DamageType)
With Objects(ObjIndex)
  .Properties(PROPERTY_HEALTH) = .Properties(PROPERTY_HEALTH) - DamageAmount
  If .Properties(PROPERTY_HEALTH) <= 0 Then
    .Frozen = True
    Call Events.SpawnEvent(Events.Event_DestroyObject, ObjIndex)
  End If
End With
End Sub
Public Sub SetObjectMapPosition(ObjIndex)
With Objects(ObjIndex)
  .MapPosition.X = Map.ProjectToMapX(.Position.X)
  .MapPosition.Y = Map.ProjectToMapY(.Position.Y)
End With
End Sub
Public Sub MoveObject(ObjIndex, Yaw, Speed)
Dim TempPos As Point3D
TempPos = Math.GetPropelCoordinates(Objects(ObjIndex).Position, Yaw, 0, Speed)
With Objects(ObjIndex)
  If CheckIfIllegalObjectPosition3D(TempPos) = False Then
    SetPosition = True
    If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then
      Call SetGroundUnOccupiedByObject(ObjIndex)
      MapX = Map.ProjectToMapX(TempPos.X)
      MapY = Map.ProjectToMapY(TempPos.Y)
      Size = ObjModels(Objects(ObjIndex).ModelIndex).Attributes(ATTRIBUTE_SIZE)
      If Map.GetGroundOccupied(MapX, MapY, Size) = False Then
        If ObjModels(.ModelIndex).BehaviorType = BEHAVIORMODE_TANK Then
          If GroundBlocks(MapX, MapY).Height - .Position.Z > ObjModels(.ModelIndex).Attributes(ATTRIBUTE_LENGTHZ) Then
            .ObjectTags(TAG_BLOCKED) = True
            'Call ObjectCommand_AvoidCollision(ObjIndex, TempPos.X, TempPos.Y)
            SetPosition = False
          End If
          If GroundBlocks(MapX, MapY).TerrainType = TERRAINTYPE_WATER Then
            .ObjectTags(TAG_BLOCKED) = True
            'Call ObjectCommand_AvoidCollision(ObjIndex, TempPos.X, TempPos.Y)
            SetPosition = False
          End If
        End If
      Else
        Call DetermineMoveFromCollide(ObjIndex, GroundBlocks(MapX, MapY).OccupyingObject)
        SetPosition = False
      End If
    End If
    If SetPosition = True Then
      TempPos.Z = .Position.Z
      If .Position.Z < GroundBlocks(MapX, MapY).Height Then
        'Goes up
        If ObjModels(.ModelIndex).Abilities(ABILITY_ISPHYSICAL) = True Then
          If ((GroundBlocks(MapX, MapY).Height - .Position.Z) / ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEIGHT)) > 2 Then
            .InertiaSpeedUp = .InertiaSpeedUp + (((GroundBlocks(MapX, MapY).Height - .Position.Z) * (.CurrentSpeed / 2)) / ObjModels(.ModelIndex).Attributes(ATTRIBUTE_WEIGHT))
          End If
        End If
        TempPos.Z = GroundBlocks(MapX, MapY).Height
      End If
      .Position = TempPos
      Call SetObjectMapPosition(ObjIndex)
    End If
    If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then Call SetGroundOccupiedByObject(ObjIndex)
  End If
End With
End Sub
Public Sub DetermineMoveFromCollide(ObjIndex, CollidedWithObject)
With Objects(ObjIndex)
  If ObjModels(Objects(CollidedWithObject).ModelIndex).Abilities(ABILITY_MOVES) = True Then
    If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_IMPORTANCE) >= ObjModels(Objects(CollidedWithObject).ModelIndex).Attributes(ATTRIBUTE_IMPORTANCE) Then
      If Objects(CollidedWithObject).States(STATE_MOVING) = False Then
        If GroundBlocks(.MapPosition.X - 1, .MapPosition.Y - 1).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X, .MapPosition.Y - 1).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X + 1, .MapPosition.Y - 1).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X + 1, .MapPosition.Y).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X + 1, .MapPosition.Y + 1).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X, .MapPosition.Y + 1).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X - 1, .MapPosition.Y + 1).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If GroundBlocks(.MapPosition.X - 1, .MapPosition.Y).Occupied = True Then
          IsBoxedInAmount = IsBoxedInAmount + 1
        End If
        If IsBoxedInAmount > 4 Then
          Call Entities.ObjectCommand_GetOutOfTheWay(CollidedWithObject, ObjIndex, 50)
          Call Entities.ObjectCommand_SitStillForTime(ObjIndex, 20)
        Else
          Call ObjectCommand_AvoidCollision(ObjIndex, Objects(CollidedWithObject).Position.X, Objects(CollidedWithObject).Position.Y)
        End If
      Else
        Call ObjectCommand_AvoidCollision(ObjIndex, Objects(CollidedWithObject).Position.X, Objects(CollidedWithObject).Position.Y)
      End If
    Else
      Call ObjectCommand_AvoidCollision(ObjIndex, Objects(CollidedWithObject).Position.X, Objects(CollidedWithObject).Position.Y)
    End If
  Else
    Call ObjectCommand_AvoidCollision(ObjIndex, Objects(CollidedWithObject).Position.X, Objects(CollidedWithObject).Position.Y)
  End If
End With
End Sub
Public Function CheckIfIllegalObjectPosition3D(Position As Point3D) As Boolean
If Position.X < 0 Then CheckIfIllegalObjectPosition3D = True: Exit Function
If Position.Y < 0 Then CheckIfIllegalObjectPosition3D = True: Exit Function
If Position.X > Map.BattleMap.RealWidth Then CheckIfIllegalObjectPosition3D = True: Exit Function
If Position.Y > Map.BattleMap.RealHeight Then CheckIfIllegalObjectPosition3D = True: Exit Function
End Function
Public Function GetMapImprintNum(Imprint$)
For I = 1 To MAXIMPRINTS
  If MapImprints(I).ImprintName = Imprint$ Then
    GetMapImprintNum = I
    Exit For
  End If
Next I
End Function
Public Sub ChangeObjectDestination(ObjIndex, NewX, NewY, NewZ)
Dim EmptyBlock As Point3D
If NewX < 0 Then NewX = 0
If NewY < 0 Then NewY = 0
If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then
  EmptyBlock = Map.GetNearestEmptyBlock(NewX, NewY, TERRAINTYPE_WATER, True)
Else
  EmptyBlock.X = NewX
  EmptyBlock.Y = NewY
End If
With Objects(ObjIndex)
  .Objective.MainDestination.X = EmptyBlock.X
  .Objective.MainDestination.Y = EmptyBlock.Y
  .Objective.MainDestination.Z = NewZ
  .Objective.CurrentDestination = .Objective.MainDestination
End With
End Sub
Public Sub ChangeObjectCurrentDestination(ObjIndex, NewX, NewY, NewZ)
Dim EmptyBlock As Point3D
If NewX < 0 Then NewX = 0
If NewY < 0 Then NewY = 0
If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then
  EmptyBlock = Map.GetNearestEmptyBlock(NewX, NewY, TERRAINTYPE_WATER, True)
Else
  EmptyBlock.X = NewX
  EmptyBlock.Y = NewY
End If
With Objects(ObjIndex).Objective.CurrentDestination
  .X = EmptyBlock.X
  .Y = EmptyBlock.Y
  .Z = NewZ
End With
Call SetObjectDirection(ObjIndex, Map.UnProjectToMap3DPoint(Objects(ObjIndex).Objective.CurrentDestination))
End Sub

Sub SetObjectDirection(ObjIndex, ObjDest As Point3D)
With Objects(ObjIndex)
  .Vector.Yaw = Math.GetYawFromXY(.Position.X, .Position.Y, ObjDest.X, ObjDest.Y)
  Call Math.CheckVector(.Vector)
  .Vector.ZIncline = 0
  Call SetDisplayDirection(ObjIndex)
End With
End Sub
Sub SteerInertialDirection(ObjIndex, DestYaw, TurnSpeed)
If TurnSpeed < 22 Then
  Speed = TurnSpeed
Else
  Speed = 11
End If
With Objects(ObjIndex)
    If .InertiaDirection.Yaw - 3 < DestYaw Then
      If .InertiaDirection.Yaw + 3 > DestYaw Then
        .InertiaDirection.Yaw = DestYaw
        Exit Sub
      End If
    End If
    If DestYaw > .Vector.Yaw Then
      If DestYaw - .Vector.Yaw < 180 Then
        .InertiaDirection.Yaw = .InertiaDirection.Yaw + Speed
      Else
        .InertiaDirection.Yaw = .InertiaDirection.Yaw - Speed
      End If
    Else
      If .InertiaDirection.Yaw - DestYaw < 180 Then
        .InertiaDirection.Yaw = .InertiaDirection.Yaw - Speed
      Else
        .InertiaDirection.Yaw = .InertiaDirection.Yaw + Speed
      End If
    End If
    If .InertiaDirection.Yaw + (Speed + 4) > DestYaw Then
      If .InertiaDirection.Yaw - (Speed + 4) < DestYaw Then
        .InertiaDirection.Yaw = DestYaw
      End If
    End If
    Call Math.CheckVector(.InertiaDirection)
End With
End Sub
Function SteerObjectDirection(ObjIndex, ObjDest As Point3D, ObjTurnSpeed) As Boolean
With Objects(ObjIndex)
    TurnSpeed = ObjTurnSpeed
    If .Position.Z > GroundBlocks(.MapPosition.X, .MapPosition.Y).Height Then
      If ObjModels(.ModelIndex).Abilities(ABILITY_REQUIRESTRACTION) = True Then
        TurnSpeed = ObjTurnSpeed / 4
      End If
    End If
    DestYaw = Math.GetYawFromXY(.Position.X, .Position.Y, ObjDest.X, ObjDest.Y)
    If .Vector.Yaw - 3 < DestYaw Then
      If .Vector.Yaw + 3 > DestYaw Then
        .Vector.Yaw = DestYaw
        SteerObjectDirection = True
        Exit Function
      End If
    End If
    If DestYaw > .Vector.Yaw Then
      If DestYaw - .Vector.Yaw < 180 Then
        .Vector.Yaw = .Vector.Yaw + TurnSpeed
      Else
        .Vector.Yaw = .Vector.Yaw - TurnSpeed
      End If
    Else
      If .Vector.Yaw - DestYaw < 180 Then
        .Vector.Yaw = .Vector.Yaw - TurnSpeed
      Else
        .Vector.Yaw = .Vector.Yaw + TurnSpeed
      End If
    End If
    If .Vector.Yaw + (TurnSpeed + 2) > DestYaw Then
      If .Vector.Yaw - (TurnSpeed + 2) < DestYaw Then
        .Vector.Yaw = DestYaw
        SteerObjectDirection = True
      End If
    End If
    Call Math.CheckVector(.Vector)
    .Vector.ZIncline = 0
    Call SetDisplayDirection(ObjIndex)
End With
End Function
Function SteerTurretDirection(ObjIndex, ObjDest As Point3D) As Boolean
Dim TempVector As Vect3D
With Objects(ObjIndex)
    DestYaw = Math.GetYawFromXY(.Position.X, .Position.Y, ObjDest.X, ObjDest.Y)
    If .TopDirection - 6 < DestYaw Then
      If .TopDirection + 6 > DestYaw Then
        .TopDirection = DestYaw
        SteerTurretDirection = True
        Exit Function
      End If
    End If
    If DestYaw > .TopDirection Then
      If DestYaw - .TopDirection < 180 Then
        .TopDirection = .TopDirection + 6
      Else
        .TopDirection = .TopDirection - 6
      End If
    Else
      If .TopDirection - DestYaw < 180 Then
        .TopDirection = .TopDirection - 6
      Else
        .TopDirection = .TopDirection + 6
      End If
    End If
    If .TopDirection + 8 > DestYaw Then
      If .TopDirection - 8 < DestYaw Then
        .TopDirection = DestYaw
        SteerTurretDirection = True
      End If
    End If
    TempVector.Yaw = .TopDirection
    Call Math.CheckVector(TempVector)
    .TopDirection = TempVector.Yaw
    Call SetDisplayDirection(ObjIndex)
End With
End Function
Sub SetDisplayDirection(ObjIndex)
With Objects(ObjIndex)
  If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_DIRECTIONAMOUNT) <> 1 Then
    .DisplayDirection = Int((.Vector.Yaw + ObjModels(.ModelIndex).Consts(CONST_DIRECTIONDIVDIV)) / ObjModels(.ModelIndex).Consts(CONST_DIRECTIONDIV))
    If .DisplayDirection = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_DIRECTIONAMOUNT) Then .DisplayDirection = 0
  Else
    .DisplayDirection = 0
  End If
  If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TOPDIRECTIONAMOUNT) <> 1 Then
    If ObjModels(.ModelIndex).Abilities(ABILITY_BODYISBISECTED) = True Then
      .TopDisplayDirection = Int((.TopDirection + ObjModels(.ModelIndex).Consts(CONST_TOPDIRECTIONDIVDIV)) / ObjModels(.ModelIndex).Consts(CONST_TOPDIRECTIONDIV))
      If .TopDisplayDirection = ObjModels(.ModelIndex).Attributes(ATTRIBUTE_TOPDIRECTIONAMOUNT) Then .TopDisplayDirection = 0
    End If
  Else
    .TopDisplayDirection = 0
  End If
End With
End Sub
Public Function SpawnObject(ClassNum, Side, X, Y, Z, Yaw, ZIncline) As Integer
If ObjModels(ClassNum).Abilities(ABILITY_ISPHYSICAL) = True Then
  If GroundBlocks(X, Y).Occupied = True Then
    GoTo DontSpawn
  End If
End If
If ObjModels(ClassNum).Attributes(ATTRIBUTE_MAPIMPRINT) <> NOMAPIMPRINT Then
  If Map.IsImprintSpaceNonGrass(X, Y, ObjModels(ClassNum).Attributes(ATTRIBUTE_MAPIMPRINT)) = True Then
    GoTo DontSpawn
  End If
  If Map.IsImprintSpaceOccupied(X, Y, ObjModels(ClassNum).Attributes(ATTRIBUTE_MAPIMPRINT)) = True Then
    GoTo DontSpawn
  End If
End If
For I = 1 To MAXOBJECTS
  If Objects(I).Active = False Then
    NewObject = I
    Exit For
  End If
Next I
If ObjectsActive < NewObject Then ObjectsActive = NewObject

With Objects(NewObject)
    'Clears all it's properties so it doesn't do something wacky!
    For I = 1 To MAXOBJECTPROPERTIES
      .Properties(I) = 0
    Next I
    
    'Initializes the object
    .Frozen = False
    .Active = True
    .Side = Side
    .ModelIndex = ClassNum
    .CurrentSpeed = 0
    .Position.X = Map.UnProjectToMapX(X)
    .Position.Y = Map.UnProjectToMapY(Y)
    .Position.Z = Z
    .Objective.MainDestination = Map.ProjectToMap3DPoint(.Position)
    .Objective.MainDestination.Z = Z
    .Objective.CurrentDestination = .Objective.MainDestination
    .DisplayDirection = 0
    .Vector.Yaw = Yaw
    .Vector.ZIncline = ZIncline
    .Objective.Goal = GOAL_NOTHING
    .States(STATE_MOVING) = False
    .Sprite.SpriteNumber = ObjModels(ClassNum).Attributes(ATTRIBUTE_SPRITE)
    .Sprite.SpriteFrameNumber = 1
    .Sprite.SpriteGroupNumber = 1
    
    .TopSprite.SpriteNumber = ObjModels(ClassNum).Attributes(ATTRIBUTE_TOPSPRITE)
    .TopSprite.SpriteFrameNumber = 1
    .TopSprite.SpriteGroupNumber = 1
    .TopDirection = .Vector.Yaw
    .DisplayDirection = .DisplayDirection
    
    .Properties(PROPERTY_TIMEUNTILADJUSTDIRECTION) = OBJCONST_TimeTillAdjustDirection
    .Properties(PROPERTY_WEAPONOBJECTTYPE) = ObjModels(ClassNum).Attributes(ATTRIBUTE_DEFAULTWEAPONOBJECT)
    .Properties(PROPERTY_HEALTH) = ObjModels(ClassNum).Attributes(ATTRIBUTE_HEALTH)
    
    If ObjModels(ClassNum).Abilities(ABILITY_HASDNA) = True Then Call Assign_DNA(NewObject)
    
    Call SetObjectMapPosition(NewObject)
    If ObjModels(.ModelIndex).BehaviorType = BEHAVIORMODE_TANK Then
      Dim TempPos As Point3D
      For I = 1 To 10
        SparkDirection = Int(360 * Rnd)
        TempPos = Math.GetPropelCoordinates(.Position, SparkDirection, 0, 7 + (5 * Rnd))
        Call SpawnSpark(TempPos.X, TempPos.Y, .Position.Z, PALLETE_BLUE, SparkDirection, 2, 10, 7, 1)
      Next I
      Call ObjectCommand_MoveSomewhere(NewObject, .MapPosition.X, .MapPosition.Y)
    End If
    If CheckObject(NewObject, OBJCHECK_OCCUPIESMAPSPACE) = True Then Call SetGroundOccupiedByObject(NewObject)
    'returns the handle of the object
    If ObjModels(ClassNum).Abilities(ABILITY_BUILDS) = True Then
      Call BuildObjectsChanged(Side)
    End If
End With
If ObjModels(ClassNum).Attributes(ATTRIBUTE_MAPIMPRINT) <> NOMAPIMPRINT Then
  Call Map.PlaceMapImprint(ObjModels(ClassNum).Attributes(ATTRIBUTE_MAPIMPRINT), X, Y, NewObject)
End If
Call Object_PlaySound(NewObject, SoundEvent_Spawn)
SpawnObject = NewObject
Exit Function
DontSpawn:
  SpawnObject = NOOBJECT
End Function
Public Sub LoadObjectData()
Dim MaxMods As Integer, a$, propvalue$, I As Integer, DeployObjectList(MaxObjModels) As String, WepObjs(MaxObjModels) As String
On Error Resume Next
MaxMods = 0
Call FileFunctions.OpenGameFile(File_UnitDefinitions, 1)
Do
  Line Input #1, a$
  Select Case MiscFunctions.GetPropertyName(a$)
  Case FILETAG_ENDFILE
    Exit Do
  Case "[OBJECTDEFSTART]"
    MaxMods = MaxMods + 1
    Line Input #1, a$
    ObjModels(MaxMods).ObjClassName = MiscFunctions.GetPropertyValue(a$)

    Line Input #1, a$
    ObjModels(MaxMods).ObjName = MiscFunctions.GetPropertyValue(a$)
    Line Input #1, a$
    Select Case MiscFunctions.GetPropertyValue(a$)
    Case "-NONE-"
      BehavType = BEHAVIORMODE_NONE
    Case "BEHAVIORMODE_INANIMATE"
      BehavType = BEHAVIORMODE_INANIMATE
    Case "BEHAVIORMODE_BUILDING"
      BehavType = BEHAVIORMODE_BUILDING
    Case "BEHAVIORMODE_SOLDIER"
      BehavType = BEHAVIORMODE_SOLDIER
    Case "BEHAVIORMODE_SHIP"
      BehavType = BEHAVIORMODE_SHIP
    Case "BEHAVIORMODE_TANK"
      BehavType = BEHAVIORMODE_TANK
    Case "BEHAVIORMODE_AIRCRAFT"
      BehavType = BEHAVIORMODE_AIRCRAFT
    Case "BEHAVIORMODE_SPACECRAFT"
      BehavType = BEHAVIORMODE_SPACECRAFT
    Case "BEHAVIORMODE_WEAPON"
      BehavType = BEHAVIORMODE_WEAPON
    End Select
    ObjModels(MaxMods).BehaviorType = BehavType
    
    For I = 1 To MAXABILITIES
      Line Input #1, a$
      a$ = MiscFunctions.GetPropertyValue(a$)
      ObjModels(MaxMods).Abilities(I) = MiscFunctions.ConvertTrueFalse(a$)
    Next I
    
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SPRITE) = SpriteStuff.GetSpriteIndex(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SIZE) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_LENGTHX) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_LENGTHY) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_LENGTHZ) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_MAXSPEED) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_BULLETARMOR) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SHELLARMOR) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_BOMBARMOR) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_FIREARMOR) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_ELECTROMAGNETICARMOR) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_RADIATIONARMOR) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_MAXAMMO) = Val(a$)

    Line Input #1, a$
   
    Select Case MiscFunctions.GetPropertyValue(a$)
    Case "EXPLODETYPE_BULLET"
      ExplodeType = EXPLODETYPE_BULLET
    Case "EXPLODETYPE_SHELL"
      ExplodeType = EXPLODETYPE_SHELL
    Case "EXPLODETYPE_BOMB"
      ExplodeType = EXPLODETYPE_BOMB
    Case "EXPLODETYPE_FIRE"
      ExplodeType = EXPLODETYPE_FIRE
    Case "EXPLODETYPE_ELECTROMAGNETIC"
      ExplodeType = EXPLODETYPE_ELECTROMAGNETIC
    Case "EXPLODETYPE_RADIATION"
      ExplodeType = EXPLODETYPE_RADIATION
    End Select
    ObjModels(MaxMods).Attributes(ATTRIBUTE_EXPLOSIONTYPE) = ExplodeType
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_EXPLOSIONINTENSITY) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_EXPLOSIONRADIUS) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    If a$ = "-Nothing-" Then
      ObjModels(MaxMods).Attributes(ATTRIBUTE_EXPLOSIONSPRITE) = NOSPRITE
    Else
      ObjModels(MaxMods).Attributes(ATTRIBUTE_EXPLOSIONSPRITE) = SpriteStuff.GetSpriteIndex(a$)
    End If
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_POWERREQUIRED) = Val(a$)

    Line Input #1, a$
    Select Case MiscFunctions.GetPropertyValue(a$)
    Case "-NONE-"
      BehavType = BEHAVIORMODE_NONE
    Case "BEHAVIORMODE_INANIMATE"
      BehavType = BEHAVIORMODE_INANIMATE
    Case "BEHAVIORMODE_BUILDING"
      BehavType = BEHAVIORMODE_BUILDING
    Case "BEHAVIORMODE_SOLDIER"
      BehavType = BEHAVIORMODE_SOLDIER
    Case "BEHAVIORMODE_SHIP"
      BehavType = BEHAVIORMODE_SHIP
    Case "BEHAVIORMODE_TANK"
      BehavType = BEHAVIORMODE_TANK
    Case "BEHAVIORMODE_AIRCRAFT"
      BehavType = BEHAVIORMODE_AIRCRAFT
    Case "BEHAVIORMODE_SPACECRAFT"
      BehavType = BEHAVIORMODE_SPACECRAFT
    Case "BEHAVIORMODE_WEAPON"
      BehavType = BEHAVIORMODE_WEAPON
    End Select
    
    ObjModels(MaxMods).Attributes(ATTRIBUTE_OBJECTBUILDTYPE) = BehavType
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_COST) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_HEALTH) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_WEIGHT) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_ACCURACY) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_STRENGTH) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SHOOTRADIUS) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_MINIMUMSHOOTRADIUS) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_DIRECTIONAMOUNT) = Val(a$)
    ObjModels(MaxMods).Consts(CONST_DIRECTIONDIV) = (360 / ObjModels(MaxMods).Attributes(ATTRIBUTE_DIRECTIONAMOUNT))
    ObjModels(MaxMods).Consts(CONST_DIRECTIONDIVDIV) = ObjModels(MaxMods).Consts(CONST_DIRECTIONDIV) / 2
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SIGHTRADIUS) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    If a$ <> "" Then
      ObjModels(MaxMods).Attributes(ATTRIBUTE_SOUNDGROUP) = True
      Call LoadSoundsToUnitModel(MaxMods, a$)
    Else
      ObjModels(MaxMods).Attributes(ATTRIBUTE_SOUNDGROUP) = False
    End If

    Line Input #1, a$
    Select Case MiscFunctions.GetPropertyValue(a$)
    Case "EDF"
      SideNum = FACTION_EDF
    End Select
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SIDE) = SideNum
    

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_GETTABLEPOWERUPTYPE) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_MAPIMPRINT) = Entities.GetMapImprintNum(a$)
  
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SPRITEPOSITIONX) = Val(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SPRITEPOSITIONY) = Val(a$)
  
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_COMBUSTIONTEMPERATURE) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    DeployObjectList(MaxMods) = a$
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_TECHLEVEL) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_BUILDPICTURE) = SpriteStuff.GetPicIndex(a$)

    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_TOPSPRITE) = SpriteStuff.GetSpriteIndex(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    If a$ = "ATTRIBUTE_TOPDIRECTIONAMOUNT" Then a$ = "0"
    ObjModels(MaxMods).Attributes(ATTRIBUTE_TOPDIRECTIONAMOUNT) = Val(a$)
    If ObjModels(MaxMods).Abilities(ABILITY_BODYISBISECTED) = True Then
      ObjModels(MaxMods).Consts(CONST_TOPDIRECTIONDIV) = (360 / ObjModels(MaxMods).Attributes(ATTRIBUTE_TOPDIRECTIONAMOUNT))
      ObjModels(MaxMods).Consts(CONST_TOPDIRECTIONDIVDIV) = ObjModels(MaxMods).Consts(CONST_TOPDIRECTIONDIV) / 2
    End If
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_TOPSPRITEPOSITIONX) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_TOPSPRITEPOSITIONY) = Val(a$)
  
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_BUILDATFRAME) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_REQUIREDBEFOREBUILD) = Val(a$)
    If Val(a$) = 0 Then ObjModels(MaxMods).Attributes(ATTRIBUTE_REQUIREDBEFOREBUILD) = NOOBJECT
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_IMPORTANCE) = Val(a$)
  
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_ENGINEPOWER) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_TURNSPEED) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_SHADOWPIC) = SpriteStuff.GetPicIndex(a$)
  
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_WEAPONX) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_WEAPONY) = Val(a$)
    
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    WepObjs(MaxMods) = a$
  
    Line Input #1, a$
    a$ = MiscFunctions.GetPropertyValue(a$)
    ObjModels(MaxMods).Attributes(ATTRIBUTE_WEAPONCHARGETIME) = Val(a$)
  End Select
Loop
Close #1
MaxObjModTypes = MaxMods
For I = 1 To MaxObjModTypes
  ObjModels(I).Attributes(ATTRIBUTE_DEPLOYOBJECT) = Entities.GetClassNum(DeployObjectList(I))
  ObjModels(I).Attributes(ATTRIBUTE_DEFAULTWEAPONOBJECT) = Entities.GetClassNum(WepObjs(I))
Next I
End Sub
Public Sub LoadSoundsToUnitModel(ModelIndex, SoundBaseName)
SoundEventName = SoundEvent_Fire
SoundEventText = "Fire"
ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = Sound.GetSoundIndex(SoundBaseName & "." & SoundEventText)
If ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = 0 Then ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = NOSOUND
SoundEventName = SoundEvent_Explode
SoundEventText = "Explode"
ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = Sound.GetSoundIndex(SoundBaseName & "." & SoundEventText)
If ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = 0 Then ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = NOSOUND
SoundEventName = SoundEvent_Spawn
SoundEventText = "Spawn"
ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = Sound.GetSoundIndex(SoundBaseName & "." & SoundEventText)
If ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = 0 Then ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = NOSOUND

SoundEventName = SoundEvent_BuildObject
SoundEventText = "BuildObject"
ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = Sound.GetSoundIndex(SoundBaseName & "." & SoundEventText)
If ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = 0 Then ObjModels(ModelIndex).SoundGroup.EventSounds(SoundEventName) = NOSOUND

End Sub
Public Function GetClassNum(ClassName$)
GetClassNum = -999
For I = 1 To MaxObjModTypes
  If ClassName$ = Entities.ObjModels(I).ObjClassName Then
    GetClassNum = I
    Exit For
  End If
Next I
End Function
Public Sub LoadMapImprints()
Call FileFunctions.OpenGameFile(File_ObjectImprints, 1)
imprintnum = 0
Do
  Line Input #1, a$
  Select Case a$
  Case FILETAG_ENDFILE
    Exit Do
  Case "[OBJIMPRINT]"
    
    imprintnum = imprintnum + 1
    Line Input #1, a$
    MapImprints(imprintnum).ImprintName = a$
    For X = 1 To IMPRINTSIZE
      For Y = 1 To IMPRINTSIZE
        Line Input #1, a$
        MapImprints(imprintnum).ImprintArray(X, Y) = Val(a$)
      Next Y
    Next X
  End Select
Loop
Close #1
End Sub
Public Sub Object_PlaySound(ObjIndex, SoundEvent)
With Objects(ObjIndex)
  If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_SOUNDGROUP) = True Then
    If ObjModels(.ModelIndex).SoundGroup.EventSounds(SoundEvent) <> NOSOUND Then
      Call Entities.ObjectEmitSound(ObjIndex, ObjModels(.ModelIndex).SoundGroup.EventSounds(SoundEvent))
    End If
  End If
End With
End Sub
Public Sub ResetObject(ObjIndex)
Dim BlankObject As ObjThing
Objects(ObjIndex) = BlankObject
End Sub
Public Sub DestroyObject(ObjIndex)
With Objects(ObjIndex)
    Call Object_PlaySound(ObjIndex, SoundEvent_Explode)
    If ObjModels(.ModelIndex).Abilities(ABILITY_EXPLODESWITHFIRE) = True Then
      Call VisualEffects.SpawnFire(.Position.X, .Position.Y, 0, ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONRADIUS), 15)
    End If
    .Frozen = False
    If ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONSPRITE) <> NOSPRITE Then
      Call VisualEffects.SpawnAnimation(.Position.X + (Int(20 * Rnd) - 10), .Position.Y + (Int(20 * Rnd) - 10) - (.Position.Z / 3), ObjModels(.ModelIndex).Attributes(ATTRIBUTE_EXPLOSIONSPRITE))
    End If
    For I = 1 To ObjectSelectedList.IndexesActive
      If ObjectSelectedList.Indexes(I) = ObjIndex Then
        Call ClearSelectedListEntry(I)
        Exit For
      End If
    Next I
    For I = 1 To ObjectsActive
      If Objects(I).Objective.Target = ObjIndex Then
        Objects(I).Objective.Target = NOTARGET
        Objects(I).States(STATE_FIRING) = False
        If Objects(I).Properties(PROPERTY_LASTCOMMAND) = GOAL_ATTACK Then
          Objects(I).Properties(PROPERTY_LASTCOMMAND) = GOAL_NOTHING
        End If
        If Objects(I).Objective.Goal = GOAL_GETFARTHERAWAYFROMTARGET Then
          Objects(I).Objective.Goal = GOAL_NOTHING
        End If
        If Objects(I).Objective.Goal = GOAL_ATTACK Then
          Call ObjectCommand_CeaseAttack(I)
        End If
      End If
    Next I
    .Active = False
    If CheckObject(ObjIndex, OBJCHECK_OCCUPIESMAPSPACE) = True Then Call Map.SetGroundUnOccupiedByObject(ObjIndex)
    If ObjectsActive = ObjIndex Then
      For I = 1 To ObjectsActive
        If Objects(I).Active = True Then
          ObjectsAlive = I
        End If
      Next I
      ObjectsActive = ObjectsAlive
    End If
    If ObjModels(.ModelIndex).Abilities(ABILITY_BUILDS) = True Then
      Call Players.BuildObjectsChanged(.Side)
    End If
End With
End Sub
Public Sub RunWorld()
For I = 1 To ObjectsActive
  If Objects(I).Active = True Then
    If Objects(I).Frozen = False Then
      Call Entities.RunObject(I)
    End If
  End If
Next I
End Sub
