Option Explicit
'------------------------------------------------------------
' Global constants, data types, and function calls used by
' the GOLF.MAK project.
'------------------------------------------------------------

' ScaleMode constants
Global Const TWIPS = 1
Global Const PIXELS = 3

' MsgBox constants
Global Const MB_OK = 0                 ' OK button
Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

' RGB color constants
Global Const BLUE = &HFF0000
Global Const DK_BLUE = &H800000
Global Const WHITE = &HFFFFFF
Global Const RED = &HFF&
Global Const BLACK = &H0&
Global Const CYAN = &HFFFF00
Global Const DK_CYAN = &H808000
Global Const YELLOW = &HFFFF&
Global Const BROWN = &H8080&
Global Const GREEN = &HFF00&
Global Const DK_GREEN = &H8000&
Global Const MAGENTA = &HFF00FF

' Data type defining an x-y coordinate.
Type tLocation
    X As Integer
    Y As Integer
End Type

' Data type defining information related to
' a particular golf hole.
Type tHole
    FileName As String * 12
    Tee As tLocation
    Par As Integer
    Tips As String
End Type

' The location of the program.
Global AppPath As String

' Constants for 3D Borders
Global Const BORDER_INSET = 0
Global Const BORDER_RAISED = 1

' Functions and constants used to play sounds.
Global Const SND_SYNC = &H0        ' Return when sound ends (the default)
Global Const SND_ASYNC = &H1       ' Return as soon as sound starts
Declare Function sndPlaySound Lib "MMSystem" (ByVal lpsound As String, ByVal FLAG As Integer) As Integer

' Function that returns the color at a particular
' x-y location.
Declare Function GetPixel Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Long

' Constant and function used to quickly copy bitmaps.
Global Const SRCCOPY = &HCC0020
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal NWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer

Sub CenterForm (AForm As Form)
'------------------------------------------------------------
' Center a form on the screen.
'------------------------------------------------------------

    AForm.Move (Screen.Width - AForm.Width) \ 2, (Screen.Height - AForm.Height) \ 2
End Sub

Function GetDistance (Ax As Integer, Ay As Integer, Bx As Integer, By As Integer) As Single
'------------------------------------------------------------
' Return the straight-line distance between two x-y points.
'------------------------------------------------------------
    
    GetDistance = Abs(Sqr((Ax - Bx) ^ 2 + (Ay - By) ^ 2))
End Function

Sub Make3D (AForm As Form, ctl As Control, ByVal BorderStyle As Integer, ByVal BorderWidth As Integer)
'----------------------------------------------------------------------
' Wrap a 3D effect around a control on a form.
'----------------------------------------------------------------------
' Color Constants
Const DARK_GRAY = &H808080
Const WHITE = &HFFFFFF
Const BLACK = &H0

Dim RightSide As Single
Dim BW As Integer
Dim LeftTopColor As Long, RightBottomColor As Long
Dim i As Integer
Dim SaveMode As Integer

    If Not ctl.Visible Then Exit Sub

    SaveMode = AForm.ScaleMode
    AForm.ScaleMode = PIXELS

    Select Case BorderStyle
	Case 0: ' Inset
	    LeftTopColor = DARK_GRAY
	    RightBottomColor = WHITE
	Case 1: ' Raised
	    LeftTopColor = WHITE
	    RightBottomColor = DARK_GRAY
    End Select

    ' Set the top shading line.
    For BW = 1 To BorderWidth
	' Top
	AForm.CurrentX = ctl.Left - BW
	AForm.CurrentY = ctl.Top - BW
	AForm.Line -(ctl.Left + ctl.Width + (BW - 1), ctl.Top - BW), LeftTopColor
	' Right
	AForm.Line -(ctl.Left + ctl.Width + (BW - 1), ctl.Top + ctl.Height + (BW - 1)), RightBottomColor
	' Bottom
	AForm.Line -(ctl.Left - BW, ctl.Top + ctl.Height + (BW - 1)), RightBottomColor
	' Left
	AForm.Line -(ctl.Left - BW, ctl.Top - BW), LeftTopColor
    Next

    AForm.ScaleMode = SaveMode
End Sub

Sub Paint3D (AForm As Form)
'----------------------------------------------------------------------
' Put a 3D border around any control tagged "/3D_INSET/" or "/3D_RAISED/.
'----------------------------------------------------------------------
Dim i As Integer

    For i = 0 To AForm.Controls.Count - 1
	If InStr(UCase$(AForm.Controls(i).Tag), "/3D_RAISED/") Then
	    Make3D AForm, AForm.Controls(i), BORDER_RAISED, 2
	ElseIf InStr(UCase$(AForm.Controls(i).Tag), "/3D_INSET/") Then
	    Make3D AForm, AForm.Controls(i), BORDER_INSET, 2
	End If
    Next
End Sub

Sub Pause (Seconds As Single)
'------------------------------------------------------------
' Wait for a specified number of seconds.
'------------------------------------------------------------
Dim EndTime As Single

    EndTime = Timer + Seconds
    While Timer < EndTime
	DoEvents
    Wend
End Sub

Function PopField (AStr As String, ByVal FS As String) As String
'------------------------------------------------------------
' Returns a substring of AStr.  if FS is in AStr, PopField
' returns the beginning of AStr, up to (but not including)
' FS.  AStr is also chopped so that it begins at the first
' character beyond FS.
'
' If FS is not in AStr, PopField returns the contents of AStr
' and sets AStr to a null string ("").
'
' PopField is usually used to parse a text file or text line.
'------------------------------------------------------------
Dim pos As Integer

    ' Look for the field separator.
    pos = InStr(AStr, FS)

    ' Found the field separator.
    If pos > 1 Then
	PopField = Left$(AStr, pos - 1)
	AStr = Mid$(AStr, pos + 1)

    ' Field separator is at beginning of AStr.
    ElseIf pos = 1 Then
	PopField = ""
	If Len(AStr) > 1 Then
	    AStr = Mid$(AStr, pos + 1)
	Else
	    AStr = ""
	End If

    ' Field separator not in AStr.
    Else
	PopField = AStr
	AStr = ""
    End If
End Function

