VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4140
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   6690
   Height          =   4545
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4140
   ScaleWidth      =   6690
   Top             =   1170
   Width           =   6810
   Begin VB.PictureBox Splitter 
      Height          =   495
      Left            =   4920
      MousePointer    =   9  'Size W E
      ScaleHeight     =   435
      ScaleWidth      =   1155
      TabIndex        =   2
      Top             =   1560
      Width           =   1215
   End
   Begin VB.TextBox TextRight 
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   120
      Width           =   1935
   End
   Begin VB.ListBox ListLeft 
      Height          =   2985
      Left            =   120
      TabIndex        =   0
      Top             =   600
      Width           =   1935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

'variable to hold the width of the spltter bar
Private Const SPLT_WDTH As Integer = 3

'variable to hold the last-sized postion
Private currSplitPosX As Long

'variable to hold the horizontal and vertical offsets of the 2 controls
Dim CTRL_OFFSET As Integer

'variable to hold the Splitter bar colour
Dim SPLT_COLOUR As Long
Private Sub Form_Load()
'set the startup variables

CTRL_OFFSET = 5
SPLT_COLOUR = &H808080

'set the current splitter bar position to an arbitrary value that will always be outside
'the possibe range. This allows us to check for movement of the spltter bar in subsequent
'mousexxx subs.

currSplitPosX = &H7FFFFFFF

ListLeft.AddItem "Left list Item 1"
ListLeft.AddItem "Left list Item 2"
ListLeft.AddItem "Left list Item 3"
ListLeft.AddItem "Left list Item 4"
ListLeft.AddItem "Left list Item 5"

'note: VB3 users will need to substitute Chr$(13) & chr$(10) for the VB4 constant vbCrLf in the sentence below.

TextRight = "This code demonstrates how to implement a spliiter bar in a Visual Basic Project." & vbCrLf & vbCrLf & "It's actions are controlled through the MouseDown, MouseMove and MouseUp subs of the Splitter Picturebox, and the Resize event of the form."

End Sub


Private Sub Form_Resize()

Dim x1 As Integer
Dim x2 As Integer
Dim height1 As Integer
Dim width1 As Integer
Dim width2 As Integer

On Error Resume Next

'set the height of the controls

height1 = ScaleHeight - (CTRL_OFFSET * 2)
x1 = CTRL_OFFSET
width1 = ListLeft.Width

x2 = x1 + ListLeft.Width + SPLT_WDTH - 1
width2 = ScaleWidth - x2 - CTRL_OFFSET

'move the left list
ListLeft.Move x1% - 1, CTRL_OFFSET, width1, height1

'move the right list
TextRight.Move x2, CTRL_OFFSET, width2 + 1, height1

'move the splitter bar
Splitter.Move x1 + ListLeft.Width - 1, CTRL_OFFSET, SPLT_WDTH, height1

End Sub

Private Sub Splitter_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

If Button = vbLeftButton Then
    'change the splitter colour
    Splitter.BackColor = SPLT_COLOUR
    
    'set the current position to x
    currSplitPosX = CLng(X)
Else
    'not the left button, so... if the current position <> default, cause a mouseup
    If currSplitPosX <> &H7FFFFFFF Then Splitter_MouseUp Button, Shift, X, Y
    
    'set the current position to the default value
    currSplitPosX = &H7FFFFFFF
End If

End Sub


Private Sub Splitter_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)


'if the splitter has been moved...
If currSplitPosX& <> &H7FFFFFFF Then

'if the current position <> default, reposition the splitter and set this as the current value
If CLng(X) <> currSplitPosX Then
Splitter.Move Splitter.Left + X, CTRL_OFFSET, SPLT_WDTH, ScaleHeight - (CTRL_OFFSET * 2)
currSplitPosX = CLng(X)

End If

End If

End Sub


Private Sub Splitter_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

'if the splitter has been moved...
If currSplitPosX <> &H7FFFFFFF Then
 'if the current postition <> the last position do a final move of the splitter
If CLng(X) <> currSplitPosX Then
    Splitter.Move Splitter.Left + X, CTRL_OFFSET, SPLT_WDTH, ScaleHeight - (CTRL_OFFSET * 2)
End If

'call this the default position
currSplitPosX = &H7FFFFFFF

'restore the normal splitter colour
Splitter.BackColor = &H8000000F

'and check for valid sizings.
'Either enforce the default minimum & maximum widths for the left list, or, if within range, set the width

If Splitter.Left > 60 And Splitter.Left < (ScaleWidth - 60) Then

ListLeft.Width = Splitter.Left - ListLeft.Left 'the pane is within range


ElseIf Splitter.Left < 60 Then 'the pane is too small
    ListLeft.Width = 60
Else
    ListLeft.Width = ScaleWidth - 60 'the pane is too wide
End If
    'reposition both lists, and the splitter bar
    Form_Resize
End If

End Sub


