VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "COMCTL32.OCX"
Begin VB.Form Form1 
   Caption         =   "TreeView Event Cancel demo"
   ClientHeight    =   4320
   ClientLeft      =   2970
   ClientTop       =   2850
   ClientWidth     =   7080
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   4320
   ScaleWidth      =   7080
   Begin VB.CheckBox chkNoSelection 
      Caption         =   "Prevent selection from changing"
      Height          =   285
      Left            =   3960
      TabIndex        =   3
      Top             =   930
      Width           =   3255
   End
   Begin VB.CheckBox chkNoCollapse 
      Caption         =   "Prevent all nodes from collapsing"
      Height          =   285
      Left            =   3960
      TabIndex        =   2
      Top             =   600
      Width           =   3255
   End
   Begin VB.CheckBox chkNoExpand 
      Caption         =   "Prevent all nodes from expanding"
      Height          =   285
      Left            =   3960
      TabIndex        =   1
      Top             =   270
      Width           =   3255
   End
   Begin ComctlLib.TreeView TreeView1 
      Height          =   3645
      Left            =   300
      TabIndex        =   0
      Top             =   300
      Width           =   3315
      _ExtentX        =   5847
      _ExtentY        =   6429
      _Version        =   327682
      Style           =   7
      Appearance      =   1
   End
   Begin VB.Label Label2 
      Caption         =   "Label2"
      Height          =   2205
      Left            =   3960
      TabIndex        =   5
      Top             =   1680
      Width           =   2895
   End
   Begin VB.Label Label1 
      Caption         =   "Label1"
      Height          =   255
      Left            =   3960
      TabIndex        =   4
      Top             =   1260
      Width           =   3255
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' Demonstrates how to prevent a Node selection change, expand,
' and collapse in the Comctl32.ocx TreeView control. Also shows
' how to obtain the treeview item handle for any given Node object.
'
' Brought to you by Brad Martinez
'   http://members.aol.com/btmtz/vb
'   http://www.mvps.org/ccrp
'
' Code was written in and formatted for 8pt MS San Serif
'

Private Sub Form_Load()
  Dim Node1 As Node
  Dim Node2 As Node
  Dim Node3 As Node
  Dim i As Integer
  Dim j As Integer
  Dim k As Integer
  
  ' For some convenience...
  TreeView1.HideSelection = False
  TreeView1.Indentation = 19 * Screen.TwipsPerPixelX
  TreeView1.LabelEdit = tvwManual
  TreeView1.LineStyle = tvwRootLines
  
  ' Fill up the treeview...
  For i = 1 To 2
    Set Node1 = TreeView1.Nodes.Add(, , , "Root" & i)
    For j = 1 To 3
      Set Node2 = TreeView1.Nodes.Add(Node1.Index, tvwChild, , "Root" & i & "Child" & j)
      For k = 1 To 3
        Set Node3 = TreeView1.Nodes.Add(Node2.Index, tvwChild, , "GrandChild" & (16 * (i - 1)) + (4 * (j - 1)) + k)
      Next
    Next
  
    Node1.Expanded = True
  Next
  
  Set Icon = Nothing   ' makes Karl Peterson happy... :-)
  
  If IsIDE Then
    
    ' Consider either going to the VB Owner's area on the MS site, picking
    ' up the "Debug Object for AddressOf Subclassing", or grabbing the
    ' subclassing control at http://www.softcircuits.com/, and plugging
    ' either into this code. You'll save a heck of a lot of trouble...
    
    Label2 = "This form is subclassed!  ** DO NOT**  end this program " & _
                   "from VB's end command or the UnSubClass proc won't get " & _
                   "called in Form_Unload, and VB *will* crash!! And if you find " & _
                   "that VB freezes when stepping through code, just hit Ctrl+F9 " & _
                   "to clear all breakpoints, then hit F5 to get up and going again..."
  Else
    Label2 = "this space for rent..."
  End If
  
  Call SubClass(hWnd)
  
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Call UnSubClass(hWnd)
End Sub

Private Function IsIDE() As Boolean
  On Error GoTo Out
  Debug.Print 1 / 0
Out:
  IsIDE = Err
End Function

' The form's notification message handler.

Public Function NotificationHandler(wParam As Long, lParam As Long) As Long
  Dim nmh As NMHDR
  Dim nmtv As NMTREEVIEW
  Dim nod As Node

  ' Fill the NMHDR struct from the lParam pointer.
  ' (for any WM_NOTIFY msg, lParam always points to a struct which is
  '  either the NMHDR struct, or whose 1st member is the NMHDR struct)
  MoveMemory nmh, ByVal lParam, Len(nmh)

#If MSGLOG Then
' Uncomment this to see all the treeview's notification messages
' in the Immediate window.
'  WriteMsgLog GetCtrlNotifyCodeStr(nmh.code)
#End If
  
  ' The actual notification message is in the code member
  ' of the NMHDR struct.
  Select Case nmh.code
    
    ' An item is about to be expanded or collapsed.
    ' Return TRUE to prevent the item from expanding or collapsing.
    ' One little problem here... VB superclasses the treeview and does
    ' mysterious things when the Entry key is pressed, preforming the
    ' expand/collapse before a TVN_ITEMEXPANDING or any other
    ' message is sent. Go figure. I never did find out how to trap it either...
    Case TVN_ITEMEXPANDING

      ' lParam points to the NMTREEVIEW struct, fill it.
      MoveMemory nmtv, ByVal lParam, Len(nmtv)
      
      ' If an item is expanding and expands are being prevented
      If (nmtv.action = TVE_EXPAND) And chkNoExpand Then
        ' Get the Node object for the item that is about to be expanded.
        Set nod = GetNodeFromTVItem(TreeView1, nmtv.itemNew.hItem)
        Label1 = nod.Text & " wasn't expanded"
        ' Return 1 to cancel the expand
        NotificationHandler = CTrue
      End If
      
      ' If an item is collapsing and collapses are being prevented...
      If (nmtv.action = TVE_COLLAPSE) And chkNoCollapse Then
        ' Get the Node object for the item that is about to be collapsed.
        Set nod = GetNodeFromTVItem(TreeView1, nmtv.itemNew.hItem)
        Label1 = nod.Text & " wasn't collapsed"
        ' Return 1 to cancel the collapse
        NotificationHandler = CTrue
      End If
    
    ' The current selection is about to change.
    ' Return TRUE to prevent the selection from changing.
    Case TVN_SELCHANGING

      ' lParam points to the NMTREEVIEW struct, fill it.
      MoveMemory nmtv, ByVal lParam, Len(nmtv)

      ' If we're not allowing the slection to change...
      If chkNoSelection Then
        ' If nmtv.itemNew.hItem  has a value, then the item is being selected.
        If nmtv.itemNew.hItem Then
          ' Get the Node object for the item that is about to become selected.
          Set nod = GetNodeFromTVItem(TreeView1, nmtv.itemNew.hItem)
          Label1 = nod.Text & " wasn't selected"
          ' Return 1 to cancel the selection
          NotificationHandler = CTrue
        
        ' If nmtv.itemNew.hItem = 0, then nmtv.itemOld.hItem is being de-selected.
        Else
          ' Get the Node object for the item that is about to become deselected.
          Set nod = GetNodeFromTVItem(TreeView1, nmtv.itemOld.hItem)
          Label1 = nod.Text & " wasn't deselected"
          ' Return 1 to cancel the de-selection
          NotificationHandler = CTrue
        
        End If
      End If
      
  End Select

End Function

Private Sub TreeView1_KeyDown(KeyCode As Integer, Shift As Integer)
'  If (KeyCode = vbKeyReturn) Then KeyCode = 0
End Sub
