VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Sine wave!"
   ClientHeight    =   3180
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   5055
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3180
   ScaleWidth      =   5055
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer tmrScroll 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   1920
      Top             =   1350
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Pick Mag"
      Height          =   405
      Left            =   1200
      TabIndex        =   5
      Top             =   510
      Width           =   915
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Pick Inv"
      Height          =   405
      Left            =   210
      TabIndex        =   4
      Top             =   510
      Width           =   915
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Go!"
      Height          =   405
      Left            =   1530
      TabIndex        =   3
      Top             =   60
      Width           =   915
   End
   Begin VB.CommandButton cmdSine1Cycle 
      Caption         =   "Sine 1 cycle"
      Height          =   405
      Left            =   210
      TabIndex        =   2
      Top             =   60
      Width           =   1275
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   405
      Left            =   3480
      TabIndex        =   1
      Top             =   60
      Width           =   1305
   End
   Begin VB.PictureBox pctSinus 
      BackColor       =   &H00FFFFFF&
      ClipControls    =   0   'False
      Height          =   1860
      Left            =   210
      Picture         =   "frmSine.frx":0000
      ScaleHeight     =   1800
      ScaleWidth      =   4500
      TabIndex        =   0
      Top             =   1050
      Width           =   4560
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Public Inverse As Long
Public Magnitude As Long


Sub InitApp()
Dim c As Long, r As Long

Inverse = 128
Magnitude = 5

GetObjectAPI pctSinus.Picture, Len(Bmp), Bmp

If Bmp.bmPlanes <> 1 Or Bmp.bmBitsPixel <> 8 Then
    MsgBox "Non-256 colour bitmap detected. No effects."
    Exit Sub
End If

'Init the SafeArray
With SA
    .cbElements = 1
    .cDims = 2
    .bounds(0).lLbound = 0
    .bounds(0).cElements = Bmp.bmHeight
    .bounds(1).lLbound = 0
    .bounds(1).cElements = Bmp.bmWidthBytes
    .pvData = Bmp.bmBits
End With

CopyMemory ByVal VarPtrArray(SAData), VarPtr(SA), 4

ReDim SAOData(UBound(SAData, 1), UBound(SAData, 2))
ReDim SATData(UBound(SAData, 1), UBound(SAData, 2))

For c = 0 To UBound(SAData, 1)
    For r = 0 To UBound(SAData, 2)
            SAOData(c, r) = SAData(c, r)
    Next r
Next c

Pi = 4 * Atn(1)
End Sub


Private Sub cmdExit_Click()
CopyMemory ByVal VarPtrArray(SAData), 0&, 4

Unload Me
End Sub

Private Sub cmdSine1Cycle_Click()
Dim c As Long, r As Long, shift As Long, multiplier As Double, sinefac As Double, NewR As Long
Static incriment As Double

'multiplier = 1 / (2 * 5)

For c = 0 To UBound(SAData, 1)
    sinefac = 5 * Sin(1 / 32 * Pi * c + incriment)
    'Debug.Print sinefac
    
    shift = sinefac

    For r = 0 To UBound(SAData, 2)
        NewR = r + shift
        If NewR > UBound(SAData, 2) Or NewR < 0 Then GoTo NextSteP
        
        SAData(c, r) = SAOData(c, NewR)
NextSteP:
    Next r
Next c

pctSinus.Refresh
incriment = incriment + 0.5
End Sub

Private Sub Command1_Click()
tmrScroll.Enabled = Not tmrScroll.Enabled

Select Case tmrScroll.Enabled
    Case True
        Command1.Caption = "Stop"
    Case False
        Command1.Caption = "Go!"
End Select
End Sub


Private Sub Command2_Click()
Dim result As String

result = InputBox("Enter the inv constant...", "Choose denom of fraction", CStr(Inverse))

If IsNumeric(result) Then
    Inverse = CLng(result)
Else
    MsgBox "not a number..."
End If
End Sub

Private Sub Command3_Click()
Dim result As String

result = InputBox("Enter the magnitude constant...", "Choose magnitude of distortion", CStr(Magnitude))

If IsNumeric(result) Then
    Magnitude = CLng(result)
Else
    MsgBox "not a number..."
End If
End Sub


Private Sub Form_Load()
InitApp
End Sub


Private Sub tmrScroll_Timer()
Dim c As Long, r As Long, shift As Long, multiplier As Double, sinefac As Double, newC As Long, NewR As Long
Static incriment As Double

If incriment > Bmp.bmWidth Then incriment = 0

For r = 0 To UBound(SAData, 2)
    sinefac = Magnitude * Sin(1 / (Inverse) * Pi * r + incriment)
    
    shift = sinefac

    For c = 0 To UBound(SAData, 1)
        newC = c + shift
        If newC > UBound(SAData, 1) Or newC < 0 Then GoTo NextStePR
        
        SATData(c, r) = SAOData(newC, r)
NextStePR:
    Next c
Next r

'Second pass
For c = 0 To UBound(SAData, 1)
    sinefac = Magnitude * Sin(1 / (Inverse) * Pi * c + incriment)
    
    shift = sinefac

    For r = 0 To UBound(SAData, 2)
        NewR = r + shift
        If NewR > UBound(SAData, 2) Or NewR < 0 Then GoTo NextStepC
        
        SAData(c, r) = SATData(c, NewR)
NextStepC:
    Next r
Next c

pctSinus.Refresh
incriment = incriment + 0.25
End Sub


